/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.registers;

import com.mochibit.defcon.Defcon;
import com.mochibit.defcon.customassets.fonts.AbstractCustomFont;
import com.mochibit.defcon.customassets.fonts.FontData;
import com.mochibit.defcon.customassets.items.AbstractCustomItemModel;
import com.mochibit.defcon.customassets.items.ModelData;
import com.mochibit.defcon.customassets.sounds.AbstractCustomSound;
import com.mochibit.defcon.customassets.sounds.SoundData;
import com.mochibit.defcon.customassets.sounds.SoundInfo;
import com.mochibit.defcon.registers.PackRegister;
import com.mochibit.defcon.registers.ResourcePackFormatVersion;
import com.mochibit.defcon.registers.ResourcePackRegister;
import com.mochibit.defcon.registers.ResourcePackRegisterKt;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/mochibit/defcon/registers/ResourcePackRegister;", "Lcom/mochibit/defcon/registers/PackRegister;", "()V", "packageName", "", "tempRootPath", "Ljava/nio/file/Path;", "registerPack", "", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nResourcePackRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcePackRegister.kt\ncom/mochibit/defcon/registers/ResourcePackRegister\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,366:1\n1045#2:367\n1477#2:368\n1502#2,3:369\n1505#2,3:379\n372#3,7:372\n*S KotlinDebug\n*F\n+ 1 ResourcePackRegister.kt\ncom/mochibit/defcon/registers/ResourcePackRegister\n*L\n219#1:367\n219#1:368\n219#1:369,3\n219#1:379,3\n219#1:372,7\n*E\n"})
public final class ResourcePackRegister
implements PackRegister {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String packageName;
    @NotNull
    private Path tempRootPath;
    @NotNull
    private static final ResourcePackRegister get = new ResourcePackRegister();

    private ResourcePackRegister() {
        String string = ((Object)((Object)Defcon.Companion.getInstance())).getClass().getPackage().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        this.packageName = string;
        Path path = Paths.get("./defconResourcePack", new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        this.tempRootPath = path;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerPack() {
        void $this$groupByTo$iv$iv;
        Object fontInstance;
        String string = Bukkit.getBukkitVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getBukkitVersion(...)");
        String[] stringArray = new String[]{"-"};
        String serverVersion = (String)StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null).get(0);
        Defcon.Companion.Logger.INSTANCE.info("Creating datapack for Defcon for minecraft version " + serverVersion);
        if (Files.exists(this.tempRootPath, new LinkOption[0])) {
            Files.walk(this.tempRootPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(ResourcePackRegister::registerPack$lambda$0).forEach(arg_0 -> ResourcePackRegister.registerPack$lambda$1(registerPack.2.INSTANCE, arg_0));
        }
        Files.createDirectories(this.tempRootPath, new FileAttribute[0]);
        JSONObject mcmeta = new JSONObject();
        JSONObject pack = new JSONObject();
        ((Map)pack).put("pack_format", ResourcePackFormatVersion.valueOf("V" + StringsKt.replace$default(serverVersion, ".", "_", false, 4, null)).getVersion());
        ((Map)pack).put("description", "Defcon auto-generated resource pack");
        ((Map)mcmeta).put("pack", pack);
        Path path = Paths.get(this.tempRootPath + "/pack.mcmeta", new String[0]);
        String string2 = mcmeta.toJSONString();
        Intrinsics.checkNotNullExpressionValue(string2, "toJSONString(...)");
        String string3 = string2;
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        Files.write(path, byArray, new OpenOption[0]);
        Path localAssetsPath = Paths.get(this.tempRootPath + "/assets", new String[0]);
        Files.createDirectories(localAssetsPath, new FileAttribute[0]);
        Intrinsics.checkNotNull(localAssetsPath);
        String[] stringArray2 = new String[]{"assets/defcon"};
        ResourcePackRegisterKt.copyFoldersFromResource("assets/", localAssetsPath, SetsKt.hashSetOf(stringArray2));
        Path minecraftPath = Paths.get(localAssetsPath + "/minecraft", new String[0]);
        Files.createDirectories(minecraftPath, new FileAttribute[0]);
        Path fontPath = Paths.get(minecraftPath + "/font", new String[0]);
        Files.createDirectories(fontPath, new FileAttribute[0]);
        File jarFile = new File(Defcon.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String string4 = entry.getName();
            Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
            if (!StringsKt.startsWith$default(string4, "assets/", false, 2, null)) continue;
            String string5 = entry.getName();
            Intrinsics.checkNotNullExpressionValue(string5, "getName(...)");
            Defcon.Companion.Logger.INSTANCE.info(string5);
            if (!entry.getName().equals("assets/defcon/fonts/default.json")) continue;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(jar.getInputStream(entry), fontPath.resolve("default.json"), copyOptionArray);
        }
        BufferedReader jsonReader = Files.newBufferedReader(fontPath.resolve("default.json"));
        JSONParser jsonParser = new JSONParser();
        Object object = jsonParser.parse((Reader)jsonReader);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.json.simple.JSONObject");
        JSONObject defaultJson = (JSONObject)object;
        Object object2 = defaultJson.get((Object)"providers");
        Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type org.json.simple.JSONArray");
        JSONArray providers = (JSONArray)object2;
        for (Class<AbstractCustomFont> font : new Reflections(this.packageName + ".customassets.fonts.definitions", new Scanner[0]).getSubTypesOf(AbstractCustomFont.class)) {
            fontInstance = font.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            FontData fontData = ((AbstractCustomFont)fontInstance).getFontData();
            JSONObject newFont = new JSONObject();
            ((Map)newFont).put("file", fontData.getFile());
            ((Map)newFont).put("type", fontData.getType());
            ((Map)newFont).put("ascent", fontData.getAscent());
            ((Map)newFont).put("height", fontData.getHeight());
            JSONArray chars = new JSONArray();
            Collection collection = (Collection)chars;
            Object[] objectArray = fontData.getChars().toArray();
            Intrinsics.checkNotNullExpressionValue(objectArray, "toArray(...)");
            CollectionsKt.addAll(collection, objectArray);
            ((Map)newFont).put("chars", chars);
            ((Map)newFont).put("advances", fontData.getAdvances());
            providers.add((Object)newFont);
        }
        Path path2 = fontPath.resolve("default.json");
        String string6 = defaultJson.toJSONString();
        Intrinsics.checkNotNullExpressionValue(string6, "toJSONString(...)");
        String string7 = string6;
        byte[] byArray2 = string7.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray2, "getBytes(...)");
        Files.write(path2, byArray2, new OpenOption[0]);
        Path targetSoundsPath = Paths.get(minecraftPath + "/sounds", new String[0]);
        Intrinsics.checkNotNull(targetSoundsPath);
        ResourcePackRegisterKt.copyFoldersFromResource$default("assets/defcon/sounds/", targetSoundsPath, null, 4, null);
        JSONObject soundsJson = new JSONObject();
        for (Class clazz : new Reflections(this.packageName + ".customassets.sounds.definitions", new Scanner[0]).getSubTypesOf(AbstractCustomSound.class)) {
            AbstractCustomSound soundInstance = (AbstractCustomSound)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            SoundInfo soundInfo = soundInstance.getSoundInfo();
            Iterator soundData = soundInstance.getSoundData();
            JSONObject jSONObject = new JSONObject();
            JSONArray soundsArray = new JSONArray();
            Collection collection = (Collection)soundsArray;
            Object[] objectArray = ((SoundData)((Object)soundData)).getSounds().toArray();
            Intrinsics.checkNotNullExpressionValue(objectArray, "toArray(...)");
            CollectionsKt.addAll(collection, objectArray);
            ((Map)jSONObject).put("sounds", soundsArray);
            if (!Intrinsics.areEqual(soundInfo.directory(), "")) {
                ((Map)soundsJson).put(soundInfo.directory() + "." + soundInfo.name(), jSONObject);
                continue;
            }
            ((Map)soundsJson).put(soundInfo.name(), jSONObject);
        }
        Path path3 = minecraftPath.resolve("sounds.json");
        String string8 = soundsJson.toJSONString();
        Intrinsics.checkNotNullExpressionValue(string8, "toJSONString(...)");
        fontInstance = string8;
        byte[] byArray3 = ((String)fontInstance).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray3, "getBytes(...)");
        Files.write(path3, byArray3, new OpenOption[0]);
        Path targetTexturesPath = Paths.get(minecraftPath + "/textures", new String[0]);
        Intrinsics.checkNotNull(targetTexturesPath);
        ResourcePackRegisterKt.copyFoldersFromResource$default("assets/defcon/textures/", targetTexturesPath, null, 4, null);
        Path path4 = Paths.get(minecraftPath + "/models", new String[0]);
        Intrinsics.checkNotNull(path4);
        ResourcePackRegisterKt.copyFoldersFromResource$default("assets/defcon/models/", path4, null, 4, null);
        Path targetOptifinePath = Paths.get(minecraftPath + "/optifine", new String[0]);
        Intrinsics.checkNotNull(targetOptifinePath);
        ResourcePackRegisterKt.copyFoldersFromResource$default("assets/defcon/optifine/", targetOptifinePath, null, 4, null);
        ArrayList<AbstractCustomItemModel> itemModels = new ArrayList<AbstractCustomItemModel>();
        for (Class clazz : new Reflections(this.packageName + ".customassets.items.definitions", new Scanner[0]).getSubTypesOf(AbstractCustomItemModel.class)) {
            AbstractCustomItemModel itemModelInstance = (AbstractCustomItemModel)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!itemModelInstance.getModelData().getAnimationFrames().isEmpty()) {
                for (Map.Entry entry : itemModelInstance.getModelData().getAnimationFrames().entrySet()) {
                    String string9;
                    int index = ((Number)entry.getKey()).intValue();
                    String string10 = (String)entry.getValue();
                    Path modelPath = path4.resolve("item/" + itemModelInstance.getModelData().getModelName() + "/" + itemModelInstance.getModelData().getModelName() + ".json");
                    Path frameModelPath = path4.resolve("item/" + itemModelInstance.getModelData().getModelName() + "/" + string10 + ".json");
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.copy(modelPath, frameModelPath, copyOptionArray);
                    BufferedReader modelReader = Files.newBufferedReader(frameModelPath);
                    Object object3 = jsonParser.parse((Reader)modelReader);
                    Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type org.json.simple.JSONObject");
                    JSONObject modelJson = (JSONObject)object3;
                    Object object4 = modelJson.get((Object)"textures");
                    Intrinsics.checkNotNull(object4, "null cannot be cast to non-null type org.json.simple.JSONObject");
                    JSONObject textures = (JSONObject)object4;
                    ((Map)textures).put("0", "item/" + itemModelInstance.getModelData().getModelName() + "/" + string10);
                    Intrinsics.checkNotNullExpressionValue(modelJson.toJSONString(), "toJSONString(...)");
                    byte[] byArray4 = string9.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue(byArray4, "getBytes(...)");
                    Files.write(frameModelPath, byArray4, new OpenOption[0]);
                    AbstractCustomItemModel newInstance = (AbstractCustomItemModel)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    ModelData modelData = itemModelInstance.getModelData();
                    String string11 = "item/" + itemModelInstance.getModelData().getModelName() + "/" + string10;
                    int n = itemModelInstance.getModelData().getCustomModelData() + index;
                    newInstance.setModelData(ModelData.copy$default(modelData, null, null, null, null, null, null, n, string11, null, 319, null));
                    itemModels.add(newInstance);
                }
                continue;
            }
            itemModels.add(itemModelInstance);
        }
        Iterable iterable = itemModels;
        boolean $i$f$sortedBy = false;
        Iterable iterable2 = CollectionsKt.sortedWith(iterable, new Comparator(){

            public final int compare(T a, T b) {
                AbstractCustomItemModel it = (AbstractCustomItemModel)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getModelData().getCustomModelData());
                it = (AbstractCustomItemModel)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getModelData().getCustomModelData());
            }
        });
        boolean $i$f$groupBy = false;
        Iterable iterable3 = iterable2;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object5;
            AbstractCustomItemModel it = (AbstractCustomItemModel)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getModelData().getOriginalItemName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object5 = answer$iv$iv$iv;
            } else {
                object5 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object5;
            list$iv$iv.add(element$iv$iv);
        }
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            String string12;
            ModelData firstModelData = ((AbstractCustomItemModel)CollectionsKt.first((List)entry.getValue())).getModelData();
            JSONObject model = new JSONObject();
            ((Map)model).put("parent", firstModelData.getParent().getValue());
            JSONObject textures = new JSONObject();
            for (Map.Entry<String, String> entry2 : firstModelData.getTextures().entrySet()) {
                String key = entry2.getKey();
                String value = entry2.getValue();
                ((Map)textures).put(key, value);
            }
            ((Map)model).put("textures", textures);
            JSONArray overrides = new JSONArray();
            for (com.mochibit.defcon.customassets.items.Override defaultOverride : firstModelData.getOverrides()) {
                JSONObject defaultModelOverride = new JSONObject();
                JSONObject predicate = new JSONObject();
                ((Map)defaultModelOverride).put("predicate", predicate);
                ((Map)predicate).put(defaultOverride.getPredicate().getKey(), defaultOverride.getPredicate().getValue());
                ((Map)defaultModelOverride).put("model", defaultOverride.getModel());
                overrides.add((Object)defaultModelOverride);
            }
            for (AbstractCustomItemModel item : (List)entry.getValue()) {
                JSONObject customModelOverride = new JSONObject();
                JSONObject predicate = new JSONObject();
                ((Map)customModelOverride).put("predicate", predicate);
                ((Map)predicate).put("custom_model_data", item.getModelData().getCustomModelData());
                ((Map)customModelOverride).put("model", item.getModelData().getModel());
                overrides.add((Object)customModelOverride);
            }
            ((Map)model).put("overrides", overrides);
            Path path5 = path4.resolve("item/" + entry.getKey() + ".json");
            Intrinsics.checkNotNullExpressionValue(model.toJSONString(), "toJSONString(...)");
            byte[] byArray5 = string12.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray5, "getBytes(...)");
            Files.write(path5, byArray5, new OpenOption[0]);
        }
        Path zipPath = Paths.get("./DefconResourcePack.zip", new String[0]);
        if (Files.exists(zipPath, new LinkOption[0])) {
            Files.delete(zipPath);
        }
        Intrinsics.checkNotNull(zipPath);
        ResourcePackRegisterKt.zipFolder(this.tempRootPath, zipPath, true);
    }

    private static final Path registerPack$lambda$0(Object obj) {
        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type java.nio.file.Path");
        return (Path)obj;
    }

    private static final void registerPack$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/mochibit/defcon/registers/ResourcePackRegister$Companion;", "", "()V", "get", "Lcom/mochibit/defcon/registers/ResourcePackRegister;", "getGet", "()Lcom/mochibit/defcon/registers/ResourcePackRegister;", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourcePackRegister getGet() {
            return get;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

