/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.registers;

import com.mochibit.defcon.Defcon;
import com.mochibit.defcon.classes.CustomItemDefinition;
import com.mochibit.defcon.classes.PluginConfiguration;
import com.mochibit.defcon.enums.ConfigurationStorages;
import com.mochibit.defcon.enums.ItemBehaviour;
import com.mochibit.defcon.exceptions.ItemNotRegisteredException;
import com.mochibit.defcon.interfaces.PluginItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/mochibit/defcon/registers/ItemRegister;", "", "()V", "pluginInstance", "Lorg/bukkit/plugin/java/JavaPlugin;", "registerItems", "", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nItemRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemRegister.kt\ncom/mochibit/defcon/registers/ItemRegister\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1855#2,2:111\n*S KotlinDebug\n*F\n+ 1 ItemRegister.kt\ncom/mochibit/defcon/registers/ItemRegister\n*L\n55#1:111,2\n*E\n"})
public final class ItemRegister {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaPlugin pluginInstance;
    @NotNull
    private static HashMap<String, PluginItem> registeredItems = new HashMap();

    public ItemRegister() {
        JavaPlugin javaPlugin = JavaPlugin.getPlugin(Defcon.class);
        Intrinsics.checkNotNullExpressionValue(javaPlugin, "getPlugin(...)");
        this.pluginInstance = javaPlugin;
    }

    public final boolean registerItems() {
        registeredItems = new HashMap();
        PluginConfiguration itemConfigurator = new PluginConfiguration(this.pluginInstance, ConfigurationStorages.Items);
        FileConfiguration fileConfiguration = itemConfigurator.getConfig();
        if (fileConfiguration == null) {
            return false;
        }
        FileConfiguration itemConfig = fileConfiguration;
        if (itemConfig.getList("enabled-items") == null) {
            return false;
        }
        List list = itemConfig.getList("enabled-items");
        Intrinsics.checkNotNull(list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            ItemBehaviour behaviourValue;
            String string;
            String string2;
            Object element$iv;
            Object item = element$iv = iterator2.next();
            boolean bl = false;
            String itemId = String.valueOf(item);
            if (registeredItems.get(itemId) != null) continue;
            if (itemConfig.getString(item + ".item-name") == null) {
                throw new ItemNotRegisteredException(itemId);
            }
            Intrinsics.checkNotNull(string2);
            String itemName = string2;
            String itemDescription = itemConfig.getString(item + ".item-description");
            if (itemConfig.getString(item + ".item-minecraft-id") == null) {
                throw new ItemNotRegisteredException(itemId);
            }
            Intrinsics.checkNotNull(string);
            String itemMinecraftId = string;
            int itemDataModelId = itemConfig.getInt(item + ".item-data-model-id", 0);
            String itemCustomBlockId = itemConfig.getString(item + ".definitions-block-id", null);
            int itemStackSize = itemConfig.getInt(item + ".max-stack-size");
            boolean itemUsable = itemConfig.getBoolean(item + ".is-usable");
            boolean itemTransportable = itemConfig.getBoolean(item + ".is-transportable");
            boolean itemDroppable = itemConfig.getBoolean(item + ".is-droppable");
            boolean itemEquipable = itemConfig.getBoolean(item + ".is-equipable", false);
            int itemEquipSlotNumber = itemConfig.getInt(item + ".equip-slot-number", 0);
            String behaviourName = itemConfig.getString(item + ".behaviour");
            if (behaviourName == null) {
                behaviourName = "generic";
            }
            if (ItemBehaviour.Companion.fromString(behaviourName) == null) {
                throw new IllegalArgumentException("Behaviour " + behaviourName + " is not valid");
            }
            PluginItem customItem = new CustomItemDefinition(itemId, itemName, itemDescription, itemMinecraftId, itemDataModelId, itemCustomBlockId, itemUsable, itemEquipable, itemEquipSlotNumber, itemDroppable, itemStackSize, itemTransportable, behaviourValue);
            Defcon.Companion.Logger.INSTANCE.info("Registered item " + itemId);
            ((Map)registeredItems).put(customItem.getId(), customItem);
        }
        itemConfigurator.saveConfig();
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R>\u0010\u0003\u001a&\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004j\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/mochibit/defcon/registers/ItemRegister$Companion;", "", "()V", "registeredItems", "Ljava/util/HashMap;", "", "Lcom/mochibit/defcon/interfaces/PluginItem;", "Lkotlin/collections/HashMap;", "getRegisteredItems", "()Ljava/util/HashMap;", "setRegisteredItems", "(Ljava/util/HashMap;)V", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashMap<String, PluginItem> getRegisteredItems() {
            return registeredItems;
        }

        public final void setRegisteredItems(@NotNull HashMap<String, PluginItem> hashMap) {
            Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
            registeredItems = hashMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

