/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.registers;

import com.mochibit.defcon.Defcon;
import com.mochibit.defcon.biomes.CustomBiome;
import com.mochibit.defcon.biomes.data.BiomeAdditionalSound;
import com.mochibit.defcon.biomes.data.BiomeInfo;
import com.mochibit.defcon.biomes.data.BiomeMoodSound;
import com.mochibit.defcon.biomes.data.BiomeMusic;
import com.mochibit.defcon.biomes.data.BiomeParticle;
import com.mochibit.defcon.registers.DatapackFormatVersion;
import com.mochibit.defcon.registers.DatapackRegister;
import com.mochibit.defcon.registers.PackRegister;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\"\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/mochibit/defcon/registers/DatapackRegister;", "Lcom/mochibit/defcon/registers/PackRegister;", "()V", "datapackFolder", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getDatapackFolder", "()Ljava/nio/file/Path;", "setDatapackFolder", "(Ljava/nio/file/Path;)V", "defconDatapackFolder", "getDefconDatapackFolder", "setDefconDatapackFolder", "packageName", "", "tempBiomesPath", "tempRootPath", "registerBiomes", "", "registerPack", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nDatapackRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatapackRegister.kt\ncom/mochibit/defcon/registers/DatapackRegister\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1#2:250\n*E\n"})
public final class DatapackRegister
implements PackRegister {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String packageName;
    private Path datapackFolder;
    private Path defconDatapackFolder;
    @NotNull
    private Path tempRootPath;
    private Path tempBiomesPath;
    @NotNull
    private static final DatapackRegister get = new DatapackRegister();

    private DatapackRegister() {
        String string = ((Object)((Object)Defcon.Companion.getInstance())).getClass().getPackage().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        this.packageName = string;
        String[] stringArray = new String[]{"datapacks"};
        this.datapackFolder = Paths.get("world", stringArray);
        stringArray = new String[]{"defcon"};
        this.defconDatapackFolder = Paths.get(((Object)this.datapackFolder).toString(), stringArray);
        Path path = Paths.get("./defconTempDatapack", new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        this.tempRootPath = path;
        this.tempBiomesPath = Paths.get(this.tempRootPath + "/data/defcon/worldgen/biome", new String[0]);
    }

    public final Path getDatapackFolder() {
        return this.datapackFolder;
    }

    public final void setDatapackFolder(Path path) {
        this.datapackFolder = path;
    }

    public final Path getDefconDatapackFolder() {
        return this.defconDatapackFolder;
    }

    public final void setDefconDatapackFolder(Path path) {
        this.defconDatapackFolder = path;
    }

    @Override
    public void registerPack() {
        String string = Bukkit.getBukkitVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getBukkitVersion(...)");
        String[] stringArray = new String[]{"-"};
        String serverVersion = (String)StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null).get(0);
        Defcon.Companion.Logger.INSTANCE.info("Creating datapack for Defcon for minecraft version " + serverVersion);
        if (!Files.exists(this.datapackFolder, new LinkOption[0])) {
            throw new Exception("Datapack folder not found " + this.datapackFolder);
        }
        if (Files.exists(this.tempRootPath, new LinkOption[0])) {
            Files.walk(this.tempRootPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(DatapackRegister::registerPack$lambda$0).forEach(arg_0 -> DatapackRegister.registerPack$lambda$1(registerPack.2.INSTANCE, arg_0));
        }
        Files.createDirectories(this.tempRootPath, new FileAttribute[0]);
        JSONObject mcmeta = new JSONObject();
        JSONObject pack = new JSONObject();
        ((Map)pack).put("pack_format", DatapackFormatVersion.valueOf("V" + StringsKt.replace$default(serverVersion, ".", "_", false, 4, null)).getVersion());
        ((Map)pack).put("description", "Defcon datapack");
        ((Map)mcmeta).put("pack", pack);
        Path path = Paths.get(this.tempRootPath + "/pack.mcmeta", new String[0]);
        String string2 = mcmeta.toJSONString();
        Intrinsics.checkNotNullExpressionValue(string2, "toJSONString(...)");
        String string3 = string2;
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        Files.write(path, byArray, new OpenOption[0]);
        this.registerBiomes();
        int tempHash2 = Files.walk(this.tempRootPath, new FileVisitOption[0]).filter(arg_0 -> DatapackRegister.registerPack$lambda$2(registerPack.tempHash.1.INSTANCE, arg_0)).map(arg_0 -> DatapackRegister.registerPack$lambda$3(registerPack.tempHash.2.INSTANCE, arg_0)).reduce(DatapackRegister::registerPack$lambda$4).hashCode();
        int defconHash2 = Files.exists(this.defconDatapackFolder, new LinkOption[0]) ? Files.walk(this.defconDatapackFolder, new FileVisitOption[0]).filter(arg_0 -> DatapackRegister.registerPack$lambda$5(registerPack.defconHash.1.INSTANCE, arg_0)).map(arg_0 -> DatapackRegister.registerPack$lambda$6(registerPack.defconHash.2.INSTANCE, arg_0)).reduce(DatapackRegister::registerPack$lambda$7).hashCode() : 0;
        Defcon.Companion.Logger.INSTANCE.info("Temp hash: " + tempHash2 + " | Defcon hash: " + defconHash2);
        if (tempHash2 == defconHash2) {
            return;
        }
        Defcon.Companion.Logger.INSTANCE.info("Moving datapack to " + this.defconDatapackFolder);
        if (Files.exists(this.defconDatapackFolder, new LinkOption[0])) {
            Files.walk(this.defconDatapackFolder, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(DatapackRegister::registerPack$lambda$8).forEach(arg_0 -> DatapackRegister.registerPack$lambda$9(registerPack.4.INSTANCE, arg_0));
        }
        Files.move(this.tempRootPath, this.defconDatapackFolder, new CopyOption[0]);
        Bukkit.shutdown();
    }

    private final void registerBiomes() {
        Files.createDirectories(this.tempBiomesPath, new FileAttribute[0]);
        JSONObject parentJson = new JSONObject();
        for (Class<?> biomes : new Reflections(this.packageName + ".biomes.definitions", new Scanner[0]).getTypesAnnotatedWith(BiomeInfo.class, true)) {
            Object object;
            Object biome = biomes.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(biome instanceof CustomBiome)) continue;
            CustomBiome customBiome = ((CustomBiome)biome).build();
            ((Map)parentJson).put("temperature", Float.valueOf(customBiome.getTemperature()));
            ((Map)parentJson).put("downfall", Float.valueOf(customBiome.getDownfall()));
            Map map = (Map)parentJson;
            String string = "precipitation";
            String string2 = customBiome.getPrecipitation().name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            string2 = string3;
            map.put(string, string2);
            map = (Map)parentJson;
            string = "temperature_modifier";
            string2 = customBiome.getTemperatureModifier().name();
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
            String string4 = string2.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
            string2 = string4;
            map.put(string, string2);
            ((Map)parentJson).put("has_precipitation", customBiome.getHasPrecipitation());
            JSONObject effects = new JSONObject();
            ((Map)effects).put("sky_color", customBiome.getEffects().getSkyColor());
            ((Map)effects).put("fog_color", customBiome.getEffects().getFogColor());
            ((Map)effects).put("water_color", customBiome.getEffects().getWaterColor());
            ((Map)effects).put("water_fog_color", customBiome.getEffects().getWaterFogColor());
            if (customBiome.getEffects().getMoodSound() != null) {
                JSONObject moodSound = new JSONObject();
                Map map2 = (Map)moodSound;
                BiomeMoodSound biomeMoodSound = customBiome.getEffects().getMoodSound();
                Intrinsics.checkNotNull(biomeMoodSound);
                map2.put("sound", biomeMoodSound.getSound());
                Map map3 = (Map)moodSound;
                BiomeMoodSound biomeMoodSound2 = customBiome.getEffects().getMoodSound();
                Intrinsics.checkNotNull(biomeMoodSound2);
                map3.put("tick_delay", biomeMoodSound2.getTickDelay());
                Map map4 = (Map)moodSound;
                BiomeMoodSound biomeMoodSound3 = customBiome.getEffects().getMoodSound();
                Intrinsics.checkNotNull(biomeMoodSound3);
                map4.put("block_search_extent", biomeMoodSound3.getBlockSearchExtent());
                Map map5 = (Map)moodSound;
                BiomeMoodSound biomeMoodSound4 = customBiome.getEffects().getMoodSound();
                Intrinsics.checkNotNull(biomeMoodSound4);
                map5.put("offset", Float.valueOf(biomeMoodSound4.getOffset()));
                ((Map)effects).put("mood_sound", moodSound);
            }
            if (customBiome.getEffects().getAdditionalSound() != null) {
                JSONObject additionalSound = new JSONObject();
                Map map6 = (Map)additionalSound;
                BiomeAdditionalSound biomeAdditionalSound = customBiome.getEffects().getAdditionalSound();
                Intrinsics.checkNotNull(biomeAdditionalSound);
                map6.put("sound", biomeAdditionalSound.getSound());
                Map map7 = (Map)additionalSound;
                BiomeAdditionalSound biomeAdditionalSound2 = customBiome.getEffects().getAdditionalSound();
                Intrinsics.checkNotNull(biomeAdditionalSound2);
                map7.put("tick_chance", biomeAdditionalSound2.getTickChance());
                ((Map)effects).put("additional_sound", additionalSound);
            }
            if (customBiome.getEffects().getParticle() != null) {
                Object object2;
                JSONObject particle = new JSONObject();
                Map map8 = (Map)particle;
                BiomeParticle biomeParticle = customBiome.getEffects().getParticle();
                Intrinsics.checkNotNull(biomeParticle);
                map8.put("probability", Float.valueOf(biomeParticle.getProbability()));
                JSONObject options = new JSONObject();
                Map map9 = (Map)options;
                String string5 = "type";
                BiomeParticle biomeParticle2 = customBiome.getEffects().getParticle();
                Intrinsics.checkNotNull(biomeParticle2);
                object = biomeParticle2.getParticle().name();
                Locale locale3 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale3, "getDefault(...)");
                String string6 = ((String)object).toLowerCase(locale3);
                Intrinsics.checkNotNullExpressionValue(string6, "toLowerCase(...)");
                object = "minecraft:" + string6;
                map9.put(string5, object);
                BiomeParticle biomeParticle3 = customBiome.getEffects().getParticle();
                Intrinsics.checkNotNull(biomeParticle3);
                Integer n = biomeParticle3.getColor();
                if (n != null) {
                    int it = ((Number)n).intValue();
                    boolean bl = false;
                    object2 = it;
                    ((Map)options).put("color", object2);
                }
                BiomeParticle biomeParticle4 = customBiome.getEffects().getParticle();
                Intrinsics.checkNotNull(biomeParticle4);
                Float f = biomeParticle4.getSize();
                if (f != null) {
                    float it = ((Number)f).floatValue();
                    boolean bl = false;
                    object2 = Float.valueOf(it);
                    ((Map)options).put("size", object2);
                }
                BiomeParticle biomeParticle5 = customBiome.getEffects().getParticle();
                Intrinsics.checkNotNull(biomeParticle5);
                if (biomeParticle5.getMaterial() != null) {
                    Material it;
                    boolean bl = false;
                    object2 = (Map)options;
                    String string7 = "material";
                    Object object3 = it.name();
                    Locale locale4 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue(locale4, "getDefault(...)");
                    String string8 = ((String)object3).toLowerCase(locale4);
                    Intrinsics.checkNotNullExpressionValue(string8, "toLowerCase(...)");
                    object3 = "minecraft:" + string8;
                    object2.put(string7, object3);
                }
                BiomeParticle biomeParticle6 = customBiome.getEffects().getParticle();
                Intrinsics.checkNotNull(biomeParticle6);
                Integer n2 = biomeParticle6.getFromColor();
                if (n2 != null) {
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    object2 = it;
                    ((Map)options).put("from_color", object2);
                }
                BiomeParticle biomeParticle7 = customBiome.getEffects().getParticle();
                Intrinsics.checkNotNull(biomeParticle7);
                Integer n3 = biomeParticle7.getToColor();
                if (n3 != null) {
                    int it = ((Number)n3).intValue();
                    boolean bl = false;
                    object2 = it;
                    ((Map)options).put("to_color", object2);
                }
                ((Map)particle).put("options", options);
                ((Map)effects).put("particle", particle);
            }
            if (customBiome.getEffects().getMusic() != null) {
                BiomeMusic biomeMusic = customBiome.getEffects().getMusic();
                Intrinsics.checkNotNull(biomeMusic);
                if (biomeMusic.getSound() != null) {
                    JSONObject music = new JSONObject();
                    Map map10 = (Map)music;
                    BiomeMusic biomeMusic2 = customBiome.getEffects().getMusic();
                    Intrinsics.checkNotNull(biomeMusic2);
                    map10.put("sound", biomeMusic2.getSound());
                    Map map11 = (Map)music;
                    BiomeMusic biomeMusic3 = customBiome.getEffects().getMusic();
                    Intrinsics.checkNotNull(biomeMusic3);
                    map11.put("min_delay", biomeMusic3.getMinDelay());
                    Map map12 = (Map)music;
                    BiomeMusic biomeMusic4 = customBiome.getEffects().getMusic();
                    Intrinsics.checkNotNull(biomeMusic4);
                    map12.put("max_delay", biomeMusic4.getMaxDelay());
                    Map map13 = (Map)music;
                    BiomeMusic biomeMusic5 = customBiome.getEffects().getMusic();
                    Intrinsics.checkNotNull(biomeMusic5);
                    map13.put("replace_current_music", biomeMusic5.getReplaceCurrentMusic());
                    ((Map)effects).put("music", music);
                }
            }
            if (customBiome.getEffects().getAmbientSound() != null) {
                String it;
                boolean bl = false;
                ((Map)effects).put("ambient_sound", it);
            }
            ((Map)parentJson).put("effects", effects);
            JSONObject spawners = new JSONObject();
            ((Map)parentJson).put("spawners", spawners);
            JSONObject spawnCosts = new JSONObject();
            ((Map)parentJson).put("spawn_costs", spawnCosts);
            JSONObject carvers = new JSONObject();
            ((Map)parentJson).put("carvers", carvers);
            JSONArray features = new JSONArray();
            ((Map)parentJson).put("features", features);
            Path path = Paths.get(this.tempBiomesPath + "/" + ((CustomBiome)biome).getBiomeKey().value() + ".json", new String[0]);
            Intrinsics.checkNotNullExpressionValue(parentJson.toJSONString(), "toJSONString(...)");
            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            Files.write(path, byArray, new OpenOption[0]);
        }
    }

    private static final Path registerPack$lambda$0(Object obj) {
        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type java.nio.file.Path");
        return (Path)obj;
    }

    private static final void registerPack$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean registerPack$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String registerPack$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String registerPack$lambda$4(String acc, String s) {
        return acc + s;
    }

    private static final boolean registerPack$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String registerPack$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String registerPack$lambda$7(String acc, String s) {
        return acc + s;
    }

    private static final Path registerPack$lambda$8(Object obj) {
        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type java.nio.file.Path");
        return (Path)obj;
    }

    private static final void registerPack$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/mochibit/defcon/registers/DatapackRegister$Companion;", "", "()V", "get", "Lcom/mochibit/defcon/registers/DatapackRegister;", "getGet", "()Lcom/mochibit/defcon/registers/DatapackRegister;", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DatapackRegister getGet() {
            return get;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

