/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.registers;

import com.mochibit.defcon.Defcon;
import com.mochibit.defcon.commands.GenericCommand;
import java.lang.reflect.InvocationTargetException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/mochibit/defcon/registers/CommandRegister;", "", "()V", "packageName", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "registerCommands", "", "Defcon"})
public final class CommandRegister {
    @NotNull
    private final String packageName;
    @NotNull
    private JavaPlugin plugin;

    public CommandRegister() {
        String string = ((Object)((Object)Defcon.Companion.getInstance())).getClass().getPackage().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        this.packageName = string;
        JavaPlugin javaPlugin = JavaPlugin.getPlugin(Defcon.class);
        Intrinsics.checkNotNullExpressionValue(javaPlugin, "getPlugin(...)");
        this.plugin = javaPlugin;
    }

    public final void registerCommands() {
        this.plugin.getLogger().info("Registering commands from " + this.packageName + ".commands");
        for (Class<GenericCommand> commandClass : new Reflections(this.packageName + ".commands", new Scanner[0]).getSubTypesOf(GenericCommand.class)) {
            try {
                GenericCommand genericCommand = commandClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.plugin.getLogger().info("Registering command: " + genericCommand.getCommandInfo().name());
                PluginCommand pluginCommand = this.plugin.getCommand(genericCommand.getCommandInfo().name());
                if (pluginCommand == null) {
                    this.plugin.getLogger().warning("Command " + genericCommand.getCommandInfo().name() + " not found, cache issue?");
                    continue;
                }
                pluginCommand.setExecutor((CommandExecutor)genericCommand);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

