/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.registers;

import com.mochibit.defcon.Defcon;
import com.mochibit.defcon.api.customblockdata.CustomBlockData;
import com.mochibit.defcon.classes.CustomBlockDefinition;
import com.mochibit.defcon.classes.PluginConfiguration;
import com.mochibit.defcon.enums.BlockBehaviour;
import com.mochibit.defcon.enums.BlockDataKey;
import com.mochibit.defcon.enums.ConfigurationStorages;
import com.mochibit.defcon.exceptions.BlockNotRegisteredException;
import com.mochibit.defcon.extensions.ByteKt;
import com.mochibit.defcon.interfaces.PluginBlock;
import com.mochibit.defcon.utils.MetaManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/mochibit/defcon/registers/BlockRegister;", "", "()V", "pluginInstance", "Lorg/bukkit/plugin/java/JavaPlugin;", "registerBlocks", "", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nBlockRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockRegister.kt\ncom/mochibit/defcon/registers/BlockRegister\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1855#2,2:101\n*S KotlinDebug\n*F\n+ 1 BlockRegister.kt\ncom/mochibit/defcon/registers/BlockRegister\n*L\n50#1:101,2\n*E\n"})
public final class BlockRegister {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaPlugin pluginInstance;
    @Nullable
    private static HashMap<String, PluginBlock> registeredBlocks;

    public BlockRegister() {
        JavaPlugin javaPlugin = JavaPlugin.getPlugin(Defcon.class);
        Intrinsics.checkNotNullExpressionValue(javaPlugin, "getPlugin(...)");
        this.pluginInstance = javaPlugin;
    }

    public final void registerBlocks() {
        FileConfiguration blockConfig;
        registeredBlocks = new HashMap();
        PluginConfiguration blockConfiguration = new PluginConfiguration(this.pluginInstance, ConfigurationStorages.Blocks);
        FileConfiguration fileConfiguration = blockConfig = blockConfiguration.getConfig();
        Intrinsics.checkNotNull(fileConfiguration);
        List list = fileConfiguration.getList("enabled-blocks");
        Intrinsics.checkNotNull(list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            BlockBehaviour behaviourValue;
            String string;
            Object element$iv;
            Object item = element$iv = iterator2.next();
            boolean bl = false;
            String blockId = String.valueOf(item);
            HashMap<String, PluginBlock> hashMap = registeredBlocks;
            Intrinsics.checkNotNull(hashMap);
            if (hashMap.get(blockId) != null) continue;
            if (blockConfig.getString(item + ".block-minecraft-id") == null) {
                throw new BlockNotRegisteredException(blockId);
            }
            Intrinsics.checkNotNull(string);
            String blockMinecraftId = string;
            int blockDataModelId = blockConfig.getInt(item + ".block-data-model-id");
            String behaviourName = blockConfig.getString(item + ".behaviour");
            if (behaviourName == null) {
                behaviourName = "generic";
            }
            if (BlockBehaviour.Companion.fromString(behaviourName) == null) {
                throw new BlockNotRegisteredException(blockId);
            }
            PluginBlock customBlock = new CustomBlockDefinition(blockId, blockDataModelId, blockMinecraftId, behaviourValue);
            HashMap<String, PluginBlock> hashMap2 = registeredBlocks;
            Intrinsics.checkNotNull(hashMap2);
            ((Map)hashMap2).put(customBlock.getId(), customBlock);
        }
        blockConfiguration.saveConfig();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bJ.\u0010\f\u001a*\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0004j\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u0001`\u0007R6\u0010\u0003\u001a*\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0004j\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u0001`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/mochibit/defcon/registers/BlockRegister$Companion;", "", "()V", "registeredBlocks", "Ljava/util/HashMap;", "", "Lcom/mochibit/defcon/interfaces/PluginBlock;", "Lkotlin/collections/HashMap;", "getBlock", "id", "location", "Lorg/bukkit/Location;", "getRegisteredBlocks", "Defcon"})
    @SourceDebugExtension(value={"SMAP\nBlockRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockRegister.kt\ncom/mochibit/defcon/registers/BlockRegister$Companion\n+ 2 MetaManager.kt\ncom/mochibit/defcon/utils/MetaManager\n*L\n1#1,100:1\n38#2,13:101\n*S KotlinDebug\n*F\n+ 1 BlockRegister.kt\ncom/mochibit/defcon/registers/BlockRegister$Companion\n*L\n82#1:101,13\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PluginBlock getBlock(@NotNull Location location) {
            String string;
            void this_$iv;
            Intrinsics.checkNotNullParameter(location, "location");
            MetaManager metaManager = MetaManager.INSTANCE;
            BlockDataKey key$iv = BlockDataKey.CustomBlockId;
            boolean $i$f$getBlockData = false;
            Block block = location.getWorld().getBlockAt(location);
            Intrinsics.checkNotNullExpressionValue(block, "getBlockAt(...)");
            Block block$iv = block;
            PersistentDataContainer blockData$iv = new CustomBlockData(block$iv, (Plugin)Defcon.Companion.getInstance());
            PersistentDataType<?, ?> dataType$iv = this_$iv.getPersistentDataType(Reflection.getOrCreateKotlinClass(String.class));
            Object object = blockData$iv.get(key$iv.getKey(), dataType$iv);
            if (object == null) {
                string = null;
            } else {
                Object value$iv = object;
                if (String.class == Boolean.class) {
                    Intrinsics.checkNotNull(value$iv, "null cannot be cast to non-null type kotlin.Byte");
                    string = (String)((Object)Boolean.valueOf(ByteKt.toBoolean((Byte)value$iv)));
                } else {
                    Object object2 = value$iv;
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)object2;
                }
            }
            if (string == null) {
                return null;
            }
            String customBlockId = string;
            return this.getBlock(customBlockId);
        }

        @Nullable
        public final PluginBlock getBlock(@NotNull String id) {
            Intrinsics.checkNotNullParameter(id, "id");
            HashMap hashMap = registeredBlocks;
            Intrinsics.checkNotNull(hashMap);
            return (PluginBlock)hashMap.get(id);
        }

        @Nullable
        public final HashMap<String, PluginBlock> getRegisteredBlocks() throws BlockNotRegisteredException {
            if (registeredBlocks == null) {
                throw new BlockNotRegisteredException("Block not registered for some reason. Verify the initialization");
            }
            return registeredBlocks;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

