/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.radiation;

import com.mochibit.defcon.Defcon;
import com.mochibit.defcon.api.customblockdata.CustomBlockData;
import com.mochibit.defcon.enums.BlockDataKey;
import com.mochibit.defcon.extensions.BooleanKt;
import com.mochibit.defcon.extensions.LocationKt;
import com.mochibit.defcon.math.Vector3;
import com.mochibit.defcon.radiation.RadiationArea;
import com.mochibit.defcon.save.savedata.RadiationAreaSave;
import com.mochibit.defcon.utils.FloodFill3D;
import com.mochibit.defcon.utils.MetaManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bJD\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u000bJ<\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u00122\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u000bJ8\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u00122\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/mochibit/defcon/radiation/RadiationAreaFactory;", "", "()V", "expand", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mochibit/defcon/radiation/RadiationArea;", "radiationArea", "maxFloodBlocks", "", "fromCenter", "center", "Lcom/mochibit/defcon/math/Vector3;", "worldName", "", "radLevel", "", "maxUpperVertexRadius", "maxLowerVertexRadius", "Lorg/bukkit/Location;", "generate", "maxVertexRadius", "minVertexRadius", "Defcon"})
@SourceDebugExtension(value={"SMAP\nRadiationAreaFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadiationAreaFactory.kt\ncom/mochibit/defcon/radiation/RadiationAreaFactory\n+ 2 MetaManager.kt\ncom/mochibit/defcon/utils/MetaManager\n*L\n1#1,144:1\n69#2,4:145\n55#2,11:149\n69#2,4:160\n55#2,11:164\n69#2,4:175\n55#2,11:179\n69#2,4:190\n55#2,11:194\n*S KotlinDebug\n*F\n+ 1 RadiationAreaFactory.kt\ncom/mochibit/defcon/radiation/RadiationAreaFactory\n*L\n114#1:145,4\n114#1:149,11\n115#1:160,4\n115#1:164,11\n132#1:175,4\n132#1:179,11\n133#1:190,4\n133#1:194,11\n*E\n"})
public final class RadiationAreaFactory {
    @NotNull
    public static final RadiationAreaFactory INSTANCE = new RadiationAreaFactory();

    private RadiationAreaFactory() {
    }

    @NotNull
    public final CompletableFuture<RadiationArea> fromCenter(@NotNull Location center, double radLevel, int maxFloodBlocks, @NotNull Vector3 maxUpperVertexRadius, @NotNull Vector3 maxLowerVertexRadius) {
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(maxUpperVertexRadius, "maxUpperVertexRadius");
        Intrinsics.checkNotNullParameter(maxLowerVertexRadius, "maxLowerVertexRadius");
        return this.generate(center, radLevel, maxFloodBlocks, maxUpperVertexRadius, maxLowerVertexRadius);
    }

    public static /* synthetic */ CompletableFuture fromCenter$default(RadiationAreaFactory radiationAreaFactory, Location location, double d, int n, Vector3 vector3, Vector3 vector32, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d = 1.0;
        }
        if ((n2 & 4) != 0) {
            n = 20000;
        }
        if ((n2 & 8) != 0) {
            vector3 = new Vector3(20000.0, 150.0, 20000.0);
        }
        if ((n2 & 0x10) != 0) {
            vector32 = new Vector3(-20000.0, -10.0, -20000.0);
        }
        return radiationAreaFactory.fromCenter(location, d, n, vector3, vector32);
    }

    @NotNull
    public final CompletableFuture<RadiationArea> fromCenter(@NotNull Vector3 center, @NotNull String worldName, double radLevel, int maxFloodBlocks, @NotNull Vector3 maxUpperVertexRadius, @NotNull Vector3 maxLowerVertexRadius) {
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Intrinsics.checkNotNullParameter(maxUpperVertexRadius, "maxUpperVertexRadius");
        Intrinsics.checkNotNullParameter(maxLowerVertexRadius, "maxLowerVertexRadius");
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            Defcon.Companion.Logger.INSTANCE.info("World " + worldName + " not found");
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, "completedFuture(...)");
            return completableFuture;
        }
        return this.fromCenter(center.toLocation(world), radLevel, maxFloodBlocks, maxUpperVertexRadius, maxLowerVertexRadius);
    }

    public static /* synthetic */ CompletableFuture fromCenter$default(RadiationAreaFactory radiationAreaFactory, Vector3 vector3, String string, double d, int n, Vector3 vector32, Vector3 vector33, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d = 1.0;
        }
        if ((n2 & 8) != 0) {
            n = 20000;
        }
        if ((n2 & 0x10) != 0) {
            vector32 = new Vector3(20000.0, 150.0, 20000.0);
        }
        if ((n2 & 0x20) != 0) {
            vector33 = new Vector3(-20000.0, -10.0, -20000.0);
        }
        return radiationAreaFactory.fromCenter(vector3, string, d, n, vector32, vector33);
    }

    private final CompletableFuture<RadiationArea> generate(Location center, double radLevel, int maxFloodBlocks, Vector3 maxVertexRadius, Vector3 minVertexRadius) {
        CompletableFuture<RadiationArea> completableFuture = CompletableFuture.supplyAsync(() -> RadiationAreaFactory.generate$lambda$0(center, maxFloodBlocks, minVertexRadius, maxVertexRadius, radLevel));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    static /* synthetic */ CompletableFuture generate$default(RadiationAreaFactory radiationAreaFactory, Location location, double d, int n, Vector3 vector3, Vector3 vector32, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d = 1.0;
        }
        return radiationAreaFactory.generate(location, d, n, vector3, vector32);
    }

    @NotNull
    public final CompletableFuture<RadiationArea> expand(@NotNull RadiationArea radiationArea, int maxFloodBlocks) {
        Intrinsics.checkNotNullParameter(radiationArea, "radiationArea");
        CompletableFuture<RadiationArea> completableFuture = CompletableFuture.supplyAsync(() -> RadiationAreaFactory.expand$lambda$1(radiationArea, maxFloodBlocks));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    public static /* synthetic */ CompletableFuture expand$default(RadiationAreaFactory radiationAreaFactory, RadiationArea radiationArea, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 20000;
        }
        return radiationAreaFactory.expand(radiationArea, n);
    }

    private static final RadiationArea generate$lambda$0(Location $center, int $maxFloodBlocks, Vector3 $minVertexRadius, Vector3 $maxVertexRadius, double $radLevel) {
        Intrinsics.checkNotNullParameter($center, "$center");
        Intrinsics.checkNotNullParameter($minVertexRadius, "$minVertexRadius");
        Intrinsics.checkNotNullParameter($maxVertexRadius, "$maxVertexRadius");
        RadiationArea radiationArea = null;
        Vector3 minVertex = null;
        Vector3 maxVertex = null;
        List locations = (List)FloodFill3D.getFloodFillAsync$default(FloodFill3D.INSTANCE, $center, $maxFloodBlocks + 1, true, false, 8, null).join();
        HashSet<Vector3> affectedChunkCoordinates = new HashSet<Vector3>();
        if (locations.size() > $maxFloodBlocks) {
            minVertex = new Vector3($center.getX() + $minVertexRadius.getX(), $center.getY() + $minVertexRadius.getY(), $center.getZ() + $minVertexRadius.getZ());
            maxVertex = new Vector3($center.getX() + $maxVertexRadius.getX(), $center.getY() + $maxVertexRadius.getY(), $center.getZ() + $maxVertexRadius.getZ());
            World world = $center.getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
            affectedChunkCoordinates.add(LocationKt.toChunkCoordinate(minVertex.toLocation(world)));
            World world2 = $center.getWorld();
            Intrinsics.checkNotNullExpressionValue(world2, "getWorld(...)");
            affectedChunkCoordinates.add(LocationKt.toChunkCoordinate(maxVertex.toLocation(world2)));
        } else {
            for (Location location : locations) {
                affectedChunkCoordinates.add(LocationKt.toChunkCoordinate(location));
            }
        }
        Vector3 vector3 = LocationKt.toVector3($center);
        String string = $center.getWorld().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        radiationArea = new RadiationArea(vector3, string, minVertex, maxVertex, affectedChunkCoordinates, $radLevel, 0, 64, null);
        World world = $center.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        RadiationArea indexedRA = RadiationAreaSave.Companion.getSave(world).addRadiationArea(radiationArea);
        if (locations.size() < $maxFloodBlocks) {
            for (Location location : locations) {
                PersistentDataType<?, ?> dataType$iv$iv;
                PersistentDataType<?, ?> persistentDataType;
                BlockDataKey key$iv;
                MetaManager this_$iv;
                MetaManager metaManager = MetaManager.INSTANCE;
                BlockDataKey blockDataKey = BlockDataKey.RadiationLevel;
                Number value$iv = $radLevel;
                boolean $i$f$setBlockData = false;
                Block block = location.getWorld().getBlockAt(location);
                Intrinsics.checkNotNullExpressionValue(block, "getBlockAt(...)");
                Block block$iv = block;
                PersistentDataContainer blockData$iv = new CustomBlockData(block$iv, (Plugin)Defcon.Companion.getInstance());
                MetaManager this_$iv$iv = this_$iv;
                boolean $i$f$setBlockData2 = false;
                if (Double.class == Boolean.class) {
                    blockData$iv.set(key$iv.getKey(), PersistentDataType.BYTE, (Object)BooleanKt.toByte((Boolean)((Object)value$iv)));
                } else {
                    persistentDataType = this_$iv$iv.getPersistentDataType(Reflection.getOrCreateKotlinClass(Double.class));
                    if ((persistentDataType instanceof PersistentDataType ? persistentDataType : null) != null) {
                        dataType$iv$iv = dataType$iv$iv;
                        blockData$iv.set(key$iv.getKey(), dataType$iv$iv, (Object)value$iv);
                    }
                }
                this_$iv = MetaManager.INSTANCE;
                key$iv = BlockDataKey.RadiationAreaId;
                value$iv = indexedRA.getId();
                $i$f$setBlockData = false;
                Block block2 = location.getWorld().getBlockAt(location);
                Intrinsics.checkNotNullExpressionValue(block2, "getBlockAt(...)");
                block$iv = block2;
                blockData$iv = new CustomBlockData(block$iv, (Plugin)Defcon.Companion.getInstance());
                this_$iv$iv = this_$iv;
                $i$f$setBlockData2 = false;
                if (Integer.class == Boolean.class) {
                    blockData$iv.set(key$iv.getKey(), PersistentDataType.BYTE, (Object)BooleanKt.toByte((Boolean)((Object)value$iv)));
                    continue;
                }
                persistentDataType = this_$iv$iv.getPersistentDataType(Reflection.getOrCreateKotlinClass(Integer.class));
                if ((persistentDataType instanceof PersistentDataType ? persistentDataType : null) == null) continue;
                dataType$iv$iv = dataType$iv$iv;
                blockData$iv.set(key$iv.getKey(), dataType$iv$iv, (Object)value$iv);
            }
        }
        return radiationArea;
    }

    private static final RadiationArea expand$lambda$1(RadiationArea $radiationArea, int $maxFloodBlocks) {
        Intrinsics.checkNotNullParameter($radiationArea, "$radiationArea");
        World world = Bukkit.getWorld((String)$radiationArea.getWorldName());
        if (world == null) {
            return null;
        }
        World world2 = world;
        List locations = (List)FloodFill3D.getFloodFillAsync$default(FloodFill3D.INSTANCE, $radiationArea.getCenter().toLocation(world2), $maxFloodBlocks, true, false, 8, null).join();
        HashSet<Vector3> affectedChunkCoordinates = new HashSet<Vector3>();
        for (Location location : locations) {
            PersistentDataType<?, ?> dataType$iv$iv;
            PersistentDataType<?, ?> persistentDataType;
            BlockDataKey key$iv;
            MetaManager this_$iv;
            affectedChunkCoordinates.add(LocationKt.toChunkCoordinate(location));
            MetaManager metaManager = MetaManager.INSTANCE;
            BlockDataKey blockDataKey = BlockDataKey.RadiationLevel;
            Number value$iv = $radiationArea.getRadiationLevel();
            boolean $i$f$setBlockData = false;
            Block block = location.getWorld().getBlockAt(location);
            Intrinsics.checkNotNullExpressionValue(block, "getBlockAt(...)");
            Block block$iv = block;
            PersistentDataContainer blockData$iv = new CustomBlockData(block$iv, (Plugin)Defcon.Companion.getInstance());
            MetaManager this_$iv$iv = this_$iv;
            boolean $i$f$setBlockData2 = false;
            if (Double.class == Boolean.class) {
                blockData$iv.set(key$iv.getKey(), PersistentDataType.BYTE, (Object)BooleanKt.toByte((Boolean)((Object)value$iv)));
            } else {
                persistentDataType = this_$iv$iv.getPersistentDataType(Reflection.getOrCreateKotlinClass(Double.class));
                if ((persistentDataType instanceof PersistentDataType ? persistentDataType : null) != null) {
                    dataType$iv$iv = dataType$iv$iv;
                    blockData$iv.set(key$iv.getKey(), dataType$iv$iv, (Object)value$iv);
                }
            }
            this_$iv = MetaManager.INSTANCE;
            key$iv = BlockDataKey.RadiationAreaId;
            value$iv = $radiationArea.getId();
            $i$f$setBlockData = false;
            Block block2 = location.getWorld().getBlockAt(location);
            Intrinsics.checkNotNullExpressionValue(block2, "getBlockAt(...)");
            block$iv = block2;
            blockData$iv = new CustomBlockData(block$iv, (Plugin)Defcon.Companion.getInstance());
            this_$iv$iv = this_$iv;
            $i$f$setBlockData2 = false;
            if (Integer.class == Boolean.class) {
                blockData$iv.set(key$iv.getKey(), PersistentDataType.BYTE, (Object)BooleanKt.toByte((Boolean)((Object)value$iv)));
                continue;
            }
            persistentDataType = this_$iv$iv.getPersistentDataType(Reflection.getOrCreateKotlinClass(Integer.class));
            if ((persistentDataType instanceof PersistentDataType ? persistentDataType : null) == null) continue;
            dataType$iv$iv = dataType$iv$iv;
            blockData$iv.set(key$iv.getKey(), dataType$iv$iv, (Object)value$iv);
        }
        $radiationArea.getAffectedChunkCoordinates().addAll((Collection<Vector3>)affectedChunkCoordinates);
        return $radiationArea;
    }
}

