/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.radiation;

import com.google.gson.annotations.Expose;
import com.mochibit.defcon.extensions.LocationKt;
import com.mochibit.defcon.math.Vector3;
import com.mochibit.defcon.save.savedata.RadiationAreaSave;
import com.mochibit.defcon.save.schemas.RadiationAreaSchema;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0018\b\u0002\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00030\tj\b\u0012\u0004\u0012\u00020\u0003`\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0019\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u00030\tj\b\u0012\u0004\u0012\u00020\u0003`\nH\u00c6\u0003J\t\u0010%\u001a\u00020\fH\u00c6\u0003J\t\u0010&\u001a\u00020\u000eH\u00c6\u0003Jc\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0018\b\u0002\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00030\tj\b\u0012\u0004\u0012\u00020\u0003`\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010(\u001a\u00020\u001d2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\u000eH\u00d6\u0001J\t\u0010+\u001a\u00020\u0005H\u00d6\u0001R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00030\tj\b\u0012\u0004\u0012\u00020\u0003`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Lcom/mochibit/defcon/radiation/RadiationArea;", "", "center", "Lcom/mochibit/defcon/math/Vector3;", "worldName", "", "minVertex", "maxVertex", "affectedChunkCoordinates", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "radiationLevel", "", "id", "", "(Lcom/mochibit/defcon/math/Vector3;Ljava/lang/String;Lcom/mochibit/defcon/math/Vector3;Lcom/mochibit/defcon/math/Vector3;Ljava/util/HashSet;DI)V", "getAffectedChunkCoordinates", "()Ljava/util/HashSet;", "getCenter", "()Lcom/mochibit/defcon/math/Vector3;", "getId", "()I", "getMaxVertex", "getMinVertex", "getRadiationLevel", "()D", "getWorldName", "()Ljava/lang/String;", "checkIfInBounds", "", "location", "Lorg/bukkit/Location;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "Companion", "Defcon"})
public final class RadiationArea {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector3 center;
    @NotNull
    private final String worldName;
    @Nullable
    private final Vector3 minVertex;
    @Nullable
    private final Vector3 maxVertex;
    @NotNull
    private final HashSet<Vector3> affectedChunkCoordinates;
    private final double radiationLevel;
    private final int id;
    @Expose(serialize=false, deserialize=false)
    @NotNull
    private static final ConcurrentHashMap<Integer, RadiationArea> loadedRadiationAreas = new ConcurrentHashMap();

    public RadiationArea(@NotNull Vector3 center, @NotNull String worldName, @Nullable Vector3 minVertex, @Nullable Vector3 maxVertex, @NotNull HashSet<Vector3> affectedChunkCoordinates, double radiationLevel, int id) {
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Intrinsics.checkNotNullParameter(affectedChunkCoordinates, "affectedChunkCoordinates");
        this.center = center;
        this.worldName = worldName;
        this.minVertex = minVertex;
        this.maxVertex = maxVertex;
        this.affectedChunkCoordinates = affectedChunkCoordinates;
        this.radiationLevel = radiationLevel;
        this.id = id;
    }

    public /* synthetic */ RadiationArea(Vector3 vector3, String string, Vector3 vector32, Vector3 vector33, HashSet hashSet, double d, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            vector32 = null;
        }
        if ((n2 & 8) != 0) {
            vector33 = null;
        }
        if ((n2 & 0x10) != 0) {
            hashSet = new HashSet<Vector3>();
        }
        if ((n2 & 0x20) != 0) {
            d = 0.0;
        }
        if ((n2 & 0x40) != 0) {
            n = 0;
        }
        this(vector3, string, vector32, vector33, hashSet, d, n);
    }

    @NotNull
    public final Vector3 getCenter() {
        return this.center;
    }

    @NotNull
    public final String getWorldName() {
        return this.worldName;
    }

    @Nullable
    public final Vector3 getMinVertex() {
        return this.minVertex;
    }

    @Nullable
    public final Vector3 getMaxVertex() {
        return this.maxVertex;
    }

    @NotNull
    public final HashSet<Vector3> getAffectedChunkCoordinates() {
        return this.affectedChunkCoordinates;
    }

    public final double getRadiationLevel() {
        return this.radiationLevel;
    }

    public final int getId() {
        return this.id;
    }

    public final boolean checkIfInBounds(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        if (this.minVertex == null || this.maxVertex == null) {
            return false;
        }
        return location.getX() >= this.minVertex.getX() && location.getX() <= this.maxVertex.getX() && location.getY() >= this.minVertex.getY() && location.getY() <= this.maxVertex.getY() && location.getZ() >= this.minVertex.getZ() && location.getZ() <= this.maxVertex.getZ();
    }

    @NotNull
    public final Vector3 component1() {
        return this.center;
    }

    @NotNull
    public final String component2() {
        return this.worldName;
    }

    @Nullable
    public final Vector3 component3() {
        return this.minVertex;
    }

    @Nullable
    public final Vector3 component4() {
        return this.maxVertex;
    }

    @NotNull
    public final HashSet<Vector3> component5() {
        return this.affectedChunkCoordinates;
    }

    public final double component6() {
        return this.radiationLevel;
    }

    public final int component7() {
        return this.id;
    }

    @NotNull
    public final RadiationArea copy(@NotNull Vector3 center, @NotNull String worldName, @Nullable Vector3 minVertex, @Nullable Vector3 maxVertex, @NotNull HashSet<Vector3> affectedChunkCoordinates, double radiationLevel, int id) {
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Intrinsics.checkNotNullParameter(affectedChunkCoordinates, "affectedChunkCoordinates");
        return new RadiationArea(center, worldName, minVertex, maxVertex, affectedChunkCoordinates, radiationLevel, id);
    }

    public static /* synthetic */ RadiationArea copy$default(RadiationArea radiationArea, Vector3 vector3, String string, Vector3 vector32, Vector3 vector33, HashSet hashSet, double d, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            vector3 = radiationArea.center;
        }
        if ((n2 & 2) != 0) {
            string = radiationArea.worldName;
        }
        if ((n2 & 4) != 0) {
            vector32 = radiationArea.minVertex;
        }
        if ((n2 & 8) != 0) {
            vector33 = radiationArea.maxVertex;
        }
        if ((n2 & 0x10) != 0) {
            hashSet = radiationArea.affectedChunkCoordinates;
        }
        if ((n2 & 0x20) != 0) {
            d = radiationArea.radiationLevel;
        }
        if ((n2 & 0x40) != 0) {
            n = radiationArea.id;
        }
        return radiationArea.copy(vector3, string, vector32, vector33, hashSet, d, n);
    }

    @NotNull
    public String toString() {
        return "RadiationArea(center=" + this.center + ", worldName=" + this.worldName + ", minVertex=" + this.minVertex + ", maxVertex=" + this.maxVertex + ", affectedChunkCoordinates=" + this.affectedChunkCoordinates + ", radiationLevel=" + this.radiationLevel + ", id=" + this.id + ")";
    }

    public int hashCode() {
        int result = this.center.hashCode();
        result = result * 31 + this.worldName.hashCode();
        result = result * 31 + (this.minVertex == null ? 0 : this.minVertex.hashCode());
        result = result * 31 + (this.maxVertex == null ? 0 : this.maxVertex.hashCode());
        result = result * 31 + this.affectedChunkCoordinates.hashCode();
        result = result * 31 + Double.hashCode(this.radiationLevel);
        result = result * 31 + Integer.hashCode(this.id);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RadiationArea)) {
            return false;
        }
        RadiationArea radiationArea = (RadiationArea)other;
        if (!Intrinsics.areEqual(this.center, radiationArea.center)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.worldName, radiationArea.worldName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.minVertex, radiationArea.minVertex)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.maxVertex, radiationArea.maxVertex)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.affectedChunkCoordinates, radiationArea.affectedChunkCoordinates)) {
            return false;
        }
        if (Double.compare(this.radiationLevel, radiationArea.radiationLevel) != 0) {
            return false;
        }
        return this.id == radiationArea.id;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u000ej\b\u0012\u0004\u0012\u00020\u0006`\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002R\"\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/mochibit/defcon/radiation/RadiationArea$Companion;", "", "()V", "loadedRadiationAreas", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/mochibit/defcon/radiation/RadiationArea;", "getLoadedRadiationAreas", "()Ljava/util/concurrent/ConcurrentHashMap;", "checkIfInBounds", "", "location", "Lorg/bukkit/Location;", "getAtLocation", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "tryLoadFromLocation", "", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConcurrentHashMap<Integer, RadiationArea> getLoadedRadiationAreas() {
            return loadedRadiationAreas;
        }

        @NotNull
        public final HashSet<RadiationArea> getAtLocation(@NotNull Location location) {
            RadiationArea radiationArea;
            Intrinsics.checkNotNullParameter(location, "location");
            HashSet<RadiationArea> results = new HashSet<RadiationArea>();
            Integer currBlockRadId = LocationKt.getRadiationAreaId(location);
            if (currBlockRadId != null && (radiationArea = this.getLoadedRadiationAreas().get(currBlockRadId)) != null) {
                results.add(radiationArea);
            }
            for (RadiationArea area : this.getLoadedRadiationAreas().values()) {
                if (!area.checkIfInBounds(location)) continue;
                results.add(area);
            }
            return results;
        }

        public final boolean checkIfInBounds(@NotNull Location location) {
            Intrinsics.checkNotNullParameter(location, "location");
            for (RadiationArea area : this.getLoadedRadiationAreas().values()) {
                if (!area.checkIfInBounds(location)) continue;
                return true;
            }
            return false;
        }

        private final List<RadiationArea> tryLoadFromLocation(Location location) {
            World world = location.getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
            RadiationAreaSchema radiationAreaSchema = (RadiationAreaSchema)RadiationAreaSave.Companion.getSave(world).load();
            if (radiationAreaSchema == null) {
                return new ArrayList();
            }
            RadiationAreaSchema radiationAreaSave = radiationAreaSchema;
            ArrayList<RadiationArea> loadedRadiationAreas = new ArrayList<RadiationArea>();
            Integer radiationAreaId = LocationKt.getRadiationAreaId(location);
            for (RadiationArea radiationArea : radiationAreaSave.getRadiationAreas()) {
                if (radiationArea.checkIfInBounds(location)) {
                    loadedRadiationAreas.add(radiationArea);
                    continue;
                }
                if (radiationAreaId == null) continue;
                int n = radiationArea.getId();
                if (radiationAreaId != n) continue;
                loadedRadiationAreas.add(radiationArea);
            }
            return loadedRadiationAreas;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

