/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.particles;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.mochibit.defcon.Defcon;
import com.mochibit.defcon.math.Vector3;
import com.mochibit.defcon.particles.DisplayParticleProperties;
import com.mochibit.defcon.particles.RegistryName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 :2\u00020\u0001:\u0001:B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000fJ\b\u0010$\u001a\u00020\u0000H\u0002J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000bJ\u0010\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u000bJ\b\u0010+\u001a\u00020,H\u0002J \u0010-\u001a\u00020,2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\b\b\u0002\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020,2\u0006\u00107\u001a\u00020'H\u0002J\u0006\u00108\u001a\u00020\u0000J\b\u00109\u001a\u00020\u0000H\u0002R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0019\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001e\u0010\"\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000e\u00a8\u0006;"}, d2={"Lcom/mochibit/defcon/particles/DisplayItemAsyncHandler;", "", "loc", "Lorg/bukkit/Location;", "players", "", "Lorg/bukkit/entity/Player;", "properties", "Lcom/mochibit/defcon/particles/DisplayParticleProperties;", "(Lorg/bukkit/Location;Ljava/util/Collection;Lcom/mochibit/defcon/particles/DisplayParticleProperties;)V", "<set-?>", "Lcom/mochibit/defcon/math/Vector3;", "acceleration", "getAcceleration", "()Lcom/mochibit/defcon/math/Vector3;", "", "accelerationTicks", "getAccelerationTicks", "()I", "damping", "getDamping", "itemID", "getItemID", "itemUUID", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "getItemUUID", "()Ljava/util/UUID;", "getLoc", "()Lorg/bukkit/Location;", "getPlayers", "()Ljava/util/Collection;", "getProperties", "()Lcom/mochibit/defcon/particles/DisplayParticleProperties;", "velocity", "getVelocity", "applyMetadata", "despawn", "afterTicks", "", "getItem", "Lorg/bukkit/inventory/ItemStack;", "initialVelocity", "processMovement", "", "sendMetadata", "wrappedDataValues", "", "Lcom/comphenix/protocol/wrappers/WrappedDataValue;", "writeDefaults", "", "sendPacket", "packet", "Lcom/comphenix/protocol/events/PacketContainer;", "setTeleportDuration", "period", "summon", "updatePosition", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nDisplayItemAsyncHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayItemAsyncHandler.kt\ncom/mochibit/defcon/particles/DisplayItemAsyncHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1#2:286\n1855#3,2:287\n*S KotlinDebug\n*F\n+ 1 DisplayItemAsyncHandler.kt\ncom/mochibit/defcon/particles/DisplayItemAsyncHandler\n*L\n278#1:287,2\n*E\n"})
public final class DisplayItemAsyncHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Location loc;
    @NotNull
    private final Collection<? extends Player> players;
    @NotNull
    private final DisplayParticleProperties properties;
    private final int itemID;
    private final UUID itemUUID;
    @NotNull
    private Vector3 velocity;
    @NotNull
    private Vector3 damping;
    @NotNull
    private Vector3 acceleration;
    private int accelerationTicks;
    @NotNull
    private static final Map<RegistryName, WrappedDataWatcher.Serializer> cachedSerializers;

    public DisplayItemAsyncHandler(@NotNull Location loc, @NotNull Collection<? extends Player> players, @NotNull DisplayParticleProperties properties) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        Intrinsics.checkNotNullParameter(players, "players");
        Intrinsics.checkNotNullParameter(properties, "properties");
        this.loc = loc;
        this.players = players;
        this.properties = properties;
        this.itemID = (int)(Math.random() * (double)Integer.MAX_VALUE);
        this.itemUUID = UUID.randomUUID();
        this.velocity = new Vector3(0.0, 0.0, 0.0);
        this.damping = new Vector3(0.1, 0.1, 0.1);
        this.acceleration = new Vector3(0.0, 0.0, 0.0);
    }

    @NotNull
    public final Location getLoc() {
        return this.loc;
    }

    @NotNull
    public final Collection<? extends Player> getPlayers() {
        return this.players;
    }

    @NotNull
    public final DisplayParticleProperties getProperties() {
        return this.properties;
    }

    public final int getItemID() {
        return this.itemID;
    }

    public final UUID getItemUUID() {
        return this.itemUUID;
    }

    @NotNull
    public final Vector3 getVelocity() {
        return this.velocity;
    }

    @NotNull
    public final Vector3 getDamping() {
        return this.damping;
    }

    @NotNull
    public final Vector3 getAcceleration() {
        return this.acceleration;
    }

    public final int getAccelerationTicks() {
        return this.accelerationTicks;
    }

    @NotNull
    public final DisplayItemAsyncHandler initialVelocity(@NotNull Vector3 initialVelocity) {
        DisplayItemAsyncHandler displayItemAsyncHandler;
        Intrinsics.checkNotNullParameter(initialVelocity, "initialVelocity");
        DisplayItemAsyncHandler $this$initialVelocity_u24lambda_u240 = displayItemAsyncHandler = this;
        boolean bl = false;
        $this$initialVelocity_u24lambda_u240.velocity = initialVelocity.clone();
        return displayItemAsyncHandler;
    }

    @NotNull
    public final DisplayItemAsyncHandler damping(@NotNull Vector3 damping) {
        DisplayItemAsyncHandler displayItemAsyncHandler;
        Intrinsics.checkNotNullParameter(damping, "damping");
        DisplayItemAsyncHandler $this$damping_u24lambda_u241 = displayItemAsyncHandler = this;
        boolean bl = false;
        $this$damping_u24lambda_u241.damping = damping.clone();
        return displayItemAsyncHandler;
    }

    @NotNull
    public final DisplayItemAsyncHandler acceleration(@NotNull Vector3 acceleration) {
        DisplayItemAsyncHandler displayItemAsyncHandler;
        Intrinsics.checkNotNullParameter(acceleration, "acceleration");
        DisplayItemAsyncHandler $this$acceleration_u24lambda_u242 = displayItemAsyncHandler = this;
        boolean bl = false;
        $this$acceleration_u24lambda_u242.acceleration = acceleration.clone();
        return displayItemAsyncHandler;
    }

    @NotNull
    public final DisplayItemAsyncHandler accelerationTicks(int accelerationTicks) {
        DisplayItemAsyncHandler displayItemAsyncHandler;
        DisplayItemAsyncHandler $this$accelerationTicks_u24lambda_u243 = displayItemAsyncHandler = this;
        boolean bl = false;
        $this$accelerationTicks_u24lambda_u243.accelerationTicks = accelerationTicks;
        return displayItemAsyncHandler;
    }

    @NotNull
    public final DisplayItemAsyncHandler summon() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY);
        packet.getIntegers().write(0, (Object)this.itemID);
        packet.getUUIDs().write(0, (Object)this.itemUUID);
        packet.getEntityTypeModifier().write(0, (Object)EntityType.ITEM_DISPLAY);
        packet.getDoubles().write(0, (Object)this.loc.getX());
        packet.getDoubles().write(1, (Object)this.loc.getY());
        packet.getDoubles().write(2, (Object)this.loc.getZ());
        this.sendPacket(packet);
        this.applyMetadata();
        this.processMovement();
        this.despawn(this.properties.getMaxLife());
        return this;
    }

    private final void processMovement() {
        long initialPeriod = 10L;
        long minPeriod = 5L;
        long maxPeriod = 20L;
        double speedThreshold = 0.5;
        new BukkitRunnable(initialPeriod, this, speedThreshold, minPeriod, maxPeriod){
            private long runTime;
            private long currentPeriod;
            final /* synthetic */ long $initialPeriod;
            final /* synthetic */ DisplayItemAsyncHandler this$0;
            final /* synthetic */ double $speedThreshold;
            final /* synthetic */ long $minPeriod;
            final /* synthetic */ long $maxPeriod;
            {
                this.$initialPeriod = $initialPeriod;
                this.this$0 = $receiver;
                this.$speedThreshold = $speedThreshold;
                this.$minPeriod = $minPeriod;
                this.$maxPeriod = $maxPeriod;
                this.currentPeriod = $initialPeriod;
            }

            public final long getRunTime() {
                return this.runTime;
            }

            public final void setRunTime(long l) {
                this.runTime = l;
            }

            public final long getCurrentPeriod() {
                return this.currentPeriod;
            }

            public final void setCurrentPeriod(long l) {
                this.currentPeriod = l;
            }

            /*
             * WARNING - void declaration
             */
            public void run() {
                double playerDistance;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                if (this.runTime >= this.this$0.getProperties().getMaxLife()) {
                    this.cancel();
                    return;
                }
                if (Intrinsics.areEqual(this.this$0.getAcceleration(), new Vector3(0.0, 0.0, 0.0)) && Intrinsics.areEqual(this.this$0.getDamping(), new Vector3(0.0, 0.0, 0.0))) {
                    if (!Intrinsics.areEqual(this.this$0.getVelocity(), new Vector3(0.0, 0.0, 0.0))) {
                        this.this$0.getLoc().add(this.this$0.getVelocity().getX(), this.this$0.getVelocity().getY(), this.this$0.getVelocity().getZ());
                        DisplayItemAsyncHandler.access$setTeleportDuration(this.this$0, this.currentPeriod);
                        DisplayItemAsyncHandler.access$updatePosition(this.this$0);
                    }
                } else {
                    if (this.runTime < (long)this.this$0.getAccelerationTicks()) {
                        Vector3 vector3 = this.this$0.getVelocity();
                        vector3.setX(vector3.getX() + this.this$0.getAcceleration().getX() / (20.0 / (double)this.currentPeriod));
                        vector3 = this.this$0.getVelocity();
                        vector3.setY(vector3.getY() + this.this$0.getAcceleration().getY() / (20.0 / (double)this.currentPeriod));
                        vector3 = this.this$0.getVelocity();
                        vector3.setZ(vector3.getZ() + this.this$0.getAcceleration().getZ() / (20.0 / (double)this.currentPeriod));
                    }
                    this.this$0.getVelocity().setX(RangesKt.coerceAtLeast(this.this$0.getVelocity().getX() * (1.0 - this.this$0.getDamping().getX() / (20.0 / (double)this.currentPeriod)), 0.0));
                    this.this$0.getVelocity().setY(RangesKt.coerceAtLeast(this.this$0.getVelocity().getY() * (1.0 - this.this$0.getDamping().getY() / (20.0 / (double)this.currentPeriod)), 0.0));
                    this.this$0.getVelocity().setZ(RangesKt.coerceAtLeast(this.this$0.getVelocity().getZ() * (1.0 - this.this$0.getDamping().getZ() / (20.0 / (double)this.currentPeriod)), 0.0));
                    this.this$0.getLoc().add(this.this$0.getVelocity().getX(), this.this$0.getVelocity().getY(), this.this$0.getVelocity().getZ());
                    DisplayItemAsyncHandler.access$setTeleportDuration(this.this$0, this.currentPeriod);
                    DisplayItemAsyncHandler.access$updatePosition(this.this$0);
                }
                double speed = Math.sqrt(this.this$0.getVelocity().getX() * this.this$0.getVelocity().getX() + this.this$0.getVelocity().getY() * this.this$0.getVelocity().getY() + this.this$0.getVelocity().getZ() * this.this$0.getVelocity().getZ());
                Iterable iterable = this.this$0.getPlayers();
                DisplayItemAsyncHandler displayItemAsyncHandler = this.this$0;
                boolean $i$f$map = false;
                void var8_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player player = (Player)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getLocation().distance(displayItemAsyncHandler.getLoc()));
                }
                T t = CollectionsKt.minOrNull((List)destination$iv$iv);
                double d = playerDistance = t != null ? (Double)t : 0.0;
                this.currentPeriod = speed > this.$speedThreshold ? this.$minPeriod : (playerDistance < 10.0 ? this.$initialPeriod : (playerDistance < 50.0 ? this.$initialPeriod * (long)2 : this.$maxPeriod));
                this.runTime += this.currentPeriod;
            }
        }.runTaskTimerAsynchronously((Plugin)Defcon.Companion.getInstance(), 0L, initialPeriod);
    }

    private final void setTeleportDuration(long period) {
        long teleportDuration = period * (long)2;
        WrappedDataValue[] wrappedDataValueArray = new WrappedDataValue[]{new WrappedDataValue(10, WrappedDataWatcher.Registry.get(Integer.class), (Object)((int)teleportDuration))};
        List<WrappedDataValue> packedItems = CollectionsKt.mutableListOf(wrappedDataValueArray);
        DisplayItemAsyncHandler.sendMetadata$default(this, packedItems, false, 2, null);
    }

    private final DisplayItemAsyncHandler updatePosition() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        packet.getIntegers().write(0, (Object)this.itemID);
        packet.getDoubles().write(0, (Object)this.loc.getX());
        packet.getDoubles().write(1, (Object)this.loc.getY());
        packet.getDoubles().write(2, (Object)this.loc.getZ());
        packet.getBytes().write(0, (Object)0);
        packet.getBytes().write(1, (Object)0);
        packet.getBooleans().write(0, (Object)false);
        this.sendPacket(packet);
        return this;
    }

    private final DisplayItemAsyncHandler despawn(long afterTicks) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Defcon.Companion.getInstance(), () -> DisplayItemAsyncHandler.despawn$lambda$4(this), afterTicks);
        return this;
    }

    private final DisplayItemAsyncHandler applyMetadata() {
        int brightnessValue = this.properties.getBrightness().getBlockLight() << 4 | this.properties.getBrightness().getSkyLight() << 20;
        WrappedDataValue[] wrappedDataValueArray = new WrappedDataValue[]{new WrappedDataValue(8, cachedSerializers.get((Object)RegistryName.Int), (Object)this.properties.getInterpolationDelay()), new WrappedDataValue(9, cachedSerializers.get((Object)RegistryName.Int), (Object)this.properties.getInterpolationDuration()), new WrappedDataValue(10, cachedSerializers.get((Object)RegistryName.Int), (Object)this.properties.getTeleportDuration()), new WrappedDataValue(11, cachedSerializers.get((Object)RegistryName.Vector3f), (Object)this.properties.getTranslation()), new WrappedDataValue(12, cachedSerializers.get((Object)RegistryName.Vector3f), (Object)this.properties.getScale()), new WrappedDataValue(13, cachedSerializers.get((Object)RegistryName.Quatenionf), (Object)this.properties.getRotationLeft()), new WrappedDataValue(14, cachedSerializers.get((Object)RegistryName.Quatenionf), (Object)this.properties.getRotationRight()), new WrappedDataValue(15, cachedSerializers.get((Object)RegistryName.Byte), (Object)((byte)this.properties.getBillboard().ordinal())), new WrappedDataValue(16, cachedSerializers.get((Object)RegistryName.Int), (Object)brightnessValue), new WrappedDataValue(17, cachedSerializers.get((Object)RegistryName.Float), (Object)Float.valueOf(this.properties.getViewRange())), new WrappedDataValue(18, cachedSerializers.get((Object)RegistryName.Float), (Object)Float.valueOf(this.properties.getShadowRadius())), new WrappedDataValue(19, cachedSerializers.get((Object)RegistryName.Float), (Object)Float.valueOf(this.properties.getShadowStrength())), new WrappedDataValue(20, cachedSerializers.get((Object)RegistryName.Float), (Object)Float.valueOf(this.properties.getWidth())), new WrappedDataValue(21, cachedSerializers.get((Object)RegistryName.Float), (Object)Float.valueOf(this.properties.getHeight())), new WrappedDataValue(23, cachedSerializers.get((Object)RegistryName.ItemStack), MinecraftReflection.getMinecraftItemStack((ItemStack)this.getItem()))};
        List<WrappedDataValue> packedItems = CollectionsKt.mutableListOf(wrappedDataValueArray);
        this.sendMetadata(packedItems, true);
        return this;
    }

    private final ItemStack getItem() {
        ItemStack itemStack = this.properties.getItemStack().clone();
        Intrinsics.checkNotNullExpressionValue(itemStack, "clone(...)");
        ItemStack itemStack2 = itemStack;
        ItemMeta itemStackMeta = itemStack2.getItemMeta();
        if (this.properties.getColor() != null && itemStackMeta instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)itemStackMeta).setColor(this.properties.getColor());
        }
        if (this.properties.getModelData() != null) {
            itemStackMeta.setCustomModelData(this.properties.getModelData());
        }
        itemStack2.setItemMeta(itemStackMeta);
        return itemStack2;
    }

    private final void sendMetadata(List<? extends WrappedDataValue> wrappedDataValues, boolean writeDefaults) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
        packet.getModifier().writeDefaults();
        packet.getIntegers().write(0, (Object)this.itemID);
        packet.getDataValueCollectionModifier().write(0, wrappedDataValues);
        this.sendPacket(packet);
    }

    static /* synthetic */ void sendMetadata$default(DisplayItemAsyncHandler displayItemAsyncHandler, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        displayItemAsyncHandler.sendMetadata(list, bl);
    }

    private final void sendPacket(PacketContainer packet) {
        try {
            Iterable $this$forEach$iv = this.players;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player = (Player)element$iv;
                boolean bl = false;
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final void despawn$lambda$4(DisplayItemAsyncHandler this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        packet.getIntLists().write(0, CollectionsKt.listOf(this$0.itemID));
        this$0.sendPacket(packet);
    }

    public static final /* synthetic */ void access$setTeleportDuration(DisplayItemAsyncHandler $this, long period) {
        $this.setTeleportDuration(period);
    }

    public static final /* synthetic */ DisplayItemAsyncHandler access$updatePosition(DisplayItemAsyncHandler $this) {
        return $this.updatePosition();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(RegistryName.Vector3f, WrappedDataWatcher.Registry.get(Vector3f.class)), TuplesKt.to(RegistryName.Quatenionf, WrappedDataWatcher.Registry.get(Quaternionf.class)), TuplesKt.to(RegistryName.Byte, WrappedDataWatcher.Registry.get(Byte.class)), TuplesKt.to(RegistryName.Int, WrappedDataWatcher.Registry.get(Integer.class)), TuplesKt.to(RegistryName.Float, WrappedDataWatcher.Registry.get(Float.class)), TuplesKt.to(RegistryName.ItemStack, WrappedDataWatcher.Registry.getItemStackSerializer((boolean)false))};
        cachedSerializers = MapsKt.mutableMapOf(pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/mochibit/defcon/particles/DisplayItemAsyncHandler$Companion;", "", "()V", "cachedSerializers", "", "Lcom/mochibit/defcon/particles/RegistryName;", "Lcom/comphenix/protocol/wrappers/WrappedDataWatcher$Serializer;", "getCachedSerializers", "()Ljava/util/Map;", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<RegistryName, WrappedDataWatcher.Serializer> getCachedSerializers() {
            return cachedSerializers;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

