/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.particles;

import com.mochibit.defcon.math.Vector3;
import com.mochibit.defcon.particles.GenericParticleProperties;
import com.mochibit.defcon.particles.PluginParticle;
import com.mochibit.defcon.utils.ColorUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.bukkit.Color;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\t\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0015J\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u001bJ\b\u00108\u001a\u00020(H\u0002J\b\u00109\u001a\u00020(H\u0002J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0011J\u0016\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u0006J\u0016\u0010>\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u0006J\u0016\u0010\u0012\u001a\u00020\u00002\u000e\u0010?\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010J\u000e\u0010@\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0015J+\u0010)\u001a\u00020\u00002#\u0010A\u001a\u001f\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020(\u0018\u00010#J\u000e\u0010B\u001a\u00020\u00002\u0006\u00107\u001a\u00020CJ\u0010\u0010D\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\u0006H\u0002J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010F\u001a\u00020.J\u0010\u0010/\u001a\u00020\u00112\u0006\u0010:\u001a\u00020\u0011H\u0002J\u000e\u00102\u001a\u00020\u00002\u0006\u0010F\u001a\u00020.J\u000e\u0010G\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0015J\u0010\u0010H\u001a\u00020(2\u0006\u0010'\u001a\u00020$H\u0016J\u0010\u0010I\u001a\u00020(2\u0006\u0010'\u001a\u00020$H$J\u000e\u0010J\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0015R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u001e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR.\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018R\u001e\u0010!\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018RX\u0010)\u001a\u001f\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020(\u0018\u00010#2#\u0010\u0005\u001a\u001f\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020(\u0018\u00010#@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001e\u0010/\u001a\u00020.2\u0006\u0010\u0005\u001a\u00020.@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001e\u00102\u001a\u00020.2\u0006\u0010\u0005\u001a\u00020.@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00101\u00a8\u0006K"}, d2={"Lcom/mochibit/defcon/particles/AbstractParticle;", "Lcom/mochibit/defcon/particles/PluginParticle;", "particleProperties", "Lcom/mochibit/defcon/particles/GenericParticleProperties;", "(Lcom/mochibit/defcon/particles/GenericParticleProperties;)V", "<set-?>", "", "colorDarkenFactorMax", "getColorDarkenFactorMax", "()D", "colorDarkenFactorMin", "getColorDarkenFactorMin", "colorLightenFactorMax", "getColorLightenFactorMax", "colorLightenFactorMin", "getColorLightenFactorMin", "Lkotlin/Function0;", "Lorg/bukkit/Color;", "colorSupplier", "getColorSupplier", "()Lkotlin/jvm/functions/Function0;", "Lcom/mochibit/defcon/math/Vector3;", "displacement", "getDisplacement", "()Lcom/mochibit/defcon/math/Vector3;", "initialAcceleration", "getInitialAcceleration", "", "initialAccelerationTicks", "getInitialAccelerationTicks", "()I", "initialDamping", "getInitialDamping", "initialVelocity", "getInitialVelocity", "Lkotlin/Function1;", "Lorg/bukkit/Location;", "Lkotlin/ParameterName;", "name", "location", "", "locationConsumer", "getLocationConsumer", "()Lkotlin/jvm/functions/Function1;", "getParticleProperties", "()Lcom/mochibit/defcon/particles/GenericParticleProperties;", "", "randomizeColorBrightness", "getRandomizeColorBrightness", "()Z", "randomizeScale", "getRandomizeScale", "acceleration", "vector3", "accelerationTicks", "ticks", "applyRandomDisplacement", "applyRandomScale", "color", "colorDarkenFactor", "min", "max", "colorLightenFactor", "supplier", "damping", "consumer", "maxLife", "", "randomDisplacement", "value", "randomize", "scale", "spawn", "spawnParticle", "velocity", "Defcon"})
@SourceDebugExtension(value={"SMAP\nAbstractParticle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractParticle.kt\ncom/mochibit/defcon/particles/AbstractParticle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public abstract class AbstractParticle
implements PluginParticle {
    @NotNull
    private final GenericParticleProperties particleProperties;
    @Nullable
    private Function0<Color> colorSupplier;
    @Nullable
    private Function1<? super Location, Unit> locationConsumer;
    @NotNull
    private Vector3 initialVelocity;
    @NotNull
    private Vector3 initialDamping;
    @NotNull
    private Vector3 initialAcceleration;
    private int initialAccelerationTicks;
    private boolean randomizeColorBrightness;
    private boolean randomizeScale;
    @NotNull
    private Vector3 displacement;
    private double colorDarkenFactorMin;
    private double colorDarkenFactorMax;
    private double colorLightenFactorMin;
    private double colorLightenFactorMax;

    public AbstractParticle(@NotNull GenericParticleProperties particleProperties) {
        Intrinsics.checkNotNullParameter(particleProperties, "particleProperties");
        this.particleProperties = particleProperties;
        this.initialVelocity = new Vector3(0.0, 0.0, 0.0);
        this.initialDamping = new Vector3(0.0, 0.0, 0.0);
        this.initialAcceleration = new Vector3(0.0, 0.0, 0.0);
        this.randomizeColorBrightness = true;
        this.displacement = new Vector3(0.0, 0.0, 0.0);
        this.colorDarkenFactorMin = 0.8;
        this.colorDarkenFactorMax = 1.0;
        this.colorLightenFactorMin = 0.1;
        this.colorLightenFactorMax = 0.2;
    }

    @NotNull
    public final GenericParticleProperties getParticleProperties() {
        return this.particleProperties;
    }

    @Nullable
    public final Function0<Color> getColorSupplier() {
        return this.colorSupplier;
    }

    @Nullable
    public final Function1<Location, Unit> getLocationConsumer() {
        return this.locationConsumer;
    }

    @NotNull
    public final Vector3 getInitialVelocity() {
        return this.initialVelocity;
    }

    @NotNull
    public final Vector3 getInitialDamping() {
        return this.initialDamping;
    }

    @NotNull
    public final Vector3 getInitialAcceleration() {
        return this.initialAcceleration;
    }

    public final int getInitialAccelerationTicks() {
        return this.initialAccelerationTicks;
    }

    public final boolean getRandomizeColorBrightness() {
        return this.randomizeColorBrightness;
    }

    public final boolean getRandomizeScale() {
        return this.randomizeScale;
    }

    @NotNull
    public final Vector3 getDisplacement() {
        return this.displacement;
    }

    public final double getColorDarkenFactorMin() {
        return this.colorDarkenFactorMin;
    }

    public final double getColorDarkenFactorMax() {
        return this.colorDarkenFactorMax;
    }

    public final double getColorLightenFactorMin() {
        return this.colorLightenFactorMin;
    }

    public final double getColorLightenFactorMax() {
        return this.colorLightenFactorMax;
    }

    @NotNull
    public final AbstractParticle accelerationTicks(int ticks) {
        AbstractParticle abstractParticle;
        AbstractParticle $this$accelerationTicks_u24lambda_u240 = abstractParticle = this;
        boolean bl = false;
        $this$accelerationTicks_u24lambda_u240.initialAccelerationTicks = ticks;
        return abstractParticle;
    }

    @NotNull
    public final AbstractParticle acceleration(@NotNull Vector3 vector3) {
        AbstractParticle abstractParticle;
        Intrinsics.checkNotNullParameter(vector3, "vector3");
        AbstractParticle $this$acceleration_u24lambda_u241 = abstractParticle = this;
        boolean bl = false;
        $this$acceleration_u24lambda_u241.initialAcceleration = vector3;
        return abstractParticle;
    }

    @NotNull
    public final AbstractParticle damping(@NotNull Vector3 vector3) {
        AbstractParticle abstractParticle;
        Intrinsics.checkNotNullParameter(vector3, "vector3");
        AbstractParticle $this$damping_u24lambda_u242 = abstractParticle = this;
        boolean bl = false;
        $this$damping_u24lambda_u242.initialDamping = vector3;
        return abstractParticle;
    }

    @NotNull
    public final AbstractParticle velocity(@NotNull Vector3 vector3) {
        AbstractParticle abstractParticle;
        Intrinsics.checkNotNullParameter(vector3, "vector3");
        AbstractParticle $this$velocity_u24lambda_u243 = abstractParticle = this;
        boolean bl = false;
        $this$velocity_u24lambda_u243.initialVelocity = vector3;
        return abstractParticle;
    }

    @NotNull
    public final AbstractParticle randomizeColorBrightness(boolean randomize) {
        AbstractParticle abstractParticle;
        AbstractParticle $this$randomizeColorBrightness_u24lambda_u244 = abstractParticle = this;
        boolean bl = false;
        $this$randomizeColorBrightness_u24lambda_u244.randomizeColorBrightness = randomize;
        return abstractParticle;
    }

    @NotNull
    public final AbstractParticle displacement(@NotNull Vector3 vector3) {
        AbstractParticle abstractParticle;
        Intrinsics.checkNotNullParameter(vector3, "vector3");
        AbstractParticle $this$displacement_u24lambda_u245 = abstractParticle = this;
        boolean bl = false;
        $this$displacement_u24lambda_u245.displacement = vector3;
        return abstractParticle;
    }

    @NotNull
    public final AbstractParticle colorSupplier(@Nullable Function0<Color> supplier) {
        AbstractParticle abstractParticle;
        AbstractParticle $this$colorSupplier_u24lambda_u246 = abstractParticle = this;
        boolean bl = false;
        $this$colorSupplier_u24lambda_u246.colorSupplier = supplier;
        return abstractParticle;
    }

    @NotNull
    public final AbstractParticle locationConsumer(@Nullable Function1<? super Location, Unit> consumer) {
        AbstractParticle abstractParticle;
        AbstractParticle $this$locationConsumer_u24lambda_u247 = abstractParticle = this;
        boolean bl = false;
        $this$locationConsumer_u24lambda_u247.locationConsumer = consumer;
        return abstractParticle;
    }

    @NotNull
    public final AbstractParticle scale(@NotNull Vector3 scale) {
        AbstractParticle abstractParticle;
        Intrinsics.checkNotNullParameter(scale, "scale");
        AbstractParticle $this$scale_u24lambda_u248 = abstractParticle = this;
        boolean bl = false;
        $this$scale_u24lambda_u248.particleProperties.setScale(new Vector3f((float)scale.getX(), (float)scale.getY(), (float)scale.getZ()));
        return abstractParticle;
    }

    @NotNull
    public final AbstractParticle maxLife(long ticks) {
        AbstractParticle abstractParticle;
        AbstractParticle $this$maxLife_u24lambda_u249 = abstractParticle = this;
        boolean bl = false;
        $this$maxLife_u24lambda_u249.particleProperties.setMaxLife(ticks);
        return abstractParticle;
    }

    @NotNull
    public final AbstractParticle randomizeScale(boolean randomize) {
        AbstractParticle abstractParticle;
        AbstractParticle $this$randomizeScale_u24lambda_u2410 = abstractParticle = this;
        boolean bl = false;
        $this$randomizeScale_u24lambda_u2410.randomizeScale = randomize;
        return abstractParticle;
    }

    @NotNull
    public final AbstractParticle color(@NotNull Color color) {
        AbstractParticle abstractParticle;
        Intrinsics.checkNotNullParameter(color, "color");
        AbstractParticle $this$color_u24lambda_u2411 = abstractParticle = this;
        boolean bl = false;
        $this$color_u24lambda_u2411.particleProperties.setColor(color);
        return abstractParticle;
    }

    @NotNull
    public final AbstractParticle colorDarkenFactor(double min, double max) {
        AbstractParticle abstractParticle;
        AbstractParticle $this$colorDarkenFactor_u24lambda_u2412 = abstractParticle = this;
        boolean bl = false;
        if (min > max) {
            $this$colorDarkenFactor_u24lambda_u2412.colorDarkenFactorMin = max;
            $this$colorDarkenFactor_u24lambda_u2412.colorDarkenFactorMax = min;
        } else {
            $this$colorDarkenFactor_u24lambda_u2412.colorDarkenFactorMin = min;
            $this$colorDarkenFactor_u24lambda_u2412.colorDarkenFactorMax = max;
        }
        return abstractParticle;
    }

    @NotNull
    public final AbstractParticle colorLightenFactor(double min, double max) {
        AbstractParticle abstractParticle;
        AbstractParticle $this$colorLightenFactor_u24lambda_u2413 = abstractParticle = this;
        boolean bl = false;
        if (min > max) {
            $this$colorLightenFactor_u24lambda_u2413.colorLightenFactorMin = max;
            $this$colorLightenFactor_u24lambda_u2413.colorLightenFactorMax = min;
        } else {
            $this$colorLightenFactor_u24lambda_u2413.colorLightenFactorMin = min;
            $this$colorLightenFactor_u24lambda_u2413.colorLightenFactorMax = max;
        }
        return abstractParticle;
    }

    protected abstract void spawnParticle(@NotNull Location var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public void spawn(@NotNull Location location) {
        Color color;
        Intrinsics.checkNotNullParameter(location, "location");
        Function1<? super Location, Unit> function1 = this.locationConsumer;
        if (function1 != null) {
            function1.invoke((Location)location);
        }
        Color startingColor = this.particleProperties.getColor();
        GenericParticleProperties genericParticleProperties = this.particleProperties;
        Color color2 = this.particleProperties.getColor();
        if (color2 != null) {
            Color finalColor;
            Color color3 = color2;
            GenericParticleProperties genericParticleProperties2 = genericParticleProperties;
            boolean bl = false;
            Color color4 = this.colorSupplier;
            if (color4 == null || (color4 = color4.invoke()) == null) {
                void color5;
                color4 = finalColor = color5;
            }
            if (this.randomizeColorBrightness) {
                finalColor = this.randomizeColorBrightness(finalColor);
            }
            color = finalColor;
            genericParticleProperties = genericParticleProperties2;
        } else {
            color = null;
        }
        genericParticleProperties.setColor(color);
        this.applyRandomScale();
        this.applyRandomDisplacement();
        this.spawnParticle(location);
        this.particleProperties.setColor(startingColor);
    }

    private final void applyRandomScale() {
        if (!this.randomizeScale) {
            return;
        }
        double randomizedFactor = Random.Default.nextDouble(0.9, 1.1);
        Vector3f vector3f = this.particleProperties.getScale().mul((float)randomizedFactor);
        Intrinsics.checkNotNullExpressionValue(vector3f, "mul(...)");
        this.particleProperties.setScale(vector3f);
    }

    private final Color randomizeColorBrightness(Color color) {
        double factor = 0.0;
        if (Random.Default.nextBoolean()) {
            if (this.colorDarkenFactorMax == 0.0 && this.colorDarkenFactorMin == 0.0) {
                return color;
            }
            factor = this.colorDarkenFactorMin == this.colorDarkenFactorMax ? this.colorDarkenFactorMin : Random.Default.nextDouble(this.colorDarkenFactorMin, this.colorDarkenFactorMax);
            return ColorUtils.INSTANCE.darkenColor(color, factor);
        }
        if (this.colorLightenFactorMax == 0.0 && this.colorLightenFactorMin == 0.0) {
            return color;
        }
        factor = this.colorLightenFactorMin == this.colorLightenFactorMax ? this.colorLightenFactorMin : Random.Default.nextDouble(this.colorLightenFactorMin, this.colorLightenFactorMax);
        return ColorUtils.INSTANCE.lightenColor(color, factor);
    }

    private final void applyRandomDisplacement() {
        if (Intrinsics.areEqual(this.displacement, new Vector3(0.0, 0.0, 0.0))) {
            return;
        }
        Vector3 vector3 = this.displacement;
        double x = vector3.component1();
        double y = vector3.component2();
        double z = vector3.component3();
        this.initialVelocity = new Vector3(this.initialVelocity.getX() + (!(x == 0.0) ? this.randomDisplacement(x) : 0.0), this.initialVelocity.getY() + (!(y == 0.0) ? this.randomDisplacement(y) : 0.0), this.initialVelocity.getZ() + (!(z == 0.0) ? this.randomDisplacement(z) : 0.0));
    }

    private final double randomDisplacement(double value) {
        return value > 0.0 ? Random.Default.nextDouble(0.0, value) : Random.Default.nextDouble(value, 0.0);
    }
}

