/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.math;

import com.mochibit.defcon.math.Basis;
import com.mochibit.defcon.utils.MathFunctions;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 L2\u00020\u0001:\u0001LB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0000J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000J\b\u0010\u0017\u001a\u00020\u0000H\u0016J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u001a\u001a\u00020\u0004H\u0086\u0002J\t\u0010\u001b\u001a\u00020\u0004H\u0086\u0002J\t\u0010\u001c\u001a\u00020\u0004H\u0086\u0002J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000J\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0000J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0000J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0004H\u0086\u0002J\u0011\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\u0004H\u0086\u0002J\u000e\u0010$\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0000J\u0013\u0010%\u001a\u00020&2\b\u0010\u0012\u001a\u0004\u0018\u00010'H\u0096\u0002J\u0006\u0010(\u001a\u00020\u0000J\u0011\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0019H\u0086\u0002J\b\u0010+\u001a\u00020\u0019H\u0016J\u0006\u0010,\u001a\u00020&J\u0006\u0010-\u001a\u00020\u0004J\u0006\u0010.\u001a\u00020\u0004J\u0016\u0010/\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000J\u0011\u00101\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0011\u00102\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0006\u00103\u001a\u00020#J\u0006\u00104\u001a\u00020\u0000J\u0011\u00105\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0011\u00106\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0016\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0004J\u0006\u0010:\u001a\u00020\u0000J\u0019\u0010;\u001a\u00020#2\u0006\u0010*\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u0004H\u0086\u0002J\u0006\u0010=\u001a\u00020\u0000J\u0016\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0004J\u0011\u0010A\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010A\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0004H\u0086\u0002J\u0011\u0010B\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010B\u001a\u00020#2\u0006\u0010!\u001a\u00020\u0004H\u0086\u0002J\u0006\u0010C\u001a\u00020DJ\u000e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HJ\b\u0010I\u001a\u00020JH\u0016J\t\u0010K\u001a\u00020\u0000H\u0086\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006M"}, d2={"Lcom/mochibit/defcon/math/Vector3;", "", "()V", "x", "", "y", "z", "(DDD)V", "getX", "()D", "setX", "(D)V", "getY", "setY", "getZ", "setZ", "abs", "angleTo", "other", "ceil", "clamp", "min", "max", "clone", "compareTo", "", "component1", "component2", "component3", "cross", "distance", "distanceSquared", "div", "scalar", "divAssign", "", "dot", "equals", "", "", "floor", "get", "index", "hashCode", "isFinite", "length", "lengthSquared", "lerp", "t", "minus", "minusAssign", "normalize", "normalized", "plus", "plusAssign", "rotated", "axis", "angle", "round", "set", "value", "sign", "slerp", "to", "weight", "times", "timesAssign", "toBukkitVector", "Lorg/bukkit/util/Vector;", "toLocation", "Lorg/bukkit/Location;", "world", "Lorg/bukkit/World;", "toString", "", "unaryMinus", "Companion", "Defcon"})
public final class Vector3
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double x;
    private double y;
    private double z;
    @NotNull
    private static final Vector3 ZERO = new Vector3(0.0, 0.0, 0.0);
    @NotNull
    private static final Vector3 LEFT = new Vector3(-1.0, 0.0, 0.0);
    @NotNull
    private static final Vector3 RIGHT = new Vector3(1.0, 0.0, 0.0);
    @NotNull
    private static final Vector3 UP = new Vector3(0.0, 1.0, 0.0);
    @NotNull
    private static final Vector3 DOWN = new Vector3(0.0, -1.0, 0.0);
    @NotNull
    private static final Vector3 FORWARD = new Vector3(0.0, 0.0, 1.0);
    @NotNull
    private static final Vector3 BACKWARD = new Vector3(0.0, 0.0, -1.0);

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d) {
        this.z = d;
    }

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final void normalize() {
        double lengthSq = this.lengthSquared();
        if (lengthSq == 0.0) {
            return;
        }
        double length = Math.sqrt(lengthSq);
        this.x /= length;
        this.y /= length;
        this.z /= length;
    }

    @NotNull
    public final Vector3 normalized() {
        Vector3 result = this.clone();
        result.normalize();
        return result;
    }

    public final double dot(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    @NotNull
    public final Vector3 cross(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Vector3(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    @NotNull
    public final Vector3 min(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Vector3(Math.min(this.x, other.x), Math.min(this.y, other.y), Math.min(this.z, other.z));
    }

    @NotNull
    public final Vector3 max(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Vector3(Math.max(this.x, other.x), Math.max(this.y, other.y), Math.max(this.z, other.z));
    }

    @NotNull
    public final Vector3 abs() {
        return new Vector3(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    @NotNull
    public final Vector3 sign() {
        return new Vector3(Math.signum(this.x), Math.signum(this.y), Math.signum(this.z));
    }

    @NotNull
    public final Vector3 ceil() {
        return new Vector3(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
    }

    @NotNull
    public final Vector3 floor() {
        return new Vector3(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    @NotNull
    public final Vector3 round() {
        return new Vector3(Math.rint(this.x), Math.rint(this.y), Math.rint(this.z));
    }

    public final double distanceSquared(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double dx = this.x - other.x;
        double dy = this.y - other.y;
        double dz = this.z - other.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public final double distance(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Math.sqrt(this.distanceSquared(other));
    }

    @NotNull
    public final Vector3 lerp(@NotNull Vector3 other, double t) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Vector3(MathFunctions.INSTANCE.lerp(this.x, other.x, t), MathFunctions.INSTANCE.lerp(this.y, other.y, t), MathFunctions.INSTANCE.lerp(this.z, other.z, t));
    }

    @NotNull
    public final Vector3 slerp(@NotNull Vector3 to, double weight) {
        Intrinsics.checkNotNullParameter(to, "to");
        double startLengthSq = this.lengthSquared();
        double endLengthSq = to.lengthSquared();
        if (startLengthSq == 0.0 || endLengthSq == 0.0) {
            return this.lerp(to, weight);
        }
        Vector3 axis = this.cross(to);
        double axisLengthSq = axis.lengthSquared();
        if (axisLengthSq == 0.0) {
            return this.lerp(to, weight);
        }
        axis.divAssign(Math.sqrt(axisLengthSq));
        double startLength = Math.sqrt(startLengthSq);
        double resultLength = MathFunctions.INSTANCE.lerp(startLength, Math.sqrt(endLengthSq), weight);
        double angle = this.angleTo(to);
        return this.rotated(axis, angle * weight).times(resultLength / startLength);
    }

    @NotNull
    public final Vector3 rotated(@NotNull Vector3 axis, double angle) {
        Intrinsics.checkNotNullParameter(axis, "axis");
        return new Basis(axis, angle).xform(this);
    }

    @NotNull
    public final Vector3 clamp(@NotNull Vector3 min, @NotNull Vector3 max) {
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return new Vector3(RangesKt.coerceIn(this.x, min.x, max.x), RangesKt.coerceIn(this.y, min.y, max.y), RangesKt.coerceIn(this.z, min.z, max.z));
    }

    public final double angleTo(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Math.atan2(this.cross(other).length(), this.dot(other));
    }

    public final boolean isFinite() {
        double d = this.x;
        return !Double.isInfinite(d) && !Double.isNaN(d) && !Double.isInfinite(d = this.y) && !Double.isNaN(d) && !Double.isInfinite(d = this.z) && !Double.isNaN(d);
    }

    public final void set(int index, double value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Index " + index + " is out of bounds");
            }
        }
    }

    public final double get(int index) {
        return switch (index) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            default -> throw new IndexOutOfBoundsException("Index " + index + " is out of bounds");
        };
    }

    @NotNull
    public final Vector3 plus(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Vector3(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public final void plusAssign(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
    }

    @NotNull
    public final Vector3 minus(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Vector3(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public final void minusAssign(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
    }

    @NotNull
    public final Vector3 times(double scalar) {
        return new Vector3(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public final void timesAssign(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    @NotNull
    public final Vector3 div(double scalar) {
        return new Vector3(this.x / scalar, this.y / scalar, this.z / scalar);
    }

    public final void divAssign(double scalar) {
        this.x /= scalar;
        this.y /= scalar;
        this.z /= scalar;
    }

    @NotNull
    public final Vector3 times(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Vector3(this.x * other.x, this.y * other.y, this.z * other.z);
    }

    public final void timesAssign(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.x *= other.x;
        this.y *= other.y;
        this.z *= other.z;
    }

    @NotNull
    public final Vector3 div(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Vector3(this.x / other.x, this.y / other.y, this.z / other.z);
    }

    public final void divAssign(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.x /= other.x;
        this.y /= other.y;
        this.z /= other.z;
    }

    @NotNull
    public final Vector3 unaryMinus() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector3)) {
            return false;
        }
        if (!(this.x == ((Vector3)other).x)) {
            return false;
        }
        if (!(this.y == ((Vector3)other).y)) {
            return false;
        }
        return this.z == ((Vector3)other).z;
    }

    public final int compareTo(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        int xComparison = Double.compare(this.x, other.x);
        if (xComparison != 0) {
            return xComparison;
        }
        int yComparison = Double.compare(this.y, other.y);
        if (yComparison != 0) {
            return yComparison;
        }
        return Double.compare(this.z, other.z);
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = 31 * result + Double.hashCode(this.y);
        result = 31 * result + Double.hashCode(this.z);
        return result;
    }

    @NotNull
    public String toString() {
        return "Vector3(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    @NotNull
    public Vector3 clone() {
        return new Vector3(this.x, this.y, this.z);
    }

    @NotNull
    public final Vector toBukkitVector() {
        return new Vector(this.x, this.y, this.z);
    }

    @NotNull
    public final Location toLocation(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        return new Location(world, this.x, this.y, this.z);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/mochibit/defcon/math/Vector3$Companion;", "", "()V", "BACKWARD", "Lcom/mochibit/defcon/math/Vector3;", "getBACKWARD", "()Lcom/mochibit/defcon/math/Vector3;", "DOWN", "getDOWN", "FORWARD", "getFORWARD", "LEFT", "getLEFT", "RIGHT", "getRIGHT", "UP", "getUP", "ZERO", "getZERO", "fromBukkitVector", "vector", "Lorg/bukkit/util/Vector;", "fromLocation", "location", "Lorg/bukkit/Location;", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector3 getZERO() {
            return ZERO;
        }

        @NotNull
        public final Vector3 getLEFT() {
            return LEFT;
        }

        @NotNull
        public final Vector3 getRIGHT() {
            return RIGHT;
        }

        @NotNull
        public final Vector3 getUP() {
            return UP;
        }

        @NotNull
        public final Vector3 getDOWN() {
            return DOWN;
        }

        @NotNull
        public final Vector3 getFORWARD() {
            return FORWARD;
        }

        @NotNull
        public final Vector3 getBACKWARD() {
            return BACKWARD;
        }

        @NotNull
        public final Vector3 fromLocation(@NotNull Location location) {
            Intrinsics.checkNotNullParameter(location, "location");
            return new Vector3(location.getX(), location.getY(), location.getZ());
        }

        @NotNull
        public final Vector3 fromBukkitVector(@NotNull Vector vector) {
            Intrinsics.checkNotNullParameter(vector, "vector");
            return new Vector3(vector.getX(), vector.getY(), vector.getZ());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

