/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.math;

import com.mochibit.defcon.math.Basis;
import com.mochibit.defcon.math.Vector3;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b'\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 R2\u00020\u0001:\u0001RB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0000H\u0014J\u0011\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020\u0012J\u0006\u0010 \u001a\u00020\u0019J\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00062\b\b\u0002\u0010#\u001a\u00020\u0006J\u0006\u0010$\u001a\u00020\u0012J\u0006\u0010%\u001a\u00020\u0000J\u0006\u0010&\u001a\u00020\u0012J\u0006\u0010'\u001a\u00020\u0000J\u0016\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0016J\u0016\u0010+\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0016J\u0016\u0010,\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0016J\u0016\u0010-\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0016J\u000e\u0010.\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u0006J\u000e\u0010/\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u0006J\u000e\u00100\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0006J\u000e\u00101\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0006J\u000e\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u0000Jf\u00102\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u00162\u0006\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u00162\u0006\u0010:\u001a\u00020\u00162\u0006\u0010;\u001a\u00020\u00162\u0006\u0010<\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\u00162\u0006\u0010>\u001a\u00020\u00162\u0006\u0010?\u001a\u00020\u0016J \u0010@\u001a\u00020\u00122\u0006\u0010A\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\b\b\u0002\u0010#\u001a\u00020\u0006J\u0011\u0010B\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010B\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\u0011\u0010C\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010C\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\b\u0010D\u001a\u00020EH\u0016J\u000e\u0010F\u001a\u00020\u00122\u0006\u0010G\u001a\u00020\u0006J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0006J\u000e\u0010I\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0006J\u000e\u0010J\u001a\u00020\u00062\u0006\u0010K\u001a\u00020\u0006J!\u0010J\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060L2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00060L\u00a2\u0006\u0002\u0010NJ\u000e\u0010O\u001a\u00020\u00062\u0006\u0010K\u001a\u00020\u0006J.\u0010O\u001a\u0012\u0012\u0004\u0012\u00020\u00060Pj\b\u0012\u0004\u0012\u00020\u0006`Q2\u0016\u0010M\u001a\u0012\u0012\u0004\u0012\u00020\u00060Pj\b\u0012\u0004\u0012\u00020\u0006`QR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006S"}, d2={"Lcom/mochibit/defcon/math/Transform3D;", "", "()V", "basis", "Lcom/mochibit/defcon/math/Basis;", "origin", "Lcom/mochibit/defcon/math/Vector3;", "(Lcom/mochibit/defcon/math/Basis;Lcom/mochibit/defcon/math/Vector3;)V", "getBasis", "()Lcom/mochibit/defcon/math/Basis;", "setBasis", "(Lcom/mochibit/defcon/math/Basis;)V", "getOrigin", "()Lcom/mochibit/defcon/math/Vector3;", "setOrigin", "(Lcom/mochibit/defcon/math/Vector3;)V", "affineInverse", "affineInvert", "", "clone", "div", "scalar", "", "divAssign", "equals", "", "other", "", "hashCode", "", "inverse", "invert", "isFinite", "lookingAt", "target", "up", "orthogonalize", "orthogonalized", "orthonormalize", "orthonormalized", "rotate", "axis", "angle", "rotateBasis", "rotated", "rotatedLocal", "scale", "scaleBasis", "scaled", "scaledLocal", "set", "transform", "xx", "xy", "xz", "yx", "yy", "yz", "zx", "zy", "zz", "tx", "ty", "tz", "setLookAt", "eye", "times", "timesAssign", "toString", "", "translateLocal", "translation", "translated", "translatedLocal", "xform", "vector", "", "vectors", "([Lcom/mochibit/defcon/math/Vector3;)[Lcom/mochibit/defcon/math/Vector3;", "xformInv", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "Companion", "Defcon"})
public final class Transform3D
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Basis basis;
    @NotNull
    private Vector3 origin;
    @NotNull
    private static final Transform3D IDENTITY = new Transform3D(new Basis(), new Vector3());

    public Transform3D(@NotNull Basis basis, @NotNull Vector3 origin) {
        Intrinsics.checkNotNullParameter(basis, "basis");
        Intrinsics.checkNotNullParameter(origin, "origin");
        this.basis = basis;
        this.origin = origin;
    }

    @NotNull
    public final Basis getBasis() {
        return this.basis;
    }

    public final void setBasis(@NotNull Basis basis) {
        Intrinsics.checkNotNullParameter(basis, "<set-?>");
        this.basis = basis;
    }

    @NotNull
    public final Vector3 getOrigin() {
        return this.origin;
    }

    public final void setOrigin(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter(vector3, "<set-?>");
        this.origin = vector3;
    }

    public Transform3D() {
        this(new Basis(), new Vector3());
    }

    public final void set(@NotNull Transform3D transform) {
        Intrinsics.checkNotNullParameter(transform, "transform");
        this.basis = transform.basis;
        this.origin = transform.origin;
    }

    public final void set(double xx, double xy, double xz, double yx, double yy, double yz, double zx, double zy, double zz, double tx, double ty, double tz) {
        this.basis.set(xx, xy, xz, yx, yy, yz, zx, zy, zz);
        this.origin.setX(tx);
        this.origin.setY(ty);
        this.origin.setZ(tz);
    }

    public final void invert() {
        this.basis.transpose();
        this.origin = this.basis.xform(this.origin.unaryMinus());
    }

    @NotNull
    public final Transform3D inverse() {
        Transform3D res = this.clone();
        res.invert();
        return res;
    }

    public final void affineInvert() {
        this.basis.invert();
        this.origin = this.basis.xform(this.origin.unaryMinus());
    }

    @NotNull
    public final Transform3D affineInverse() {
        Transform3D res = this.clone();
        res.affineInvert();
        return res;
    }

    public final void rotate(@NotNull Vector3 axis, double angle) {
        Intrinsics.checkNotNullParameter(axis, "axis");
        this.set(this.rotated(axis, angle));
    }

    @NotNull
    public final Transform3D rotated(@NotNull Vector3 axis, double angle) {
        Intrinsics.checkNotNullParameter(axis, "axis");
        Basis rotBasis = new Basis(axis, angle);
        return new Transform3D(rotBasis.times(this.basis), rotBasis.xform(this.origin));
    }

    @NotNull
    public final Transform3D rotatedLocal(@NotNull Vector3 axis, double angle) {
        Intrinsics.checkNotNullParameter(axis, "axis");
        Basis rotBasis = new Basis(axis, angle);
        return new Transform3D(this.basis.times(rotBasis), this.origin);
    }

    public final void rotateBasis(@NotNull Vector3 axis, double angle) {
        Intrinsics.checkNotNullParameter(axis, "axis");
        this.basis.rotate(axis, angle);
    }

    public final void setLookAt(@NotNull Vector3 eye, @NotNull Vector3 target, @NotNull Vector3 up) {
        Intrinsics.checkNotNullParameter(eye, "eye");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(up, "up");
        this.basis = Basis.Companion.lookingAt(target.minus(eye), up);
        this.origin = eye;
    }

    public static /* synthetic */ void setLookAt$default(Transform3D transform3D, Vector3 vector3, Vector3 vector32, Vector3 vector33, int n, Object object) {
        if ((n & 4) != 0) {
            vector33 = new Vector3(0.0, 1.0, 0.0);
        }
        transform3D.setLookAt(vector3, vector32, vector33);
    }

    @NotNull
    public final Transform3D lookingAt(@NotNull Vector3 target, @NotNull Vector3 up) {
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(up, "up");
        Transform3D newTransform = this.clone();
        newTransform.basis = Basis.Companion.lookingAt(target.minus(this.origin), up);
        return newTransform;
    }

    public static /* synthetic */ Transform3D lookingAt$default(Transform3D transform3D, Vector3 vector3, Vector3 vector32, int n, Object object) {
        if ((n & 2) != 0) {
            vector32 = new Vector3(0.0, 1.0, 0.0);
        }
        return transform3D.lookingAt(vector3, vector32);
    }

    public final void scale(@NotNull Vector3 scale) {
        Intrinsics.checkNotNullParameter(scale, "scale");
        this.basis.scale(scale);
        this.origin = this.origin.times(scale);
    }

    @NotNull
    public final Transform3D scaled(@NotNull Vector3 scale) {
        Intrinsics.checkNotNullParameter(scale, "scale");
        return new Transform3D(this.basis.scaled(scale), this.origin.times(scale));
    }

    @NotNull
    public final Transform3D scaledLocal(@NotNull Vector3 scale) {
        Intrinsics.checkNotNullParameter(scale, "scale");
        return new Transform3D(this.basis.scaledLocal(scale), this.origin);
    }

    public final void scaleBasis(@NotNull Vector3 scale) {
        Intrinsics.checkNotNullParameter(scale, "scale");
        this.basis.scale(scale);
    }

    public final void translateLocal(@NotNull Vector3 translation) {
        Intrinsics.checkNotNullParameter(translation, "translation");
        for (int i = 0; i < 3; ++i) {
            Vector3 vector3 = this.origin;
            int n = i;
            vector3.set(n, vector3.get(n) + this.basis.get(i).dot(translation));
        }
    }

    @NotNull
    public final Transform3D translated(@NotNull Vector3 translation) {
        Intrinsics.checkNotNullParameter(translation, "translation");
        return new Transform3D(this.basis, this.origin.plus(translation));
    }

    @NotNull
    public final Transform3D translatedLocal(@NotNull Vector3 translation) {
        Intrinsics.checkNotNullParameter(translation, "translation");
        return new Transform3D(this.basis, this.origin.plus(this.basis.xform(translation)));
    }

    public final void orthonormalize() {
        this.basis.orthonormalize();
    }

    @NotNull
    public final Transform3D orthonormalized() {
        Transform3D res = this.clone();
        res.orthonormalize();
        return res;
    }

    public final void orthogonalize() {
        this.basis.orthogonalize();
    }

    @NotNull
    public final Transform3D orthogonalized() {
        Transform3D res = this.clone();
        res.orthogonalize();
        return res;
    }

    public final boolean isFinite() {
        return this.basis.isFinite() && this.origin.isFinite();
    }

    @NotNull
    public final Vector3 xform(@NotNull Vector3 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return new Vector3(this.basis.getRows()[0].dot(vector) + this.origin.getX(), this.basis.getRows()[1].dot(vector) + this.origin.getY(), this.basis.getRows()[2].dot(vector) + this.origin.getZ());
    }

    @NotNull
    public final Vector3[] xform(@NotNull Vector3[] vectors) {
        Intrinsics.checkNotNullParameter(vectors, "vectors");
        Vector3[] result = new Vector3[vectors.length];
        int n = vectors.length;
        for (int i = 0; i < n; ++i) {
            result[i] = this.xform(vectors[i]);
        }
        return result;
    }

    @NotNull
    public final Vector3 xformInv(@NotNull Vector3 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        Vector3 vec = vector.minus(this.origin);
        return new Vector3(this.basis.getRows()[0].get(0) * vec.getX() + this.basis.getRows()[1].get(0) * vec.getY() + this.basis.getRows()[2].get(0) * vec.getZ(), this.basis.getRows()[0].get(1) * vec.getX() + this.basis.getRows()[1].get(1) * vec.getY() + this.basis.getRows()[2].get(1) * vec.getZ(), this.basis.getRows()[0].get(2) * vec.getX() + this.basis.getRows()[1].get(2) * vec.getY() + this.basis.getRows()[2].get(2) * vec.getZ());
    }

    @NotNull
    public final HashSet<Vector3> xformInv(@NotNull HashSet<Vector3> vectors) {
        Intrinsics.checkNotNullParameter(vectors, "vectors");
        HashSet<Vector3> result = new HashSet<Vector3>();
        for (Vector3 vector : vectors) {
            Intrinsics.checkNotNull(vector);
            result.add(this.xformInv(vector));
        }
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof Transform3D) {
            return Intrinsics.areEqual(this.basis, ((Transform3D)other).basis) && Intrinsics.areEqual(this.origin, ((Transform3D)other).origin);
        }
        return false;
    }

    public final void timesAssign(@NotNull Transform3D transform) {
        Intrinsics.checkNotNullParameter(transform, "transform");
        this.origin = this.xform(transform.origin);
        this.basis = this.basis.times(transform.basis);
    }

    @NotNull
    public final Transform3D times(@NotNull Transform3D transform) {
        Intrinsics.checkNotNullParameter(transform, "transform");
        Transform3D clone = this.clone();
        clone.timesAssign(transform);
        return clone;
    }

    public final void timesAssign(double scalar) {
        this.origin = this.origin.times(scalar);
        this.basis = this.basis.times(scalar);
    }

    @NotNull
    public final Transform3D times(double scalar) {
        Transform3D clone = this.clone();
        clone.timesAssign(scalar);
        return clone;
    }

    public final void divAssign(double scalar) {
        this.origin = this.origin.div(scalar);
        this.basis = this.basis.div(scalar);
    }

    @NotNull
    public final Transform3D div(double scalar) {
        Transform3D clone = this.clone();
        clone.divAssign(scalar);
        return clone;
    }

    @NotNull
    public String toString() {
        return "[X: " + this.basis.getColumn(0) + " Y: " + this.basis.getColumn(1) + " Z: " + this.basis.getColumn(2) + " Origin: " + this.origin + "]";
    }

    @NotNull
    public Transform3D clone() {
        return new Transform3D(this.basis.clone(), this.origin.clone());
    }

    public int hashCode() {
        int result = this.basis.hashCode();
        result = 31 * result + this.origin.hashCode();
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/mochibit/defcon/math/Transform3D$Companion;", "", "()V", "IDENTITY", "Lcom/mochibit/defcon/math/Transform3D;", "getIDENTITY", "()Lcom/mochibit/defcon/math/Transform3D;", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Transform3D getIDENTITY() {
            return IDENTITY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

