/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.math;

import com.mochibit.defcon.math.Vector3;
import com.mochibit.defcon.utils.MathFunctions;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\bC\u0018\u0000 q2\u00020\u0001:\u0001qB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nBO\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0005\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u0012\u0006\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0014B\u0005\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u001b\u001a\u00020\u0000H\u0016J&\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eJ\u0006\u0010\"\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020\u0000J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010&\u001a\u00020'2\u0006\u0010%\u001a\u00020\u0005H\u0086\u0002J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0096\u0002J\u0011\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u001eH\u0086\u0002J\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050/J\u000e\u00100\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u001eJ\u0006\u00101\u001a\u00020\u0003J\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050/J\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050/J\u0006\u00104\u001a\u00020\u0003J\u0006\u00105\u001a\u00020\u0003J\u0006\u00106\u001a\u00020\u0003J\u0006\u00107\u001a\u00020\u0005J\b\u00108\u001a\u00020\u001eH\u0016J\u0006\u00109\u001a\u00020\u0000J\u0006\u0010:\u001a\u00020'J\u0006\u0010;\u001a\u00020)J\u0006\u0010<\u001a\u00020)J\u000e\u0010=\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0000J\u0006\u0010>\u001a\u00020)J\u0006\u0010?\u001a\u00020)J\u0006\u0010@\u001a\u00020)J\u0006\u0010A\u001a\u00020)J\u0016\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u0005J\u0011\u0010E\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010F\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010G\u001a\u00020'J\u0006\u0010H\u001a\u00020\u0000J\u0006\u0010I\u001a\u00020'J\u0006\u0010J\u001a\u00020\u0000J\u0011\u0010K\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010L\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0000H\u0086\u0002J\u0016\u0010M\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010N\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010O\u001a\u00020'2\u0006\u0010P\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u0003J\u0016\u0010Q\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010R\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010S\u001a\u00020'2\u0006\u0010S\u001a\u00020\u0003J\u000e\u0010T\u001a\u00020'2\u0006\u0010S\u001a\u00020\u0003J\u000e\u0010U\u001a\u00020'2\u0006\u0010S\u001a\u00020\u0003J\u000e\u0010V\u001a\u00020\u00002\u0006\u0010S\u001a\u00020\u0003J\u000e\u0010W\u001a\u00020\u00002\u0006\u0010S\u001a\u00020\u0003J\u000e\u0010X\u001a\u00020\u00002\u0006\u0010S\u001a\u00020\u0003J\u000e\u0010Y\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0000JN\u0010Y\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010Z\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\u001e\u0010[\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010S\u001a\u00020\u0003J\u0016\u0010\\\u001a\u00020'2\u0006\u0010-\u001a\u00020\u001e2\u0006\u0010]\u001a\u00020\u0003J\u001e\u0010^\u001a\u00020'2\u0006\u0010_\u001a\u00020\u00032\u0006\u0010`\u001a\u00020\u00032\u0006\u0010a\u001a\u00020\u0003J\u000e\u0010b\u001a\u00020'2\u0006\u0010c\u001a\u00020\u0003J\u0006\u0010d\u001a\u00020'J\u0016\u0010e\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u0005J\u000e\u0010f\u001a\u00020\u00052\u0006\u0010g\u001a\u00020\u0003J\u000e\u0010h\u001a\u00020\u00052\u0006\u0010g\u001a\u00020\u0003J\u000e\u0010i\u001a\u00020\u00052\u0006\u0010g\u001a\u00020\u0003J\u0011\u0010j\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010j\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010k\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010k\u001a\u00020'2\u0006\u0010%\u001a\u00020\u0005H\u0086\u0002J\u0006\u0010l\u001a\u00020'J\u000e\u0010m\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u0000J\u0006\u0010n\u001a\u00020\u0000J\u000e\u0010o\u001a\u00020\u00032\u0006\u0010g\u001a\u00020\u0003J\u000e\u0010p\u001a\u00020\u00032\u0006\u0010g\u001a\u00020\u0003R\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006r"}, d2={"Lcom/mochibit/defcon/math/Basis;", "", "axis", "Lcom/mochibit/defcon/math/Vector3;", "angle", "", "(Lcom/mochibit/defcon/math/Vector3;D)V", "xAxis", "yAxis", "zAxis", "(Lcom/mochibit/defcon/math/Vector3;Lcom/mochibit/defcon/math/Vector3;Lcom/mochibit/defcon/math/Vector3;)V", "xx", "xy", "xz", "yx", "yy", "yz", "zx", "zy", "zz", "(DDDDDDDDD)V", "()V", "rows", "", "getRows", "()[Lcom/mochibit/defcon/math/Vector3;", "[Lcom/mochibit/defcon/math/Vector3;", "clone", "cofac", "row1", "", "col1", "row2", "col2", "determinant", "diagonalize", "div", "scalar", "divAssign", "", "equals", "", "other", "", "get", "index", "getAxisAngle", "Lkotlin/Pair;", "getColumn", "getMainDiagonal", "getRotationAxisAngle", "getRotationAxisAngleLocal", "getScale", "getScaleAbs", "getScaleLocal", "getUniformScale", "hashCode", "inverse", "invert", "isConformal", "isDiagonal", "isEqualApprox", "isFinite", "isOrthogonal", "isOrthonormal", "isRotation", "lerp", "to", "weight", "minus", "minusAssign", "orthogonalize", "orthogonalized", "orthonormalize", "orthonormalized", "plus", "plusAssign", "rotate", "rotateLocal", "rotateToAlign", "from", "rotated", "rotatedLocal", "scale", "scaleLocal", "scaleOrthogonal", "scaled", "scaledLocal", "scaledOrthogonal", "set", "setAxisAngle", "setAxisAngleScale", "setColumn", "value", "setColumns", "x", "y", "z", "setDiagonal", "diagonal", "setZero", "slerp", "tdotx", "vector", "tdoty", "tdotz", "times", "timesAssign", "transpose", "transposeXform", "transposed", "xform", "xformInv", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nBasis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Basis.kt\ncom/mochibit/defcon/math/Basis\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,720:1\n1#2:721\n*E\n"})
public final class Basis
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector3[] rows;

    public Basis() {
        Vector3[] vector3Array = new Vector3[]{new Vector3(1.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 0.0, 1.0)};
        this.rows = vector3Array;
    }

    @NotNull
    public final Vector3[] getRows() {
        return this.rows;
    }

    public final void set(double xx, double xy, double xz, double yx, double yy, double yz, double zx, double zy, double zz) {
        this.rows[0].set(0, xx);
        this.rows[0].set(1, xy);
        this.rows[0].set(2, xz);
        this.rows[1].set(0, yx);
        this.rows[1].set(1, yy);
        this.rows[1].set(2, yz);
        this.rows[2].set(0, zx);
        this.rows[2].set(1, zy);
        this.rows[2].set(2, zz);
    }

    public final void set(@NotNull Basis other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.rows[0] = other.rows[0];
        this.rows[1] = other.rows[1];
        this.rows[2] = other.rows[2];
    }

    public Basis(@NotNull Vector3 axis, double angle) {
        Intrinsics.checkNotNullParameter(axis, "axis");
        this();
        this.setAxisAngle(axis, angle);
    }

    public Basis(@NotNull Vector3 xAxis, @NotNull Vector3 yAxis, @NotNull Vector3 zAxis) {
        Intrinsics.checkNotNullParameter(xAxis, "xAxis");
        Intrinsics.checkNotNullParameter(yAxis, "yAxis");
        Intrinsics.checkNotNullParameter(zAxis, "zAxis");
        this();
        this.setColumns(xAxis, yAxis, zAxis);
    }

    public Basis(double xx, double xy, double xz, double yx, double yy, double yz, double zx, double zy, double zz) {
        this();
        this.set(xx, xy, xz, yx, yy, yz, zx, zy, zz);
    }

    public final void setColumns(@NotNull Vector3 x, @NotNull Vector3 y, @NotNull Vector3 z) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        Intrinsics.checkNotNullParameter(z, "z");
        this.setColumn(0, x);
        this.setColumn(1, y);
        this.setColumn(2, z);
    }

    public final void setColumn(int index, @NotNull Vector3 value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.rows[0].set(index, value.getX());
        this.rows[1].set(index, value.getY());
        this.rows[2].set(index, value.getZ());
    }

    @NotNull
    public final Vector3 getColumn(int index) {
        return new Vector3(this.rows[0].get(index), this.rows[1].get(index), this.rows[2].get(index));
    }

    @NotNull
    public final Vector3 getMainDiagonal() {
        return new Vector3(this.rows[0].get(0), this.rows[1].get(1), this.rows[2].get(2));
    }

    public final void setZero() {
        this.rows[0] = Vector3.Companion.getZERO();
        this.rows[1] = Vector3.Companion.getZERO();
        this.rows[2] = Vector3.Companion.getZERO();
    }

    @NotNull
    public final Basis transposeXform(@NotNull Basis to) {
        Intrinsics.checkNotNullParameter(to, "to");
        return new Basis(this.rows[0].getX() * to.get(0).getX() + this.rows[1].getX() * to.get(1).getX() + this.rows[2].getX() * to.get(2).getX(), this.rows[0].getX() * to.get(0).getY() + this.rows[1].getX() * to.get(1).getY() + this.rows[2].getX() * to.get(2).getY(), this.rows[0].getX() * to.get(0).getZ() + this.rows[1].getX() * to.get(1).getZ() + this.rows[2].getX() * to.get(2).getZ(), this.rows[0].getY() * to.get(0).getX() + this.rows[1].getY() * to.get(1).getX() + this.rows[2].getY() * to.get(2).getX(), this.rows[0].getY() * to.get(0).getY() + this.rows[1].getY() * to.get(1).getY() + this.rows[2].getY() * to.get(2).getY(), this.rows[0].getY() * to.get(0).getZ() + this.rows[1].getY() * to.get(1).getZ() + this.rows[2].getY() * to.get(2).getZ(), this.rows[0].getZ() * to.get(0).getX() + this.rows[1].getZ() * to.get(1).getX() + this.rows[2].getZ() * to.get(2).getX(), this.rows[0].getZ() * to.get(0).getY() + this.rows[1].getZ() * to.get(1).getY() + this.rows[2].getZ() * to.get(2).getY(), this.rows[0].getZ() * to.get(0).getZ() + this.rows[1].getZ() * to.get(1).getZ() + this.rows[2].getZ() * to.get(2).getZ());
    }

    public final double cofac(int row1, int col1, int row2, int col2) {
        return this.rows[row1].get(col1) * this.rows[row2].get(col2) - this.rows[row1].get(col2) * this.rows[row2].get(col1);
    }

    public final void invert() {
        int n = 0;
        Double[] doubleArray = new Double[3];
        while (n < 3) {
            int n2 = n++;
            this.cofac(1, 1, 2, 2);
            this.cofac(1, 2, 2, 0);
            doubleArray[n2] = this.cofac(1, 0, 2, 1);
        }
        Double[] co = doubleArray;
        double det = this.rows[0].get(0) * co[0] + this.rows[0].get(1) * co[1] + this.rows[0].get(2) * co[2];
        if (det == 0.0) {
            throw new ArithmeticException("Matrix is singular and cannot be inverted");
        }
        double invDet = 1.0 / det;
        this.set(co[0] * invDet, this.cofac(0, 2, 2, 1) * invDet, this.cofac(0, 1, 1, 2) * invDet, co[1] * invDet, this.cofac(0, 0, 2, 2) * invDet, this.cofac(0, 2, 1, 0) * invDet, co[2] * invDet, this.cofac(0, 1, 2, 0) * invDet, this.cofac(0, 0, 1, 1) * invDet);
    }

    public final void transpose() {
        double d;
        double d2 = d = this.rows[1].get(0);
        int n = 1;
        Vector3 vector3 = this.rows[0];
        boolean bl = false;
        this.rows[1].set(0, this.rows[0].get(1));
        Unit unit = Unit.INSTANCE;
        vector3.set(n, d);
        double it = d = this.rows[2].get(0);
        n = 2;
        vector3 = this.rows[0];
        boolean bl2 = false;
        this.rows[2].set(0, this.rows[0].get(2));
        unit = Unit.INSTANCE;
        vector3.set(n, d);
        it = d = this.rows[2].get(1);
        n = 2;
        vector3 = this.rows[1];
        boolean bl3 = false;
        this.rows[2].set(1, this.rows[1].get(2));
        unit = Unit.INSTANCE;
        vector3.set(n, d);
    }

    @NotNull
    public final Basis inverse() {
        Basis result = this.clone();
        result.invert();
        return result;
    }

    @NotNull
    public final Basis transposed() {
        Basis result = this.clone();
        result.transpose();
        return result;
    }

    public final double determinant() {
        return this.rows[0].get(0) * (this.rows[1].get(1) * this.rows[2].get(2) - this.rows[2].get(1) * this.rows[1].get(2)) - this.rows[1].get(0) * (this.rows[0].get(1) * this.rows[2].get(2) - this.rows[2].get(1) * this.rows[0].get(2)) + this.rows[2].get(0) * (this.rows[0].get(1) * this.rows[1].get(2) - this.rows[1].get(1) * this.rows[0].get(2));
    }

    public final void rotate(@NotNull Vector3 axis, double angle) {
        Intrinsics.checkNotNullParameter(axis, "axis");
        this.set(this.rotated(axis, angle));
    }

    @NotNull
    public final Basis rotated(@NotNull Vector3 axis, double angle) {
        Intrinsics.checkNotNullParameter(axis, "axis");
        return new Basis(axis, angle).times(this);
    }

    public final void rotateLocal(@NotNull Vector3 axis, double angle) {
        Intrinsics.checkNotNullParameter(axis, "axis");
        this.set(this.rotatedLocal(axis, angle));
    }

    @NotNull
    public final Basis rotatedLocal(@NotNull Vector3 axis, double angle) {
        Intrinsics.checkNotNullParameter(axis, "axis");
        return this.times(new Basis(axis, angle));
    }

    @NotNull
    public final Pair<Vector3, Double> getRotationAxisAngle() {
        Basis orthonormalizedBasis = this.orthonormalized();
        double det = orthonormalizedBasis.determinant();
        if (det < 0.0) {
            orthonormalizedBasis.scale(new Vector3(-1.0, -1.0, -1.0));
        }
        Pair<Vector3, Double> res = orthonormalizedBasis.getAxisAngle();
        return new Pair<Vector3, Double>(res.getFirst(), res.getSecond());
    }

    @NotNull
    public final Pair<Vector3, Double> getRotationAxisAngleLocal() {
        Basis transposed = this.transposed();
        transposed.orthonormalize();
        double det = transposed.determinant();
        if (det < 0.0) {
            transposed.scale(new Vector3(-1.0, -1.0, -1.0));
        }
        Pair<Vector3, Double> res = transposed.getAxisAngle();
        return new Pair<Vector3, Double>(res.getFirst(), -((Number)res.getSecond()).doubleValue());
    }

    public final void rotateToAlign(@NotNull Vector3 from, @NotNull Vector3 to) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        Vector3 axis = from.cross(to).normalized();
        if (axis.lengthSquared() == 0.0) {
            return;
        }
        double dot = from.dot(to);
        dot = MathFunctions.INSTANCE.clamp(dot, -1.0, 1.0);
        double angle = Math.acos(dot);
        this.rotate(axis, angle);
    }

    public final void setAxisAngle(@NotNull Vector3 axis, double angle) {
        Intrinsics.checkNotNullParameter(axis, "axis");
        Vector3 axisSq = new Vector3(axis.getX() * axis.getX(), axis.getY() * axis.getY(), axis.getZ() * axis.getZ());
        double c = Math.cos(angle);
        this.rows[0].setX(axisSq.getX() + c * (1.0 - axisSq.getX()));
        this.rows[1].setY(axisSq.getY() + c * (1.0 - axisSq.getY()));
        this.rows[2].setZ(axisSq.getZ() + c * (1.0 - axisSq.getZ()));
        double s = Math.sin(angle);
        double t = 1.0 - c;
        double xyzt = axis.getX() * axis.getY() * t;
        double zyxs = axis.getZ() * s;
        this.rows[0].setY(xyzt - zyxs);
        this.rows[1].setX(xyzt + zyxs);
        xyzt = axis.getX() * axis.getZ() * t;
        zyxs = axis.getY() * s;
        this.rows[0].setZ(xyzt + zyxs);
        this.rows[2].setX(xyzt - zyxs);
        xyzt = axis.getY() * axis.getZ() * t;
        zyxs = axis.getX() * s;
        this.rows[1].setZ(xyzt - zyxs);
        this.rows[2].setY(xyzt + zyxs);
    }

    @NotNull
    public final Pair<Vector3, Double> getAxisAngle() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (this.rows[0].get(1) - this.rows[1].get(0) == 0.0 && this.rows[0].get(2) - this.rows[2].get(0) == 0.0 && this.rows[1].get(2) - this.rows[2].get(1) == 0.0) {
            if (this.isDiagonal() && Math.abs(this.rows[0].get(0) + this.rows[1].get(1) + this.rows[2].get(2) - (double)3) < 3.0000000000000004E-5) {
                return new Pair<Vector3, Double>(new Vector3(0.0, 1.0, 0.0), 0.0);
            }
            double xx = (this.rows[0].get(0) + 1.0) / (double)2;
            double yy = (this.rows[1].get(1) + 1.0) / (double)2;
            double zz = (this.rows[2].get(2) + 1.0) / (double)2;
            double xy = (this.rows[0].get(1) + this.rows[1].get(0)) / (double)4;
            double xz = (this.rows[0].get(2) + this.rows[2].get(0)) / (double)4;
            double yz = (this.rows[1].get(2) + this.rows[2].get(1)) / (double)4;
            if (xx > yy && xx > zz) {
                if (xx < 1.0E-5) {
                    x = 0.0;
                    y = 1.4142135623730951;
                    z = 0.7071067811865476;
                } else {
                    x = Math.sqrt(xx);
                    y = xy / x;
                    z = xz / x;
                }
            } else if (yy > zz) {
                if (yy < 1.0E-5) {
                    x = 0.7071067811865476;
                    y = 0.0;
                    z = 0.7071067811865476;
                } else {
                    y = Math.sqrt(yy);
                    x = xy / y;
                    z = yz / y;
                }
            } else if (zz < 1.0E-5) {
                x = 0.7071067811865476;
                y = 0.7071067811865476;
                z = 0.0;
            } else {
                z = Math.sqrt(zz);
                x = xz / z;
                y = yz / z;
            }
            return new Pair<Vector3, Double>(new Vector3(x, y, z), Math.PI);
        }
        double s = Math.sqrt((this.rows[2].get(1) - this.rows[1].get(2)) * (this.rows[2].get(1) - this.rows[1].get(2)) + (this.rows[0].get(2) - this.rows[2].get(0)) * (this.rows[0].get(2) - this.rows[2].get(0)) + (this.rows[1].get(0) - this.rows[0].get(1)) * (this.rows[1].get(0) - this.rows[0].get(1)));
        if (Math.abs(s) < 1.0E-5) {
            s = 1.0;
        }
        x = (this.rows[2].get(1) - this.rows[1].get(2)) / s;
        y = (this.rows[0].get(2) - this.rows[2].get(0)) / s;
        z = (this.rows[1].get(0) - this.rows[0].get(1)) / s;
        return new Pair<Vector3, Double>(new Vector3(x, y, z), Math.acos((this.rows[0].get(0) + this.rows[1].get(1) + this.rows[2].get(2) - 1.0) / (double)2));
    }

    public final void scale(@NotNull Vector3 scale) {
        Intrinsics.checkNotNullParameter(scale, "scale");
        Vector3 vector3 = this.rows[0];
        vector3.set(0, vector3.get(0) * scale.getX());
        vector3 = this.rows[0];
        vector3.set(1, vector3.get(1) * scale.getX());
        vector3 = this.rows[0];
        vector3.set(2, vector3.get(2) * scale.getX());
        vector3 = this.rows[1];
        vector3.set(0, vector3.get(0) * scale.getY());
        vector3 = this.rows[1];
        vector3.set(1, vector3.get(1) * scale.getY());
        vector3 = this.rows[1];
        vector3.set(2, vector3.get(2) * scale.getY());
        vector3 = this.rows[2];
        vector3.set(0, vector3.get(0) * scale.getZ());
        vector3 = this.rows[2];
        vector3.set(1, vector3.get(1) * scale.getZ());
        vector3 = this.rows[2];
        vector3.set(2, vector3.get(2) * scale.getZ());
    }

    @NotNull
    public final Basis scaled(@NotNull Vector3 scale) {
        Intrinsics.checkNotNullParameter(scale, "scale");
        Basis result = this.clone();
        result.scale(scale);
        return result;
    }

    public final void scaleLocal(@NotNull Vector3 scale) {
        Intrinsics.checkNotNullParameter(scale, "scale");
        Basis result = this.scaledLocal(scale);
        this.set(result);
    }

    @NotNull
    public final Basis scaledLocal(@NotNull Vector3 scale) {
        Intrinsics.checkNotNullParameter(scale, "scale");
        return this.times(Companion.fromScale(scale));
    }

    public final void scaleOrthogonal(@NotNull Vector3 scale) {
        Intrinsics.checkNotNullParameter(scale, "scale");
        Basis result = this.scaledOrthogonal(scale);
        this.set(result);
    }

    @NotNull
    public final Basis scaledOrthogonal(@NotNull Vector3 scale) {
        Intrinsics.checkNotNullParameter(scale, "scale");
        Basis result = this.clone();
        Vector3 vecS = new Vector3(-1.0, -1.0, -1.0).plus(scale);
        double sign = Math.signum(vecS.getX() + vecS.getY() + vecS.getZ());
        Basis orthonBasis = result.orthonormalized();
        vecS = orthonBasis.xform(vecS);
        Vector3 dots = Vector3.Companion.getZERO();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n = j;
                dots.set(n, dots.get(n) + vecS.get(i) * Math.abs(result.getColumn(i).normalized().dot(orthonBasis.getColumn(j))));
            }
        }
        if (!(sign == Math.signum(dots.getX() + dots.getY() + dots.getZ()))) {
            vecS = vecS.unaryMinus();
        }
        orthonBasis.scaleLocal(new Vector3(1.0, 1.0, 1.0).plus(dots));
        return orthonBasis;
    }

    public final double getUniformScale() {
        return (this.rows[0].length() + this.rows[1].length() + this.rows[2].length()) / (double)3.0f;
    }

    @NotNull
    public final Vector3 getScale() {
        double detSign = Math.signum(this.determinant());
        return this.getScaleAbs().times(detSign);
    }

    @NotNull
    public final Vector3 getScaleAbs() {
        return new Vector3(new Vector3(this.rows[0].get(0), this.rows[1].get(0), this.rows[2].get(0)).length(), new Vector3(this.rows[0].get(1), this.rows[1].get(1), this.rows[2].get(1)).length(), new Vector3(this.rows[0].get(2), this.rows[1].get(2), this.rows[2].get(2)).length());
    }

    @NotNull
    public final Vector3 getScaleLocal() {
        double detSign = Math.signum(this.determinant());
        return new Vector3(this.rows[0].length(), this.rows[1].length(), this.rows[2].length()).times(detSign);
    }

    public final void setDiagonal(@NotNull Vector3 diagonal) {
        Intrinsics.checkNotNullParameter(diagonal, "diagonal");
        this.rows[0].set(0, diagonal.getX());
        this.rows[0].set(1, 0.0);
        this.rows[0].set(2, 0.0);
        this.rows[1].set(0, 0.0);
        this.rows[1].set(1, diagonal.getY());
        this.rows[1].set(2, 0.0);
        this.rows[2].set(0, 0.0);
        this.rows[2].set(1, 0.0);
        this.rows[2].set(2, diagonal.getZ());
    }

    public final void setAxisAngleScale(@NotNull Vector3 axis, double angle, @NotNull Vector3 scale) {
        Intrinsics.checkNotNullParameter(axis, "axis");
        Intrinsics.checkNotNullParameter(scale, "scale");
        this.setDiagonal(scale);
        this.rotate(axis, angle);
    }

    public final double tdotx(@NotNull Vector3 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return this.rows[0].getX() * vector.getX() + this.rows[1].getX() * vector.getY() + this.rows[2].getX() * vector.getZ();
    }

    public final double tdoty(@NotNull Vector3 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return this.rows[0].getY() * vector.getX() + this.rows[1].getY() * vector.getY() + this.rows[2].getY() * vector.getZ();
    }

    public final double tdotz(@NotNull Vector3 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return this.rows[0].getZ() * vector.getX() + this.rows[1].getZ() * vector.getY() + this.rows[2].getZ() * vector.getZ();
    }

    public final boolean isEqualApprox(@NotNull Basis other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.areEqual(this.rows[0], other.rows[0]) && Intrinsics.areEqual(this.rows[1], other.rows[1]) && Intrinsics.areEqual(this.rows[2], other.rows[2]);
    }

    public final boolean isFinite() {
        return this.rows[0].isFinite() && this.rows[1].isFinite() && this.rows[2].isFinite();
    }

    @NotNull
    public final Vector3 xform(@NotNull Vector3 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return new Vector3(this.rows[0].dot(vector), this.rows[1].dot(vector), this.rows[2].dot(vector));
    }

    @NotNull
    public final Vector3 xformInv(@NotNull Vector3 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return new Vector3(this.rows[0].get(0) * vector.getX() + this.rows[1].get(0) * vector.getY() + this.rows[2].get(0) * vector.getZ(), this.rows[0].get(1) * vector.getX() + this.rows[1].get(1) * vector.getY() + this.rows[2].get(1) * vector.getZ(), this.rows[0].get(2) * vector.getX() + this.rows[1].get(2) * vector.getY() + this.rows[2].get(2) * vector.getZ());
    }

    public final boolean isOrthonormal() {
        Vector3 x = this.getColumn(0);
        Vector3 y = this.getColumn(1);
        Vector3 z = this.getColumn(2);
        return x.lengthSquared() == 1.0 && y.lengthSquared() == 1.0 && z.lengthSquared() == 1.0 && x.dot(y) == 0.0 && x.dot(z) == 0.0 && y.dot(z) == 0.0;
    }

    public final boolean isOrthogonal() {
        Vector3 x = this.getColumn(0);
        Vector3 y = this.getColumn(1);
        Vector3 z = this.getColumn(2);
        return x.dot(y) == 0.0 && x.dot(z) == 0.0 && y.dot(z) == 0.0;
    }

    public final boolean isConformal() {
        Vector3 x = this.getColumn(0);
        Vector3 y = this.getColumn(1);
        Vector3 z = this.getColumn(2);
        double xLenSq = x.lengthSquared();
        return xLenSq == y.lengthSquared() && xLenSq == z.lengthSquared() && x.dot(y) == 0.0 && x.dot(z) == 0.0 && y.dot(z) == 0.0;
    }

    public final boolean isDiagonal() {
        return this.rows[0].get(1) == 0.0 && this.rows[0].get(2) == 0.0 && this.rows[1].get(0) == 0.0 && this.rows[1].get(2) == 0.0 && this.rows[2].get(0) == 0.0 && this.rows[2].get(1) == 0.0;
    }

    public final boolean isRotation() {
        return this.isConformal() && this.determinant() == 1.0;
    }

    @NotNull
    public final Basis lerp(@NotNull Basis to, double weight) {
        Intrinsics.checkNotNullParameter(to, "to");
        Basis basis = new Basis();
        basis.rows[0] = this.rows[0].lerp(to.rows[0], weight);
        basis.rows[1] = this.rows[1].lerp(to.rows[1], weight);
        basis.rows[2] = this.rows[2].lerp(to.rows[2], weight);
        return basis;
    }

    @NotNull
    public final Basis slerp(@NotNull Basis to, double weight) {
        Intrinsics.checkNotNullParameter(to, "to");
        throw new NotImplementedError("Slerp is not implemented for Basis yet (Quaternion is missing)");
    }

    public final void orthonormalize() {
        Vector3 x = this.getColumn(0);
        Vector3 y = this.getColumn(1);
        Vector3 z = this.getColumn(2);
        x.normalize();
        y = y.minus(x.times(x.dot(y)));
        y.normalize();
        z = z.minus(x.times(x.dot(z))).minus(y.times(y.dot(z)));
        z.normalize();
        this.setColumn(0, x);
        this.setColumn(1, y);
        this.setColumn(2, z);
    }

    @NotNull
    public final Basis orthonormalized() {
        Basis result = this.clone();
        result.orthonormalize();
        return result;
    }

    public final void orthogonalize() {
        Vector3 scale = this.getScale();
        this.orthonormalize();
        this.scaleLocal(scale);
    }

    @NotNull
    public final Basis orthogonalized() {
        Basis result = this.clone();
        result.orthogonalize();
        return result;
    }

    @NotNull
    public final Basis diagonalize() {
        int j;
        int i;
        int iteMax = 1024;
        Basis accRot = new Basis();
        int ite = 0;
        for (double offMatrixNorm2 = this.rows[0].get(1) * this.rows[0].get(1) + this.rows[0].get(2) * this.rows[0].get(2) + this.rows[1].get(2) * this.rows[1].get(2); offMatrixNorm2 > 0.0 && ite++ < iteMax; offMatrixNorm2 -= this.rows[i].get(j) * this.rows[i].get(j)) {
            double el012 = this.rows[0].get(1) * this.rows[0].get(1);
            double el022 = this.rows[0].get(2) * this.rows[0].get(2);
            double el122 = this.rows[1].get(2) * this.rows[1].get(2);
            i = 0;
            j = 0;
            if (el012 > el022) {
                if (el122 > el012) {
                    i = 1;
                    j = 2;
                } else {
                    i = 0;
                    j = 1;
                }
            } else if (el122 > el022) {
                i = 1;
                j = 2;
            } else {
                i = 0;
                j = 2;
            }
            double angle = 0.0;
            angle = this.rows[j].get(j) == this.rows[i].get(i) ? 0.7853981633974483 : 0.5 * Math.atan((double)2 * this.rows[i].get(j) / (this.rows[j].get(j) - this.rows[i].get(i)));
            Basis rot = new Basis();
            rot.rows[i].set(i, Math.cos(angle));
            rot.rows[j].set(j, rot.rows[i].get(i));
            rot.rows[j].set(i, Math.sin(angle));
            rot.rows[i].set(j, -rot.rows[j].get(i));
            this.timesAssign(rot.times(rot.transposed()));
            accRot.timesAssign(rot);
        }
        return accRot;
    }

    @NotNull
    public final Vector3 get(int index) {
        return this.rows[index];
    }

    @NotNull
    public final Basis times(@NotNull Basis other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Basis(new Vector3(other.tdotx(this.rows[0]), other.tdoty(this.rows[0]), other.tdotz(this.rows[0])), new Vector3(other.tdotx(this.rows[1]), other.tdoty(this.rows[1]), other.tdotz(this.rows[1])), new Vector3(other.tdotx(this.rows[2]), other.tdoty(this.rows[2]), other.tdotz(this.rows[2])));
    }

    public final void timesAssign(@NotNull Basis other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.set(other.tdotx(this.rows[0]), other.tdoty(this.rows[0]), other.tdotz(this.rows[0]), other.tdotx(this.rows[1]), other.tdoty(this.rows[1]), other.tdotz(this.rows[1]), other.tdotx(this.rows[2]), other.tdoty(this.rows[2]), other.tdotz(this.rows[2]));
    }

    @NotNull
    public final Basis plus(@NotNull Basis other) {
        Intrinsics.checkNotNullParameter(other, "other");
        Basis result = this.clone();
        result.plusAssign(other);
        return result;
    }

    public final void plusAssign(@NotNull Basis other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.rows[0] = this.rows[0].plus(other.rows[0]);
        this.rows[1] = this.rows[1].plus(other.rows[1]);
        this.rows[2] = this.rows[2].plus(other.rows[2]);
    }

    @NotNull
    public final Basis minus(@NotNull Basis other) {
        Intrinsics.checkNotNullParameter(other, "other");
        Basis result = this.clone();
        result.minusAssign(other);
        return result;
    }

    public final void minusAssign(@NotNull Basis other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.rows[0] = this.rows[0].minus(other.rows[0]);
        this.rows[1] = this.rows[1].minus(other.rows[1]);
        this.rows[2] = this.rows[2].minus(other.rows[2]);
    }

    @NotNull
    public final Basis times(double scalar) {
        Basis result = this.clone();
        result.timesAssign(scalar);
        return result;
    }

    public final void timesAssign(double scalar) {
        this.rows[0] = this.rows[0].times(scalar);
        this.rows[1] = this.rows[1].times(scalar);
        this.rows[2] = this.rows[2].times(scalar);
    }

    @NotNull
    public final Basis div(double scalar) {
        Basis result = this.clone();
        result.divAssign(scalar);
        return result;
    }

    public final void divAssign(double scalar) {
        this.rows[0] = this.rows[0].div(scalar);
        this.rows[1] = this.rows[1].div(scalar);
        this.rows[2] = this.rows[2].div(scalar);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Basis)) {
            return false;
        }
        return Arrays.equals(this.rows, ((Basis)other).rows);
    }

    @NotNull
    public Basis clone() {
        return new Basis(this.rows[0].clone(), this.rows[1].clone(), this.rows[2].clone());
    }

    public int hashCode() {
        return Arrays.hashCode(this.rows);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lcom/mochibit/defcon/math/Basis$Companion;", "", "()V", "fromScale", "Lcom/mochibit/defcon/math/Basis;", "scale", "Lcom/mochibit/defcon/math/Vector3;", "lookingAt", "target", "up", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Basis fromScale(@NotNull Vector3 scale) {
            Intrinsics.checkNotNullParameter(scale, "scale");
            return new Basis(scale.getX(), 0.0, 0.0, 0.0, scale.getY(), 0.0, 0.0, 0.0, scale.getZ());
        }

        @NotNull
        public final Basis lookingAt(@NotNull Vector3 target, @NotNull Vector3 up) {
            Intrinsics.checkNotNullParameter(target, "target");
            Intrinsics.checkNotNullParameter(up, "up");
            Vector3 vZ = target.normalized();
            Vector3 vX = up.cross(vZ);
            vX.normalize();
            Vector3 vY = vZ.cross(vX);
            Basis basis = new Basis();
            basis.setColumns(vX, vY, vZ);
            return basis;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

