/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.listeners.items;

import com.mochibit.defcon.enums.ItemBehaviour;
import com.mochibit.defcon.events.customitems.CustomItemEquipEvent;
import com.mochibit.defcon.events.radiationarea.RadiationSuffocationEvent;
import com.mochibit.defcon.extensions.ItemStackKt;
import com.mochibit.defcon.radiation.RadiationArea;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/mochibit/defcon/listeners/items/GasMaskListener;", "Lorg/bukkit/event/Listener;", "()V", "onGasMaskEquip", "", "event", "Lcom/mochibit/defcon/events/customitems/CustomItemEquipEvent;", "protectFromGas", "Lcom/mochibit/defcon/events/radiationarea/RadiationSuffocationEvent;", "Defcon"})
public final class GasMaskListener
implements Listener {
    @EventHandler
    public final void protectFromGas(@NotNull RadiationSuffocationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Player player = event.getPlayer();
        RadiationArea radiationArea = event.getRadiationArea();
        ItemStack itemStack = player.getInventory().getHelmet();
        if (itemStack == null) {
            return;
        }
        ItemStack helmet = itemStack;
        ItemBehaviour itemBehaviour = ItemStackKt.getBehaviour(helmet);
        if (itemBehaviour != ItemBehaviour.GAS_MASK) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public final void onGasMaskEquip(@NotNull CustomItemEquipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        HumanEntity player = event.getPlayer();
        ItemStack item = event.getEquippedItem();
        ItemBehaviour itemBehaviour = ItemStackKt.getBehaviour(item);
        if (itemBehaviour != ItemBehaviour.GAS_MASK) {
            event.setCancelled(true);
            return;
        }
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
    }
}

