/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.listeners.customitem;

import com.mochibit.defcon.Defcon;
import com.mochibit.defcon.events.customitems.CustomItemEquipEvent;
import com.mochibit.defcon.extensions.ItemStackKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u0016"}, d2={"Lcom/mochibit/defcon/listeners/customitem/CustomItemEquipListener;", "Lorg/bukkit/event/Listener;", "()V", "callCustomItemEquipEvent", "Lcom/mochibit/defcon/events/customitems/CustomItemEquipEvent;", "item", "Lorg/bukkit/inventory/ItemStack;", "player", "Lorg/bukkit/entity/HumanEntity;", "equipItemInArmorClick", "", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "equipItemInArmorDrag", "Lorg/bukkit/event/inventory/InventoryDragEvent;", "isEquipable", "", "slot", "", "rawSlotToEquipmentSlot", "rawSlot", "shiftClickEquipItemInArmorClick", "Defcon"})
public class CustomItemEquipListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void equipItemInArmorClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getSlotType() != InventoryType.SlotType.ARMOR) {
            return;
        }
        ItemStack itemStack = event.getCursor();
        if (itemStack == null) {
            return;
        }
        ItemStack cursor = itemStack;
        if (cursor.getType() == Material.AIR) {
            return;
        }
        if (!this.isEquipable(cursor, event.getRawSlot())) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        Intrinsics.checkNotNullExpressionValue(humanEntity, "getWhoClicked(...)");
        HumanEntity player = humanEntity;
        ItemStack oldItem = event.getCurrentItem();
        if (this.callCustomItemEquipEvent(cursor, player).isCancelled()) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
        event.setCancelled(true);
        player.getInventory().setHelmet(cursor);
        player.setItemOnCursor(oldItem);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void shiftClickEquipItemInArmorClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        ItemStack currentItem = itemStack;
        if (currentItem.getType() == Material.AIR) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        Intrinsics.checkNotNullExpressionValue(humanEntity, "getWhoClicked(...)");
        HumanEntity player = humanEntity;
        if (event.getClick() != ClickType.SHIFT_LEFT && event.getClick() != ClickType.SHIFT_RIGHT) {
            return;
        }
        if (event.getAction() != InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            return;
        }
        if (!ItemStackKt.isEquipable(currentItem)) {
            return;
        }
        if (event.getSlotType() == InventoryType.SlotType.CRAFTING) {
            return;
        }
        if (event.getSlotType() == InventoryType.SlotType.ARMOR) {
            return;
        }
        Defcon.Companion.Logger.INSTANCE.info("SHIFT CLICKED AN EQUIPABLE ITEM");
        Defcon.Companion.Logger.INSTANCE.info("Current item: " + currentItem);
        int equipmentSlot = this.rawSlotToEquipmentSlot(ItemStackKt.equipSlotNumber(currentItem));
        ItemStack oldItem = player.getInventory().getItem(equipmentSlot);
        Defcon.Companion.Logger.INSTANCE.info("Old item: " + oldItem);
        if (oldItem != null && oldItem.getType() != Material.AIR) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
        if (this.callCustomItemEquipEvent(currentItem, player).isCancelled()) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
        event.setCancelled(true);
        player.getInventory().setItem(event.getSlot(), null);
        player.getInventory().setItem(equipmentSlot, currentItem);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void equipItemInArmorDrag(@NotNull InventoryDragEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ItemStack itemStack = event.getOldCursor();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getOldCursor(...)");
        ItemStack cursor = itemStack;
        HumanEntity humanEntity = event.getWhoClicked();
        Intrinsics.checkNotNullExpressionValue(humanEntity, "getWhoClicked(...)");
        HumanEntity player = humanEntity;
        if (cursor.getType() == Material.AIR) {
            return;
        }
        Integer n = event.getRawSlots().stream().findFirst().orElse(0);
        Intrinsics.checkNotNullExpressionValue(n, "orElse(...)");
        if (!this.isEquipable(cursor, ((Number)n).intValue())) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
        if (this.callCustomItemEquipEvent(cursor, player).isCancelled()) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
        ItemStack oldItem = player.getInventory().getHelmet();
        event.setCancelled(true);
        player.getInventory().setHelmet(cursor);
        player.setItemOnCursor(oldItem);
    }

    private final boolean isEquipable(ItemStack item, int slot) {
        if (!ItemStackKt.isEquipable(item)) {
            return false;
        }
        return ItemStackKt.equipSlotNumber(item) == slot;
    }

    private final CustomItemEquipEvent callCustomItemEquipEvent(ItemStack item, HumanEntity player) {
        CustomItemEquipEvent customItemEquipEvent = new CustomItemEquipEvent(item, player);
        Bukkit.getServer().getPluginManager().callEvent((Event)customItemEquipEvent);
        return customItemEquipEvent;
    }

    private final int rawSlotToEquipmentSlot(int rawSlot) {
        return switch (rawSlot) {
            case 5 -> 39;
            case 6 -> 38;
            case 7 -> 37;
            case 8 -> 36;
            default -> -1;
        };
    }
}

