/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.explosions;

import com.mochibit.defcon.Defcon;
import com.mochibit.defcon.explosions.Shockwave;
import com.mochibit.defcon.utils.Geometry;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/mochibit/defcon/explosions/ShockwaveColumn;", "", "location", "Lorg/bukkit/Location;", "explosionPower", "", "radiusGroup", "", "shockwave", "Lcom/mochibit/defcon/explosions/Shockwave;", "(Lorg/bukkit/Location;FILcom/mochibit/defcon/explosions/Shockwave;)V", "getLocation", "()Lorg/bukkit/Location;", "minHeight", "", "compareTo", "other", "explode", "", "killNearbyEntities", "replaceBlocks", "radius", "Defcon"})
public final class ShockwaveColumn
implements Comparable<ShockwaveColumn> {
    @NotNull
    private final Location location;
    private final float explosionPower;
    private final int radiusGroup;
    @NotNull
    private final Shockwave shockwave;
    private final double minHeight;

    public ShockwaveColumn(@NotNull Location location, float explosionPower, int radiusGroup, @NotNull Shockwave shockwave) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(shockwave, "shockwave");
        this.location = location;
        this.explosionPower = explosionPower;
        this.radiusGroup = radiusGroup;
        this.shockwave = shockwave;
        Location location2 = this.location.clone().add(0.0, this.shockwave.getShockwaveHeight(), 0.0);
        Intrinsics.checkNotNullExpressionValue(location2, "add(...)");
        this.minHeight = Geometry.INSTANCE.getMinYUsingSnapshot(location2, this.shockwave.getShockwaveHeight() * (double)2).getY();
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    public final void explode() {
        int lastExplodedY = -1000;
        Location center = this.shockwave.getCenter();
        double maxDeltaHeight = this.shockwave.getShockwaveHeight();
        Vector vector = this.location.toVector().subtract(center.toVector()).normalize();
        Intrinsics.checkNotNullExpressionValue(vector, "normalize(...)");
        Vector direction = vector;
        int maxY = RangesKt.coerceAtMost((int)(this.location.getY() + maxDeltaHeight), this.location.getWorld().getMaxHeight() - 1);
        int minY = (int)this.minHeight;
        int y = maxY;
        if (minY <= y) {
            while (true) {
                if (Math.abs(y - lastExplodedY) >= 8) {
                    Block backwardBlock;
                    Block forwardBlock;
                    Location currentYLocation;
                    Intrinsics.checkNotNullExpressionValue(this.location.clone().set(this.location.getX(), (double)y, this.location.getZ()), "set(...)");
                    BlockFace axis = Math.abs(direction.getX()) > Math.abs(direction.getZ()) ? BlockFace.EAST : BlockFace.SOUTH;
                    Intrinsics.checkNotNullExpressionValue(currentYLocation.clone().add(axis.getDirection()).getBlock(), "getBlock(...)");
                    Intrinsics.checkNotNullExpressionValue(currentYLocation.clone().add(axis.getDirection().clone().multiply(-1)).getBlock(), "getBlock(...)");
                    if (forwardBlock.getType() != Material.AIR || backwardBlock.getType() != Material.AIR) {
                        Bukkit.getScheduler().runTask((Plugin)Defcon.Companion.getInstance(), () -> ShockwaveColumn.explode$lambda$0(this, currentYLocation));
                        this.replaceBlocks(currentYLocation, (int)this.explosionPower * 2);
                        this.killNearbyEntities(currentYLocation);
                        lastExplodedY = y;
                    }
                }
                if (y == minY) break;
                --y;
            }
        }
    }

    private final void replaceBlocks(Location location, int radius) {
        Random.Default random = Random.Default;
        int radiusSquared = radius * radius;
        for (int i = 0; i < 1000; ++i) {
            Block block;
            int z;
            int y;
            int x = random.nextInt(-radius, radius + 1);
            if (x * x + (y = random.nextInt(-radius, radius + 1)) * y + (z = random.nextInt(-radius, radius + 1)) * z > radiusSquared) continue;
            Intrinsics.checkNotNullExpressionValue(location.clone().add((double)x, (double)y, (double)z).getBlock(), "getBlock(...)");
            if (block.getType() == Material.AIR || block.getType() == Material.WATER || block.getType() == Material.LAVA || block.getType() == Material.DEEPSLATE) continue;
            Bukkit.getScheduler().runTask((Plugin)Defcon.Companion.getInstance(), () -> ShockwaveColumn.replaceBlocks$lambda$1(random, block));
        }
    }

    private final void killNearbyEntities(Location location) {
        int power = (int)this.explosionPower * 3;
        Bukkit.getScheduler().runTask((Plugin)Defcon.Companion.getInstance(), () -> ShockwaveColumn.killNearbyEntities$lambda$2(location, power));
    }

    @Override
    public int compareTo(@NotNull ShockwaveColumn other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.compare(this.radiusGroup, other.radiusGroup);
    }

    private static final void explode$lambda$0(ShockwaveColumn this$0, Location $currentYLocation) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($currentYLocation, "$currentYLocation");
        this$0.location.getWorld().createExplosion($currentYLocation.clone().add(0.0, 5.0, 0.0), this$0.explosionPower, true, true);
    }

    private static final void replaceBlocks$lambda$1(Random.Default $random, Block $block) {
        Intrinsics.checkNotNullParameter($random, "$random");
        Intrinsics.checkNotNullParameter($block, "$block");
        if ($random.nextDouble() < 0.6) {
            $block.setType(Material.DEEPSLATE);
        }
    }

    private static final void killNearbyEntities$lambda$2(Location $location, int $power) {
        Intrinsics.checkNotNullParameter($location, "$location");
        Collection collection = $location.getWorld().getNearbyEntities($location, (double)$power, (double)$power, (double)$power);
        Intrinsics.checkNotNullExpressionValue(collection, "getNearbyEntities(...)");
        Collection nearbyEntities = collection;
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            ((LivingEntity)entity).damage(10000.0);
        }
    }
}

