/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.explosions;

import com.mochibit.defcon.Defcon;
import com.mochibit.defcon.biomes.definitions.NuclearFalloutBiome;
import com.mochibit.defcon.explosions.ShockwaveColumn;
import com.mochibit.defcon.threading.jobs.SimpleSchedulable;
import com.mochibit.defcon.threading.runnables.ScheduledRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0002J!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 *\b\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010\u001f\u001a\u00020\u0005H\u0082\u0004R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/mochibit/defcon/explosions/Shockwave;", "", "center", "Lorg/bukkit/Location;", "shockwaveRadiusStart", "", "shockwaveRadius", "shockwaveHeight", "(Lorg/bukkit/Location;DDD)V", "biome", "Lcom/mochibit/defcon/biomes/definitions/NuclearFalloutBiome;", "getCenter", "()Lorg/bukkit/Location;", "cylinderQueue", "Ljava/util/concurrent/PriorityBlockingQueue;", "Lcom/mochibit/defcon/explosions/ShockwaveColumn;", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "getShockwaveHeight", "()D", "getShockwaveRadius", "getShockwaveRadiusStart", "explode", "", "precalculateCylinders", "shockwaveCyl", "", "radius", "explosionPower", "", "startExploding", "step", "Lkotlin/sequences/Sequence;", "Lkotlin/ranges/ClosedRange;", "Defcon"})
public final class Shockwave {
    @NotNull
    private final Location center;
    private final double shockwaveRadiusStart;
    private final double shockwaveRadius;
    private final double shockwaveHeight;
    @NotNull
    private final NuclearFalloutBiome biome;
    @NotNull
    private final ThreadPoolExecutor executor;
    @NotNull
    private final PriorityBlockingQueue<ShockwaveColumn> cylinderQueue;

    public Shockwave(@NotNull Location center, double shockwaveRadiusStart, double shockwaveRadius, double shockwaveHeight) {
        Intrinsics.checkNotNullParameter(center, "center");
        this.center = center;
        this.shockwaveRadiusStart = shockwaveRadiusStart;
        this.shockwaveRadius = shockwaveRadius;
        this.shockwaveHeight = shockwaveHeight;
        this.biome = new NuclearFalloutBiome();
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        Intrinsics.checkNotNull(executorService, "null cannot be cast to non-null type java.util.concurrent.ThreadPoolExecutor");
        this.executor = (ThreadPoolExecutor)executorService;
        this.cylinderQueue = new PriorityBlockingQueue();
    }

    @NotNull
    public final Location getCenter() {
        return this.center;
    }

    public final double getShockwaveRadiusStart() {
        return this.shockwaveRadiusStart;
    }

    public final double getShockwaveRadius() {
        return this.shockwaveRadius;
    }

    public final double getShockwaveHeight() {
        return this.shockwaveHeight;
    }

    public final void explode() {
        Defcon.Companion.Logger.INSTANCE.info("Exploding..");
        ThreadsKt.thread$default(true, false, null, null, 0, new Function0<Unit>(this){
            final /* synthetic */ Shockwave this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Defcon.Companion.Logger.INSTANCE.info("Calculating cylinders");
                Shockwave.access$precalculateCylinders(this.this$0);
                Shockwave.access$getExecutor$p(this.this$0).shutdown();
                Defcon.Companion.Logger.INSTANCE.info("Finished calculating cylinders");
            }
        }, 30, null);
        this.startExploding();
    }

    private final void precalculateCylinders() {
        int radius = (int)this.shockwaveRadiusStart;
        int n = (int)this.shockwaveRadius;
        if (radius <= n) {
            while (true) {
                double explosionPower;
                if (radius % MathKt.roundToInt(1.5 * Math.ceil((explosionPower = (double)6.0f - (double)((float)radius * 3.0f) / this.shockwaveRadius) / (double)6)) == 0) {
                    this.executor.submit(() -> Shockwave.precalculateCylinders$lambda$0(this, radius, explosionPower));
                }
                if (radius == n) break;
                ++radius;
            }
        }
    }

    private final void startExploding() {
        ScheduledRunnable scheduledRunnable = new ScheduledRunnable().maxMillisPerTick(30.0);
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Defcon.Companion.getInstance(), (Runnable)scheduledRunnable, 0L, 1L);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimerAsynchronously(...)");
        BukkitTask taskTimer = bukkitTask;
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Defcon.Companion.getInstance(), arg_0 -> Shockwave.startExploding$lambda$1(new Function1<BukkitTask, Unit>(this, scheduledRunnable, taskTimer){
            final /* synthetic */ Shockwave this$0;
            final /* synthetic */ ScheduledRunnable $scheduledRunnable;
            final /* synthetic */ BukkitTask $taskTimer;
            {
                this.this$0 = $receiver;
                this.$scheduledRunnable = $scheduledRunnable;
                this.$taskTimer = $taskTimer;
                super(1);
            }

            public final void invoke(BukkitTask task) {
                while (!((Collection)Shockwave.access$getCylinderQueue$p(this.this$0)).isEmpty()) {
                    ShockwaveColumn shockwaveColumn;
                    ShockwaveColumn column = (ShockwaveColumn)Shockwave.access$getCylinderQueue$p(this.this$0).poll();
                    if (column == null) continue;
                    ScheduledRunnable scheduledRunnable = this.$scheduledRunnable;
                    ShockwaveColumn it = shockwaveColumn;
                    boolean bl = false;
                    scheduledRunnable.addWorkload(new SimpleSchedulable(new Function0<Unit>(column){
                        final /* synthetic */ ShockwaveColumn $column;
                        {
                            this.$column = $column;
                            super(0);
                        }

                        public final void invoke() {
                            this.$column.explode();
                        }
                    }));
                }
                if (Shockwave.access$getExecutor$p(this.this$0).isTerminated() && Shockwave.access$getCylinderQueue$p(this.this$0).isEmpty() && this.$scheduledRunnable.getWorkloadDeque().isEmpty()) {
                    task.cancel();
                    this.$taskTimer.cancel();
                }
            }
        }, arg_0), 0L, 2L);
    }

    private final List<ShockwaveColumn> shockwaveCyl(double radius, float explosionPower) {
        List columns = new ArrayList();
        double angleStep = RangesKt.coerceAtLeast(1.0 / radius, 0.2);
        Iterator<Double> iterator2 = this.step((ClosedRange<Double>)RangesKt.rangeTo(0.0, Math.PI * 2), angleStep).iterator();
        while (iterator2.hasNext()) {
            double angle = ((Number)iterator2.next()).doubleValue();
            double x = radius * Math.cos(angle);
            double z = radius * Math.sin(angle);
            Location location = this.center.clone().add(x, 0.0, z);
            Intrinsics.checkNotNullExpressionValue(location, "add(...)");
            columns.add(new ShockwaveColumn(location, explosionPower, (int)radius, this));
            Location location2 = this.center.clone().add(-x, 0.0, z);
            Intrinsics.checkNotNullExpressionValue(location2, "add(...)");
            columns.add(new ShockwaveColumn(location2, explosionPower, (int)radius, this));
            Location location3 = this.center.clone().add(x, 0.0, -z);
            Intrinsics.checkNotNullExpressionValue(location3, "add(...)");
            columns.add(new ShockwaveColumn(location3, explosionPower, (int)radius, this));
            Location location4 = this.center.clone().add(-x, 0.0, -z);
            Intrinsics.checkNotNullExpressionValue(location4, "add(...)");
            columns.add(new ShockwaveColumn(location4, explosionPower, (int)radius, this));
        }
        return columns;
    }

    private final Sequence<Double> step(ClosedRange<Double> $this$step, double step2) {
        return SequencesKt.generateSequence($this$step.getStart(), (Function1)new Function1<Double, Double>(step2, $this$step){
            final /* synthetic */ double $step;
            final /* synthetic */ ClosedRange<Double> $this_step;
            {
                this.$step = $step;
                this.$this_step = $receiver;
                super(1);
            }

            @Nullable
            public final Double invoke(double previous) {
                return previous + this.$step <= ((Number)this.$this_step.getEndInclusive()).doubleValue() ? Double.valueOf(previous + this.$step) : null;
            }
        });
    }

    private static final void precalculateCylinders$lambda$0(Shockwave this$0, int $radius, double $explosionPower) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        List<ShockwaveColumn> columns = this$0.shockwaveCyl($radius, (float)$explosionPower);
        this$0.cylinderQueue.addAll((Collection<ShockwaveColumn>)columns);
        Defcon.Companion.Logger.INSTANCE.info("Calculating columns for radius " + $radius);
    }

    private static final void startExploding$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$precalculateCylinders(Shockwave $this) {
        $this.precalculateCylinders();
    }

    public static final /* synthetic */ ThreadPoolExecutor access$getExecutor$p(Shockwave $this) {
        return $this.executor;
    }

    public static final /* synthetic */ PriorityBlockingQueue access$getCylinderQueue$p(Shockwave $this) {
        return $this.cylinderQueue;
    }
}

