/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.explosions;

import com.mochibit.defcon.Defcon;
import com.mochibit.defcon.effects.nuclear.CondensationCloudVFX;
import com.mochibit.defcon.effects.nuclear.NuclearExplosionVFX;
import com.mochibit.defcon.effects.nuclear.NuclearFogVFX;
import com.mochibit.defcon.explosions.Explosion;
import com.mochibit.defcon.explosions.NuclearComponent;
import com.mochibit.defcon.explosions.NuclearExplosion;
import com.mochibit.defcon.explosions.Shockwave;
import com.mochibit.defcon.radiation.RadiationAreaFactory;
import java.time.Duration;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/mochibit/defcon/explosions/NuclearExplosion;", "Lcom/mochibit/defcon/explosions/Explosion;", "center", "Lorg/bukkit/Location;", "nuclearComponent", "Lcom/mochibit/defcon/explosions/NuclearComponent;", "(Lorg/bukkit/Location;Lcom/mochibit/defcon/explosions/NuclearComponent;)V", "explode", "", "Defcon"})
@SourceDebugExtension(value={"SMAP\nNuclearExplosion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NuclearExplosion.kt\ncom/mochibit/defcon/explosions/NuclearExplosion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1855#2,2:199\n1855#2,2:201\n1855#2,2:203\n*S KotlinDebug\n*F\n+ 1 NuclearExplosion.kt\ncom/mochibit/defcon/explosions/NuclearExplosion\n*L\n64#1:199,2\n95#1:201,2\n109#1:203,2\n*E\n"})
public final class NuclearExplosion
extends Explosion {
    @NotNull
    private final Location center;
    @NotNull
    private final NuclearComponent nuclearComponent;

    public NuclearExplosion(@NotNull Location center, @NotNull NuclearComponent nuclearComponent) {
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(nuclearComponent, "nuclearComponent");
        this.center = center;
        this.nuclearComponent = nuclearComponent;
    }

    @Override
    public void explode() {
        Player player;
        new NuclearExplosionVFX(this.nuclearComponent, this.center).instantiate(true);
        new NuclearFogVFX(this.nuclearComponent, this.center).instantiate(true);
        new CondensationCloudVFX(this.nuclearComponent, this.center).instantiate(true);
        Collection collection = this.center.getWorld().getNearbyPlayers(this.center, 300.0);
        Intrinsics.checkNotNullExpressionValue(collection, "getNearbyPlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        block0: for (Object element$iv : $this$forEach$iv) {
            Vector direction;
            Location playerLocation;
            player = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(player.getLocation().add(0.0, 1.0, 0.0), "add(...)");
            Intrinsics.checkNotNullExpressionValue(playerLocation.clone().subtract(this.center).toVector().normalize(), "normalize(...)");
            BlockIterator blockIterator = new BlockIterator(this.center.getWorld(), this.center.toVector(), direction, 0.0, 180);
            while (blockIterator.hasNext()) {
                Title title;
                Block block;
                Intrinsics.checkNotNullExpressionValue(blockIterator.next(), "next(...)");
                if (block.getType().isOccluding() && block.getType().isSolid()) continue block0;
                if (!(block.getLocation().distanceSquared(player.getLocation()) < 1.0)) continue;
                Intrinsics.checkNotNullExpressionValue(Title.title((Component)((Component)Component.text((String)"\ue000")), (Component)((Component)Component.empty()), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(6L), (Duration)Duration.ofSeconds(10L))), "title(...)");
                float angle = player.getEyeLocation().getDirection().angle(direction.multiply(-1.0));
                Defcon.Companion.Logger.INSTANCE.info("Angle: " + angle);
                if (!((double)angle < 1.74)) continue block0;
                player.showTitle(title);
                continue block0;
            }
        }
        Collection collection2 = this.center.getWorld().getNearbyPlayers(this.center, 300.0);
        Intrinsics.checkNotNullExpressionValue(collection2, "getNearbyPlayers(...)");
        $this$forEach$iv = collection2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            player = (Player)element$iv;
            boolean bl = false;
            double distance = player.getLocation().distance(this.center);
            int soundSpeed = 50;
            long delayInSeconds = (long)(distance / (double)soundSpeed);
            Bukkit.getScheduler().runTaskLater((Plugin)Defcon.Companion.getInstance(), () -> NuclearExplosion.explode$lambda$2$lambda$1(player, this), delayInSeconds * (long)20);
            player.playSound(this.center, "minecraft:nuke.ground_rumble", 1.0f, 1.0f);
        }
        Collection collection3 = this.center.getWorld().getNearbyPlayers(this.center, 600.0);
        Intrinsics.checkNotNullExpressionValue(collection3, "getNearbyPlayers(...)");
        $this$forEach$iv = collection3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            player = (Player)element$iv;
            boolean bl = false;
            double distance = player.getLocation().distance(this.center);
            int soundSpeed = 50;
            long delayInSeconds = (long)(distance / (double)soundSpeed);
            Bukkit.getScheduler().runTaskLater((Plugin)Defcon.Companion.getInstance(), () -> NuclearExplosion.explode$lambda$4$lambda$3(player, this), delayInSeconds * (long)20);
        }
        float thermalRadius = this.nuclearComponent.getThermalPower() * (float)30 * (float)10;
        Ref.IntRef secondsElapsed = new Ref.IntRef();
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Defcon.Companion.getInstance(), arg_0 -> NuclearExplosion.explode$lambda$5(new Function1<BukkitTask, Unit>(secondsElapsed, this, thermalRadius){
            final /* synthetic */ Ref.IntRef $secondsElapsed;
            final /* synthetic */ NuclearExplosion this$0;
            final /* synthetic */ float $thermalRadius;
            {
                this.$secondsElapsed = $secondsElapsed;
                this.this$0 = $receiver;
                this.$thermalRadius = $thermalRadius;
                super(1);
            }

            public final void invoke(BukkitTask task) {
                int n = this.$secondsElapsed.element;
                this.$secondsElapsed.element = n + 1;
                if (this.$secondsElapsed.element >= 10) {
                    task.cancel();
                    return;
                }
                Bukkit.getScheduler().runTask((Plugin)Defcon.Companion.getInstance(), () -> explode.4.invoke$lambda$1(this.this$0, this.$thermalRadius));
            }

            private static final void invoke$lambda$1(NuclearExplosion this$0, float $thermalRadius) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Collection collection = NuclearExplosion.access$getCenter$p(this$0).getWorld().getNearbyEntities(NuclearExplosion.access$getCenter$p(this$0), (double)$thermalRadius, (double)$thermalRadius, (double)$thermalRadius);
                Intrinsics.checkNotNullExpressionValue(collection, "getNearbyEntities(...)");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                block0: for (T element$iv : $this$forEach$iv) {
                    Vector direction;
                    Entity entity = (Entity)element$iv;
                    boolean bl = false;
                    if (!(entity instanceof LivingEntity)) continue;
                    Intrinsics.checkNotNullExpressionValue(((LivingEntity)entity).getLocation().subtract(NuclearExplosion.access$getCenter$p(this$0)).toVector().normalize(), "normalize(...)");
                    BlockIterator blockIterator = new BlockIterator(NuclearExplosion.access$getCenter$p(this$0).getWorld(), NuclearExplosion.access$getCenter$p(this$0).toVector(), direction, 0.0, (int)$thermalRadius);
                    while (blockIterator.hasNext()) {
                        Block block;
                        Intrinsics.checkNotNullExpressionValue(blockIterator.next(), "next(...)");
                        if (block.getType().isOccluding() && block.getType().isSolid()) continue block0;
                        if (!(block.getLocation().distanceSquared(((LivingEntity)entity).getLocation()) < 1.0)) continue;
                        entity.setFireTicks(600);
                        continue block0;
                    }
                }
            }
        }, arg_0), 0L, 20L);
        float shockwaveRadius = this.nuclearComponent.getBlastPower() * (float)60 * (float)10;
        float shockwaveHeight = this.nuclearComponent.getBlastPower() * (float)100 * (float)2;
        float falloutRadius = shockwaveRadius / (float)16;
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Defcon.Companion.getInstance(), () -> NuclearExplosion.explode$lambda$6(this), 800L);
        float obliterationRadius = this.nuclearComponent.getBlastPower() * (float)30;
        int x = -((int)obliterationRadius);
        int n = (int)obliterationRadius;
        if (x <= n) {
            while (true) {
                int n2;
                int y;
                if ((y = -((int)obliterationRadius)) <= (n2 = (int)obliterationRadius)) {
                    while (true) {
                        int n3;
                        int z;
                        if ((z = -((int)obliterationRadius)) <= (n3 = (int)obliterationRadius)) {
                            while (true) {
                                int distance;
                                if ((float)(distance = x * x + y * y + z * z) <= obliterationRadius * obliterationRadius) {
                                    Block block;
                                    Intrinsics.checkNotNullExpressionValue(this.center.clone().add((double)x, (double)y, (double)z).getBlock(), "getBlock(...)");
                                    if (block.getType() != Material.AIR) {
                                        block.setType(Material.AIR);
                                    }
                                }
                                if (z == n3) break;
                                ++z;
                            }
                        }
                        if (y == n2) break;
                        ++y;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
        new Shockwave(this.center, 0.0, shockwaveRadius, shockwaveHeight).explode();
    }

    private static final void explode$lambda$2$lambda$1(Player $player, NuclearExplosion this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        $player.playSound(this$0.center, "minecraft:nuke.set_near", 1.0f, 1.0f);
        $player.playSound(this$0.center, "minecraft:nuke.set_near_outer_rumble", 1.0f, 1.0f);
        $player.playSound(this$0.center, "minecraft:nuke.set_near_outer_wind", 1.0f, 1.0f);
    }

    private static final void explode$lambda$4$lambda$3(Player $player, NuclearExplosion this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        $player.playSound(this$0.center, "minecraft:nuke.set_distant_outer", 1.0f, 1.0f);
    }

    private static final void explode$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void explode$lambda$6(NuclearExplosion this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        RadiationAreaFactory.fromCenter$default(RadiationAreaFactory.INSTANCE, this$0.center, 3.0, 20000, null, null, 24, null).join();
    }

    public static final /* synthetic */ Location access$getCenter$p(NuclearExplosion $this) {
        return $this.center;
    }
}

