/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.effects.nuclear;

import com.mochibit.defcon.effects.AnimatedEffect;
import com.mochibit.defcon.effects.ColorSuppliable;
import com.mochibit.defcon.effects.EffectComponent;
import com.mochibit.defcon.effects.ParticleComponent;
import com.mochibit.defcon.explosions.NuclearComponent;
import com.mochibit.defcon.math.Vector3;
import com.mochibit.defcon.particles.AbstractParticle;
import com.mochibit.defcon.particles.ExplosionDustParticle;
import com.mochibit.defcon.vertexgeometry.VertexShapeBuilder;
import com.mochibit.defcon.vertexgeometry.particle.ParticleShape;
import com.mochibit.defcon.vertexgeometry.shapes.SphereBuilder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Color;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0011\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u000eR\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/mochibit/defcon/effects/nuclear/CondensationCloudVFX;", "Lcom/mochibit/defcon/effects/AnimatedEffect;", "nuclearComponent", "Lcom/mochibit/defcon/explosions/NuclearComponent;", "position", "Lorg/bukkit/Location;", "(Lcom/mochibit/defcon/explosions/NuclearComponent;Lorg/bukkit/Location;)V", "condensationCloud", "Lcom/mochibit/defcon/effects/ParticleComponent;", "currentRadius", "", "getCurrentRadius", "()D", "setCurrentRadius", "(D)V", "ringWidth", "getRingWidth", "riseSpeed", "getRiseSpeed", "setRiseSpeed", "secondaryCondensationCloud", "showOnlyRadiusPredicate", "Lkotlin/Function2;", "", "animate", "", "delta", "start", "Defcon"})
public final class CondensationCloudVFX
extends AnimatedEffect {
    @NotNull
    private final NuclearComponent nuclearComponent;
    @NotNull
    private final Location position;
    private double riseSpeed;
    private double currentRadius;
    private final double ringWidth;
    @NotNull
    private final Function2<Double, Double, Boolean> showOnlyRadiusPredicate;
    @NotNull
    private final ParticleComponent condensationCloud;
    @NotNull
    private final ParticleComponent secondaryCondensationCloud;

    /*
     * WARNING - void declaration
     */
    public CondensationCloudVFX(@NotNull NuclearComponent nuclearComponent, @NotNull Location position) {
        void $this$secondaryCondensationCloud_u24lambda_u245;
        EffectComponent[] $this$secondaryCondensationCloud_u24lambda_u244;
        EffectComponent[] $this$secondaryCondensationCloud_u24lambda_u243;
        EffectComponent[] $this$condensationCloud_u24lambda_u242;
        EffectComponent[] $this$condensationCloud_u24lambda_u241;
        EffectComponent[] $this$condensationCloud_u24lambda_u240;
        Intrinsics.checkNotNullParameter(nuclearComponent, "nuclearComponent");
        Intrinsics.checkNotNullParameter(position, "position");
        super(1200);
        this.nuclearComponent = nuclearComponent;
        this.position = position;
        this.riseSpeed = 4.0;
        this.currentRadius = 100.0;
        this.ringWidth = 30.0;
        this.showOnlyRadiusPredicate = new Function2<Double, Double, Boolean>(this){
            final /* synthetic */ CondensationCloudVFX this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Boolean invoke(double x, double z) {
                double distSquared = x * x + z * z;
                double innerRadius = this.this$0.getCurrentRadius() - this.this$0.getRingWidth();
                double outerRadius = this.this$0.getCurrentRadius() + this.this$0.getRingWidth();
                return distSquared >= innerRadius * innerRadius && distSquared <= outerRadius * outerRadius;
            }
        };
        EffectComponent[] effectComponentArray = new ExplosionDustParticle();
        ExplosionDustParticle explosionDustParticle = effectComponentArray;
        CondensationCloudVFX condensationCloudVFX = this;
        boolean bl = false;
        $this$condensationCloud_u24lambda_u240.scale(new Vector3(30.0, 30.0, 30.0));
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        $this$condensationCloud_u24lambda_u240.color(color);
        $this$condensationCloud_u24lambda_u240.colorDarkenFactor(0.9, 1.0);
        $this$condensationCloud_u24lambda_u240.colorLightenFactor(0.0, 0.0);
        Location location = this.position;
        VertexShapeBuilder vertexShapeBuilder = new SphereBuilder().withRadiusXZ(400.0).withRadiusY(1.0);
        AbstractParticle abstractParticle = (AbstractParticle)effectComponentArray;
        $this$condensationCloud_u24lambda_u240 = effectComponentArray = new ParticleShape(abstractParticle, vertexShapeBuilder, location);
        boolean bl2 = false;
        $this$condensationCloud_u24lambda_u241.xzPredicate(this.showOnlyRadiusPredicate);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        ColorSuppliable colorSuppliable = null;
        EffectComponent[] effectComponentArray2 = effectComponentArray;
        $this$condensationCloud_u24lambda_u241 = effectComponentArray = new ParticleComponent((ParticleShape)effectComponentArray2, colorSuppliable, n, defaultConstructorMarker).visible(false).translate(new Vector3(0.0, 60.0, 0.0));
        boolean bl3 = false;
        $this$condensationCloud_u24lambda_u242.applyRadialVelocityFromCenter(new Vector3(2.0, 0.0, 2.0));
        condensationCloudVFX.condensationCloud = effectComponentArray.emitRate(50);
        $this$condensationCloud_u24lambda_u242 = effectComponentArray = new ExplosionDustParticle();
        condensationCloudVFX = this;
        boolean bl4 = false;
        $this$secondaryCondensationCloud_u24lambda_u243.scale(new Vector3(30.0, 30.0, 30.0));
        Color color2 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
        $this$secondaryCondensationCloud_u24lambda_u243.color(color2);
        $this$secondaryCondensationCloud_u24lambda_u243.colorDarkenFactor(0.9, 1.0);
        $this$secondaryCondensationCloud_u24lambda_u243.colorLightenFactor(0.0, 0.0);
        Location location2 = this.position;
        VertexShapeBuilder vertexShapeBuilder2 = new SphereBuilder().withRadiusXZ(400.0).withRadiusY(1.0);
        AbstractParticle abstractParticle2 = (AbstractParticle)effectComponentArray;
        $this$secondaryCondensationCloud_u24lambda_u243 = effectComponentArray = new ParticleShape(abstractParticle2, vertexShapeBuilder2, location2);
        boolean bl5 = false;
        $this$secondaryCondensationCloud_u24lambda_u244.xzPredicate(this.showOnlyRadiusPredicate);
        DefaultConstructorMarker defaultConstructorMarker2 = null;
        int n2 = 2;
        ColorSuppliable colorSuppliable2 = null;
        EffectComponent[] effectComponentArray3 = effectComponentArray;
        $this$secondaryCondensationCloud_u24lambda_u244 = effectComponentArray = new ParticleComponent((ParticleShape)effectComponentArray3, colorSuppliable2, n2, defaultConstructorMarker2).visible(false).translate(new Vector3(0.0, 140.0, 0.0));
        boolean bl6 = false;
        $this$secondaryCondensationCloud_u24lambda_u245.applyRadialVelocityFromCenter(new Vector3(2.0, 0.0, 2.0));
        condensationCloudVFX.secondaryCondensationCloud = effectComponentArray.emitRate(50);
        effectComponentArray = new EffectComponent[]{this.condensationCloud, this.secondaryCondensationCloud};
        this.setEffectComponents(CollectionsKt.mutableListOf(effectComponentArray));
    }

    public final double getRiseSpeed() {
        return this.riseSpeed;
    }

    public final void setRiseSpeed(double d) {
        this.riseSpeed = d;
    }

    public final double getCurrentRadius() {
        return this.currentRadius;
    }

    public final void setCurrentRadius(double d) {
        this.currentRadius = d;
    }

    public final double getRingWidth() {
        return this.ringWidth;
    }

    @Override
    public void animate(double delta) {
        if (this.getTickAlive() > 400.0) {
            double deltaMovement = this.riseSpeed * delta;
            this.condensationCloud.translate(new Vector3(0.0, deltaMovement, 0.0));
            this.currentRadius += deltaMovement;
            this.secondaryCondensationCloud.translate(new Vector3(0.0, deltaMovement * 1.5, 0.0));
        }
    }

    @Override
    public void start() {
        super.start();
        this.condensationCloud.setVisibilityAfterDelay(true, 400L);
        this.secondaryCondensationCloud.setVisibilityAfterDelay(true, 700L);
    }
}

