/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.commands;

import com.mochibit.defcon.commands.CommandInfo;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u000eJ#\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0011J3\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/mochibit/defcon/commands/GenericCommand;", "Lorg/bukkit/command/CommandExecutor;", "()V", "commandInfo", "Lcom/mochibit/defcon/commands/CommandInfo;", "getCommandInfo", "()Lcom/mochibit/defcon/commands/CommandInfo;", "execute", "", "sender", "Lorg/bukkit/command/CommandSender;", "args", "", "", "(Lorg/bukkit/command/CommandSender;[Ljava/lang/String;)V", "player", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/entity/Player;[Ljava/lang/String;)V", "onCommand", "", "command", "Lorg/bukkit/command/Command;", "label", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "Defcon"})
public abstract class GenericCommand
implements CommandExecutor {
    @NotNull
    private final CommandInfo commandInfo;

    public GenericCommand() {
        CommandInfo commandInfo = this.getClass().getDeclaredAnnotation(CommandInfo.class);
        Intrinsics.checkNotNullExpressionValue(commandInfo, "getDeclaredAnnotation(...)");
        this.commandInfo = commandInfo;
        Objects.requireNonNull(this.commandInfo, "Commands must have a CommandInfo annotation");
    }

    @NotNull
    public final CommandInfo getCommandInfo() {
        return this.commandInfo;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args2, "args");
        if (((CharSequence)this.commandInfo.permission()).length() > 0 && !sender.hasPermission(this.commandInfo.permission())) {
            sender.sendMessage(ChatColor.RED.toString() + "You can't execute this command.");
            return true;
        }
        if (this.commandInfo.requiresPlayer()) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(ChatColor.RED.toString() + "This command can be only executed from a player.");
                return true;
            }
            this.execute((Player)sender, args2);
            return true;
        }
        this.execute(sender, args2);
        return true;
    }

    public void execute(@NotNull Player player, @NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(args2, "args");
    }

    private final void execute(CommandSender sender, String[] args2) {
    }
}

