/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.classes;

import com.mochibit.defcon.enums.ConfigurationStorages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\u0013H\u0002R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/mochibit/defcon/classes/PluginConfiguration;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "configurationStorage", "Lcom/mochibit/defcon/enums/ConfigurationStorages;", "(Lorg/bukkit/plugin/java/JavaPlugin;Lcom/mochibit/defcon/enums/ConfigurationStorages;)V", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "getConfig", "()Lorg/bukkit/configuration/file/FileConfiguration;", "configuration", "configurationFile", "Ljava/io/File;", "configurationFilePath", "fileName", "", "filePath", "reloadConfig", "", "saveConfig", "saveDefaultConfig", "Companion", "Defcon"})
public final class PluginConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final JavaPlugin plugin;
    @NotNull
    private final String filePath;
    @NotNull
    private final String fileName;
    @Nullable
    private File configurationFile;
    @Nullable
    private File configurationFilePath;
    @Nullable
    private FileConfiguration configuration;

    public PluginConfiguration(@Nullable JavaPlugin plugin, @NotNull ConfigurationStorages configurationStorage) {
        Intrinsics.checkNotNullParameter((Object)configurationStorage, "configurationStorage");
        this.plugin = plugin;
        this.filePath = configurationStorage.getStoragePath();
        this.fileName = configurationStorage.getStorageFileName() + ".yml";
        JavaPlugin javaPlugin = this.plugin;
        Intrinsics.checkNotNull(javaPlugin);
        this.configurationFilePath = new File(javaPlugin.getDataFolder(), this.filePath);
        this.configurationFile = new File(this.configurationFilePath, this.fileName);
        this.saveDefaultConfig();
    }

    public final void reloadConfig() {
        if (this.configurationFilePath == null) {
            JavaPlugin javaPlugin = this.plugin;
            Intrinsics.checkNotNull(javaPlugin);
            this.configurationFilePath = new File(javaPlugin.getDataFolder(), this.filePath);
        }
        if (this.configurationFile == null) {
            this.configurationFile = new File(this.configurationFilePath, this.fileName);
        }
        File file = this.configurationFile;
        Intrinsics.checkNotNull(file);
        this.configuration = (FileConfiguration)YamlConfiguration.loadConfiguration((File)file);
        JavaPlugin javaPlugin = this.plugin;
        Intrinsics.checkNotNull(javaPlugin);
        InputStream stream = javaPlugin.getResource(this.fileName);
        if (stream != null) {
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream));
            Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
            YamlConfiguration ymlFile = yamlConfiguration;
            FileConfiguration fileConfiguration = this.configuration;
            Intrinsics.checkNotNull(fileConfiguration, "null cannot be cast to non-null type org.bukkit.configuration.file.YamlConfiguration");
            ((YamlConfiguration)fileConfiguration).setDefaults((Configuration)ymlFile);
        }
    }

    public final void saveConfig() {
        try {
            FileConfiguration fileConfiguration = this.configuration;
            Intrinsics.checkNotNull(fileConfiguration);
            File file = this.configurationFile;
            Intrinsics.checkNotNull(file);
            fileConfiguration.save(file);
        }
        catch (IOException e) {
            JavaPlugin javaPlugin = this.plugin;
            Intrinsics.checkNotNull(javaPlugin);
            javaPlugin.getLogger().log(Level.SEVERE, "Could not save config to " + this.configurationFile, e);
        }
    }

    private final void saveDefaultConfig() {
        File file = this.configurationFilePath;
        Intrinsics.checkNotNull(file);
        if (!file.exists()) {
            File file2 = this.configurationFilePath;
            Intrinsics.checkNotNull(file2);
            if (!file2.mkdirs()) {
                JavaPlugin javaPlugin = this.plugin;
                Intrinsics.checkNotNull(javaPlugin);
                javaPlugin.getLogger().log(Level.WARNING, "Could not create the directory!");
                return;
            }
        }
        File file3 = this.configurationFile;
        Intrinsics.checkNotNull(file3);
        if (!file3.exists()) {
            JavaPlugin javaPlugin = this.plugin;
            Intrinsics.checkNotNull(javaPlugin);
            javaPlugin.saveResource(this.filePath + this.fileName, false);
        }
    }

    @Nullable
    public final FileConfiguration getConfig() {
        File file = this.configurationFilePath;
        Intrinsics.checkNotNull(file);
        if (!file.exists()) {
            this.saveDefaultConfig();
        }
        if (this.configuration == null) {
            this.reloadConfig();
        }
        return this.configuration;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/mochibit/defcon/classes/PluginConfiguration$Companion;", "", "()V", "save", "", "config", "Lcom/mochibit/defcon/classes/PluginConfiguration;", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        public final void save(@NotNull PluginConfiguration config) {
            Intrinsics.checkNotNullParameter(config, "config");
            config.saveConfig();
            config.reloadConfig();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

