/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.biomes;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.ChunkCoordIntPair;
import com.mochibit.defcon.Defcon;
import com.mochibit.defcon.biomes.CustomBiome;
import com.mochibit.defcon.threading.jobs.SimpleCompositionJob;
import com.mochibit.defcon.threading.runnables.ScheduledRunnable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.UnsafeValues;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/mochibit/defcon/biomes/CustomBiomeHandler;", "", "()V", "Companion", "Defcon"})
public final class CustomBiomeHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final UnsafeValues UNSAFE;
    private static final int CHUNK_SIZE = 16;

    static {
        UnsafeValues unsafeValues = Bukkit.getUnsafe();
        Intrinsics.checkNotNullExpressionValue(unsafeValues, "getUnsafe(...)");
        UNSAFE = unsafeValues;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/mochibit/defcon/biomes/CustomBiomeHandler$Companion;", "", "()V", "CHUNK_SIZE", "", "UNSAFE", "Lorg/bukkit/UnsafeValues;", "Lorg/jetbrains/annotations/NotNull;", "refreshChunkAsync", "", "chunk", "Lorg/bukkit/Chunk;", "sendChunkDataPacket", "protocolManager", "Lcom/comphenix/protocol/ProtocolManager;", "player", "Lorg/bukkit/entity/Player;", "chunkCoord", "Lcom/comphenix/protocol/wrappers/ChunkCoordIntPair;", "setCustomBiome", "biome", "Lcom/mochibit/defcon/biomes/CustomBiome;", "Defcon"})
    @SourceDebugExtension(value={"SMAP\nCustomBiomeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomBiomeHandler.kt\ncom/mochibit/defcon/biomes/CustomBiomeHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1855#2,2:92\n*S KotlinDebug\n*F\n+ 1 CustomBiomeHandler.kt\ncom/mochibit/defcon/biomes/CustomBiomeHandler$Companion\n*L\n66#1:92,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void setCustomBiome(@NotNull Chunk chunk, @NotNull CustomBiome biome) {
            Intrinsics.checkNotNullParameter(chunk, "chunk");
            Intrinsics.checkNotNullParameter(biome, "biome");
            ScheduledRunnable syncRunnable = new ScheduledRunnable().maxMillisPerTick(2.5);
            BukkitTask bukkitTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Defcon.Companion.getInstance(), (Runnable)syncRunnable, 0L, 20L);
            Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimerAsynchronously(...)");
            BukkitTask task = bukkitTask;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Defcon.Companion.getInstance(), () -> Companion.setCustomBiome$lambda$1(chunk, biome, syncRunnable));
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Defcon.Companion.getInstance(), () -> Companion.setCustomBiome$lambda$2(task), 2400L);
        }

        private final void refreshChunkAsync(Chunk chunk) {
            Collection collection = Bukkit.getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
            Collection players = collection;
            ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
            ChunkCoordIntPair chunkCoord = new ChunkCoordIntPair(chunk.getX(), chunk.getZ());
            Iterable $this$forEach$iv = players;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player = (Player)element$iv;
                boolean bl = false;
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)Defcon.Companion.getInstance(), () -> Companion.refreshChunkAsync$lambda$4$lambda$3(protocolManager, player, chunkCoord));
            }
        }

        private final void sendChunkDataPacket(ProtocolManager protocolManager, Player player, ChunkCoordIntPair chunkCoord) {
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.MAP_CHUNK);
            packet.getIntegers().write(0, (Object)chunkCoord.getChunkX());
            packet.getIntegers().write(1, (Object)chunkCoord.getChunkZ());
            try {
                protocolManager.sendServerPacket(player, packet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private static final void setCustomBiome$lambda$1$lambda$0(int $maxHeight, Chunk $chunk, int $x, int $z, NamespacedKey $key, NamespacedKey it) {
            Intrinsics.checkNotNullParameter($chunk, "$chunk");
            Intrinsics.checkNotNullParameter($key, "$key");
            Intrinsics.checkNotNullParameter(it, "it");
            for (int offsetX = 0; offsetX < 4; ++offsetX) {
                for (int offsetZ = 0; offsetZ < 4; ++offsetZ) {
                    for (int y = 55; y < $maxHeight; ++y) {
                        UNSAFE.setBiomeKey((RegionAccessor)$chunk.getWorld(), $x + offsetX, y, $z + offsetZ, $key);
                    }
                }
            }
        }

        private static final void setCustomBiome$lambda$1(Chunk $chunk, CustomBiome $biome, ScheduledRunnable $syncRunnable) {
            Intrinsics.checkNotNullParameter($chunk, "$chunk");
            Intrinsics.checkNotNullParameter($biome, "$biome");
            Intrinsics.checkNotNullParameter($syncRunnable, "$syncRunnable");
            int minX = $chunk.getX() << 4;
            int maxX = minX + 16;
            int minZ = $chunk.getZ() << 4;
            int maxZ = minZ + 16;
            NamespacedKey key = $biome.getBiomeKey();
            int maxHeight = $chunk.getWorld().getMaxHeight();
            IntProgression intProgression = RangesKt.step(RangesKt.until(minX, maxX), 4);
            int x = intProgression.getFirst();
            int n = intProgression.getLast();
            int n2 = intProgression.getStep();
            if (n2 > 0 && x <= n || n2 < 0 && n <= x) {
                while (true) {
                    IntProgression intProgression2 = RangesKt.step(RangesKt.until(minZ, maxZ), 4);
                    int z = intProgression2.getFirst();
                    int n3 = intProgression2.getLast();
                    int n4 = intProgression2.getStep();
                    if (n4 > 0 && z <= n3 || n4 < 0 && n3 <= z) {
                        while (true) {
                            $syncRunnable.addWorkload(new SimpleCompositionJob<NamespacedKey>(key, arg_0 -> Companion.setCustomBiome$lambda$1$lambda$0(maxHeight, $chunk, x, z, key, arg_0)));
                            if (z == n3) break;
                            z += n4;
                        }
                    }
                    if (x == n) break;
                    x += n2;
                }
            }
            if ($chunk.isLoaded()) {
                Companion.refreshChunkAsync($chunk);
            }
        }

        private static final void setCustomBiome$lambda$2(BukkitTask $task) {
            Intrinsics.checkNotNullParameter($task, "$task");
            $task.cancel();
        }

        private static final void refreshChunkAsync$lambda$4$lambda$3(ProtocolManager $protocolManager, Player $player, ChunkCoordIntPair $chunkCoord) {
            Intrinsics.checkNotNullParameter($chunkCoord, "$chunkCoord");
            Intrinsics.checkNotNull($protocolManager);
            Intrinsics.checkNotNull($player);
            Companion.sendChunkDataPacket($protocolManager, $player, $chunkCoord);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

