/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.biomes;

import com.mochibit.defcon.biomes.CustomBiome;
import com.mochibit.defcon.biomes.data.BiomeCarver;
import com.mochibit.defcon.biomes.data.BiomeEffects;
import com.mochibit.defcon.biomes.data.BiomeFeature;
import com.mochibit.defcon.biomes.data.BiomeSpawnCost;
import com.mochibit.defcon.biomes.data.BiomeSpawner;
import com.mochibit.defcon.biomes.enums.PrecipitationType;
import com.mochibit.defcon.biomes.enums.TemperatureModifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u001bJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/mochibit/defcon/biomes/CustomBiomeBuilder;", "", "()V", "biome", "Lcom/mochibit/defcon/biomes/CustomBiome;", "addAmbientSpawner", "spawner", "Lcom/mochibit/defcon/biomes/data/BiomeSpawner;", "addAxolotlSpawner", "addCarver", "carver", "Lcom/mochibit/defcon/biomes/data/BiomeCarver;", "addCreatureSpawner", "addFeature", "feature", "Lcom/mochibit/defcon/biomes/data/BiomeFeature;", "addMiscSpawner", "addMonsterSpawner", "addSpawnCost", "spawnCost", "Lcom/mochibit/defcon/biomes/data/BiomeSpawnCost;", "addUndergroundWaterCreatureSpawner", "addWaterAmbientSpawner", "addWaterCreatureSpawner", "build", "setDownfall", "downfall", "", "setEffects", "effects", "Lcom/mochibit/defcon/biomes/data/BiomeEffects;", "setHasPrecipitation", "hasPrecipitation", "", "setPrecipitation", "precipitation", "Lcom/mochibit/defcon/biomes/enums/PrecipitationType;", "setTemperature", "temperature", "setTemperatureModifier", "temperatureModifier", "Lcom/mochibit/defcon/biomes/enums/TemperatureModifier;", "Defcon"})
public final class CustomBiomeBuilder {
    @NotNull
    private CustomBiome biome = new CustomBiome();

    @NotNull
    public final CustomBiome build() {
        return this.biome;
    }

    @NotNull
    public final CustomBiomeBuilder setTemperature(float temperature) {
        this.biome.setTemperature(temperature);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder setDownfall(float downfall) {
        this.biome.setDownfall(downfall);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder setPrecipitation(@NotNull PrecipitationType precipitation) {
        Intrinsics.checkNotNullParameter((Object)precipitation, "precipitation");
        this.biome.setPrecipitation(precipitation);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder setTemperatureModifier(@NotNull TemperatureModifier temperatureModifier) {
        Intrinsics.checkNotNullParameter((Object)temperatureModifier, "temperatureModifier");
        this.biome.setTemperatureModifier(temperatureModifier);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder setHasPrecipitation(boolean hasPrecipitation) {
        this.biome.setHasPrecipitation(hasPrecipitation);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder setEffects(@NotNull BiomeEffects effects) {
        Intrinsics.checkNotNullParameter(effects, "effects");
        this.biome.setEffects(effects);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder addMonsterSpawner(@NotNull BiomeSpawner spawner) {
        Intrinsics.checkNotNullParameter(spawner, "spawner");
        this.biome.getMonsterSpawners().add(spawner);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder addCreatureSpawner(@NotNull BiomeSpawner spawner) {
        Intrinsics.checkNotNullParameter(spawner, "spawner");
        this.biome.getCreatureSpawners().add(spawner);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder addAmbientSpawner(@NotNull BiomeSpawner spawner) {
        Intrinsics.checkNotNullParameter(spawner, "spawner");
        this.biome.getAmbientSpawners().add(spawner);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder addAxolotlSpawner(@NotNull BiomeSpawner spawner) {
        Intrinsics.checkNotNullParameter(spawner, "spawner");
        this.biome.getAxolotlSpawners().add(spawner);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder addUndergroundWaterCreatureSpawner(@NotNull BiomeSpawner spawner) {
        Intrinsics.checkNotNullParameter(spawner, "spawner");
        this.biome.getUndergroundWaterCreatureSpawners().add(spawner);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder addWaterCreatureSpawner(@NotNull BiomeSpawner spawner) {
        Intrinsics.checkNotNullParameter(spawner, "spawner");
        this.biome.getWaterCreatureSpawners().add(spawner);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder addWaterAmbientSpawner(@NotNull BiomeSpawner spawner) {
        Intrinsics.checkNotNullParameter(spawner, "spawner");
        this.biome.getWaterAmbientSpawners().add(spawner);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder addMiscSpawner(@NotNull BiomeSpawner spawner) {
        Intrinsics.checkNotNullParameter(spawner, "spawner");
        this.biome.getMiscSpawners().add(spawner);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder addSpawnCost(@NotNull BiomeSpawnCost spawnCost) {
        Intrinsics.checkNotNullParameter(spawnCost, "spawnCost");
        this.biome.getSpawnCosts().add(spawnCost);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder addFeature(@NotNull BiomeFeature feature) {
        Intrinsics.checkNotNullParameter(feature, "feature");
        this.biome.getFeatures().add(feature);
        return this;
    }

    @NotNull
    public final CustomBiomeBuilder addCarver(@NotNull BiomeCarver carver) {
        Intrinsics.checkNotNullParameter(carver, "carver");
        this.biome.getCarvers().add(carver);
        return this;
    }
}

