/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.biomes;

import com.mochibit.defcon.biomes.data.BiomeCarver;
import com.mochibit.defcon.biomes.data.BiomeEffects;
import com.mochibit.defcon.biomes.data.BiomeFeature;
import com.mochibit.defcon.biomes.data.BiomeInfo;
import com.mochibit.defcon.biomes.data.BiomeMoodSound;
import com.mochibit.defcon.biomes.data.BiomeSpawnCost;
import com.mochibit.defcon.biomes.data.BiomeSpawner;
import com.mochibit.defcon.biomes.enums.PrecipitationType;
import com.mochibit.defcon.biomes.enums.TemperatureModifier;
import com.mochibit.defcon.utils.MetaManager;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010Q\u001a\u00020\u0000H\u0016R*\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR*\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R*\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0004j\b\u0012\u0004\u0012\u00020\u0013`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\b\"\u0004\b\u0015\u0010\nR*\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\b\"\u0004\b\u0018\u0010\nR\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R*\u0010%\u001a\u0012\u0012\u0004\u0012\u00020&0\u0004j\b\u0012\u0004\u0012\u00020&`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\b\"\u0004\b(\u0010\nR\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R*\u0010/\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\b\"\u0004\b1\u0010\nR*\u00102\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\b\"\u0004\b4\u0010\nR\u001a\u00105\u001a\u000206X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R*\u0010;\u001a\u0012\u0012\u0004\u0012\u00020<0\u0004j\b\u0012\u0004\u0012\u00020<`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\b\"\u0004\b>\u0010\nR\u001a\u0010?\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u001c\"\u0004\bA\u0010\u001eR\u001a\u0010B\u001a\u00020CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR*\u0010H\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010\b\"\u0004\bJ\u0010\nR*\u0010K\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010\b\"\u0004\bM\u0010\nR*\u0010N\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010\b\"\u0004\bP\u0010\n\u00a8\u0006R"}, d2={"Lcom/mochibit/defcon/biomes/CustomBiome;", "", "()V", "ambientSpawners", "Ljava/util/HashSet;", "Lcom/mochibit/defcon/biomes/data/BiomeSpawner;", "Lkotlin/collections/HashSet;", "getAmbientSpawners", "()Ljava/util/HashSet;", "setAmbientSpawners", "(Ljava/util/HashSet;)V", "axolotlSpawners", "getAxolotlSpawners", "setAxolotlSpawners", "biomeKey", "Lorg/bukkit/NamespacedKey;", "getBiomeKey", "()Lorg/bukkit/NamespacedKey;", "carvers", "Lcom/mochibit/defcon/biomes/data/BiomeCarver;", "getCarvers", "setCarvers", "creatureSpawners", "getCreatureSpawners", "setCreatureSpawners", "downfall", "", "getDownfall", "()F", "setDownfall", "(F)V", "effects", "Lcom/mochibit/defcon/biomes/data/BiomeEffects;", "getEffects", "()Lcom/mochibit/defcon/biomes/data/BiomeEffects;", "setEffects", "(Lcom/mochibit/defcon/biomes/data/BiomeEffects;)V", "features", "Lcom/mochibit/defcon/biomes/data/BiomeFeature;", "getFeatures", "setFeatures", "hasPrecipitation", "", "getHasPrecipitation", "()Z", "setHasPrecipitation", "(Z)V", "miscSpawners", "getMiscSpawners", "setMiscSpawners", "monsterSpawners", "getMonsterSpawners", "setMonsterSpawners", "precipitation", "Lcom/mochibit/defcon/biomes/enums/PrecipitationType;", "getPrecipitation", "()Lcom/mochibit/defcon/biomes/enums/PrecipitationType;", "setPrecipitation", "(Lcom/mochibit/defcon/biomes/enums/PrecipitationType;)V", "spawnCosts", "Lcom/mochibit/defcon/biomes/data/BiomeSpawnCost;", "getSpawnCosts", "setSpawnCosts", "temperature", "getTemperature", "setTemperature", "temperatureModifier", "Lcom/mochibit/defcon/biomes/enums/TemperatureModifier;", "getTemperatureModifier", "()Lcom/mochibit/defcon/biomes/enums/TemperatureModifier;", "setTemperatureModifier", "(Lcom/mochibit/defcon/biomes/enums/TemperatureModifier;)V", "undergroundWaterCreatureSpawners", "getUndergroundWaterCreatureSpawners", "setUndergroundWaterCreatureSpawners", "waterAmbientSpawners", "getWaterAmbientSpawners", "setWaterAmbientSpawners", "waterCreatureSpawners", "getWaterCreatureSpawners", "setWaterCreatureSpawners", "build", "Defcon"})
public class CustomBiome {
    @NotNull
    private final NamespacedKey biomeKey;
    private float temperature;
    private float downfall;
    @NotNull
    private PrecipitationType precipitation;
    @NotNull
    private TemperatureModifier temperatureModifier;
    private boolean hasPrecipitation;
    @NotNull
    private BiomeEffects effects;
    @NotNull
    private HashSet<BiomeSpawner> monsterSpawners;
    @NotNull
    private HashSet<BiomeSpawner> creatureSpawners;
    @NotNull
    private HashSet<BiomeSpawner> ambientSpawners;
    @NotNull
    private HashSet<BiomeSpawner> axolotlSpawners;
    @NotNull
    private HashSet<BiomeSpawner> undergroundWaterCreatureSpawners;
    @NotNull
    private HashSet<BiomeSpawner> waterCreatureSpawners;
    @NotNull
    private HashSet<BiomeSpawner> waterAmbientSpawners;
    @NotNull
    private HashSet<BiomeSpawner> miscSpawners;
    @NotNull
    private HashSet<BiomeSpawnCost> spawnCosts;
    @NotNull
    private HashSet<BiomeFeature> features;
    @NotNull
    private HashSet<BiomeCarver> carvers;

    public CustomBiome() {
        Object object = this.getClass().getAnnotation(BiomeInfo.class);
        if (object == null || (object = object.key()) == null) {
            object = "minecraft:forest";
        }
        this.biomeKey = MetaManager.INSTANCE.convertStringToNamespacedKey((String)object);
        this.temperature = 0.7f;
        this.downfall = 0.8f;
        this.precipitation = PrecipitationType.RAIN;
        this.temperatureModifier = TemperatureModifier.NONE;
        this.hasPrecipitation = true;
        this.effects = new BiomeEffects(7972607, 12638463, 4159204, 329011, null, null, null, null, new BiomeMoodSound("minecraft:ambient.cave", 6000, 8, 2.0f), null, null, null, 3824, null);
        this.monsterSpawners = new HashSet();
        this.creatureSpawners = new HashSet();
        this.ambientSpawners = new HashSet();
        this.axolotlSpawners = new HashSet();
        this.undergroundWaterCreatureSpawners = new HashSet();
        this.waterCreatureSpawners = new HashSet();
        this.waterAmbientSpawners = new HashSet();
        this.miscSpawners = new HashSet();
        this.spawnCosts = new HashSet();
        this.features = new HashSet();
        this.carvers = new HashSet();
    }

    @NotNull
    public final NamespacedKey getBiomeKey() {
        return this.biomeKey;
    }

    public final float getTemperature() {
        return this.temperature;
    }

    public final void setTemperature(float f) {
        this.temperature = f;
    }

    public final float getDownfall() {
        return this.downfall;
    }

    public final void setDownfall(float f) {
        this.downfall = f;
    }

    @NotNull
    public final PrecipitationType getPrecipitation() {
        return this.precipitation;
    }

    public final void setPrecipitation(@NotNull PrecipitationType precipitationType) {
        Intrinsics.checkNotNullParameter((Object)precipitationType, "<set-?>");
        this.precipitation = precipitationType;
    }

    @NotNull
    public final TemperatureModifier getTemperatureModifier() {
        return this.temperatureModifier;
    }

    public final void setTemperatureModifier(@NotNull TemperatureModifier temperatureModifier) {
        Intrinsics.checkNotNullParameter((Object)temperatureModifier, "<set-?>");
        this.temperatureModifier = temperatureModifier;
    }

    public final boolean getHasPrecipitation() {
        return this.hasPrecipitation;
    }

    public final void setHasPrecipitation(boolean bl) {
        this.hasPrecipitation = bl;
    }

    @NotNull
    public final BiomeEffects getEffects() {
        return this.effects;
    }

    public final void setEffects(@NotNull BiomeEffects biomeEffects) {
        Intrinsics.checkNotNullParameter(biomeEffects, "<set-?>");
        this.effects = biomeEffects;
    }

    @NotNull
    public final HashSet<BiomeSpawner> getMonsterSpawners() {
        return this.monsterSpawners;
    }

    public final void setMonsterSpawners(@NotNull HashSet<BiomeSpawner> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.monsterSpawners = hashSet;
    }

    @NotNull
    public final HashSet<BiomeSpawner> getCreatureSpawners() {
        return this.creatureSpawners;
    }

    public final void setCreatureSpawners(@NotNull HashSet<BiomeSpawner> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.creatureSpawners = hashSet;
    }

    @NotNull
    public final HashSet<BiomeSpawner> getAmbientSpawners() {
        return this.ambientSpawners;
    }

    public final void setAmbientSpawners(@NotNull HashSet<BiomeSpawner> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.ambientSpawners = hashSet;
    }

    @NotNull
    public final HashSet<BiomeSpawner> getAxolotlSpawners() {
        return this.axolotlSpawners;
    }

    public final void setAxolotlSpawners(@NotNull HashSet<BiomeSpawner> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.axolotlSpawners = hashSet;
    }

    @NotNull
    public final HashSet<BiomeSpawner> getUndergroundWaterCreatureSpawners() {
        return this.undergroundWaterCreatureSpawners;
    }

    public final void setUndergroundWaterCreatureSpawners(@NotNull HashSet<BiomeSpawner> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.undergroundWaterCreatureSpawners = hashSet;
    }

    @NotNull
    public final HashSet<BiomeSpawner> getWaterCreatureSpawners() {
        return this.waterCreatureSpawners;
    }

    public final void setWaterCreatureSpawners(@NotNull HashSet<BiomeSpawner> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.waterCreatureSpawners = hashSet;
    }

    @NotNull
    public final HashSet<BiomeSpawner> getWaterAmbientSpawners() {
        return this.waterAmbientSpawners;
    }

    public final void setWaterAmbientSpawners(@NotNull HashSet<BiomeSpawner> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.waterAmbientSpawners = hashSet;
    }

    @NotNull
    public final HashSet<BiomeSpawner> getMiscSpawners() {
        return this.miscSpawners;
    }

    public final void setMiscSpawners(@NotNull HashSet<BiomeSpawner> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.miscSpawners = hashSet;
    }

    @NotNull
    public final HashSet<BiomeSpawnCost> getSpawnCosts() {
        return this.spawnCosts;
    }

    public final void setSpawnCosts(@NotNull HashSet<BiomeSpawnCost> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.spawnCosts = hashSet;
    }

    @NotNull
    public final HashSet<BiomeFeature> getFeatures() {
        return this.features;
    }

    public final void setFeatures(@NotNull HashSet<BiomeFeature> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.features = hashSet;
    }

    @NotNull
    public final HashSet<BiomeCarver> getCarvers() {
        return this.carvers;
    }

    public final void setCarvers(@NotNull HashSet<BiomeCarver> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.carvers = hashSet;
    }

    @NotNull
    public CustomBiome build() {
        return this;
    }
}

