/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon;

import com.mochibit.defcon.api.paperlib.PaperLib;
import com.mochibit.defcon.events.customitems.GeigerDetectEvent;
import com.mochibit.defcon.events.radiationarea.RadiationSuffocationEvent;
import com.mochibit.defcon.extensions.PlayerKt;
import com.mochibit.defcon.radiation.RadiationArea;
import com.mochibit.defcon.registers.BlockRegister;
import com.mochibit.defcon.registers.CommandRegister;
import com.mochibit.defcon.registers.DatapackRegister;
import com.mochibit.defcon.registers.EventRegister;
import com.mochibit.defcon.registers.ItemRegister;
import com.mochibit.defcon.registers.ResourcePackRegister;
import com.mochibit.defcon.registers.StructureRegister;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/mochibit/defcon/Defcon;", "Lorg/bukkit/plugin/java/JavaPlugin;", "()V", "onDisable", "", "onEnable", "onLoad", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nDefcon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Defcon.kt\ncom/mochibit/defcon/Defcon\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
public final class Defcon
extends JavaPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static Defcon instance;
    @NotNull
    private static String namespace;

    public void onLoad() {
        Companion.setInstance(this);
        DatapackRegister.Companion.getGet().registerPack();
    }

    public void onEnable() {
        PaperLib.suggestPaper((Plugin)this);
        this.getLogger().info("[Defcon] has been enabled!");
        Companion.Logger.INSTANCE.info("Registering resource pack");
        ResourcePackRegister.Companion.getGet().registerPack();
        new EventRegister().registerEvents();
        if (!new ItemRegister().registerItems()) {
            this.getLogger().warning("[Defcon] Some items were not registered!");
        }
        new BlockRegister().registerBlocks();
        new CommandRegister().registerCommands();
        new StructureRegister().registerStructures();
        Bukkit.getScheduler().runTaskTimer((Plugin)this, Defcon::onEnable$lambda$1, 0L, 20L);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, Defcon::onEnable$lambda$2, 0L, 20L);
    }

    public void onDisable() {
        this.getLogger().info("[Defcon] has been disabled!");
    }

    /*
     * WARNING - void declaration
     */
    private static final void onEnable$lambda$1() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) continue;
            Location location = player.getLocation().add(0.0, 1.0, 0.0);
            Intrinsics.checkNotNullExpressionValue(location, "add(...)");
            HashSet<RadiationArea> radiationAreas = RadiationArea.Companion.getAtLocation(location);
            if (radiationAreas.isEmpty()) continue;
            Iterable iterable = radiationAreas;
            double d = 0.0;
            for (Object t : iterable) {
                void it;
                RadiationArea radiationArea = (RadiationArea)t;
                double d2 = d;
                boolean bl = false;
                double d3 = it.getRadiationLevel();
                d = d2 + d3;
            }
            double totalRadiation = d / (double)radiationAreas.size();
            if (totalRadiation == 0.0) continue;
            Intrinsics.checkNotNull(player);
            GeigerDetectEvent geigerDetectEvent = new GeigerDetectEvent((HumanEntity)player, totalRadiation);
            Bukkit.getPluginManager().callEvent((Event)geigerDetectEvent);
            for (RadiationArea radiationArea : radiationAreas) {
                if (radiationArea.getRadiationLevel() < 3.0) continue;
                Intrinsics.checkNotNull(radiationArea);
                RadiationSuffocationEvent radSuffocateEvent = new RadiationSuffocationEvent(player, radiationArea);
                Bukkit.getPluginManager().callEvent((Event)radSuffocateEvent);
                if (radSuffocateEvent.isCancelled()) continue;
                player.damage(1.0);
            }
            PlayerKt.increaseRadiationLevel(player, totalRadiation / (double)20);
        }
    }

    private static final void onEnable$lambda$2() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Intrinsics.checkNotNull(player);
            double radLevel = PlayerKt.getRadiationLevel(player);
            if (radLevel <= 0.0) continue;
            AttributeInstance attributeInstance = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (attributeInstance != null) {
                attributeInstance.setBaseValue(20.0 - RangesKt.coerceAtMost(radLevel, 20.0));
            }
            if (radLevel > 5.0) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 100, 1));
            }
            if (radLevel > 10.0) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 100, 1));
            }
            if (!(radLevel > 15.0)) continue;
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 100, 1));
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, 100, 1));
        }
    }

    static {
        namespace = "defcon";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/mochibit/defcon/Defcon$Companion;", "", "()V", "instance", "Lcom/mochibit/defcon/Defcon;", "getInstance", "()Lcom/mochibit/defcon/Defcon;", "setInstance", "(Lcom/mochibit/defcon/Defcon;)V", "namespace", "", "getNamespace", "()Ljava/lang/String;", "setNamespace", "(Ljava/lang/String;)V", "Logger", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Defcon getInstance() {
            Defcon defcon = instance;
            if (defcon != null) {
                return defcon;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        public final void setInstance(@NotNull Defcon defcon) {
            Intrinsics.checkNotNullParameter((Object)defcon, "<set-?>");
            instance = defcon;
        }

        @NotNull
        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            namespace = string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lcom/mochibit/defcon/Defcon$Companion$Logger;", "", "()V", "info", "", "message", "", "severe", "warning", "Defcon"})
        public static final class Logger {
            @NotNull
            public static final Logger INSTANCE = new Logger();

            private Logger() {
            }

            public final void info(@NotNull String message) {
                Intrinsics.checkNotNullParameter(message, "message");
                Companion.getInstance().getLogger().info(message);
            }

            public final void warning(@NotNull String message) {
                Intrinsics.checkNotNullParameter(message, "message");
                Companion.getInstance().getLogger().warning(message);
            }

            public final void severe(@NotNull String message) {
                Intrinsics.checkNotNullParameter(message, "message");
                Companion.getInstance().getLogger().severe(message);
            }
        }
    }
}

