/*
 * Decompiled with CFR 0.152.
 */
package dev.mja00.villagerLobotomizer.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public class CommentPreservingYamlMigrator {
    private final Logger logger;
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^(\\s*)#(.*)$");

    public CommentPreservingYamlMigrator(Logger logger) {
        this.logger = logger;
    }

    public String mergeWithComments(String existingYaml, String defaultYaml) throws IOException {
        try {
            this.logger.fine("Starting comment-preserving YAML merge");
            CommentedYamlData existingData = this.parseWithComments(existingYaml);
            CommentedYamlData defaultData = this.parseWithComments(defaultYaml);
            this.logger.fine("Extracted " + existingData.comments.size() + " comments from existing config");
            this.logger.fine("Extracted " + defaultData.comments.size() + " comments from default config");
            Yaml yaml = new Yaml();
            LinkedHashMap<String, Object> existingMap = (LinkedHashMap<String, Object>)yaml.load(existingYaml);
            LinkedHashMap<String, Object> defaultMap = (LinkedHashMap<String, Object>)yaml.load(defaultYaml);
            if (existingMap == null) {
                existingMap = new LinkedHashMap<String, Object>();
            }
            if (defaultMap == null) {
                defaultMap = new LinkedHashMap<String, Object>();
            }
            LinkedHashMap<String, Object> mergedMap = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, String> mergedComments = new LinkedHashMap<String, String>();
            this.mergeRecursive("", existingMap, defaultMap, mergedMap, existingData.comments, defaultData.comments, mergedComments);
            this.logger.fine("Merged configuration has " + mergedComments.size() + " comments");
            return this.generateYamlWithComments(mergedMap, mergedComments, defaultData.headerComments);
        }
        catch (Exception e) {
            this.logger.severe("Error during comment-preserving merge:");
            this.logger.severe("  Error: " + e.getMessage());
            this.logger.severe("  Existing YAML length: " + existingYaml.length());
            this.logger.severe("  Default YAML length: " + defaultYaml.length());
            throw new IOException("Comment-preserving merge failed", e);
        }
    }

    private void mergeRecursive(String path, Map<String, Object> existing, Map<String, Object> defaults, Map<String, Object> merged, Map<String, String> existingComments, Map<String, String> defaultComments, Map<String, String> mergedComments) {
        String keyPath;
        for (String key : defaults.keySet()) {
            String comment;
            keyPath = path.isEmpty() ? key : path + "." + key;
            Object defaultValue = defaults.get(key);
            Object existingValue = existing.get(key);
            if (defaultValue instanceof Map && existingValue instanceof Map) {
                LinkedHashMap<String, Object> nestedMerged = new LinkedHashMap<String, Object>();
                merged.put(key, nestedMerged);
                this.mergeRecursive(keyPath, (Map)existingValue, (Map)defaultValue, nestedMerged, existingComments, defaultComments, mergedComments);
                String comment2 = existingComments.get(keyPath);
                if (comment2 == null && (comment2 = defaultComments.get(keyPath)) != null) {
                    this.logger.info("Added comment for new section: " + keyPath);
                }
                if (comment2 == null) continue;
                mergedComments.put(keyPath, comment2);
                continue;
            }
            if (existingValue != null) {
                merged.put(key, existingValue);
                comment = existingComments.get(keyPath);
                if (comment == null) continue;
                mergedComments.put(keyPath, comment);
                continue;
            }
            merged.put(key, defaultValue);
            comment = defaultComments.get(keyPath);
            if (comment != null) {
                mergedComments.put(keyPath, comment);
                this.logger.info("Added new config option with comment: " + keyPath + " = " + String.valueOf(defaultValue));
                continue;
            }
            this.logger.info("Added new config option: " + keyPath + " = " + String.valueOf(defaultValue));
        }
        for (String key : existing.keySet()) {
            if (defaults.containsKey(key)) continue;
            keyPath = path.isEmpty() ? key : path + "." + key;
            merged.put(key, existing.get(key));
            String comment = existingComments.get(keyPath);
            if (comment != null) {
                mergedComments.put(keyPath, comment);
            }
            this.logger.info("Preserved obsolete config option: " + keyPath + " (consider removing)");
        }
    }

    private CommentedYamlData parseWithComments(String yamlContent) {
        LinkedHashMap<String, String> comments = new LinkedHashMap<String, String>();
        ArrayList<String> headerComments = new ArrayList<String>();
        String[] lines = yamlContent.split("\\n");
        ArrayList<String> pendingComments = new ArrayList<String>();
        boolean foundFirstKey = false;
        for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
            String line = lines[lineIndex];
            Matcher commentMatcher = COMMENT_PATTERN.matcher(line);
            if (commentMatcher.matches()) {
                String comment = commentMatcher.group(2).trim();
                if (!foundFirstKey) {
                    headerComments.add(comment);
                    continue;
                }
                pendingComments.add(comment);
                continue;
            }
            if (line.trim().contains(":") && !line.trim().startsWith("#") && !line.trim().startsWith("-")) {
                foundFirstKey = true;
                if (pendingComments.isEmpty()) continue;
                String keyPath = this.extractKeyPath(lines, lineIndex);
                if (keyPath == null || keyPath.isEmpty()) {
                    keyPath = this.extractKey(line);
                }
                String combinedComment = String.join((CharSequence)" ", pendingComments);
                if (keyPath != null && !keyPath.isEmpty()) {
                    comments.put(keyPath, combinedComment);
                }
                pendingComments.clear();
                continue;
            }
            if (line.trim().isEmpty() || !foundFirstKey || line.trim().startsWith("-")) continue;
            pendingComments.clear();
        }
        return new CommentedYamlData(comments, headerComments);
    }

    private String findCommentTarget(String[] lines, int commentIndex) {
        for (int i = commentIndex + 1; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.startsWith("#") || !line.contains(":") || line.startsWith("-")) continue;
            return this.extractKeyPath(lines, i);
        }
        return null;
    }

    private String extractKeyPath(String[] lines, int lineIndex) {
        Stack<String> pathStack = new Stack<String>();
        Stack<Integer> indentStack = new Stack<Integer>();
        for (int i = 0; i <= lineIndex; ++i) {
            String line = lines[i];
            if (!line.trim().contains(":") || line.trim().startsWith("#")) continue;
            this.updatePath(line, pathStack, indentStack);
        }
        return pathStack.isEmpty() ? "" : String.join((CharSequence)".", pathStack);
    }

    private void updatePath(String line, Stack<String> pathStack, Stack<Integer> indentStack) {
        int indent = this.getIndentLevel(line);
        String key = this.extractKey(line);
        if (key == null) {
            return;
        }
        while (!indentStack.isEmpty() && indentStack.peek() >= indent) {
            indentStack.pop();
            if (pathStack.isEmpty()) continue;
            pathStack.pop();
        }
        pathStack.push(key);
        indentStack.push(indent);
    }

    private int getIndentLevel(String line) {
        int indent = 0;
        for (char c : line.toCharArray()) {
            if (c == ' ') {
                ++indent;
                continue;
            }
            if (c != '\t') break;
            indent += 4;
        }
        return indent;
    }

    private String extractKey(String line) {
        String trimmed = line.trim();
        if (trimmed.contains(":")) {
            String key = trimmed.split(":")[0].trim();
            if (key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            } else if (key.startsWith("'") && key.endsWith("'")) {
                key = key.substring(1, key.length() - 1);
            }
            return key;
        }
        return null;
    }

    private String generateYamlWithComments(Map<String, Object> data, Map<String, String> comments, List<String> headerComments) {
        StringBuilder result = new StringBuilder();
        for (String comment : headerComments) {
            result.append("#").append(comment).append("\n");
        }
        if (!headerComments.isEmpty()) {
            result.append("\n");
        }
        this.generateYamlSection(data, comments, result, "", 0);
        return result.toString();
    }

    private void generateYamlSection(Map<String, Object> data, Map<String, String> comments, StringBuilder result, String pathPrefix, int indentLevel) {
        String indent = "  ".repeat(indentLevel);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Object keyPath = pathPrefix.isEmpty() ? key : pathPrefix + "." + key;
            String comment = comments.get(keyPath);
            if (comment != null && !comment.isEmpty()) {
                result.append(indent).append("#").append(comment).append("\n");
            }
            if (value instanceof Map) {
                result.append(indent).append(key).append(":\n");
                this.generateYamlSection((Map)value, comments, result, (String)keyPath, indentLevel + 1);
                continue;
            }
            if (value instanceof List) {
                List list = (List)value;
                result.append(indent).append(key).append(":\n");
                for (Object item : list) {
                    result.append(indent).append("  - ").append(this.formatValue(item)).append("\n");
                }
                continue;
            }
            result.append(indent).append(key).append(": ").append(this.formatValue(value)).append("\n");
        }
    }

    private String formatValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.contains(":") || str.contains("#") || str.contains("\"") || str.trim().isEmpty()) {
                return "\"" + str.replace("\"", "\\\"") + "\"";
            }
            return str;
        }
        return value.toString();
    }

    private record CommentedYamlData(Map<String, String> comments, List<String> headerComments) {
    }
}

