/*
 * Decompiled with CFR 0.152.
 */
package dev.mja00.villagerLobotomizer.sentry;

import dev.mja00.villagerLobotomizer.sentry.EventProcessor;
import dev.mja00.villagerLobotomizer.sentry.Hint;
import dev.mja00.villagerLobotomizer.sentry.SentryEvent;
import dev.mja00.villagerLobotomizer.sentry.SentryLevel;
import dev.mja00.villagerLobotomizer.sentry.SentryOptions;
import dev.mja00.villagerLobotomizer.sentry.util.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DuplicateEventDetectionEventProcessor
implements EventProcessor {
    @NotNull
    private final Map<Throwable, Object> capturedObjects = Collections.synchronizedMap(new WeakHashMap());
    @NotNull
    private final SentryOptions options;

    public DuplicateEventDetectionEventProcessor(@NotNull SentryOptions options) {
        this.options = Objects.requireNonNull(options, "options are required");
    }

    @Override
    @Nullable
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        if (this.options.isEnableDeduplication()) {
            Throwable throwable = event.getThrowable();
            if (throwable != null) {
                if (this.capturedObjects.containsKey(throwable) || DuplicateEventDetectionEventProcessor.containsAnyKey(this.capturedObjects, DuplicateEventDetectionEventProcessor.allCauses(throwable))) {
                    this.options.getLogger().log(SentryLevel.DEBUG, "Duplicate Exception detected. Event %s will be discarded.", event.getEventId());
                    return null;
                }
                this.capturedObjects.put(throwable, null);
            }
        } else {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event deduplication is disabled.", new Object[0]);
        }
        return event;
    }

    private static <T> boolean containsAnyKey(@NotNull Map<T, Object> map, @NotNull List<T> list) {
        for (T entry : list) {
            if (!map.containsKey(entry)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<Throwable> allCauses(@NotNull Throwable throwable) {
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        Throwable ex = throwable;
        while (ex.getCause() != null) {
            causes.add(ex.getCause());
            ex = ex.getCause();
        }
        return causes;
    }

    @Override
    @Nullable
    public Long getOrder() {
        return 1000L;
    }
}

