/*
 * Decompiled with CFR 0.152.
 */
package dev.mja00.villagerLobotomizer.sentry.util.thread;

import dev.mja00.villagerLobotomizer.sentry.protocol.SentryThread;
import dev.mja00.villagerLobotomizer.sentry.util.thread.IThreadChecker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ThreadChecker
implements IThreadChecker {
    private static final long mainThreadId = Thread.currentThread().getId();
    private static final ThreadChecker instance = new ThreadChecker();

    public static ThreadChecker getInstance() {
        return instance;
    }

    private ThreadChecker() {
    }

    @Override
    public boolean isMainThread(long threadId) {
        return mainThreadId == threadId;
    }

    @Override
    public boolean isMainThread(@NotNull Thread thread) {
        return this.isMainThread(thread.getId());
    }

    @Override
    public boolean isMainThread() {
        return this.isMainThread(Thread.currentThread());
    }

    @Override
    public boolean isMainThread(@NotNull SentryThread sentryThread) {
        Long threadId = sentryThread.getId();
        return threadId != null && this.isMainThread(threadId);
    }

    @Override
    @NotNull
    public String getCurrentThreadName() {
        return Thread.currentThread().getName();
    }

    @Override
    public long currentThreadSystemId() {
        return Thread.currentThread().getId();
    }
}

