/*
 * Decompiled with CFR 0.152.
 */
package dev.mja00.villagerLobotomizer.sentry;

import dev.mja00.villagerLobotomizer.sentry.Dsn;
import dev.mja00.villagerLobotomizer.sentry.RequestDetails;
import dev.mja00.villagerLobotomizer.sentry.SentryOptions;
import dev.mja00.villagerLobotomizer.sentry.util.Objects;
import java.net.URI;
import java.util.HashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class RequestDetailsResolver {
    private static final String USER_AGENT = "User-Agent";
    private static final String SENTRY_AUTH = "X-Sentry-Auth";
    @NotNull
    private final Dsn dsn;
    @Nullable
    private final String sentryClientName;

    public RequestDetailsResolver(@NotNull String dsn, @Nullable String sentryClientName) {
        Objects.requireNonNull(dsn, "dsn is required");
        this.dsn = new Dsn(dsn);
        this.sentryClientName = sentryClientName;
    }

    @ApiStatus.Internal
    public RequestDetailsResolver(@NotNull SentryOptions options) {
        Objects.requireNonNull(options, "options is required");
        this.dsn = options.retrieveParsedDsn();
        this.sentryClientName = options.getSentryClientName();
    }

    @NotNull
    public RequestDetails resolve() {
        URI sentryUri = this.dsn.getSentryUri();
        String envelopeUrl = sentryUri.resolve(sentryUri.getPath() + "/envelope/").toString();
        String publicKey = this.dsn.getPublicKey();
        String secretKey = this.dsn.getSecretKey();
        String authHeader = "Sentry sentry_version=7,sentry_client=" + this.sentryClientName + ",sentry_key=" + publicKey + (secretKey != null && secretKey.length() > 0 ? ",sentry_secret=" + secretKey : "");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(USER_AGENT, this.sentryClientName);
        headers.put(SENTRY_AUTH, authHeader);
        return new RequestDetails(envelopeUrl, headers);
    }
}

