/*
 * Decompiled with CFR 0.152.
 */
package dev.mja00.villagerLobotomizer.sentry;

import dev.mja00.villagerLobotomizer.sentry.SentryLevel;
import dev.mja00.villagerLobotomizer.sentry.SentryOptions;
import dev.mja00.villagerLobotomizer.sentry.cache.EnvelopeCache;
import dev.mja00.villagerLobotomizer.sentry.cache.IEnvelopeCache;
import java.io.File;
import org.jetbrains.annotations.NotNull;

final class MovePreviousSession
implements Runnable {
    @NotNull
    private final SentryOptions options;

    MovePreviousSession(@NotNull SentryOptions options) {
        this.options = options;
    }

    @Override
    public void run() {
        String cacheDirPath = this.options.getCacheDirPath();
        if (cacheDirPath == null) {
            this.options.getLogger().log(SentryLevel.INFO, "Cache dir is not set, not moving the previous session.", new Object[0]);
            return;
        }
        if (!this.options.isEnableAutoSessionTracking()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Session tracking is disabled, bailing from previous session mover.", new Object[0]);
            return;
        }
        IEnvelopeCache cache = this.options.getEnvelopeDiskCache();
        if (cache instanceof EnvelopeCache) {
            File currentSessionFile = EnvelopeCache.getCurrentSessionFile(cacheDirPath);
            File previousSessionFile = EnvelopeCache.getPreviousSessionFile(cacheDirPath);
            ((EnvelopeCache)cache).movePreviousSession(currentSessionFile, previousSessionFile);
            ((EnvelopeCache)cache).flushPreviousSession();
        }
    }
}

