/*
 * Decompiled with CFR 0.152.
 */
package dev.mja00.villagerLobotomizer.sentry;

import dev.mja00.villagerLobotomizer.sentry.CheckIn;
import dev.mja00.villagerLobotomizer.sentry.Hint;
import dev.mja00.villagerLobotomizer.sentry.IScope;
import dev.mja00.villagerLobotomizer.sentry.ProfileChunk;
import dev.mja00.villagerLobotomizer.sentry.ProfilingTraceData;
import dev.mja00.villagerLobotomizer.sentry.SentryEnvelope;
import dev.mja00.villagerLobotomizer.sentry.SentryEvent;
import dev.mja00.villagerLobotomizer.sentry.SentryLevel;
import dev.mja00.villagerLobotomizer.sentry.SentryLogEvent;
import dev.mja00.villagerLobotomizer.sentry.SentryLogEvents;
import dev.mja00.villagerLobotomizer.sentry.SentryReplayEvent;
import dev.mja00.villagerLobotomizer.sentry.Session;
import dev.mja00.villagerLobotomizer.sentry.TraceContext;
import dev.mja00.villagerLobotomizer.sentry.UserFeedback;
import dev.mja00.villagerLobotomizer.sentry.protocol.Feedback;
import dev.mja00.villagerLobotomizer.sentry.protocol.Message;
import dev.mja00.villagerLobotomizer.sentry.protocol.SentryId;
import dev.mja00.villagerLobotomizer.sentry.protocol.SentryTransaction;
import dev.mja00.villagerLobotomizer.sentry.transport.RateLimiter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ISentryClient {
    public boolean isEnabled();

    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent var1, @Nullable IScope var2, @Nullable Hint var3);

    public void close();

    public void close(boolean var1);

    public void flush(long var1);

    @NotNull
    default public SentryId captureEvent(@NotNull SentryEvent event) {
        return this.captureEvent(event, null, null);
    }

    @NotNull
    default public SentryId captureEvent(@NotNull SentryEvent event, @Nullable IScope scope) {
        return this.captureEvent(event, scope, null);
    }

    @NotNull
    default public SentryId captureEvent(@NotNull SentryEvent event, @Nullable Hint hint) {
        return this.captureEvent(event, null, hint);
    }

    @NotNull
    public SentryId captureFeedback(@NotNull Feedback var1, @Nullable Hint var2, @NotNull IScope var3);

    @NotNull
    default public SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level, @Nullable IScope scope) {
        SentryEvent event = new SentryEvent();
        Message sentryMessage = new Message();
        sentryMessage.setFormatted(message);
        event.setMessage(sentryMessage);
        event.setLevel(level);
        return this.captureEvent(event, scope);
    }

    @NotNull
    default public SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level) {
        return this.captureMessage(message, level, null);
    }

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable) {
        return this.captureException(throwable, null, null);
    }

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable, @Nullable IScope scope, @Nullable Hint hint) {
        SentryEvent event = new SentryEvent(throwable);
        return this.captureEvent(event, scope, hint);
    }

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable, @Nullable Hint hint) {
        return this.captureException(throwable, null, hint);
    }

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable, @Nullable IScope scope) {
        return this.captureException(throwable, scope, null);
    }

    @NotNull
    public SentryId captureReplayEvent(@NotNull SentryReplayEvent var1, @Nullable IScope var2, @Nullable Hint var3);

    public void captureUserFeedback(@NotNull UserFeedback var1);

    public void captureSession(@NotNull Session var1, @Nullable Hint var2);

    default public void captureSession(@NotNull Session session) {
        this.captureSession(session, null);
    }

    @Nullable
    public SentryId captureEnvelope(@NotNull SentryEnvelope var1, @Nullable Hint var2);

    @Nullable
    default public SentryId captureEnvelope(@NotNull SentryEnvelope envelope) {
        return this.captureEnvelope(envelope, null);
    }

    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable IScope scope, @Nullable Hint hint) {
        return this.captureTransaction(transaction, null, scope, hint);
    }

    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable TraceContext traceContext, @Nullable IScope scope, @Nullable Hint hint) {
        return this.captureTransaction(transaction, traceContext, scope, hint, null);
    }

    @NotNull
    @ApiStatus.Internal
    public SentryId captureTransaction(@NotNull SentryTransaction var1, @Nullable TraceContext var2, @Nullable IScope var3, @Nullable Hint var4, @Nullable ProfilingTraceData var5);

    @ApiStatus.Internal
    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable TraceContext traceContext) {
        return this.captureTransaction(transaction, traceContext, null, null);
    }

    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction) {
        return this.captureTransaction(transaction, null, null, null);
    }

    @ApiStatus.Internal
    @NotNull
    public SentryId captureProfileChunk(@NotNull ProfileChunk var1, @Nullable IScope var2);

    @NotNull
    public SentryId captureCheckIn(@NotNull CheckIn var1, @Nullable IScope var2, @Nullable Hint var3);

    public void captureLog(@NotNull SentryLogEvent var1, @Nullable IScope var2);

    @ApiStatus.Internal
    public void captureBatchedLogEvents(@NotNull SentryLogEvents var1);

    @ApiStatus.Internal
    @Nullable
    public RateLimiter getRateLimiter();

    @ApiStatus.Internal
    default public boolean isHealthy() {
        return true;
    }
}

