/*
 * Decompiled with CFR 0.152.
 */
package dev.mja00.villagerLobotomizer;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.mja00.villagerLobotomizer.VillagerLobotomizer;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.EntitySelectorArgumentResolver;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.Nullable;

public class LobotomizeCommand {
    private final VillagerLobotomizer plugin;

    public LobotomizeCommand(VillagerLobotomizer plugin) {
        this.plugin = plugin;
    }

    public LiteralCommandNode<CommandSourceStack> createCommand(String commandName) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandName).requires(command -> command.getSender().hasPermission("lobotomy.command"))).then(Commands.literal((String)"info").executes(command -> this.infoCommand((CommandSourceStack)command.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug").executes(command -> this.debugCommand((CommandSourceStack)command.getSource()))).then(Commands.argument((String)"villager", (ArgumentType)ArgumentTypes.entity()).executes(command -> this.debugCommandSpecific((CommandSourceStack)command.getSource(), (EntitySelectorArgumentResolver)command.getArgument("villager", EntitySelectorArgumentResolver.class))))).then(Commands.literal((String)"toggle").executes(command -> this.toggleDebugCommand((CommandSourceStack)command.getSource()))))).then(Commands.literal((String)"wake").executes(command -> this.wakeCommand((CommandSourceStack)command.getSource())))).then(Commands.literal((String)"reload").executes(command -> this.reloadCommand((CommandSourceStack)command.getSource())))).then(Commands.literal((String)"config").then(((RequiredArgumentBuilder)Commands.argument((String)"key", (ArgumentType)StringArgumentType.string()).suggests(LobotomizeCommand::getConfigKeySuggestions).then(Commands.literal((String)"get").executes(command -> this.getConfigCommand((CommandSourceStack)command.getSource(), (String)command.getArgument("key", String.class))))).then(Commands.literal((String)"set").then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.string()).executes(command -> this.setConfigCommand((CommandSourceStack)command.getSource(), (String)command.getArgument("key", String.class), (String)command.getArgument("value", String.class)))))))).build();
    }

    private int infoCommand(CommandSourceStack source) throws CommandSyntaxException {
        int active = this.plugin.getStorage().getActive().size();
        int inactive = this.plugin.getStorage().getLobotomized().size();
        int total = active + inactive;
        CommandSender sender = source.getSender();
        if (total == 0) {
            sender.sendMessage(Component.text((String)"No villagers are currently tracked. Villagers are tracked when chunks load.").color((TextColor)NamedTextColor.YELLOW));
            return 1;
        }
        Component message = ((TextComponent)Component.text((String)"There are ").append(Component.text((String)String.valueOf(total)).color((TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)" known villagers on the server."));
        message = message.append((Component)Component.text((String)"\nActive: ")).append(Component.text((String)String.valueOf(active)).color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)" (")).append(Component.text((String)String.valueOf((double)Math.round(10000.0 * (double)active / (double)total) / 100.0)).color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)"%)"));
        message = message.append((Component)Component.text((String)"\nLobotomized: ")).append(Component.text((String)String.valueOf(inactive)).color((TextColor)NamedTextColor.RED)).append((Component)Component.text((String)" (")).append(Component.text((String)String.valueOf((double)Math.round(10000.0 * (double)inactive / (double)total) / 100.0)).color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)"%)"));
        sender.sendMessage(message);
        return 1;
    }

    private int debugCommand(CommandSourceStack source) throws CommandSyntaxException {
        Entity target = this.getLookedTarget(source);
        if (target == null) {
            return 0;
        }
        return this.getVillagerDetails(source, (Villager)target);
    }

    @Nullable
    private Entity getLookedTarget(CommandSourceStack source) {
        Entity entity = source.getExecutor();
        if (!(entity instanceof Player)) {
            source.getSender().sendMessage((Component)Component.text((String)"Only players can use this command."));
            return null;
        }
        Player player = (Player)entity;
        Entity target = this.getTargeted(player);
        if (target == null) {
            source.getSender().sendMessage((Component)Component.text((String)"Look at a villager while executing the command, or specify the UUID of a villager."));
            return null;
        }
        return target;
    }

    private int debugCommandSpecific(CommandSourceStack source, EntitySelectorArgumentResolver resolver) throws CommandSyntaxException {
        if (!(source.getExecutor() instanceof Player)) {
            source.getSender().sendMessage((Component)Component.text((String)"Only players can use this command."));
            return 0;
        }
        List targets = (List)resolver.resolve(source);
        Entity target = (Entity)targets.get(0);
        if (!(target instanceof Villager)) {
            source.getSender().sendMessage((Component)Component.text((String)"Look at a villager while executing the command, or specify the UUID of a villager."));
            return 0;
        }
        Villager villager = (Villager)target;
        return this.getVillagerDetails(source, villager);
    }

    private int getVillagerDetails(CommandSourceStack source, Villager villager) {
        boolean lobotomized = this.plugin.getStorage().getLobotomized().contains(villager);
        boolean active = this.plugin.getStorage().getActive().contains(villager);
        boolean hasAI = villager.isAware() && villager.hasAI();
        Component message = Component.text((String)"Is Awareness enabled: ").append(Component.text((boolean)villager.isAware()).color((TextColor)(villager.isAware() ? NamedTextColor.GREEN : NamedTextColor.RED)));
        message = message.append((Component)Component.text((String)"\nIs AI enabled: ")).append(Component.text((boolean)hasAI).color((TextColor)(hasAI ? NamedTextColor.GREEN : NamedTextColor.RED)));
        message = message.append((Component)Component.text((String)"\nIs marked as Lobotomized: ")).append(Component.text((boolean)lobotomized).color((TextColor)(lobotomized ? NamedTextColor.GREEN : NamedTextColor.RED)));
        message = message.append((Component)Component.text((String)"\nIs marked as Active: ")).append(Component.text((boolean)active).color((TextColor)(active ? NamedTextColor.GREEN : NamedTextColor.RED)));
        message = message.append((Component)Component.text((String)"\nVillager level: ")).append(Component.text((int)villager.getVillagerLevel()).color((TextColor)NamedTextColor.GREEN));
        message = message.append((Component)Component.text((String)"\nVillager experience: ")).append(Component.text((int)villager.getVillagerExperience()).color((TextColor)NamedTextColor.GREEN));
        source.getSender().sendMessage(message);
        return 1;
    }

    @Nullable
    private Entity getTargeted(Player player) {
        Entity target = null;
        RayTraceResult ray = player.getWorld().rayTraceEntities(player.getEyeLocation(), player.getEyeLocation().getDirection(), 16.0, 0.0, ex -> ex instanceof Villager);
        target = ray == null ? null : ray.getHitEntity();
        return target;
    }

    private int wakeCommand(CommandSourceStack source) throws CommandSyntaxException {
        Entity target = this.getLookedTarget(source);
        if (target == null) {
            return 0;
        }
        Villager villager = (Villager)target;
        this.plugin.getStorage().removeVillager(villager);
        this.plugin.getStorage().clearLobotomizedMarker(villager);
        source.getSender().sendMessage((Component)Component.text((String)"This villager will now be unaffected by the plugin until the chunk is reloaded."));
        return 1;
    }

    private int reloadCommand(CommandSourceStack source) throws CommandSyntaxException {
        int villagers = this.plugin.reloadPluginState();
        if (villagers < 0) {
            source.getSender().sendMessage(Component.text((String)"Failed to reload storage; keeping existing state. Check console for details.").color((TextColor)NamedTextColor.RED));
            return 0;
        }
        Component message = ((TextComponent)Component.text((String)"Reloaded ").append(Component.text((String)String.valueOf(villagers)).color((TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)" villagers. The config file was also reloaded."));
        source.getSender().sendMessage(message);
        return 1;
    }

    private int toggleDebugCommand(CommandSourceStack source) throws CommandSyntaxException {
        this.plugin.setDebugging(!this.plugin.isDebugging());
        source.getSender().sendMessage(((TextComponent)Component.text((String)"Debug mode: ").append((Component)Component.text((String)(this.plugin.isDebugging() ? "enabled" : "disabled")))).append((Component)Component.text((String)". Messages about villager tracking will now be printed to your console.")));
        return 1;
    }

    private static CompletableFuture<Suggestions> getConfigKeySuggestions(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (!(source.getExecutor() instanceof Player)) {
            return builder.buildFuture();
        }
        VillagerLobotomizer plugin = (VillagerLobotomizer)Bukkit.getPluginManager().getPlugin("VillagerLobotimizer");
        if (plugin == null) {
            return builder.buildFuture();
        }
        Set configKeys = plugin.getConfig().getKeys(true);
        String remaining = builder.getRemaining().toLowerCase();
        configKeys.stream().filter(key -> key.toLowerCase().startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private int getConfigCommand(CommandSourceStack source, String key) throws CommandSyntaxException {
        String value = this.plugin.getConfig().getString(key);
        source.getSender().sendMessage((Component)Component.text((String)("The value of " + key + " is " + value)));
        return 1;
    }

    private int setConfigCommand(CommandSourceStack source, String key, String value) throws CommandSyntaxException {
        if (!this.plugin.getConfig().contains(key)) {
            source.getSender().sendMessage(Component.text((String)("Config key '" + key + "' does not exist.")).color((TextColor)NamedTextColor.RED));
            return 0;
        }
        Object currentValue = this.plugin.getConfig().get(key);
        try {
            if (currentValue instanceof Boolean) {
                if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                    source.getSender().sendMessage(Component.text((String)("'" + key + "' expects a boolean value (true/false), but got: " + value)).color((TextColor)NamedTextColor.RED));
                    return 0;
                }
                boolean boolValue = Boolean.parseBoolean(value);
                this.plugin.getConfig().set(key, (Object)boolValue);
            } else if (currentValue instanceof Number) {
                Long parsed;
                Object object = currentValue;
                Objects.requireNonNull(object);
                Object object2 = object;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Integer.class, Double.class, Float.class}, (Object)object2, n)) {
                    case 0: {
                        Long l = (Long)object2;
                        Number number = Long.valueOf(value);
                        break;
                    }
                    case 1: {
                        Integer i = (Integer)object2;
                        Number number = Integer.valueOf(value);
                        break;
                    }
                    case 2: {
                        Double d = (Double)object2;
                        Number number = Double.valueOf(value);
                        break;
                    }
                    case 3: {
                        Float f = (Float)object2;
                        Number number = Float.valueOf(value);
                        break;
                    }
                    default: {
                        Number number = parsed = null;
                    }
                }
                if (parsed != null) {
                    this.plugin.getConfig().set(key, (Object)parsed);
                }
            } else if (currentValue instanceof String) {
                this.plugin.getConfig().set(key, (Object)value);
            } else {
                if (currentValue instanceof List) {
                    source.getSender().sendMessage(Component.text((String)"Setting list values is not supported yet. Use the config file directly.").color((TextColor)NamedTextColor.YELLOW));
                    return 0;
                }
                source.getSender().sendMessage(Component.text((String)("Cannot set value for '" + key + "': unsupported type.")).color((TextColor)NamedTextColor.RED));
                return 0;
            }
            this.plugin.saveConfig();
            this.plugin.reloadConfig();
            source.getSender().sendMessage(Component.text((String)("Successfully set '" + key + "' to '" + value + "'")).color((TextColor)NamedTextColor.GREEN));
            source.getSender().sendMessage(Component.text((String)"Note: You may need to run '/lobotomy reload' for changes to take effect.").color((TextColor)NamedTextColor.YELLOW));
            return 1;
        }
        catch (Exception e) {
            source.getSender().sendMessage(Component.text((String)("Failed to set config value: " + e.getMessage())).color((TextColor)NamedTextColor.RED));
            return 0;
        }
    }
}

