/*
 * Decompiled with CFR 0.152.
 */
package dev.mja00.villagerLobotomizer.utils;

import dev.mja00.villagerLobotomizer.utils.CommentPreservingYamlMigrator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ConfigMigrator {
    private final JavaPlugin plugin;
    private final Logger logger;
    private static final int CURRENT_CONFIG_VERSION = 3;

    public ConfigMigrator(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    public void migrateConfig() {
        File dataFolder = this.plugin.getDataFolder();
        if (!dataFolder.exists() && !dataFolder.mkdirs()) {
            this.logger.severe("Failed to create plugin data folder: " + dataFolder.getAbsolutePath());
            return;
        }
        File configFile = new File(dataFolder, "config.yml");
        if (!configFile.exists()) {
            this.logger.info("No existing config found, creating default config.");
            this.plugin.saveDefaultConfig();
            return;
        }
        YamlConfiguration existingConfig = YamlConfiguration.loadConfiguration((File)configFile);
        int existingVersion = existingConfig.getInt("config-version", 0);
        if (existingVersion == 3) {
            this.logger.fine("Config is up to date (version 3)");
            return;
        }
        this.logger.info("Config migration needed: current version " + existingVersion + " -> target version 3");
        try {
            this.createBackup(configFile);
            String existingYaml = Files.readString(configFile.toPath(), StandardCharsets.UTF_8);
            String migratedYaml = this.getString(existingYaml);
            Files.writeString(configFile.toPath(), (CharSequence)migratedYaml, StandardCharsets.UTF_8, new OpenOption[0]);
            this.plugin.reloadConfig();
            this.logger.info("Config migration with comment preservation completed successfully!");
        }
        catch (IOException e) {
            this.logger.severe("Failed to migrate config due to I/O error:");
            this.logger.severe("  Error: " + e.getMessage());
            this.logger.severe("  Config file: " + configFile.getAbsolutePath());
            this.logger.severe("  Check file permissions and disk space");
            this.logger.severe("  Falling back to standard config loading");
            e.printStackTrace();
        }
        catch (Exception e) {
            this.logger.severe("Failed to migrate config due to unexpected error:");
            this.logger.severe("  Error type: " + e.getClass().getSimpleName());
            this.logger.severe("  Error message: " + e.getMessage());
            this.logger.severe("  Config file: " + configFile.getAbsolutePath());
            this.logger.severe("  Existing version: " + existingVersion + " -> Target version: 3");
            this.logger.severe("  Please report this error with the stack trace below:");
            e.printStackTrace();
            this.logger.info("Attempting fallback to standard config merge...");
            try {
                this.fallbackMigration(configFile, (FileConfiguration)existingConfig);
                this.logger.info("Fallback migration completed successfully");
            }
            catch (Exception fallbackError) {
                this.logger.severe("Fallback migration also failed: " + fallbackError.getMessage());
                this.logger.severe("Config migration aborted - manual intervention required");
            }
        }
    }

    @NotNull
    private String getString(String existingYaml) throws IOException {
        CommentPreservingYamlMigrator commentMigrator = new CommentPreservingYamlMigrator(this.logger);
        String defaultYaml = this.getDefaultConfigAsString();
        Object migratedYaml = commentMigrator.mergeWithComments(existingYaml, defaultYaml);
        migratedYaml = !((String)migratedYaml).contains("config-version:") ? "config-version: 3\n" + (String)migratedYaml : ((String)migratedYaml).replaceFirst("config-version:\\s*\\d+", "config-version: 3");
        return migratedYaml;
    }

    private void createBackup(File configFile) throws IOException {
        String timestamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        File backupFile = new File(this.plugin.getDataFolder(), "config_backup_" + timestamp + ".yml");
        Files.copy(configFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.logger.info("Created config backup: " + backupFile.getName());
    }

    private FileConfiguration getDefaultConfig() throws IOException {
        InputStream resource = this.plugin.getResource("config.yml");
        if (resource == null) {
            throw new IOException("Default config.yml resource not found in plugin jar");
        }
        return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(resource));
    }

    private String getDefaultConfigAsString() throws IOException {
        InputStream resource = this.plugin.getResource("config.yml");
        if (resource == null) {
            throw new IOException("Default config.yml resource not found in plugin jar");
        }
        return new String(resource.readAllBytes(), StandardCharsets.UTF_8);
    }

    private FileConfiguration mergeConfigs(FileConfiguration existing, FileConfiguration defaults) {
        YamlConfiguration merged = new YamlConfiguration();
        this.addMissingKeys(existing, defaults, (FileConfiguration)merged);
        this.removeObsoleteKeys(existing, defaults, (FileConfiguration)merged);
        return merged;
    }

    private void addMissingKeys(FileConfiguration existing, FileConfiguration defaults, FileConfiguration merged) {
        Set defaultKeys = defaults.getKeys(true);
        Set existingKeys = existing.getKeys(true);
        for (String key : defaultKeys) {
            if (defaults.isConfigurationSection(key)) continue;
            if (existingKeys.contains(key)) {
                merged.set(key, existing.get(key));
                this.logger.fine("Preserved existing value for: " + key);
                continue;
            }
            merged.set(key, defaults.get(key));
            this.logger.info("Added new config option: " + key + " = " + String.valueOf(defaults.get(key)));
        }
        for (String key : defaultKeys) {
            if (!defaults.isConfigurationSection(key)) continue;
            ConfigurationSection defaultSection = defaults.getConfigurationSection(key);
            ConfigurationSection existingSection = existing.getConfigurationSection(key);
            ConfigurationSection mergedSection = merged.createSection(key);
            if (existingSection != null) {
                this.mergeSection(existingSection, defaultSection, mergedSection);
                continue;
            }
            this.copySection(defaultSection, mergedSection);
            this.logger.info("Added new config section: " + key);
        }
    }

    private void removeObsoleteKeys(FileConfiguration existing, FileConfiguration defaults, FileConfiguration merged) {
        Set existingKeys = existing.getKeys(true);
        Set defaultKeys = defaults.getKeys(true);
        for (String key : existingKeys) {
            if (existing.isConfigurationSection(key) || defaultKeys.contains(key)) continue;
            this.logger.info("Removed obsolete config option: " + key + " (was: " + String.valueOf(existing.get(key)) + ")");
        }
    }

    private void mergeSection(ConfigurationSection existing, ConfigurationSection defaults, ConfigurationSection merged) {
        if (defaults == null) {
            return;
        }
        for (String key : defaults.getKeys(false)) {
            if (defaults.isConfigurationSection(key)) {
                ConfigurationSection defaultSubSection = defaults.getConfigurationSection(key);
                ConfigurationSection existingSubSection = existing != null ? existing.getConfigurationSection(key) : null;
                ConfigurationSection mergedSubSection = merged.createSection(key);
                if (existingSubSection != null && defaultSubSection != null) {
                    this.mergeSection(existingSubSection, defaultSubSection, mergedSubSection);
                    continue;
                }
                if (defaultSubSection == null) continue;
                this.copySection(defaultSubSection, mergedSubSection);
                this.logger.info("Added new config subsection: " + merged.getCurrentPath() + "." + key);
                continue;
            }
            if (existing != null && existing.contains(key)) {
                merged.set(key, existing.get(key));
                continue;
            }
            merged.set(key, defaults.get(key));
            this.logger.info("Added new config option: " + merged.getCurrentPath() + "." + key + " = " + String.valueOf(defaults.get(key)));
        }
    }

    private void copySection(ConfigurationSection source, ConfigurationSection target) {
        if (source == null || target == null) {
            return;
        }
        for (String key : source.getKeys(false)) {
            if (source.isConfigurationSection(key)) {
                ConfigurationSection sourceSubSection = source.getConfigurationSection(key);
                if (sourceSubSection == null) continue;
                this.copySection(sourceSubSection, target.createSection(key));
                continue;
            }
            target.set(key, source.get(key));
        }
    }

    private void fallbackMigration(File configFile, FileConfiguration existingConfig) throws IOException {
        this.logger.info("Using fallback migration (comments will not be preserved)");
        FileConfiguration defaultConfig = this.getDefaultConfig();
        FileConfiguration migratedConfig = this.mergeConfigs(existingConfig, defaultConfig);
        migratedConfig.set("config-version", (Object)3);
        migratedConfig.save(configFile);
        this.plugin.reloadConfig();
    }

    public static int getCurrentConfigVersion() {
        return 3;
    }
}

