/*
 * Decompiled with CFR 0.152.
 */
package dev.mja00.villagerLobotomizer.listeners;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import dev.mja00.villagerLobotomizer.VillagerLobotomizer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

public class EntityListener
implements Listener {
    private final VillagerLobotomizer plugin;

    public EntityListener(VillagerLobotomizer plugin) {
        this.plugin = plugin;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof Villager)) continue;
                plugin.getStorage().addVillager((Villager)entity);
            }
        }
    }

    @EventHandler
    public final void onLoad(ChunkLoadEvent event) {
        if (this.plugin.isChunkDebugging()) {
            for (Entity entity : event.getChunk().getEntities()) {
                if (!(entity instanceof Villager)) continue;
                this.plugin.getLogger().info("[Debug] Caught " + event.getEventName() + " for villager " + String.valueOf(entity) + " (" + String.valueOf(entity.getUniqueId()) + "); The villager should have been added to the storage");
            }
        }
    }

    @EventHandler
    public final void onUnload(ChunkUnloadEvent event) {
        if (this.plugin.isChunkDebugging()) {
            for (Entity entity : event.getChunk().getEntities()) {
                if (!(entity instanceof Villager)) continue;
                this.plugin.getLogger().info("[Debug] Caught " + event.getEventName() + " for villager " + String.valueOf(entity) + " (" + String.valueOf(entity.getUniqueId()) + "); The villager should have been removed from the storage");
            }
        }
    }

    @EventHandler
    public final void onAdd(EntityAddToWorldEvent event) {
        if (event.getEntity() instanceof Villager) {
            if (this.plugin.isDebugging()) {
                this.plugin.getLogger().info("[Debug] Caught " + event.getEventName() + " for villager " + String.valueOf(event.getEntity()) + " (" + String.valueOf(event.getEntity().getUniqueId()) + "); The villager should be added to the storage");
            }
            this.plugin.getStorage().addVillager((Villager)event.getEntity());
        }
    }

    @EventHandler
    public final void onRemove(EntityRemoveFromWorldEvent event) {
        if (event.getEntity() instanceof Villager) {
            this.plugin.getStorage().removeVillager((Villager)event.getEntity());
            if (this.plugin.isDebugging()) {
                this.plugin.getLogger().info("[Debug] Caught " + event.getEventName() + " for villager " + String.valueOf(event.getEntity()) + " (" + String.valueOf(event.getEntity().getUniqueId()) + "); The villager should have been removed from the storage");
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onBlockBreak(BlockBreakEvent event) {
        this.plugin.getStorage().handleBlockChange(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onBlockPlace(BlockPlaceEvent event) {
        this.plugin.getStorage().handleBlockChange(event.getBlock());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!this.plugin.getConfig().getBoolean("prevent-trading-with-unlobotomized-villagers", false)) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        Player player = event.getPlayer();
        boolean isTrackedActive = this.plugin.getStorage().getActive().contains(villager);
        boolean isTrackedInactive = this.plugin.getStorage().getLobotomized().contains(villager);
        if (!isTrackedActive && !isTrackedInactive) {
            return;
        }
        if (isTrackedActive) {
            event.setCancelled(true);
            Component message = ((TextComponent)Component.text((String)"You cannot trade with unlobotomized villagers! ").color((TextColor)NamedTextColor.RED)).append(Component.text((String)"This villager needs to be lobotomized first.").color((TextColor)NamedTextColor.YELLOW));
            player.sendMessage(message);
            if (this.plugin.isDebugging()) {
                this.plugin.getLogger().info("[Debug] Blocked trade with unlobotomized villager " + String.valueOf(villager.getUniqueId()) + " by player " + player.getName());
            }
        }
    }
}

