/*
 * Decompiled with CFR 0.152.
 */
package dev.mja00.villagerLobotomizer.utils;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.Map;
import org.bukkit.Bukkit;

public class VersionUtils {
    private static final Map<String, SupportStatus> unsupportedServers;
    private static final String PFX;
    private static SupportStatus supportStatus;
    private static String supportStatusClass;

    private VersionUtils() {
    }

    public static SupportStatus getServerSupportStatus() {
        if (supportStatus == null) {
            for (Map.Entry<String, SupportStatus> entry : unsupportedServers.entrySet()) {
                if (entry.getKey().startsWith(PFX)) {
                    if (!Bukkit.getName().equalsIgnoreCase(entry.getKey().replaceFirst(PFX, ""))) continue;
                    supportStatusClass = entry.getKey();
                    supportStatus = entry.getValue();
                    return supportStatus;
                }
                boolean inverted = entry.getKey().contains("!");
                String clazz = entry.getKey().replace("!", "").split("#")[0];
                String method = "";
                if (entry.getKey().contains("#")) {
                    method = entry.getKey().split("#")[1];
                }
                try {
                    Class<?> lolClass = Class.forName(clazz);
                    if (!method.isEmpty()) {
                        for (Method mth : lolClass.getDeclaredMethods()) {
                            if (!mth.getName().equals(method) || inverted) continue;
                            supportStatusClass = entry.getKey();
                            supportStatus = entry.getValue();
                            return supportStatus;
                        }
                        continue;
                    }
                    if (inverted) continue;
                    supportStatusClass = entry.getKey();
                    supportStatus = entry.getValue();
                    return supportStatus;
                }
                catch (ClassNotFoundException ignored) {
                    if (!inverted) continue;
                    supportStatusClass = entry.getKey();
                    supportStatus = entry.getValue();
                    return supportStatus;
                }
            }
            supportStatus = SupportStatus.FULL;
            return supportStatus;
        }
        return supportStatus;
    }

    public static String getSupportStatusClass() {
        return supportStatusClass;
    }

    private static String make(String in) {
        char[] c = in.toCharArray();
        int i = 0;
        while (i < c.length) {
            int n = i++;
            c[n] = (char)(c[n] ^ 0x5A);
        }
        return new String(c);
    }

    static {
        PFX = VersionUtils.make("8(;4>`");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)VersionUtils.make("5(=t>(??;7t6?;<t\\026?;<\\03055.).(;*"), (Object)SupportStatus.DANGEROUS_FORK);
        builder.put((Object)"brand:Leaf", (Object)SupportStatus.DANGEROUS_FORK);
        builder.put((Object)(PFX + VersionUtils.make("\\026?;<")), (Object)SupportStatus.DANGEROUS_FORK);
        builder.put((Object)"net.minecraftforge.common.MinecraftForge", (Object)SupportStatus.UNSTABLE);
        builder.put((Object)VersionUtils.make("4?.t734?9(;<.<5(=?t957754t\\02734?9(;<.\\0345(=?"), (Object)SupportStatus.UNSTABLE);
        builder.put((Object)(PFX + VersionUtils.make("\\027523).")), (Object)SupportStatus.UNSTABLE);
        builder.put((Object)"brand:Mohist", (Object)SupportStatus.UNSTABLE);
        builder.put((Object)"net.fabricmc.loader.launch.knot.KnotServer", (Object)SupportStatus.UNSTABLE);
        builder.put((Object)VersionUtils.make("4?.t<;8(3979t65;>?(t6;/492t145.t\\02145.\\t?(,?("), (Object)SupportStatus.UNSTABLE);
        builder.put((Object)(PFX + VersionUtils.make("\\0035/?(")), (Object)SupportStatus.UNSTABLE);
        unsupportedServers = builder.build();
        supportStatus = null;
        supportStatusClass = null;
    }

    public static enum SupportStatus {
        FULL(true),
        LIMITED(true),
        DANGEROUS_FORK(false),
        STUPID_PLUGIN(false),
        NMS_CLEANROOM(false),
        UNSTABLE(false),
        OUTDATED(false);

        private final boolean supported;

        private SupportStatus(boolean supported) {
            this.supported = supported;
        }

        public boolean isSupported() {
            return this.supported;
        }
    }
}

