/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.Util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import me.marcangeloh.Util.MessengerUtil;

public class UpdateChecker {
    private final String FILE_URL = "https://raw.githubusercontent.com/marcangeloh/Plugins/refs/heads/master/UpgradableTools.txt";
    private String onlineVersion = null;
    private String downloadLink = null;

    public boolean isUpdateAvailable(String original) {
        String version = this.reformatVersion(original);
        if (this.onlineVersion == null) {
            this.fetchAndLogUltraPointsInfo();
        }
        this.onlineVersion = this.reformatVersion(this.onlineVersion);
        if (this.onlineVersion.equals(version)) {
            MessengerUtil.notifyConsole("<green>Your version of " + "<gradient:#3e713e:#baffb4>UpgradeableTools: </gradient><reset>".replaceAll(": ", "") + "<green> is up to date. You are running version <yellow>" + original);
            return false;
        }
        int splitVersion = Integer.parseInt(version);
        int splitOnline = Integer.parseInt(this.onlineVersion);
        if (splitOnline > splitVersion) {
            MessengerUtil.notifyConsole("<red><a:" + this.downloadLink + ">Your version of UltraPoints is outdated. Please use the newest version, you can find it here.");
            return true;
        }
        return false;
    }

    private String reformatVersion(String version) {
        return version.replaceAll("\\.", "").replaceAll("v", "").replaceAll("SNAPSHOT", "").replaceAll("-", "");
    }

    private void fetchAndLogUltraPointsInfo() {
        block9: {
            try {
                URL url = new URL("https://raw.githubusercontent.com/marcangeloh/Plugins/refs/heads/master/UpgradableTools.txt");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) break block9;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String line1 = in.readLine();
                    String line2 = in.readLine();
                    if (line1 != null) {
                        this.onlineVersion = line1.trim();
                    }
                    if (line2 != null) {
                        this.downloadLink = line2.trim();
                    }
                }
            }
            catch (IOException e) {
                MessengerUtil.notifyConsole("An error occurred while reading from GitHub: " + e.getMessage());
            }
        }
    }
}

