/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.Util;

import me.marcangeloh.API.Util.GeneralUtil.Tools;
import me.marcangeloh.Events.JobEvents;
import me.marcangeloh.PointsCore;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.CheckerUtil;
import me.marcangeloh.Util.MessengerUtil;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PointsUtil {
    PointsCore pointsCore;

    public PointsUtil(PointsCore pointsCore) {
        this.pointsCore = pointsCore;
    }

    public Double checkForPoints(ItemStack stack, Player player) {
        if (CheckerUtil.checkForShovel(stack)) {
            if (UpgradeableTools.usePointsCore) {
                return this.pointsCore.playerPoints.shovelPoints.getPoints(player);
            }
            if (UpgradeableTools.useEconomy) {
                return UpgradeableTools.getEconomy().getBalance((OfflinePlayer)player);
            }
            return JobEvents.shovelPoints.get(player.getUniqueId().toString());
        }
        if (CheckerUtil.checkForPickaxe(stack)) {
            if (UpgradeableTools.usePointsCore) {
                return this.pointsCore.playerPoints.pickaxePoints.getPoints(player);
            }
            if (UpgradeableTools.useEconomy) {
                return UpgradeableTools.getEconomy().getBalance((OfflinePlayer)player);
            }
            return JobEvents.pickaxePoints.get(player.getUniqueId().toString());
        }
        if (CheckerUtil.checkForAxe(stack)) {
            if (UpgradeableTools.usePointsCore) {
                return this.pointsCore.playerPoints.axePoints.getPoints(player);
            }
            if (UpgradeableTools.useEconomy) {
                return UpgradeableTools.getEconomy().getBalance((OfflinePlayer)player);
            }
            return JobEvents.axePoints.get(player.getUniqueId().toString());
        }
        if (CheckerUtil.checkForArmor(stack)) {
            if (UpgradeableTools.usePointsCore) {
                return this.pointsCore.playerPoints.armorPoints.getPoints(player);
            }
            if (UpgradeableTools.useEconomy) {
                return UpgradeableTools.getEconomy().getBalance((OfflinePlayer)player);
            }
            return JobEvents.armorPoints.get(player.getUniqueId().toString());
        }
        if (CheckerUtil.checkForHoe(stack)) {
            if (UpgradeableTools.usePointsCore) {
                return this.pointsCore.playerPoints.hoePoints.getPoints(player);
            }
            if (UpgradeableTools.useEconomy) {
                return UpgradeableTools.getEconomy().getBalance((OfflinePlayer)player);
            }
            return JobEvents.hoePoints.get(player.getUniqueId().toString());
        }
        if (CheckerUtil.checkForTrident(stack) || CheckerUtil.checkForCrossbow(stack) || CheckerUtil.checkForBow(stack)) {
            if (UpgradeableTools.usePointsCore) {
                return this.pointsCore.playerPoints.rangedWeaponPoints.getPoints(player);
            }
            if (UpgradeableTools.useEconomy) {
                return UpgradeableTools.getEconomy().getBalance((OfflinePlayer)player);
            }
            return JobEvents.weaponPoints.get(player.getUniqueId().toString());
        }
        if (CheckerUtil.checkForSwords(stack)) {
            if (UpgradeableTools.usePointsCore) {
                return this.pointsCore.playerPoints.meleeWeaponPoints.getPoints(player);
            }
            if (UpgradeableTools.useEconomy) {
                return UpgradeableTools.getEconomy().getBalance((OfflinePlayer)player);
            }
            return JobEvents.weaponPoints.get(player.getUniqueId().toString());
        }
        if (stack.getType().equals((Object)Material.FISHING_ROD)) {
            if (UpgradeableTools.usePointsCore) {
                return this.pointsCore.playerPoints.fishingPoints.getPoints(player);
            }
            if (UpgradeableTools.useEconomy) {
                return UpgradeableTools.getEconomy().getBalance((OfflinePlayer)player);
            }
            return JobEvents.fishingPoints.get(player.getUniqueId().toString());
        }
        return 0.0;
    }

    public boolean setPointsForToolType(String tool, Player player, Double amount) {
        if (UpgradeableTools.useEconomy) {
            double balance = UpgradeableTools.getEconomy().getBalance((OfflinePlayer)player);
            if (balance >= amount) {
                UpgradeableTools.getEconomy().withdrawPlayer((OfflinePlayer)player, balance - (balance - amount));
            } else {
                UpgradeableTools.getEconomy().depositPlayer((OfflinePlayer)player, balance + (amount - balance));
            }
            return true;
        }
        switch (tool) {
            case "MELEE": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.setPointsForToolType(Tools.MELEE_WEAPON, player, amount);
                return true;
            }
            case "RANGED": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.setPointsForToolType(Tools.RANGED_WEAPON, player, amount);
                return true;
            }
            case "AXE": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.setPointsForToolType(Tools.AXE, player, amount);
                return true;
            }
            case "SHOVEL": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.setPointsForToolType(Tools.SHOVEL, player, amount);
                return true;
            }
            case "FISHING": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.setPointsForToolType(Tools.FISH_ROD, player, amount);
                return true;
            }
            case "PICKAXE": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.setPointsForToolType(Tools.PICKAXE, player, amount);
                return true;
            }
            case "ARMOR": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.setPointsForToolType(Tools.ARMOR, player, amount);
                return true;
            }
            case "HOE": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.setPointsForToolType(Tools.HOE, player, amount);
                return true;
            }
        }
        return false;
    }

    public boolean addPointsTo(String tool, Player player, double amount) {
        if (UpgradeableTools.useEconomy) {
            UpgradeableTools.getEconomy().depositPlayer((OfflinePlayer)player, amount);
            return true;
        }
        if (UpgradeableTools.useXP) {
            player.giveExp((int)amount);
            return true;
        }
        switch (tool) {
            case "MELEE": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.addPointsToToolType(Tools.MELEE_WEAPON, player, amount);
                return true;
            }
            case "RANGED": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.addPointsToToolType(Tools.RANGED_WEAPON, player, amount);
                return true;
            }
            case "AXE": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.addPointsToToolType(Tools.AXE, player, amount);
                return true;
            }
            case "SHOVEL": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.addPointsToToolType(Tools.SHOVEL, player, amount);
                return true;
            }
            case "FISHING": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.addPointsToToolType(Tools.FISH_ROD, player, amount);
                return true;
            }
            case "PICKAXE": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.addPointsToToolType(Tools.PICKAXE, player, amount);
                return true;
            }
            case "ARMOR": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.addPointsToToolType(Tools.ARMOR, player, amount);
                return true;
            }
            case "HOE": {
                UpgradeableTools.PLUGIN.pointsCore.playerPoints.addPointsToToolType(Tools.HOE, player, amount);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean withdrawPointsFor(ItemStack tool, Player player, Double cost) {
        if (CheckerUtil.checkForShovel(tool)) {
            if (UpgradeableTools.usePointsCore) {
                if (this.checkForPoints(tool, player) >= cost) {
                    this.pointsCore.playerPoints.shovelPoints.removePointsFromPlayer(player, cost);
                    return true;
                }
                MessengerUtil.notifyPlayer(player, "<red>You do not have enough money to perform this upgrade.");
                return false;
            }
            if (!UpgradeableTools.useEconomy) return false;
            return this.handleEconWithdrawal(player, cost);
        }
        if (CheckerUtil.checkForPickaxe(tool)) {
            if (UpgradeableTools.usePointsCore) {
                if (this.checkForPoints(tool, player) >= cost) {
                    this.pointsCore.playerPoints.pickaxePoints.removePointsFromPlayer(player, cost);
                    return true;
                }
                MessengerUtil.notifyPlayer(player, "<red>You do not have enough money to perform this upgrade.");
                return false;
            }
            if (UpgradeableTools.useEconomy) {
                return this.handleEconWithdrawal(player, cost);
            }
            if (!UpgradeableTools.useXP) return false;
            if ((double)player.getExp() > cost) {
                MessengerUtil.notifyPlayer(player, "<red>You do not have enough experience to perform this upgrade.");
                return false;
            }
            player.setExp((float)((double)player.getExp() - cost));
            return false;
        } else {
            if (CheckerUtil.checkForAxe(tool)) {
                if (UpgradeableTools.usePointsCore) {
                    if (this.checkForPoints(tool, player) >= cost) {
                        this.pointsCore.playerPoints.axePoints.removePointsFromPlayer(player, cost);
                        return true;
                    }
                    MessengerUtil.notifyPlayer(player, "<red>You do not have enough money to perform this upgrade.");
                    return false;
                }
                if (!UpgradeableTools.useEconomy) return false;
                return this.handleEconWithdrawal(player, cost);
            }
            if (CheckerUtil.checkForArmor(tool)) {
                if (UpgradeableTools.usePointsCore) {
                    if (this.checkForPoints(tool, player) >= cost) {
                        this.pointsCore.playerPoints.armorPoints.removePointsFromPlayer(player, cost);
                        return true;
                    }
                    MessengerUtil.notifyPlayer(player, "<red>You do not have enough money to perform this upgrade.");
                    return false;
                }
                if (!UpgradeableTools.useEconomy) return false;
                return this.handleEconWithdrawal(player, cost);
            }
            if (CheckerUtil.checkForHoe(tool)) {
                if (UpgradeableTools.usePointsCore) {
                    if (this.checkForPoints(tool, player) >= cost) {
                        this.pointsCore.playerPoints.hoePoints.removePointsFromPlayer(player, cost);
                        return true;
                    }
                    MessengerUtil.notifyPlayer(player, "<red>You do not have enough money to perform this upgrade.");
                    return false;
                }
                if (!UpgradeableTools.useEconomy) return false;
                return this.handleEconWithdrawal(player, cost);
            }
            if (CheckerUtil.checkForTrident(tool) || CheckerUtil.checkForBow(tool) || CheckerUtil.checkForCrossbow(tool)) {
                if (UpgradeableTools.usePointsCore) {
                    if (this.checkForPoints(tool, player) >= cost) {
                        this.pointsCore.playerPoints.rangedWeaponPoints.removePointsFromPlayer(player, cost);
                        return true;
                    }
                    MessengerUtil.notifyPlayer(player, "<red>You do not have enough money to perform this upgrade.");
                    return false;
                }
                if (!UpgradeableTools.useEconomy) return false;
                return this.handleEconWithdrawal(player, cost);
            }
            if (CheckerUtil.checkForSwords(tool)) {
                if (UpgradeableTools.usePointsCore) {
                    if (this.checkForPoints(tool, player) >= cost) {
                        this.pointsCore.playerPoints.meleeWeaponPoints.removePointsFromPlayer(player, cost);
                        return true;
                    }
                    MessengerUtil.notifyPlayer(player, "<red>You do not have enough money to perform this upgrade.");
                    return false;
                }
                if (!UpgradeableTools.useEconomy) return false;
                return this.handleEconWithdrawal(player, cost);
            }
            if (!tool.getType().equals((Object)Material.FISHING_ROD)) return false;
            if (UpgradeableTools.usePointsCore) {
                if (this.checkForPoints(tool, player) >= cost) {
                    this.pointsCore.playerPoints.fishingPoints.removePointsFromPlayer(player, cost);
                    return true;
                }
                MessengerUtil.notifyPlayer(player, "<red>You do not have enough money to perform this upgrade.");
                return false;
            }
            if (!UpgradeableTools.useEconomy) return false;
            return this.handleEconWithdrawal(player, cost);
        }
    }

    private boolean handleEconWithdrawal(Player player, Double cost) {
        if (UpgradeableTools.getEconomy().getBalance((OfflinePlayer)player) >= cost) {
            EconomyResponse economyResponse = UpgradeableTools.getEconomy().withdrawPlayer((OfflinePlayer)player, cost.doubleValue());
            if (!economyResponse.transactionSuccess()) {
                return true;
            }
            MessengerUtil.notifyPlayer(player, "<red>An error occurred with the transaction.");
            return false;
        }
        MessengerUtil.notifyPlayer(player, "<red>You do not have enough money to perform this upgrade.");
        return false;
    }
}

