/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.Util;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.InvGUIStorage;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.apache.commons.text.WordUtils;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryUtil {
    private final HashMap<Enchantment, InvGUIStorage> itemList = new HashMap();

    public void addEnchantment(AbstractCustomEnchantment enchantment, ItemStack tool, Material type, String toolType, String enchantmentName, int page, int index, boolean custom) {
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + enchantment.getKey())));
        this.addEnchantment(yourEnchantment, tool, type, toolType, enchantmentName, page, index, custom);
    }

    public void addEnchantment(Enchantment enchantment, ItemStack tool, Material type, String toolType, String enchantmentName, int page, int index, boolean custom) {
        ItemStack stack = new ItemStack(type);
        if (custom) {
            stack = this.handleCustomEnchantSection(stack, tool, enchantment, toolType);
        } else {
            this.addEnchantment(tool, toolType, enchantmentName.replaceAll(" ", "").replaceAll("-", ""), enchantment, enchantmentName, stack);
        }
        this.itemList.put(enchantment, new InvGUIStorage(index, page, stack));
    }

    public void addCustomStack(AbstractCustomEnchantment enchantment, ItemStack tool, ItemStack item, String toolType, String enchantmentName, int page, int index, boolean custom) {
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + enchantment.getKey())));
        this.addCustomStack(yourEnchantment, tool, item, toolType, enchantmentName, page, index, custom);
    }

    public void addCustomStack(Enchantment enchantment, ItemStack tool, ItemStack item, String toolType, String enchantmentName, int page, int index, boolean custom) {
        ItemStack stack = item;
        if (custom) {
            stack = this.handleCustomEnchantSection(stack, tool, enchantment, toolType);
        } else {
            this.addEnchantment(tool, toolType, enchantmentName.replaceAll(" ", "").replaceAll("-", ""), enchantment, enchantmentName, stack);
        }
        this.itemList.put(enchantment, new InvGUIStorage(index, page, stack));
    }

    public List<InvGUIStorage> getContents(int page) {
        ArrayList<InvGUIStorage> list = new ArrayList<InvGUIStorage>();
        for (Enchantment enchantment : this.itemList.keySet()) {
            if (this.itemList.get(enchantment).getPage() != page) continue;
            list.add(this.itemList.get(enchantment));
        }
        return list;
    }

    public void reset() {
        this.itemList.clear();
    }

    private ItemStack handleCustomEnchantSection(ItemStack item, ItemStack tool, Enchantment enchants, String type) {
        int level = tool.getEnchantmentLevel(enchants);
        String pathName = WordUtils.capitalizeFully(enchants.getKey().getKey().replaceAll("_", " ")).replaceAll(" ", "");
        String name = UpgradeableTools.PLUGIN.getConfig().getString("MultiplierToLevel." + type + "." + pathName + ".name", WordUtils.capitalizeFully(enchants.getKey().getKey().replaceAll("_", " ")));
        this.addCustomEnchant(type, item, enchants, level, name);
        if (UpgradeableTools.PLUGIN.getConfig().getBoolean("MultiplierToLevel." + type + "." + pathName + ".enabled")) {
            return item;
        }
        return null;
    }

    private ItemStack addCustomEnchant(String toolType, ItemStack item, Enchantment enchantment, int enchantmentLevel, String enchName) {
        ArrayList<Component> lores;
        ItemMeta itemMeta;
        block5: {
            itemMeta = item.getItemMeta();
            lores = new ArrayList<Component>();
            String pathName = WordUtils.capitalizeFully(enchantment.getKey().getKey().replaceAll("_", " ")).replaceAll(" ", "");
            int maxEnchantmentLevel = UpgradeableTools.PLUGIN.getConfig().getInt("MultiplierToLevel." + toolType + "." + pathName + ".MaximumLevel");
            lores.add(MiniMessage.miniMessage().deserialize((Object)("<gray>" + enchName + " " + maxEnchantmentLevel)));
            double enchantmentStart = UpgradeableTools.PLUGIN.getConfig().getDouble("MultiplierToLevel." + toolType + "." + pathName + ".Start");
            double enchantmentMultiplier = UpgradeableTools.PLUGIN.getConfig().getDouble("MultiplierToLevel." + toolType + "." + pathName + ".Multiplier");
            try {
                if (enchantmentLevel > 0) {
                    if (enchantmentLevel == maxEnchantmentLevel) {
                        itemMeta.displayName(MiniMessage.miniMessage().deserialize((Object)("<blue>" + enchName + " --- <green>" + maxEnchantmentLevel + "/" + maxEnchantmentLevel)));
                    } else {
                        double cost = (double)enchantmentLevel * enchantmentMultiplier * enchantmentStart;
                        lores.add(MiniMessage.miniMessage().deserialize((Object)"<blue> Cost: "));
                        lores.add(MiniMessage.miniMessage().deserialize((Object)("<yellow>" + cost)));
                        itemMeta.lore(lores);
                        itemMeta.displayName(MiniMessage.miniMessage().deserialize((Object)("<blue>" + enchName + " --- <dark_aqua>" + enchantmentLevel + "/" + maxEnchantmentLevel)));
                    }
                    break block5;
                }
                throw new Exception();
            }
            catch (Exception e) {
                lores.add(MiniMessage.miniMessage().deserialize((Object)"<blue>Cost: "));
                lores.add(MiniMessage.miniMessage().deserialize((Object)("<yellow>" + enchantmentStart)));
                itemMeta.lore(lores);
                itemMeta.displayName(MiniMessage.miniMessage().deserialize((Object)("<blue>" + enchName + " --- <dark_aqua>0/" + maxEnchantmentLevel)));
            }
        }
        item.setItemMeta(itemMeta);
        lores.clear();
        return item;
    }

    private ItemStack addEnchantment(ItemStack tool, String toolString, String enchPath, Enchantment enchantment, String displayName, ItemStack item) {
        ArrayList<Component> lores = new ArrayList<Component>();
        Map enchants = tool.getItemMeta().getEnchants();
        ItemMeta itemMeta = item.getItemMeta();
        Object path = this.checkPath(enchPath) ? "Common." : toolString + ".";
        path = "MultiplierToLevel." + (String)path + enchPath;
        int maxLevel = UpgradeableTools.PLUGIN.getConfig().getInt((String)path + ".MaximumLevel");
        double start = UpgradeableTools.PLUGIN.getConfig().getDouble((String)path + ".Start");
        double multiplier = UpgradeableTools.PLUGIN.getConfig().getDouble(enchPath + ".Multiplier");
        itemMeta.addEnchant(enchantment, maxLevel, true);
        if (enchants.containsKey(enchantment)) {
            if ((Integer)enchants.get(enchantment) == maxLevel) {
                itemMeta.displayName(MiniMessage.miniMessage().deserialize((Object)("<blue>" + displayName + " --- <green>" + maxLevel + "/" + maxLevel)));
            } else {
                double cost = (double)((Integer)enchants.get(enchantment)).intValue() * multiplier * start;
                lores.add(MiniMessage.miniMessage().deserialize((Object)"<blue>Cost: "));
                lores.add(MiniMessage.miniMessage().deserialize((Object)("<yellow>" + cost)));
                itemMeta.lore(lores);
                itemMeta.displayName(MiniMessage.miniMessage().deserialize((Object)("<blue>" + displayName + " --- <dark_aqua>" + String.valueOf(enchants.get(enchantment)) + "/" + maxLevel)));
            }
        } else {
            lores.add(MiniMessage.miniMessage().deserialize((Object)"<blue>Cost: "));
            lores.add(MiniMessage.miniMessage().deserialize((Object)("<yellow>" + start)));
            itemMeta.lore(lores);
            itemMeta.displayName(MiniMessage.miniMessage().deserialize((Object)("<blue>" + displayName + " --- <dark_aqua>0/" + maxLevel)));
        }
        item.setItemMeta(itemMeta);
        lores.clear();
        return item;
    }

    private boolean checkPath(String path) {
        return switch (path.toLowerCase()) {
            case "unbreaking", "efficiency", "mending", "fortune", "silktouch" -> true;
            default -> false;
        };
    }
}

