/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.Util.InventoryHolders;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashMap;
import me.marcangeloh.CustomEnchantments.CustomEnchants;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.Events.JobEvents;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.CheckerUtil;
import me.marcangeloh.Util.InvGUIStorage;
import me.marcangeloh.Util.InventoryHolders.SettingsGUI;
import me.marcangeloh.Util.InventoryUtil;
import me.marcangeloh.Util.MessengerUtil;
import me.marcangeloh.Util.PointsUtil;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.apache.commons.text.WordUtils;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class UpgradeGUI
implements InventoryHolder {
    private final Inventory inventory;
    private final HashMap<String, ItemStack> itemList;
    private final PointsUtil pointsUtil;
    int page;
    private final String branding;
    private final InventoryUtil inventoryUtil;

    public UpgradeGUI(UpgradeableTools plugin, ItemStack tool, InventoryUtil inventoryUtil, String branding, PointsUtil pointsUtil, Player p, HashMap<String, ItemStack> itemList) {
        this.inventoryUtil = inventoryUtil;
        this.branding = branding;
        this.pointsUtil = pointsUtil;
        this.page = 1;
        this.itemList = itemList;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 45, MiniMessage.miniMessage().deserialize((Object)String.format("%s%s p. %s", branding, UpgradeableTools.PLUGIN.getConfig().getString("InventoryTitles.UpgradeInventory"), this.page)));
        this.handleInventoryBuilder(tool, inventoryUtil, pointsUtil, p, this.page);
    }

    private void handleInventoryBuilder(ItemStack tool, InventoryUtil inventoryUtil, PointsUtil pointsUtil, Player p, int page) {
        ItemStack filler = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.displayName(MiniMessage.miniMessage().deserialize((Object)("<blue>Upgrade points: <yellow>" + String.format("%.2f", pointsUtil.checkForPoints(tool, p)))));
        filler.setItemMeta(fillerMeta);
        if (this.handleArmor(tool, inventoryUtil) && this.handleWeapons(tool, inventoryUtil) && this.handleTools(tool, inventoryUtil)) {
            Component toolComponent = tool.getItemMeta().displayName();
            if (toolComponent == null) {
                return;
            }
            MessengerUtil.notifyPlayer(p, "<red>You cannot upgrade " + PlainTextComponentSerializer.plainText().serialize(toolComponent));
            return;
        }
        if (inventoryUtil.getContents(page).isEmpty()) {
            return;
        }
        for (InvGUIStorage invGUIStorage : inventoryUtil.getContents(page)) {
            this.inventory.setItem(invGUIStorage.getIndex(), invGUIStorage.getStack());
        }
        inventoryUtil.reset();
        if (page > 1) {
            this.inventory.setItem(38, this.itemList.get("back"));
        }
        this.inventory.setItem(42, this.itemList.get("next"));
        this.inventory.setItem(40, this.itemList.get("settings"));
        this.inventory.setItem(22, tool);
        ItemStack[] contents = this.inventory.getContents();
        for (int x = 0; x < 45; ++x) {
            try {
                if (!contents[x].getType().equals((Object)Material.AIR)) continue;
                this.inventory.setItem(x, filler);
                continue;
            }
            catch (NullPointerException e) {
                this.inventory.setItem(x, filler);
            }
        }
    }

    private boolean handleArmor(ItemStack tool, InventoryUtil inventoryUtil) {
        return !this.handleBoots(tool, inventoryUtil) && !this.handleHelmet(tool, inventoryUtil) && !this.handleLeggings(tool, inventoryUtil) && !this.handleChestplate(tool, inventoryUtil);
    }

    private boolean handleWeapons(ItemStack tool, InventoryUtil inventoryUtil) {
        return !this.handleSwords(tool, inventoryUtil) && !this.handleBow(tool, inventoryUtil) && !this.handleTrident(tool, inventoryUtil) && !this.handleCrossbow(tool, inventoryUtil);
    }

    private boolean handleTools(ItemStack tool, InventoryUtil inventoryUtil) {
        return !this.handlePickaxe(tool, inventoryUtil) && !this.handleShovel(tool, inventoryUtil) && !this.handleAxe(tool, inventoryUtil) && !UpgradeGUI.handleFishing(tool, inventoryUtil) && !this.handleHoe(tool, inventoryUtil);
    }

    private boolean handleCrossbow(ItemStack tool, InventoryUtil inventoryUtil) {
        if (tool.getType().equals((Object)Material.CROSSBOW)) {
            inventoryUtil.addEnchantment(CustomEnchants.poisonShot, tool, Material.SPLASH_POTION, "Crossbow", "Poison Shot", 1, 7, true);
            inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.itemList.get("backpack"), "Crossbow", "Backpack", 1, 1, true);
            inventoryUtil.addEnchantment(Enchantment.MULTISHOT, tool, Material.ARROW, "Crossbow", "Multishot", 1, 10, false);
            inventoryUtil.addEnchantment(Enchantment.PIERCING, tool, Material.CHAINMAIL_CHESTPLATE, "Crossbow", "Piercing", 1, 19, false);
            inventoryUtil.addEnchantment(Enchantment.QUICK_CHARGE, tool, Material.RAIL, "Crossbow", "Quick Charge", 1, 16, false);
            inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Crossbow", "Soul Bound", 1, 13, true);
            inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Crossbow", "Unbreaking", 1, 25, false);
            inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Crossbow", "Mending", 1, 28, false);
            return true;
        }
        return false;
    }

    private boolean handleTrident(ItemStack tool, InventoryUtil inventoryUtil) {
        if (tool.getType().equals((Object)Material.TRIDENT)) {
            inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.itemList.get("backpack"), "Trident", "Backpack", 1, 1, true);
            inventoryUtil.addEnchantment(Enchantment.CHANNELING, tool, Material.END_CRYSTAL, "Trident", "Channeling", 1, 10, false);
            inventoryUtil.addEnchantment(Enchantment.IMPALING, tool, Material.ARROW, "Trident", "Impaling", 1, 19, false);
            inventoryUtil.addEnchantment(Enchantment.LOYALTY, tool, Material.WOLF_SPAWN_EGG, "Trident", "Loyalty", 1, 16, false);
            inventoryUtil.addEnchantment(Enchantment.RIPTIDE, tool, Material.ENDER_PEARL, "Trident", "Riptide", 1, 34, false);
            inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Trident", "Unbreaking", 1, 25, false);
            inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Trident", "Soul Bound", 1, 13, true);
            inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Trident", "Mending", 1, 28, false);
            return true;
        }
        return false;
    }

    private boolean handleChestplate(ItemStack tool, InventoryUtil inventoryUtil) {
        if (CheckerUtil.checkForChestplate(tool)) {
            inventoryUtil.addEnchantment(Enchantment.PROJECTILE_PROTECTION, tool, Material.ARROW, "Armor", "Projectile Protection", 1, 1, false);
            inventoryUtil.addCustomStack(CustomEnchants.secondChance, tool, this.itemList.get("secondChance"), "Armor", "Second Chance", 1, 4, true);
            inventoryUtil.addEnchantment(Enchantment.FIRE_PROTECTION, tool, Material.BLAZE_POWDER, "Armor", "Fire Protection", 1, 10, false);
            inventoryUtil.addEnchantment(Enchantment.BLAST_PROTECTION, tool, Material.TNT, "Armor", "Blast Protection", 1, 19, false);
            inventoryUtil.addEnchantment(Enchantment.PROTECTION, tool, Material.SHIELD, "Armor", "Protection", 1, 31, false);
            inventoryUtil.addEnchantment(Enchantment.THORNS, tool, Material.CACTUS, "Armor", "Thorns", 1, 23, false);
            inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Armor", "Soul Bound", 1, 13, true);
            inventoryUtil.addEnchantment(CustomEnchants.poisonTouch, tool, Material.SPLASH_POTION, "Armor", "Poison Touch", 1, 16, true);
            inventoryUtil.addEnchantment(CustomEnchants.explosiveTouch, tool, Material.TNT_MINECART, "Armor", "Explosive Touch", 1, 21, true);
            inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Armor", "Unbreaking", 1, 25, false);
            inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Armor", "Mending", 1, 28, false);
            inventoryUtil.addEnchantment(CustomEnchants.dupe, tool, Material.OAK_LOG, "Armor", "Dupe", 1, 34, true);
            return true;
        }
        return false;
    }

    private boolean handleLeggings(ItemStack tool, InventoryUtil inventoryUtil) {
        if (CheckerUtil.checkForLeggins(tool)) {
            inventoryUtil.addEnchantment(Enchantment.SWIFT_SNEAK, tool, Material.GOLDEN_APPLE, "Armor", "Swift Sneak", 1, 16, false);
            inventoryUtil.addEnchantment(Enchantment.PROJECTILE_PROTECTION, tool, Material.ARROW, "Armor", "Projectile Protection", 1, 1, false);
            inventoryUtil.addEnchantment(Enchantment.FIRE_PROTECTION, tool, Material.BLAZE_POWDER, "Armor", "Fire Protection", 1, 10, false);
            inventoryUtil.addEnchantment(Enchantment.BLAST_PROTECTION, tool, Material.TNT, "Armor", "Blast Protection", 1, 19, false);
            inventoryUtil.addEnchantment(Enchantment.PROTECTION, tool, Material.SHIELD, "Armor", "Protection", 1, 31, false);
            inventoryUtil.addEnchantment(Enchantment.THORNS, tool, Material.CACTUS, "Armor", "Thorns", 1, 23, false);
            inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Armor", "Soul Bound", 1, 13, true);
            inventoryUtil.addEnchantment(CustomEnchants.poisonTouch, tool, Material.SPLASH_POTION, "Armor", "Poison Touch", 1, 4, true);
            inventoryUtil.addEnchantment(CustomEnchants.explosiveTouch, tool, Material.TNT_MINECART, "Armor", "Explosive Touch", 1, 21, true);
            inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Armor", "Unbreaking", 1, 25, false);
            inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Armor", "Mending", 1, 28, false);
            return true;
        }
        return false;
    }

    private boolean handleHelmet(ItemStack tool, InventoryUtil inventoryUtil) {
        if (CheckerUtil.checkForHelmet(tool)) {
            inventoryUtil.addEnchantment(Enchantment.PROJECTILE_PROTECTION, tool, Material.ARROW, "Armor", "Projectile Protection", 1, 1, false);
            inventoryUtil.addEnchantment(Enchantment.FIRE_PROTECTION, tool, Material.BLAZE_POWDER, "Armor", "Fire Protection", 1, 10, false);
            inventoryUtil.addEnchantment(Enchantment.BLAST_PROTECTION, tool, Material.TNT, "Armor", "Blast Protection", 1, 19, false);
            inventoryUtil.addEnchantment(Enchantment.AQUA_AFFINITY, tool, Material.DIAMOND_PICKAXE, "Armor", "Aqua Affinity", 1, 16, false);
            inventoryUtil.addEnchantment(Enchantment.PROTECTION, tool, Material.SHIELD, "Armor", "Protection", 1, 31, false);
            inventoryUtil.addEnchantment(Enchantment.THORNS, tool, Material.CACTUS, "Armor", "Thorns", 1, 23, false);
            inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Armor", "Soul Bound", 1, 13, true);
            inventoryUtil.addEnchantment(CustomEnchants.poisonTouch, tool, Material.SPLASH_POTION, "Armor", "Poison Touch", 1, 7, true);
            inventoryUtil.addEnchantment(CustomEnchants.explosiveTouch, tool, Material.TNT_MINECART, "Armor", "Explosive Touch", 1, 4, true);
            inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Armor", "Unbreaking", 1, 25, false);
            inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Armor", "Mending", 1, 28, false);
            inventoryUtil.addEnchantment(Enchantment.RESPIRATION, tool, Material.TURTLE_SCUTE, "Armor", "Respiration", 1, 34, false);
            inventoryUtil.addEnchantment(CustomEnchants.nightVision, tool, Material.ENDER_EYE, "Armor", "Night Vision", 2, 1, true);
            inventoryUtil.addEnchantment(CustomEnchants.blink, tool, Material.ENDER_PEARL, "Armor", "Blink", 1, 21, true);
            return true;
        }
        return false;
    }

    private boolean handleBoots(ItemStack tool, InventoryUtil inventoryUtil) {
        if (CheckerUtil.checkForBoots(tool)) {
            inventoryUtil.addEnchantment(Enchantment.SOUL_SPEED, tool, Material.SOUL_CAMPFIRE, "Armor", "Soul Speed", 2, 4, false);
            inventoryUtil.addEnchantment(Enchantment.PROJECTILE_PROTECTION, tool, Material.ARROW, "Armor", "Projectile Protection", 1, 1, false);
            inventoryUtil.addEnchantment(Enchantment.FIRE_PROTECTION, tool, Material.BLAZE_POWDER, "Armor", "Fire Protection", 1, 10, false);
            inventoryUtil.addEnchantment(Enchantment.BLAST_PROTECTION, tool, Material.TNT, "Armor", "Blast Protection", 1, 19, false);
            inventoryUtil.addEnchantment(Enchantment.DEPTH_STRIDER, tool, Material.ACACIA_BOAT, "Armor", "Depth Strider", 1, 16, false);
            inventoryUtil.addEnchantment(Enchantment.FEATHER_FALLING, tool, Material.FEATHER, "Armor", "Feather Falling", 1, 34, false);
            inventoryUtil.addEnchantment(Enchantment.FROST_WALKER, tool, Material.ICE, "Armor", "Frost Walker", 1, 13, false);
            inventoryUtil.addEnchantment(Enchantment.PROTECTION, tool, Material.SHIELD, "Armor", "Protection", 1, 31, false);
            inventoryUtil.addEnchantment(Enchantment.THORNS, tool, Material.CACTUS, "Armor", "Thorns", 1, 23, false);
            inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Armor", "Soul Bound", 1, 21, true);
            inventoryUtil.addEnchantment(CustomEnchants.poisonTouch, tool, Material.SPLASH_POTION, "Armor", "Poison Touch", 1, 7, true);
            inventoryUtil.addEnchantment(CustomEnchants.explosiveTouch, tool, Material.TNT_MINECART, "Armor", "Explosive Touch", 2, 1, true);
            inventoryUtil.addEnchantment(CustomEnchants.speed, tool, Material.MINECART, "Armor", "Speed", 1, 4, true);
            inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Armor", "Unbreaking", 1, 25, false);
            inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Armor", "Mending", 1, 28, false);
            return true;
        }
        return false;
    }

    private boolean handleBow(ItemStack tool, InventoryUtil inventoryUtil) {
        if (tool.getType().equals((Object)Material.BOW)) {
            inventoryUtil.addEnchantment(CustomEnchants.poisonShot, tool, Material.SPLASH_POTION, "Bow", "Poison Shot", 1, 7, true);
            inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.itemList.get("backpack"), "Bow", "Backpack", 1, 1, true);
            inventoryUtil.addEnchantment(Enchantment.FLAME, tool, Material.FIRE_CHARGE, "Bow", "Flame", 1, 10, false);
            inventoryUtil.addEnchantment(Enchantment.INFINITY, tool, Material.ARROW, "Bow", "Infinity", 1, 19, false);
            inventoryUtil.addEnchantment(Enchantment.PUNCH, tool, Material.PISTON, "Bow", "Punch", 1, 16, false);
            inventoryUtil.addEnchantment(Enchantment.POWER, tool, Material.ANVIL, "Bow", "Power", 1, 34, false);
            inventoryUtil.addEnchantment(CustomEnchants.explosive, tool, Material.TNT, "Bow", "Explosive", 1, 31, true);
            inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Bow", "Soul Bound", 1, 13, true);
            inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Bow", "Unbreaking", 1, 25, false);
            inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Bow", "Mending", 1, 28, false);
            return true;
        }
        return false;
    }

    private boolean handleHoe(ItemStack tool, InventoryUtil inventoryUtil) {
        if (CheckerUtil.checkForHoe(tool)) {
            inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.itemList.get("backpack"), "Hoe", "Backpack", 1, 1, true);
            inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Hoe", "Soul Bound", 1, 13, true);
            inventoryUtil.addEnchantment(CustomEnchants.massPlanter, tool, Material.DISPENSER, "Hoe", "Mass Planter", 1, 19, true);
            inventoryUtil.addEnchantment(CustomEnchants.massHarvester, tool, Material.WHEAT, "Hoe", "Mass Harvester", 1, 25, true);
            inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Hoe", "Unbreaking", 1, 10, false);
            inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Hoe", "Mending", 1, 16, false);
            return true;
        }
        return false;
    }

    private boolean handleSwords(ItemStack tool, InventoryUtil inventoryUtil) {
        if (CheckerUtil.checkForSwords(tool)) {
            inventoryUtil.addEnchantment(CustomEnchants.confusion, tool, Material.SCULK_SENSOR, "Swords", "Confusion", 2, 13, true);
            inventoryUtil.addCustomStack(CustomEnchants.spook, tool, this.itemList.get("spook"), "Swords", "Spook", 2, 7, true);
            inventoryUtil.addEnchantment(CustomEnchants.freeze, tool, Material.SNOWBALL, "Swords", "Freeze", 2, 4, true);
            inventoryUtil.addCustomStack(CustomEnchants.bleed, tool, this.itemList.get("bleed"), "Swords", "Bleed", 2, 1, true);
            inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.itemList.get("backpack"), "Swords", "Backpack", 1, 20, true);
            inventoryUtil.addEnchantment(CustomEnchants.mendWalker, tool, Material.ELYTRA, "Swords", "Mend-Walker", 1, 21, true);
            inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Swords", "Soul Bound", 1, 4, true);
            inventoryUtil.addEnchantment(CustomEnchants.lifeSteal, tool, Material.TOTEM_OF_UNDYING, "Swords", "Life Steal", 1, 13, true);
            inventoryUtil.addEnchantment(CustomEnchants.shockwave, tool, Material.REDSTONE, "Swords", "Shockwave", 1, 31, true);
            inventoryUtil.addEnchantment(Enchantment.SHARPNESS, tool, Material.CACTUS, "Swords", "Sharpness", 1, 1, false);
            inventoryUtil.addEnchantment(Enchantment.FIRE_ASPECT, tool, Material.FIRE_CHARGE, "Swords", "Fire Aspect", 1, 10, false);
            inventoryUtil.addEnchantment(Enchantment.LOOTING, tool, Material.BUCKET, "Swords", "Looting", 1, 19, false);
            inventoryUtil.addEnchantment(Enchantment.SWEEPING_EDGE, tool, Material.IRON_HOE, "Swords", "Sweeping Edge", 1, 34, false);
            inventoryUtil.addEnchantment(Enchantment.SMITE, tool, Material.BONE, "Swords", "Smite", 1, 23, false);
            inventoryUtil.addEnchantment(Enchantment.BANE_OF_ARTHROPODS, tool, Material.SPIDER_EYE, "Swords", "Bane Of Arthropods", 1, 7, false);
            inventoryUtil.addEnchantment(Enchantment.KNOCKBACK, tool, Material.DISPENSER, "Swords", "Knockback", 1, 16, false);
            inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Swords", "Unbreaking", 1, 25, false);
            inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Swords", "Mending", 1, 28, false);
            inventoryUtil.addEnchantment(CustomEnchants.decapitation, tool, Material.SKELETON_SKULL, "Swords", "Decapitation", 1, 24, true);
            return true;
        }
        return false;
    }

    private static boolean handleFishing(ItemStack tool, InventoryUtil inventoryUtil) {
        if (tool.getType().equals((Object)Material.FISHING_ROD)) {
            inventoryUtil.addEnchantment(Enchantment.LUCK_OF_THE_SEA, tool, Material.RABBIT_FOOT, "FishingRod", "Luck Of The Sea", 1, 16, false);
            inventoryUtil.addEnchantment(Enchantment.LURE, tool, Material.COD_BUCKET, "FishingRod", "Lure", 1, 10, false);
            inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "FishingRod", "Mending", 1, 28, false);
            inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "FishingRod", "Unbreaking", 1, 34, false);
            inventoryUtil.addEnchantment(CustomEnchants.mendWalker, tool, Material.ELYTRA, "FishingRod", "Mend-Walker", 1, 31, true);
            inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "FishingRod", "Soul Bound", 1, 13, true);
            return true;
        }
        return false;
    }

    private boolean handleAxe(ItemStack tool, InventoryUtil inventoryUtil) {
        if (CheckerUtil.checkForAxe(tool)) {
            inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.itemList.get("backpack"), "Axe", "Backpack", 1, 1, true);
            inventoryUtil.addEnchantment(CustomEnchants.autoEquip, tool, Material.BEACON, "Axe", "Auto Equip", 1, 23, true);
            inventoryUtil.addEnchantment(Enchantment.EFFICIENCY, tool, Material.REDSTONE, "Axe", "Efficiency", 1, 10, false);
            inventoryUtil.addEnchantment(Enchantment.SILK_TOUCH, tool, Material.FEATHER, "Axe", "Silk Touch", 1, 16, false);
            inventoryUtil.addEnchantment(Enchantment.FORTUNE, tool, Material.EMERALD, "Axe", "Fortune", 1, 19, false);
            inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Axe", "Unbreaking", 1, 25, false);
            inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Axe", "Mending", 1, 28, false);
            inventoryUtil.addEnchantment(CustomEnchants.mendWalker, tool, Material.ELYTRA, "Axe", "Mend-Walker", 1, 31, true);
            inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Axe", "Soul Bound", 1, 13, true);
            inventoryUtil.addEnchantment(CustomEnchants.fell, tool, Material.STONECUTTER, "Axe", "Soul Bound", 1, 31, true);
            inventoryUtil.addEnchantment(CustomEnchants.magnetic, tool, Material.HOPPER, "Axe", "Magnetic", 1, 21, true);
            return true;
        }
        return false;
    }

    private boolean handleShovel(ItemStack tool, InventoryUtil inventoryUtil) {
        if (CheckerUtil.checkForShovel(tool)) {
            inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.itemList.get("backpack"), "Shovel", "Backpack", 1, 1, true);
            inventoryUtil.addEnchantment(CustomEnchants.autoEquip, tool, Material.BEACON, "Shovel", "Auto Equip", 1, 23, true);
            inventoryUtil.addEnchantment(CustomEnchants.blastExcavating, tool, Material.TNT, "Shovel", "Blast Excavating", 1, 34, true);
            inventoryUtil.addEnchantment(CustomEnchants.luck, tool, Material.RABBIT_FOOT, "Shovel", "Luck", 1, 31, true);
            inventoryUtil.addEnchantment(CustomEnchants.magnetic, tool, Material.HOPPER, "Shovel", "Magnetic", 1, 21, true);
            inventoryUtil.addEnchantment(Enchantment.EFFICIENCY, tool, Material.REDSTONE, "Shovel", "Efficiency", 1, 10, false);
            inventoryUtil.addEnchantment(Enchantment.SILK_TOUCH, tool, Material.FEATHER, "Shovel", "Silk Touch", 1, 16, false);
            inventoryUtil.addEnchantment(Enchantment.FORTUNE, tool, Material.EMERALD, "Shovel", "Fortune", 1, 19, false);
            inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Shovel", "Unbreaking", 1, 25, false);
            inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Shovel", "Mending", 1, 28, false);
            inventoryUtil.addEnchantment(CustomEnchants.mendWalker, tool, Material.ELYTRA, "Shovel", "Mend-Walker", 1, 31, true);
            inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Shovel", "Soul Bound", 1, 13, true);
            return true;
        }
        return false;
    }

    private boolean handlePickaxe(ItemStack tool, InventoryUtil inventoryUtil) {
        if (CheckerUtil.checkForPickaxe(tool)) {
            inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.itemList.get("backpack"), "Pickaxe", "Backpack", 1, 7, true);
            inventoryUtil.addEnchantment(CustomEnchants.autoEquip, tool, Material.BEACON, "Pickaxe", "Auto Equip", 1, 1, true);
            inventoryUtil.addEnchantment(CustomEnchants.drain, tool, Material.SPONGE, "Pickaxe", "Drain", 1, 13, true);
            inventoryUtil.addEnchantment(CustomEnchants.blastMining, tool, Material.TNT, "Pickaxe", "Blast Mining", 1, 34, true);
            inventoryUtil.addEnchantment(CustomEnchants.magnetic, tool, Material.HOPPER, "Pickaxe", "Magnetic", 1, 21, true);
            inventoryUtil.addEnchantment(Enchantment.EFFICIENCY, tool, Material.REDSTONE, "Pickaxe", "Efficiency", 1, 10, false);
            inventoryUtil.addEnchantment(Enchantment.SILK_TOUCH, tool, Material.FEATHER, "Pickaxe", "Silk Touch", 1, 16, false);
            inventoryUtil.addEnchantment(Enchantment.FORTUNE, tool, Material.EMERALD, "Pickaxe", "Fortune", 1, 19, false);
            inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Pickaxe", "Unbreaking", 1, 25, false);
            inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Pickaxe", "Mending", 1, 28, false);
            inventoryUtil.addEnchantment(CustomEnchants.smelter, tool, Material.FURNACE, "Pickaxe", "Smelter", 1, 23, true);
            inventoryUtil.addEnchantment(CustomEnchants.mendWalker, tool, Material.ELYTRA, "Pickaxe", "Mend-Walker", 1, 31, true);
            inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Pickaxe", "Soul Bound", 1, 4, true);
            return true;
        }
        return false;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void handleClick(InventoryClickEvent e, Player player, String currentItemName, HashMap<Player, Boolean> giveBack) {
        e.setCancelled(true);
        ItemStack item = e.getClickedInventory().getItem(22);
        if (item == null) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta.getEnchants().size() >= 2) {
            if (!CheckerUtil.checkForHelmet(item)) {
                if (itemMeta.hasEnchant(Enchantment.AQUA_AFFINITY)) {
                    itemMeta.removeEnchant(Enchantment.AQUA_AFFINITY);
                    itemMeta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    item.setItemMeta(itemMeta);
                }
            } else if (itemMeta.hasEnchant(Enchantment.SHARPNESS)) {
                itemMeta.removeEnchant(Enchantment.SHARPNESS);
                itemMeta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                item.setItemMeta(itemMeta);
            }
        }
        switch (e.getCurrentItem().getType()) {
            case BEACON: {
                this.addToInventoryClickEvent(CustomEnchants.autoEquip, "AutoEquip", player, item, giveBack);
                break;
            }
            case HOPPER: {
                this.addToInventoryClickEvent(CustomEnchants.magnetic, "Magnetic", player, item, giveBack);
                break;
            }
            case MINECART: {
                this.addToInventoryClickEvent(CustomEnchants.speed, "Speed", player, item, giveBack);
                break;
            }
            case SKELETON_SKULL: {
                this.addToInventoryClickEvent(CustomEnchants.decapitation, "Decapitation", player, item, giveBack);
                break;
            }
            case TURTLE_SCUTE: {
                this.addToInventoryClickEvent(Enchantment.RESPIRATION, "Respiration", player, item, giveBack);
                break;
            }
            case DIAMOND_PICKAXE: {
                this.addToInventoryClickEvent(Enchantment.AQUA_AFFINITY, "AquaAffinity", player, item, giveBack);
                break;
            }
            case ICE: {
                if (!CheckerUtil.checkForBoots(item)) break;
                this.addToInventoryClickEvent(Enchantment.FROST_WALKER, "FrostWalker", player, item, giveBack);
                break;
            }
            case SHIELD: {
                this.addToInventoryClickEvent(Enchantment.PROTECTION, "Protection", player, item, giveBack);
                break;
            }
            case ACACIA_BOAT: {
                if (!CheckerUtil.checkForBoots(item)) break;
                this.addToInventoryClickEvent(Enchantment.DEPTH_STRIDER, "DepthStrider", player, item, giveBack);
                break;
            }
            case BLAZE_POWDER: {
                this.addToInventoryClickEvent(Enchantment.FIRE_PROTECTION, "FireProtection", player, item, giveBack);
                break;
            }
            case SPONGE: {
                if (!CheckerUtil.checkForPickaxe(item)) break;
                this.addToInventoryClickEvent(CustomEnchants.drain, "Drain", player, item, giveBack);
                break;
            }
            case SOUL_LANTERN: {
                this.addToInventoryClickEvent(CustomEnchants.soulBound, "SoulBound", player, item, giveBack);
                break;
            }
            case ELYTRA: {
                this.addToInventoryClickEvent(CustomEnchants.mendWalker, "MendWalker", player, item, giveBack);
                break;
            }
            case FURNACE: {
                this.addToInventoryClickEvent(CustomEnchants.smelter, "Smelter", player, item, giveBack);
                break;
            }
            case TNT: {
                if (CheckerUtil.checkForPickaxe(item)) {
                    this.addToInventoryClickEvent(CustomEnchants.blastMining, "BlastMining", player, item, giveBack);
                    break;
                }
                if (CheckerUtil.checkForShovel(item)) {
                    this.addToInventoryClickEvent(CustomEnchants.blastExcavating, "BlastExcavating", player, item, giveBack);
                    break;
                }
                if (item.getType().equals((Object)Material.BOW)) {
                    this.addToInventoryClickEvent(CustomEnchants.explosive, "Explosive", player, item, giveBack);
                    break;
                }
                this.addToInventoryClickEvent(Enchantment.BLAST_PROTECTION, "BlastProtection", player, item, giveBack);
                break;
            }
            case TNT_MINECART: {
                this.addToInventoryClickEvent(CustomEnchants.explosiveTouch, "ExplosiveTouch", player, item, giveBack);
                break;
            }
            case SPLASH_POTION: {
                if (currentItemName.contains("Poison Touch")) {
                    this.addToInventoryClickEvent(CustomEnchants.poisonTouch, "PoisonTouch", player, item, giveBack);
                    break;
                }
                if (!currentItemName.contains("Poison Shot")) break;
                this.addToInventoryClickEvent(CustomEnchants.poisonShot, "PoisonShot", player, item, giveBack);
                break;
            }
            case TOTEM_OF_UNDYING: {
                this.addToInventoryClickEvent(CustomEnchants.lifeSteal, "LifeSteal", player, item, giveBack);
                break;
            }
            case REDSTONE: {
                if (CheckerUtil.checkForTools(item)) {
                    this.addToInventoryClickEvent(Enchantment.EFFICIENCY, "Efficiency", player, item, giveBack);
                    break;
                }
                if (!CheckerUtil.checkForSwords(item)) break;
                this.addToInventoryClickEvent(CustomEnchants.shockwave, "Shockwave", player, item, giveBack);
                break;
            }
            case SCULK_SENSOR: {
                this.addToInventoryClickEvent(CustomEnchants.confusion, "Confusion", player, item, giveBack);
                break;
            }
            case FEATHER: {
                if (item.getEnchantmentLevel(Enchantment.FORTUNE) == 0) {
                    if (CheckerUtil.checkForPickaxe(item)) {
                        this.addToInventoryClickEvent(Enchantment.SILK_TOUCH, "SilkTouch", player, item, giveBack);
                    } else if (CheckerUtil.checkForAxe(item)) {
                        this.addToInventoryClickEvent(Enchantment.SILK_TOUCH, "SilkTouch", player, item, giveBack);
                    } else if (CheckerUtil.checkForShovel(item)) {
                        this.addToInventoryClickEvent(Enchantment.SILK_TOUCH, "SilkTouch", player, item, giveBack);
                    }
                } else {
                    MessengerUtil.notifyPlayer(player, "<red>You cannot enchant Fortune and Silk Touch");
                }
                if (!CheckerUtil.checkForBoots(item)) break;
                this.addToInventoryClickEvent(Enchantment.FEATHER_FALLING, "FeatherFalling", player, item, giveBack);
                break;
            }
            case EMERALD: {
                if (item.getEnchantmentLevel(Enchantment.SILK_TOUCH) == 0) {
                    if (CheckerUtil.checkForPickaxe(item)) {
                        this.addToInventoryClickEvent(Enchantment.FORTUNE, "Fortune", player, item, giveBack);
                        break;
                    }
                    if (CheckerUtil.checkForAxe(item)) {
                        this.addToInventoryClickEvent(Enchantment.FORTUNE, "Fortune", player, item, giveBack);
                        break;
                    }
                    if (!CheckerUtil.checkForShovel(item)) break;
                    this.addToInventoryClickEvent(Enchantment.FORTUNE, "Fortune", player, item, giveBack);
                    break;
                }
                MessengerUtil.notifyPlayer(player, "<red>You can't have fortune and silk touch on the same tool.");
                break;
            }
            case BEDROCK: {
                this.addToInventoryClickEvent(Enchantment.UNBREAKING, "Unbreaking", player, item, giveBack);
                break;
            }
            case EXPERIENCE_BOTTLE: {
                if (CheckerUtil.checkForBow(item) && (item.containsEnchantment(Enchantment.INFINITY) || item.containsEnchantment(Enchantment.POWER))) {
                    MessengerUtil.notifyPlayer(player, "<red>Cannot enchant due to a conflicting enchantment.");
                    break;
                }
                this.addToInventoryClickEvent(Enchantment.MENDING, "Mending", player, item, giveBack);
                break;
            }
            case COD_BUCKET: {
                if (!item.getType().equals((Object)Material.FISHING_ROD)) break;
                if (item.getEnchantmentLevel(Enchantment.LURE) + 1 > 5) {
                    MessengerUtil.notifyPlayer(player, "<red>Due to the games limitations, 5 is the maximum level for luck of the sea.");
                    return;
                }
                this.addToInventoryClickEvent(Enchantment.LURE, "Lure", player, item, giveBack);
                break;
            }
            case RABBIT_FOOT: {
                if (item.getType().equals((Object)Material.FISHING_ROD)) {
                    if (item.getEnchantmentLevel(Enchantment.LUCK_OF_THE_SEA) + 1 > 5) {
                        MessengerUtil.notifyPlayer(player, "<red>Due to the games limitations, 5 is the maximum level for luck of the sea.");
                        return;
                    }
                    this.addToInventoryClickEvent(Enchantment.LUCK_OF_THE_SEA, "LuckOfTheSea", player, item, giveBack);
                    break;
                }
                if (!CheckerUtil.checkForShovel(item)) break;
                this.addToInventoryClickEvent(CustomEnchants.luck, "Luck", player, item, giveBack);
                break;
            }
            case PISTON: {
                if (!CheckerUtil.checkForBow(item)) break;
                this.addToInventoryClickEvent(Enchantment.PUNCH, "Punch", player, item, giveBack);
                break;
            }
            case ANVIL: {
                if (!CheckerUtil.checkForBow(item)) break;
                if (item.containsEnchantment(Enchantment.MENDING) || item.containsEnchantment(Enchantment.INFINITY)) {
                    MessengerUtil.notifyPlayer(player, "<red>Cannot enchant due to a conflicting enchantment.");
                    break;
                }
                this.addToInventoryClickEvent(Enchantment.POWER, "Power", player, item, giveBack);
                break;
            }
            case CACTUS: {
                if (CheckerUtil.checkForSwords(item)) {
                    this.addToInventoryClickEvent(Enchantment.SHARPNESS, "Sharpness", player, item, giveBack);
                    break;
                }
                this.addToInventoryClickEvent(Enchantment.THORNS, "Thorns", player, item, giveBack);
                break;
            }
            case FIRE_CHARGE: {
                if (CheckerUtil.checkForSwords(item)) {
                    this.addToInventoryClickEvent(Enchantment.FIRE_ASPECT, "FireAspect", player, item, giveBack);
                    break;
                }
                if (!item.getType().equals((Object)Material.BOW)) break;
                this.addToInventoryClickEvent(Enchantment.FLAME, "Flame", player, item, giveBack);
                break;
            }
            case BUCKET: {
                if (!CheckerUtil.checkForSwords(item)) break;
                this.addToInventoryClickEvent(Enchantment.LOOTING, "Looting", player, item, giveBack);
                break;
            }
            case ARROW: {
                if (item.getType().equals((Object)Material.BOW)) {
                    if (item.containsEnchantment(Enchantment.MENDING) || item.containsEnchantment(Enchantment.POWER)) {
                        MessengerUtil.notifyPlayer(player, "<red>Cannot enchant due to a conflicting enchantment.");
                        break;
                    }
                    this.addToInventoryClickEvent(Enchantment.INFINITY, "Infinity", player, item, giveBack);
                    break;
                }
                if (item.getType().equals((Object)Material.TRIDENT)) {
                    this.addToInventoryClickEvent(Enchantment.IMPALING, "Impaling", player, item, giveBack);
                    break;
                }
                if (item.getType().equals((Object)Material.CROSSBOW)) {
                    this.addToInventoryClickEvent(Enchantment.MULTISHOT, "Multishot", player, item, giveBack);
                    break;
                }
                this.addToInventoryClickEvent(Enchantment.PROJECTILE_PROTECTION, "ProjectileProtection", player, item, giveBack);
                break;
            }
            case BONE: {
                if (!CheckerUtil.checkForSwords(item)) break;
                this.addToInventoryClickEvent(Enchantment.SMITE, "Smite", player, item, giveBack);
                break;
            }
            case SPIDER_EYE: {
                if (!CheckerUtil.checkForSwords(item)) break;
                this.addToInventoryClickEvent(Enchantment.BANE_OF_ARTHROPODS, "BaneOfArthropods", player, item, giveBack);
                break;
            }
            case DISPENSER: {
                if (CheckerUtil.checkForSwords(item)) {
                    this.addToInventoryClickEvent(Enchantment.KNOCKBACK, "Knockback", player, item, giveBack);
                    break;
                }
                if (!CheckerUtil.checkForHoe(item)) break;
                this.addToInventoryClickEvent(CustomEnchants.massPlanter, "MassPlanter", player, item, giveBack);
                break;
            }
            case CHAINMAIL_CHESTPLATE: {
                if (!item.getType().equals((Object)Material.CROSSBOW)) break;
                this.addToInventoryClickEvent(Enchantment.PIERCING, "Piercing", player, item, giveBack);
                break;
            }
            case RAIL: {
                if (!item.getType().equals((Object)Material.CROSSBOW)) break;
                this.addToInventoryClickEvent(Enchantment.QUICK_CHARGE, "QuickCharge", player, item, giveBack);
                break;
            }
            case IRON_HOE: {
                if (!CheckerUtil.checkForSwords(item)) break;
                this.addToInventoryClickEvent(Enchantment.SWEEPING_EDGE, "SweepingEdge", player, item, giveBack);
                break;
            }
            case WOLF_SPAWN_EGG: {
                if (!item.getType().equals((Object)Material.TRIDENT)) break;
                if (item.containsEnchantment(Enchantment.RIPTIDE)) {
                    MessengerUtil.notifyPlayer(player, "<red>You can't have riptide and loyalty on the same tool.");
                    return;
                }
                this.addToInventoryClickEvent(Enchantment.LOYALTY, "Loyalty", player, item, giveBack);
                break;
            }
            case END_CRYSTAL: {
                if (!item.getType().equals((Object)Material.TRIDENT)) break;
                this.addToInventoryClickEvent(Enchantment.CHANNELING, "Channeling", player, item, giveBack);
                break;
            }
            case ENDER_PEARL: {
                if (item.getType().equals((Object)Material.TRIDENT)) {
                    if (item.containsEnchantment(Enchantment.LOYALTY)) {
                        MessengerUtil.notifyPlayer(player, "<red>You can't have riptide and loyalty on the same tool.");
                        return;
                    }
                    this.addToInventoryClickEvent(Enchantment.RIPTIDE, "Riptide", player, item, giveBack);
                    break;
                }
                if (!CheckerUtil.checkForHelmet(item)) break;
                this.addToInventoryClickEvent(CustomEnchants.blink, "Blink", player, item, giveBack);
                break;
            }
            case ENDER_EYE: {
                this.addToInventoryClickEvent(CustomEnchants.nightVision, "NightVision", player, item, giveBack);
                break;
            }
            case STONECUTTER: {
                this.addToInventoryClickEvent(CustomEnchants.fell, "Fell", player, item, giveBack);
                break;
            }
            case OAK_LOG: {
                this.addToInventoryClickEvent(CustomEnchants.dupe, "Dupe", player, item, giveBack);
            }
            case WHEAT: {
                this.addToInventoryClickEvent(CustomEnchants.massHarvester, "MassHarvester", player, item, giveBack);
                break;
            }
            case SNOWBALL: {
                if (!CheckerUtil.checkForSwords(item)) break;
                this.addToInventoryClickEvent(CustomEnchants.freeze, "Freeze", player, item, giveBack);
                break;
            }
            case PLAYER_HEAD: {
                if (currentItemName.contains("Settings")) {
                    giveBack.put(player, false);
                    player.closeInventory();
                    giveBack.put(player, true);
                    this.openSettingsGUI(player, item);
                    break;
                }
                if (e.getCurrentItem().equals((Object)this.itemList.get("backpack"))) {
                    this.addToInventoryClickEvent(CustomEnchants.backpack, "Backpack", player, item, giveBack);
                    break;
                }
                if (currentItemName.contains(UpgradeableTools.PLUGIN.getConfig().getString("MultiplierToLevel.Armor.SecondChance.name", "Second Chance"))) {
                    this.addToInventoryClickEvent(CustomEnchants.secondChance, "SecondChance", player, item, giveBack);
                    break;
                }
                if (currentItemName.contains(UpgradeableTools.PLUGIN.getConfig().getString("MultiplierToLevel.Swords.Bleed.name", "Bleed"))) {
                    this.addToInventoryClickEvent(CustomEnchants.bleed, "Bleed", player, item, giveBack);
                    break;
                }
                if (currentItemName.contains(UpgradeableTools.PLUGIN.getConfig().getString("MultiplierToLevel.Swords.Spook.name", "Spook"))) {
                    this.addToInventoryClickEvent(CustomEnchants.spook, "Spook", player, item, giveBack);
                    break;
                }
                if (currentItemName.contains("Next Page")) {
                    ++this.page;
                    giveBack.put(player, false);
                    this.handleInventoryBuilder(item, this.inventoryUtil, this.pointsUtil, player, this.page);
                    player.openInventory(this.getInventory());
                    giveBack.put(player, true);
                    break;
                }
                if (!currentItemName.contains("Back")) break;
                --this.page;
                giveBack.put(player, false);
                this.handleInventoryBuilder(item, this.inventoryUtil, this.pointsUtil, player, this.page);
                player.openInventory(this.getInventory());
                giveBack.put(player, true);
                break;
            }
            case SOUL_CAMPFIRE: {
                this.addToInventoryClickEvent(Enchantment.SOUL_SPEED, "SoulSpeed", player, item, giveBack);
                break;
            }
            case GOLDEN_APPLE: {
                this.addToInventoryClickEvent(Enchantment.SWIFT_SNEAK, "SwiftSneak", player, item, giveBack);
                break;
            }
        }
    }

    private void openSettingsGUI(Player p, ItemStack tool) {
        SettingsGUI settingsGUI = new SettingsGUI(p, this.pointsUtil, tool, this.branding, this.itemList);
        p.openInventory(settingsGUI.getInventory());
    }

    private void processInventoryClickEvent(Enchantment enchantment, ItemStack tool, int level, Player player, HashMap<Player, Boolean> giveBack) {
        if (tool.containsEnchantment(enchantment)) {
            tool.removeEnchantment(enchantment);
        }
        tool.addUnsafeEnchantment(enchantment, ++level);
        giveBack.put(player, false);
        this.handleInventoryBuilder(tool, this.inventoryUtil, this.pointsUtil, player, this.page);
        player.openInventory(this.getInventory());
        giveBack.put(player, true);
    }

    public void addToInventoryClickEvent(AbstractCustomEnchantment abstractEnchant, String path, Player player, ItemStack tool, HashMap<Player, Boolean> giveBack) {
        Enchantment enchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + abstractEnchant.getKey())));
        this.addToInventoryClickEvent(enchantment, path, player, tool, giveBack);
    }

    public void addToInventoryClickEvent(Enchantment enchantment, String path, Player player, ItemStack tool, HashMap<Player, Boolean> giveBack) {
        int level = 0;
        if (tool.getItemMeta().getEnchants().containsKey(enchantment)) {
            level = (Integer)tool.getItemMeta().getEnchants().get(enchantment);
        }
        if (CheckerUtil.checkForPickaxe(tool)) {
            this.handleAll(player, tool, level, this.checkPath(path) ? "Common." + path : "Pickaxe." + path, enchantment, JobEvents.pickaxePoints, giveBack);
        } else if (CheckerUtil.checkForShovel(tool)) {
            this.handleAll(player, tool, level, this.checkPath(path) ? "Common." + path : "Shovel." + path, enchantment, JobEvents.shovelPoints, giveBack);
        } else if (CheckerUtil.checkForAxe(tool)) {
            this.handleAll(player, tool, level, this.checkPath(path) ? "Common." + path : "Axe." + path, enchantment, JobEvents.axePoints, giveBack);
        } else if (tool.getType().equals((Object)Material.FISHING_ROD)) {
            this.handleAll(player, tool, level, this.checkPath(path) ? "Common." + path : "FishingRod." + path, enchantment, JobEvents.fishingPoints, giveBack);
        } else if (CheckerUtil.checkForHoe(tool)) {
            this.handleAll(player, tool, level, this.checkPath(path) ? "Common." + path : "Hoe." + path, enchantment, JobEvents.hoePoints, giveBack);
        } else if (CheckerUtil.checkForWeapons(tool)) {
            String truePath;
            String string = truePath = this.checkPath(path) ? "Common." + path : "Swords." + path;
            if (tool.getType().equals((Object)Material.BOW)) {
                truePath = this.checkPath(path) ? "Common." + path : "Bow." + path;
            } else if (tool.getType().equals((Object)Material.TRIDENT)) {
                truePath = this.checkPath(path) ? "Common." + path : "Trident." + path;
            } else if (tool.getType().equals((Object)Material.CROSSBOW)) {
                truePath = this.checkPath(path) ? "Common." + path : "Crossbow." + path;
            }
            this.handleAll(player, tool, level, truePath, enchantment, JobEvents.weaponPoints, giveBack);
        } else if (CheckerUtil.checkForArmor(tool)) {
            this.handleAll(player, tool, level, this.checkPath(path) ? "Common." + path : "Armor." + path, enchantment, JobEvents.armorPoints, giveBack);
        }
    }

    private boolean checkPath(String path) {
        return switch (path.toLowerCase()) {
            case "unbreaking", "efficiency", "mending", "fortune", "silktouch" -> true;
            default -> false;
        };
    }

    private void handleAll(Player player, ItemStack tool, int level, String path, Enchantment enchantment, HashMap<String, Double> points, HashMap<Player, Boolean> giveBack) {
        String name = UpgradeableTools.PLUGIN.getConfig().getString("MultiplierToLevel." + path + ".name", WordUtils.capitalizeFully(enchantment.getKey().getKey().replaceAll("_", " ")));
        if (level <= 0) {
            try {
                level = tool.getEnchantmentLevel(enchantment);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                MessengerUtil.notifyConsole(e.getMessage());
                level = tool.getItemMeta().getEnchantLevel(enchantment);
            }
        }
        if (level <= 0) {
            level = 0;
        }
        if (!CheckerUtil.checkEnchantmentPermission(player, enchantment, level)) {
            return;
        }
        this.handlePoints(player, tool, level, path, enchantment, points, giveBack);
    }

    private void handlePoints(Player player, ItemStack tool, int level, String path, Enchantment enchantment, HashMap<String, Double> points, HashMap<Player, Boolean> giveBack) {
        int maxLevel = UpgradeableTools.PLUGIN.getConfig().getInt("MultiplierToLevel." + path + ".MaximumLevel");
        double start = UpgradeableTools.PLUGIN.getConfig().getDouble("MultiplierToLevel." + path + ".Start");
        double multiplier = UpgradeableTools.PLUGIN.getConfig().getDouble("MultiplierToLevel." + path + ".Multiplier");
        if (level >= maxLevel) {
            return;
        }
        if (this.pointHandler(player, points, tool, start, level, multiplier, maxLevel)) {
            this.processInventoryClickEvent(enchantment, tool, level, player, giveBack);
        }
    }

    private boolean pointHandler(Player player, HashMap<String, Double> pointList, ItemStack toolType, double start, int level, double multiplier, double maxLevel) {
        String p = player.getName();
        String tool = CheckerUtil.getItemType(toolType);
        double cost = start;
        if ((double)level < maxLevel) {
            if (level > 0) {
                cost = (double)level * multiplier * start;
            }
        } else {
            MessengerUtil.notifyPlayer(player, "<red>You cannot upgrade a tool that is already at it's maximum level.");
        }
        if (this.pointsUtil.withdrawPointsFor(toolType, player, cost)) {
            return true;
        }
        if (pointList.containsKey(p)) {
            if (pointList.get(p) > cost) {
                double oldValue = pointList.get(p);
                pointList.replace(p, oldValue, oldValue - cost);
                return true;
            }
            MessengerUtil.notifyPlayer(player, "<red>You do not have enough weapon points to upgrade your " + tool + "!");
            return false;
        }
        return false;
    }
}

