/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.Util.InventoryHolders;

import java.util.ArrayList;
import java.util.HashMap;
import me.marcangeloh.Events.PlayerChatEvent;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.ChatActions;
import me.marcangeloh.Util.ChatStorage;
import me.marcangeloh.Util.MessengerUtil;
import me.marcangeloh.Util.PointsUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class SettingsGUI
implements InventoryHolder {
    private final Inventory inventory;

    public SettingsGUI(Player p, PointsUtil pointsUtil, ItemStack tool, String branding, HashMap<String, ItemStack> itemList) {
        this.inventory = UpgradeableTools.PLUGIN.getServer().createInventory((InventoryHolder)this, 9, MiniMessage.miniMessage().deserialize((Object)(branding + UpgradeableTools.PLUGIN.getConfig().getString("InventoryTitles.SettingsInventory", "Settings"))));
        if (!this.settingsGUICheck(p)) {
            return;
        }
        ItemStack filler = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.displayName(MiniMessage.miniMessage().deserialize((Object)("<blue>Upgrade points: <yellow>" + String.format("%.2f", pointsUtil.checkForPoints(tool, p)))));
        filler.setItemMeta(fillerMeta);
        ItemStack name = new ItemStack(Material.NAME_TAG);
        ItemMeta nameMeta = name.getItemMeta();
        nameMeta.displayName(MiniMessage.miniMessage().deserialize((Object)"<yellow>Name"));
        ArrayList<Component> lores = new ArrayList<Component>();
        lores.add(MiniMessage.miniMessage().deserialize((Object)"<gray>Customize the name of the item"));
        nameMeta.lore(lores);
        name.setItemMeta(nameMeta);
        this.inventory.setItem(1, name);
        this.inventory.setItem(7, itemList.get("loreBook"));
        this.inventory.setItem(4, tool);
        for (int i = 0; i < 9; ++i) {
            if (this.inventory.getItem(i) == null) {
                this.inventory.setItem(i, filler);
                continue;
            }
            if (this.inventory.getItem(i) != null && this.inventory.getItem(i).getType() != Material.AIR) continue;
            this.inventory.setItem(i, filler);
        }
    }

    private boolean settingsGUICheck(Player p) {
        if (!UpgradeableTools.PLUGIN.getConfig().getBoolean("ToolSettingsPermission", false)) {
            return true;
        }
        return p.hasPermission("UpgradeableTools.settings");
    }

    public void handleClickEvent(InventoryClickEvent e, Player player, String currentItemName, HashMap<Player, Boolean> giveBack, PlayerChatEvent playerChatEvent) {
        e.setCancelled(true);
        ItemStack tool = e.getView().getItem(4);
        if (currentItemName.contains("Name")) {
            giveBack.put(player, false);
            playerChatEvent.setPlayerActions(player, new ChatStorage(ChatActions.HANDLE_NAME, tool));
            player.closeInventory();
            MessengerUtil.notifyPlayer(player, "<yellow>Please insert the name of the item:");
            giveBack.put(player, true);
        } else if (currentItemName.contains("Lore")) {
            giveBack.put(player, false);
            playerChatEvent.setPlayerActions(player, new ChatStorage(ChatActions.HANDLE_LORE, tool));
            player.closeInventory();
            MessengerUtil.notifyPlayer(player, "<yellow>Type in the lore as you want it, when done type in 'done'");
            giveBack.put(player, true);
        }
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

