/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.Util;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import java.util.Locale;
import me.marcangeloh.Config.ConfigManager;
import me.marcangeloh.Events.JobEvents;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.InventoryHolders.ToolSelectionInventory;
import me.marcangeloh.Util.MessengerUtil;
import me.marcangeloh.Util.PointsUtil;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CommandUtil
extends ConfigManager {
    Commands commands;

    public CommandUtil(Commands commands) {
        this.commands = commands;
    }

    public void registerUTCommand() {
        LiteralArgumentBuilder upgradeabletools = Commands.literal((String)"upgradeabletools");
        this.commands.register(((LiteralArgumentBuilder)upgradeabletools.executes(commandContext -> {
            CommandSender sender = ((CommandSourceStack)commandContext.getSource()).getSender();
            if (sender instanceof Player) {
                Player p = (Player)sender;
                if (!this.handleWorld(p)) {
                    return 1;
                }
                ItemStack item = new ItemStack(p.getInventory().getItemInMainHand());
                this.OpenGUI(p, item);
            } else {
                MessengerUtil.notifySender(sender, "<red>You must be a player to execute this command");
            }
            return 1;
        })).build(), "Brings up the GUI for tool upgrade.", List.of("ut", "utools"));
    }

    public void registerUTACommand() {
        LiteralArgumentBuilder upgradeabletoolsadmin = Commands.literal((String)"upgradeabletoolsadmin");
        ((LiteralArgumentBuilder)upgradeabletoolsadmin.requires(sender -> sender.getSender().hasPermission("upgradabletools.admin"))).executes(commandContext -> {
            CommandSender sender = ((CommandSourceStack)commandContext.getSource()).getSender();
            MessengerUtil.notifySender(sender, "<red>You're trying to use the command improperly. Proper structure is: ");
            MessengerUtil.notifySender(sender, "<green>/uta </green><red>[add/set] [playerCommand] [pointType] [amount]");
            return 1;
        });
        LiteralArgumentBuilder addPointsCommand = Commands.literal((String)"add");
        addPointsCommand.executes(commandContext -> {
            CommandSender sender = ((CommandSourceStack)commandContext.getSource()).getSender();
            MessengerUtil.notifySender(sender, "<red>You're trying to use the command improperly. Proper structure is: ");
            MessengerUtil.notifySender(sender, "<green>/uta add </green><red>[playerCommand] [pointType] [amount]");
            return 1;
        });
        LiteralArgumentBuilder setPointsCommand = Commands.literal((String)"set");
        setPointsCommand.executes(commandContext -> {
            CommandSender sender = ((CommandSourceStack)commandContext.getSource()).getSender();
            MessengerUtil.notifySender(sender, "<red>You're trying to use the command improperly. Proper structure is: ");
            MessengerUtil.notifySender(sender, "<green>/uta set </green><red>[playerCommand] [pointType] [amount]");
            return 1;
        });
        RequiredArgumentBuilder<CommandSourceStack, PlayerSelectorArgumentResolver> playerCommand = CommandUtil.registerPlayerCommand();
        RequiredArgumentBuilder<CommandSourceStack, String> toolCommand = CommandUtil.registerToolCommand();
        RequiredArgumentBuilder amount = Commands.argument((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg());
        amount.executes(commandContext -> {
            String action = ((ParsedCommandNode)commandContext.getNodes().get(1)).getNode().getName();
            Player player = (Player)((List)((PlayerSelectorArgumentResolver)commandContext.getArgument("playerCommand", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)commandContext.getSource())).getFirst();
            String tool = (String)commandContext.getArgument("tool", String.class);
            double qty = (Double)commandContext.getArgument("amount", Double.class);
            if (action.equalsIgnoreCase("add")) {
                CommandUtil.handleAdd((CommandContext<CommandSourceStack>)commandContext, player, tool, qty);
            } else if (action.equalsIgnoreCase("set")) {
                CommandUtil.handleSet((CommandContext<CommandSourceStack>)commandContext, player, tool, qty);
            }
            return 1;
        });
        upgradeabletoolsadmin.then(addPointsCommand.then(playerCommand.then(toolCommand.then((ArgumentBuilder)amount))));
        upgradeabletoolsadmin.then(setPointsCommand.then(playerCommand.then(toolCommand.then((ArgumentBuilder)amount))));
        this.commands.register(upgradeabletoolsadmin.build(), "The admin commands for the UpgradeableTools plugin.", List.of("uta", "utoolsadmin", "utadmin"));
    }

    private static void handleAdd(CommandContext<CommandSourceStack> commandContext, Player player, String tool, double qty) {
        PointsUtil pointsUtil = new PointsUtil(UpgradeableTools.PLUGIN.pointsCore);
        CommandSender sender = ((CommandSourceStack)commandContext.getSource()).getSender();
        if (UpgradeableTools.usePointsCore || UpgradeableTools.useXP || UpgradeableTools.useEconomy) {
            if (!pointsUtil.addPointsTo(tool.toUpperCase(), player, qty)) {
                MessengerUtil.notifySender(sender, "<red>An Error has occurred when attempting to add points.");
                return;
            }
        } else if (JobEvents.shovelPoints.containsKey(player.getUniqueId().toString())) {
            Double oldValue = JobEvents.shovelPoints.get(player.getUniqueId().toString());
            JobEvents.shovelPoints.replace(player.getUniqueId().toString(), oldValue, qty + oldValue);
        } else {
            JobEvents.shovelPoints.put(player.getUniqueId().toString(), qty + fileConfig.getDouble(String.valueOf(player.getUniqueId()) + ".ShovelPoints"));
        }
        MessengerUtil.notifyPlayer(player, "<green>You've successfully received " + qty + " points");
        MessengerUtil.notifySender(sender, String.format("<green>You successfully added %s to %s %s points", qty, MiniMessage.miniMessage().serialize(player.displayName()), tool));
    }

    private static void handleSet(CommandContext<CommandSourceStack> commandContext, Player player, String tool, double qty) {
        MessengerUtil.notifySender(((CommandSourceStack)commandContext.getSource()).getSender(), String.format("<green>You successfully set %s %s to %s", MiniMessage.miniMessage().serialize(player.displayName()), tool, qty));
    }

    @NotNull
    private static RequiredArgumentBuilder<CommandSourceStack, PlayerSelectorArgumentResolver> registerPlayerCommand() {
        RequiredArgumentBuilder playerCommand = Commands.argument((String)"playerCommand", (ArgumentType)ArgumentTypes.player());
        playerCommand.suggests((ctx, builder) -> {
            Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase(Locale.ROOT).startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        });
        playerCommand.executes(commandContext -> {
            Player player = (Player)((List)((PlayerSelectorArgumentResolver)commandContext.getArgument("playerCommand", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)commandContext.getSource())).getFirst();
            CommandSender sender = ((CommandSourceStack)commandContext.getSource()).getSender();
            MessengerUtil.notifySender(sender, "<red>You're trying to use the command improperly. Proper structure is: ");
            MessengerUtil.notifySender(sender, String.format("<green>/uta set %s</green><red> [pointType] [amount]", player.displayName()));
            return 1;
        });
        return playerCommand;
    }

    @NotNull
    private static RequiredArgumentBuilder<CommandSourceStack, String> registerToolCommand() {
        RequiredArgumentBuilder toolCommand = Commands.argument((String)"tool", (ArgumentType)StringArgumentType.word());
        toolCommand.executes(commandContext -> {
            Player player = (Player)((List)((PlayerSelectorArgumentResolver)commandContext.getArgument("playerCommand", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)commandContext.getSource())).getFirst();
            String tool = (String)commandContext.getArgument("tool", String.class);
            CommandSender sender = ((CommandSourceStack)commandContext.getSource()).getSender();
            MessengerUtil.notifySender(sender, "<red>You're trying to use the command improperly. Proper structure is: ");
            MessengerUtil.notifySender(sender, String.format("<green>/uta set %s %s</green><red> [amount]", player.displayName(), tool));
            return 1;
        });
        CommandUtil.addToolSuggestions((RequiredArgumentBuilder<CommandSourceStack, String>)toolCommand);
        return toolCommand;
    }

    private static void addToolSuggestions(RequiredArgumentBuilder<CommandSourceStack, String> toolCommand) {
        toolCommand.suggests((commandContext, suggestionsBuilder) -> {
            suggestionsBuilder.suggest("axe", (Message)MessageComponentSerializer.message().serialize(MiniMessage.miniMessage().deserialize((Object)"<green>Axe Tool Points")));
            suggestionsBuilder.suggest("pickaxe", (Message)MessageComponentSerializer.message().serialize(MiniMessage.miniMessage().deserialize((Object)"<green>Pickaxe Tool Points")));
            suggestionsBuilder.suggest("shovel", (Message)MessageComponentSerializer.message().serialize(MiniMessage.miniMessage().deserialize((Object)"<green>Shovel Tool Points")));
            suggestionsBuilder.suggest("armor", (Message)MessageComponentSerializer.message().serialize(MiniMessage.miniMessage().deserialize((Object)"<green>Armor Tool Points (Helmets, Leggings, Chestplates, Boots, Elytra)")));
            suggestionsBuilder.suggest("fish", (Message)MessageComponentSerializer.message().serialize(MiniMessage.miniMessage().deserialize((Object)"<green>Fishing Tool Points")));
            suggestionsBuilder.suggest("ranged", (Message)MessageComponentSerializer.message().serialize(MiniMessage.miniMessage().deserialize((Object)"<green>Ranged Weapon Points (Bows, Crossbow, Trident)")));
            suggestionsBuilder.suggest("melee", (Message)MessageComponentSerializer.message().serialize(MiniMessage.miniMessage().deserialize((Object)"<green>Melee Weapon Points (Swords, Mace)")));
            return suggestionsBuilder.buildFuture();
        });
    }

    private boolean handleWorld(Player p2) {
        boolean isUTEnabledInWorld = UpgradeableTools.PLUGIN.getConfig().getBoolean("InventoryTitles.RestrictToWorlds", false);
        boolean passes = false;
        if (isUTEnabledInWorld) {
            List worlds = UpgradeableTools.PLUGIN.getConfig().getStringList("InventoryTitles.OnlyUseInWorld");
            for (String world : worlds) {
                if (!p2.getLocation().getWorld().getName().equalsIgnoreCase(world)) continue;
                passes = true;
            }
            if (!passes) {
                MessengerUtil.notifyPlayer(p2, "<red>You cannot use this command in this world.");
            }
            return passes;
        }
        return true;
    }

    private void OpenGUI(Player p, ItemStack item) {
        ToolSelectionInventory toolSelectionInventory = new ToolSelectionInventory(UpgradeableTools.PLUGIN);
        Inventory inventory = toolSelectionInventory.getInventory();
        inventory.addItem(new ItemStack[]{item});
        p.getInventory().setItem(p.getInventory().getHeldItemSlot(), null);
        p.openInventory(inventory);
    }
}

