/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.Util;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import me.marcangeloh.Config.ConfigManager;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.MessengerUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class CheckerUtil {
    private static final UUID RANDOM_UUID = UUID.fromString("92864445-51c5-4c3b-9039-517c9927d1b4");

    public static void setUpgradeData(Block block) {
        if (!block.getType().equals((Object)Material.ENCHANTING_TABLE)) {
            return;
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof TileState)) {
            return;
        }
        TileState tileState = (TileState)blockState;
        PersistentDataContainer persistentDataContainer = tileState.getPersistentDataContainer();
        NamespacedKey key = new NamespacedKey((Plugin)UpgradeableTools.PLUGIN, "upgrade-inv");
        persistentDataContainer.set(key, PersistentDataType.STRING, (Object)"justsomerandomdata");
        tileState.update();
    }

    public static boolean checkForUpgradeStructure(Block block) {
        if (!block.getType().equals((Object)Material.ENCHANTING_TABLE)) {
            return false;
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof TileState)) {
            return false;
        }
        TileState tileState = (TileState)blockState;
        PersistentDataContainer persistentDataContainer = tileState.getPersistentDataContainer();
        NamespacedKey key = new NamespacedKey((Plugin)UpgradeableTools.PLUGIN, "upgrade-inv");
        return persistentDataContainer.has(key, PersistentDataType.STRING);
    }

    private static PlayerProfile getProfile(String url) {
        URL urlObject;
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)RANDOM_UUID);
        PlayerTextures textures = profile.getTextures();
        try {
            urlObject = new URL(url);
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException("Invalid URL", exception);
        }
        textures.setSkin(urlObject);
        return profile;
    }

    public static ItemStack getHead(String url, String name, List<Component> lore) {
        try {
            ItemStack head = new ItemStack(Material.PLAYER_HEAD);
            if (url.isEmpty()) {
                return head;
            }
            PlayerProfile profile = CheckerUtil.getProfile("https://textures.minecraft.net/texture/" + url);
            SkullMeta headMeta = (SkullMeta)head.getItemMeta();
            headMeta.setOwnerProfile(profile);
            headMeta.displayName(MiniMessage.miniMessage().deserialize((Object)name));
            headMeta.lore(lore);
            head.setItemMeta((ItemMeta)headMeta);
            return head;
        }
        catch (NullPointerException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean checkForShovel(ItemStack item) {
        return CheckerUtil.checkItemForType(item, Material.DIAMOND_SHOVEL) || CheckerUtil.checkItemForType(item, Material.GOLDEN_SHOVEL) || CheckerUtil.checkItemForType(item, Material.NETHERITE_SHOVEL) || CheckerUtil.checkItemForType(item, Material.IRON_SHOVEL) || CheckerUtil.checkItemForType(item, Material.WOODEN_SHOVEL) || CheckerUtil.checkItemForType(item, Material.STONE_SHOVEL);
    }

    public static boolean checkForHoe(ItemStack item) {
        return CheckerUtil.checkItemForType(item, Material.DIAMOND_HOE) || CheckerUtil.checkItemForType(item, Material.NETHERITE_HOE) || CheckerUtil.checkItemForType(item, Material.GOLDEN_HOE) || CheckerUtil.checkItemForType(item, Material.IRON_HOE) || CheckerUtil.checkItemForType(item, Material.STONE_HOE) || CheckerUtil.checkItemForType(item, Material.WOODEN_HOE);
    }

    public static boolean checkForAxe(ItemStack item) {
        return CheckerUtil.checkItemForType(item, Material.DIAMOND_AXE) || CheckerUtil.checkItemForType(item, Material.NETHERITE_AXE) || CheckerUtil.checkItemForType(item, Material.GOLDEN_AXE) || CheckerUtil.checkItemForType(item, Material.IRON_AXE) || CheckerUtil.checkItemForType(item, Material.WOODEN_AXE) || CheckerUtil.checkItemForType(item, Material.STONE_AXE);
    }

    public static boolean checkForPickaxe(ItemStack item) {
        return CheckerUtil.checkItemForType(item, Material.DIAMOND_PICKAXE) || CheckerUtil.checkItemForType(item, Material.NETHERITE_PICKAXE) || CheckerUtil.checkItemForType(item, Material.GOLDEN_PICKAXE) || CheckerUtil.checkItemForType(item, Material.IRON_PICKAXE) || CheckerUtil.checkItemForType(item, Material.WOODEN_PICKAXE) || CheckerUtil.checkItemForType(item, Material.STONE_PICKAXE);
    }

    public static boolean checkForBow(ItemStack itemStack) {
        return CheckerUtil.checkItemForType(itemStack, Material.BOW);
    }

    public static boolean checkForWeapons(ItemStack item) {
        return CheckerUtil.checkForSwords(item) || CheckerUtil.checkForCrossbow(item) || CheckerUtil.checkForTrident(item) || CheckerUtil.checkForBow(item);
    }

    public static boolean checkForTools(ItemStack item) {
        return CheckerUtil.checkForHoe(item) || CheckerUtil.checkForPickaxe(item) || CheckerUtil.checkForShovel(item) || CheckerUtil.checkForAxe(item);
    }

    public static boolean checkForTrident(ItemStack item) {
        return CheckerUtil.checkItemForType(item, Material.TRIDENT);
    }

    public static boolean checkForCrossbow(ItemStack item) {
        return CheckerUtil.checkItemForType(item, Material.CROSSBOW);
    }

    public static boolean checkEnchantmentPermission(Player player, Enchantment enchantment, int level) {
        if (!ConfigManager.permissions.getBoolean("Permissions.per-enchantment-permissions.enabled", false)) {
            return true;
        }
        if (ConfigManager.permissions.getBoolean("Permissions.per-enchantment-permissions.per-level", false)) {
            if (ConfigManager.permissions.getBoolean("Permissions.per-enchantment-permissions.permissions-check")) {
                player.sendMessage("UpgradeableTools." + enchantment.getKey().getKey() + "." + level);
            }
            if (!(player.hasPermission("UpgradeableTools." + enchantment.getKey().getKey() + "." + (level + 1)) || player.hasPermission("UpgradeableTools." + enchantment.getKey().getKey() + ".*") || player.hasPermission("UpgradeableTools.*") || player.hasPermission("*"))) {
                MessengerUtil.notifyPlayer(player, "You do not have permission to upgrade your tool more.");
                return false;
            }
        }
        if (!(player.hasPermission("UpgradeableTools." + enchantment.getKey().getKey()) || player.hasPermission("UpgradeableTools.*") || player.hasPermission("*"))) {
            MessengerUtil.notifyPlayer(player, "<red>You do not have permission to upgrade your tool more.");
            return false;
        }
        return true;
    }

    public static boolean isPlayerInRegion(Player player, Location location) {
        if (!UpgradeableTools.isWorldGuardEnabled) {
            return false;
        }
        com.sk89q.worldedit.util.Location loc = BukkitAdapter.adapt((Location)location);
        if (location.getWorld() == null) {
            return false;
        }
        World world = BukkitAdapter.adapt((org.bukkit.World)location.getWorld());
        boolean canBypass = WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(UpgradeableTools.WGBukkit.wrapPlayer(player), world);
        if (canBypass) {
            return false;
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        return !query.testState(loc, UpgradeableTools.WGBukkit.wrapPlayer(player), new StateFlag[]{Flags.BUILD});
    }

    public static boolean checkForSwords(ItemStack item) {
        return CheckerUtil.checkItemForType(item, Material.WOODEN_SWORD) || CheckerUtil.checkItemForType(item, Material.STONE_SWORD) || CheckerUtil.checkItemForType(item, Material.GOLDEN_SWORD) || CheckerUtil.checkItemForType(item, Material.DIAMOND_SWORD) || CheckerUtil.checkItemForType(item, Material.NETHERITE_SWORD) || CheckerUtil.checkItemForType(item, Material.IRON_SWORD);
    }

    public static boolean checkForHelmet(ItemStack item) {
        return CheckerUtil.checkItemForType(item, Material.CHAINMAIL_HELMET) || CheckerUtil.checkItemForType(item, Material.DIAMOND_HELMET) || CheckerUtil.checkItemForType(item, Material.GOLDEN_HELMET) || CheckerUtil.checkItemForType(item, Material.IRON_HELMET) || CheckerUtil.checkItemForType(item, Material.LEATHER_HELMET) || CheckerUtil.checkItemForType(item, Material.NETHERITE_HELMET) || CheckerUtil.checkItemForType(item, Material.TURTLE_HELMET);
    }

    public static boolean checkForChestplate(ItemStack item) {
        return CheckerUtil.checkItemForType(item, Material.CHAINMAIL_CHESTPLATE) || CheckerUtil.checkItemForType(item, Material.DIAMOND_CHESTPLATE) || CheckerUtil.checkItemForType(item, Material.GOLDEN_CHESTPLATE) || CheckerUtil.checkItemForType(item, Material.IRON_CHESTPLATE) || CheckerUtil.checkItemForType(item, Material.NETHERITE_CHESTPLATE) || CheckerUtil.checkItemForType(item, Material.LEATHER_CHESTPLATE);
    }

    public static boolean checkForBoots(ItemStack item) {
        return CheckerUtil.checkItemForType(item, Material.CHAINMAIL_BOOTS) || CheckerUtil.checkItemForType(item, Material.DIAMOND_BOOTS) || CheckerUtil.checkItemForType(item, Material.GOLDEN_BOOTS) || CheckerUtil.checkItemForType(item, Material.IRON_BOOTS) || CheckerUtil.checkItemForType(item, Material.NETHERITE_BOOTS) || CheckerUtil.checkItemForType(item, Material.LEATHER_BOOTS);
    }

    public static boolean checkForLeggins(ItemStack item) {
        return CheckerUtil.checkItemForType(item, Material.CHAINMAIL_LEGGINGS) || CheckerUtil.checkItemForType(item, Material.DIAMOND_LEGGINGS) || CheckerUtil.checkItemForType(item, Material.GOLDEN_LEGGINGS) || CheckerUtil.checkItemForType(item, Material.IRON_LEGGINGS) || CheckerUtil.checkItemForType(item, Material.NETHERITE_LEGGINGS) || CheckerUtil.checkItemForType(item, Material.LEATHER_LEGGINGS);
    }

    public static boolean checkForArmor(ItemStack item) {
        return CheckerUtil.checkForBoots(item) || CheckerUtil.checkForChestplate(item) || CheckerUtil.checkForHelmet(item) || CheckerUtil.checkForLeggins(item);
    }

    private static boolean checkItemForType(ItemStack item, Material type) {
        return item.getType().equals((Object)type);
    }

    public static String getItemType(ItemStack item) {
        if (CheckerUtil.checkForArmor(item)) {
            return "Armor";
        }
        if (CheckerUtil.checkForWeapons(item)) {
            return "Weapon";
        }
        if (CheckerUtil.checkForTools(item)) {
            return "Tool";
        }
        return null;
    }
}

