/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import me.marcangeloh.API.Util.ConfigurationUtil.ValueUtil;
import me.marcangeloh.Config.ConfigManager;
import me.marcangeloh.CustomEnchantments.CustomEnchants;
import me.marcangeloh.Events.AnvilEvent;
import me.marcangeloh.Events.DisenchantEvent;
import me.marcangeloh.Events.EnchantEvent;
import me.marcangeloh.Events.Events;
import me.marcangeloh.Events.JobEvents;
import me.marcangeloh.Metrics;
import me.marcangeloh.PointsCore;
import me.marcangeloh.Util.CommandUtil;
import me.marcangeloh.Util.MessengerUtil;
import me.marcangeloh.Util.PointsUtil;
import me.marcangeloh.Util.UpdateChecker;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpgradeableTools
extends JavaPlugin {
    public static UpgradeableTools PLUGIN;
    private static final Pattern HEX_PATTERN;
    public static final String BRANDING_PREFIX = "<gradient:#3e713e:#baffb4>UpgradeableTools: </gradient><reset>";
    private final ConfigManager cfgm;
    public PointsCore pointsCore;
    public static boolean isWorldGuardEnabled;
    public static WorldGuardPlugin WGBukkit;
    public static boolean useEconomy;
    public static boolean usePointsCore;
    public static boolean useXP;
    private static Economy econ;
    private Events pluginEvents;
    private final CustomEnchants customEnchants;
    public static HashMap<UUID, Integer> cdtime;

    public static Economy getEconomy() {
        return econ;
    }

    public UpgradeableTools(ConfigManager configManager, CustomEnchants customEnchants) {
        this.cfgm = configManager;
        this.customEnchants = customEnchants;
    }

    public void onEnable() {
        PLUGIN = this;
        this.cfgm.setup();
        this.printAsciiArt();
        MessengerUtil.notifyConsole("Config loaded.");
        this.pointsCore = (PointsCore)UpgradeableTools.getPlugin(PointsCore.class);
        ValueUtil valueUtil = new ValueUtil(this.pointsCore);
        PointsUtil pointsUtil = new PointsUtil(this.pointsCore);
        this.pluginEvents = new Events(valueUtil, pointsUtil);
        this.pluginEvents.onEnable();
        this.getServer().getPluginManager().registerEvents((Listener)this.pluginEvents, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DisenchantEvent(valueUtil), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AnvilEvent(valueUtil), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EnchantEvent(valueUtil), (Plugin)this);
        this.customEnchants.onEnable(this);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands commands = (Commands)event.registrar();
            CommandUtil commandUtil = new CommandUtil(commands);
            commandUtil.registerUTCommand();
            commandUtil.registerUTACommand();
        });
        this.setupMetrics();
        this.setupWorldGuardIntegration();
        this.setupEconomyIntegration();
        this.setupXP();
        this.setupPointsCoreIntegration();
        try {
            this.setupNormalConfig();
        }
        catch (IOException e) {
            MessengerUtil.notifyConsole("<red>The plugin encountered an issue saving the config. Disabling now.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (econ == null && !usePointsCore) {
            this.getServer().getPluginManager().registerEvents((Listener)new JobEvents(), (Plugin)this);
        }
        this.setCraftingRecipes();
        this.startCooldownRunnable();
        this.checkForUpdates();
        MessengerUtil.notifyConsole("<green>The plugin has been enabled successfully.");
    }

    public void onDisable() {
        if (econ == null && !usePointsCore) {
            this.savePlayerData();
        }
        this.pluginEvents.onDisable();
        this.customEnchants.onDisable();
        NamespacedKey craftingKey = new NamespacedKey((Plugin)this, "crafting-key");
        this.getServer().removeRecipe(craftingKey);
        MessengerUtil.notifyConsole("<red>The plugin has been disabled successfully.");
    }

    private void printAsciiArt() {
        MessengerUtil.notifyConsole("\n\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2580\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\n\u2588\u2584\u2500\u2588\u2588\u2500\u2584\u2588\u2584\u2500\u2584\u2584\u2500\u2588\u2500\u2584\u2584\u2584\u2584\u2588\u2584\u2500\u2584\u2584\u2580\u2588\u2588\u2580\u2584\u2500\u2588\u2588\u2584\u2500\u2584\u2584\u2580\u2588\u2584\u2500\u2584\u2584\u2500\u2588\u2588\u2580\u2584\u2500\u2588\u2588\u2584\u2500\u2584\u2500\u2580\u2588\u2584\u2500\u2584\u2588\u2588\u2588\u2584\u2500\u2584\u2584\u2500\u2588\u2588\u2588\u2500\u2584\u2500\u2584\u2500\u2588\u2500\u2584\u2584\u2500\u2588\u2500\u2584\u2584\u2500\u2588\u2584\u2500\u2584\u2588\u2588\u2588\u2500\u2584\u2584\u2584\u2584\u2588\n\u2588\u2588\u2500\u2588\u2588\u2500\u2588\u2588\u2588\u2500\u2584\u2584\u2584\u2588\u2500\u2588\u2588\u2584\u2500\u2588\u2588\u2500\u2584\u2500\u2584\u2588\u2588\u2500\u2580\u2500\u2588\u2588\u2588\u2500\u2588\u2588\u2500\u2588\u2588\u2500\u2584\u2588\u2580\u2588\u2588\u2500\u2580\u2500\u2588\u2588\u2588\u2500\u2584\u2500\u2580\u2588\u2588\u2500\u2588\u2588\u2580\u2588\u2588\u2500\u2584\u2588\u2580\u2588\u2588\u2588\u2588\u2588\u2500\u2588\u2588\u2588\u2500\u2588\u2588\u2500\u2588\u2500\u2588\u2588\u2500\u2588\u2588\u2500\u2588\u2588\u2580\u2588\u2584\u2584\u2584\u2584\u2500\u2588\n\u2580\u2580\u2584\u2584\u2584\u2584\u2580\u2580\u2584\u2584\u2584\u2580\u2580\u2580\u2584\u2584\u2584\u2584\u2584\u2580\u2584\u2584\u2580\u2584\u2584\u2580\u2584\u2584\u2580\u2584\u2584\u2580\u2584\u2584\u2584\u2584\u2580\u2580\u2584\u2584\u2584\u2584\u2584\u2580\u2584\u2584\u2580\u2584\u2584\u2580\u2584\u2584\u2584\u2584\u2580\u2580\u2584\u2584\u2584\u2584\u2584\u2580\u2584\u2584\u2584\u2584\u2584\u2580\u2580\u2580\u2580\u2584\u2584\u2584\u2580\u2580\u2584\u2584\u2584\u2584\u2580\u2584\u2584\u2584\u2584\u2580\u2584\u2584\u2584\u2584\u2584\u2580\u2584\u2584\u2584\u2584\u2584\u2580");
    }

    private void setupMetrics() {
        int pluginId = 4292;
        new Metrics(this, pluginId);
    }

    private void checkForUpdates() {
        if (new UpdateChecker().isUpdateAvailable(this.getPluginMeta().getVersion())) {
            // empty if block
        }
    }

    private void setupWorldGuardIntegration() {
        Plugin worldGuardPlugin = this.getServer().getPluginManager().getPlugin("WorldGuard");
        if (worldGuardPlugin instanceof WorldGuardPlugin) {
            WGBukkit = (WorldGuardPlugin)worldGuardPlugin;
            isWorldGuardEnabled = true;
            MessengerUtil.notifyConsole("WorldGuard found and integrated.");
        } else {
            isWorldGuardEnabled = false;
            MessengerUtil.notifyConsole("WorldGuard not found or not a WorldGuardPlugin instance. Integration disabled.");
        }
    }

    private void setupPointsCoreIntegration() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("PointsCore");
        if (plugin instanceof PointsCore) {
            usePointsCore = true;
            this.pointsCore = (PointsCore)plugin;
            MessengerUtil.notifyConsole("<green>PointsCore has been setup on this server.");
        } else {
            MessengerUtil.notifyConsole("<red>PointsCore has not been setup on this server due to missing dependency.");
            usePointsCore = false;
        }
    }

    private void setupXP() {
        if (this.cfgm.getPlayerData().getBoolean("UpgradeWithXP", false)) {
            useXP = true;
        }
    }

    private void setupEconomyIntegration() {
        if (this.cfgm.getPlayerData().getBoolean("UpgradeWithVault", false)) {
            RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp != null) {
                econ = (Economy)rsp.getProvider();
                useEconomy = true;
                MessengerUtil.notifyConsole("<green>Vault Economy has been setup on this server.");
            } else {
                MessengerUtil.notifyConsole("<red>Vault found, but no Economy provider registered. Economy integration disabled.");
                useEconomy = false;
            }
        } else {
            MessengerUtil.notifyConsole("Vault economy integration disabled by config.");
            useEconomy = false;
        }
        if (!useEconomy && this.cfgm.getPlayerData().getBoolean("UpgradeWithVault", false)) {
            MessengerUtil.notifyConsole("<red>Vault integration was enabled in config but could not be set up.");
        }
    }

    private void setupNormalConfig() throws IOException {
        this.saveResource("PermissionsConfig.yml", false);
        this.saveDefaultConfig();
    }

    private void setCraftingRecipes() {
        ItemStack result = new ItemStack(Material.ENCHANTING_TABLE);
        ItemMeta resultMeta = result.getItemMeta();
        if (resultMeta != null) {
            resultMeta.displayName(MiniMessage.miniMessage().deserialize((Object)"<green>Enchanting Maximizer"));
            ArrayList<Component> lores = new ArrayList<Component>();
            lores.add(MiniMessage.miniMessage().deserialize((Object)"<gray>Place this block to begin"));
            lores.add(MiniMessage.miniMessage().deserialize((Object)"<gray>your enchanting journey!"));
            resultMeta.lore(lores);
            result.setItemMeta(resultMeta);
        }
        NamespacedKey craftingKey = new NamespacedKey((Plugin)this, "crafting-key");
        ShapelessRecipe shapelessRecipe = new ShapelessRecipe(craftingKey, result);
        shapelessRecipe.addIngredient(Material.ENCHANTING_TABLE);
        shapelessRecipe.addIngredient(Material.AMETHYST_SHARD);
        this.getServer().addRecipe((Recipe)shapelessRecipe);
        MessengerUtil.notifyConsole("Crafting recipes loaded.");
    }

    private void startCooldownRunnable() {
        new BukkitRunnable(){

            public void run() {
                if (cdtime.isEmpty()) {
                    return;
                }
                cdtime.entrySet().removeIf(entry -> {
                    entry.setValue((Integer)entry.getValue() - 1);
                    return (Integer)entry.getValue() <= 0;
                });
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    public static List<String> getEnchantmentNames() {
        ArrayList<String> enchantmentNames = new ArrayList<String>();
        ConfigurationSection multiplierSection = PLUGIN.getConfig().getConfigurationSection("MultiplierToLevel");
        if (PLUGIN == null || multiplierSection == null) {
            return enchantmentNames;
        }
        for (String tools : multiplierSection.getKeys(false)) {
            ConfigurationSection toolsSection = PLUGIN.getConfig().getConfigurationSection("MultiplierToLevel." + tools);
            if (toolsSection == null) continue;
            for (String enchantment : toolsSection.getKeys(false)) {
                String name = PLUGIN.getConfig().getString("MultiplierToLevel." + tools + "." + enchantment + ".name");
                if (name == null || name.equalsIgnoreCase("undefined enchantment")) continue;
                enchantmentNames.add(name);
            }
        }
        return enchantmentNames;
    }

    private void savePlayerData() {
        this.saveJobPoints(JobEvents.fishingPoints, ".FishingPoints");
        this.saveJobPoints(JobEvents.pickaxePoints, ".PickaxePoints");
        this.saveJobPoints(JobEvents.shovelPoints, ".ShovelPoints");
        this.saveJobPoints(JobEvents.axePoints, ".AxePoints");
        this.saveJobPoints(JobEvents.weaponPoints, ".WeaponPoints");
        this.saveJobPoints(JobEvents.hoePoints, ".HoePoints");
        this.saveJobPoints(JobEvents.armorPoints, ".ArmorPoints");
        this.cfgm.savePlayerData();
        MessengerUtil.notifyConsole("<green>Saved Player data.");
    }

    private void saveJobPoints(HashMap<String, Double> pointsMap, String pathSuffix) {
        for (Map.Entry<String, Double> entry : pointsMap.entrySet()) {
            this.cfgm.getPlayerData().set(entry.getKey() + pathSuffix, (Object)entry.getValue());
        }
    }

    static {
        HEX_PATTERN = Pattern.compile("#[a-fA-F0-9]{6}");
        useEconomy = false;
        usePointsCore = false;
        useXP = false;
        econ = null;
        cdtime = new HashMap();
    }
}

