/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.Events;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.marcangeloh.Util.ChatActions;
import me.marcangeloh.Util.ChatStorage;
import me.marcangeloh.Util.MessengerUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerChatEvent
implements Listener {
    private final HashMap<Player, ChatStorage> chatActionsMap = new HashMap();
    private final HashMap<Player, ArrayList<Component>> loresCollector = new HashMap();

    public void setPlayerActions(Player player, ChatStorage storage) {
        if (this.chatActionsMap.containsKey(player)) {
            this.chatActionsMap.get(player).setActions(storage.getActions());
            this.chatActionsMap.get(player).setStack(storage.getStack());
            return;
        }
        this.chatActionsMap.putIfAbsent(player, storage);
    }

    public void onDisable() {
        for (Player player : this.chatActionsMap.keySet()) {
            if (this.chatActionsMap.get(player).getActions().equals((Object)ChatActions.NONE) || this.chatActionsMap.get(player).getStack() == null) continue;
            player.getInventory().addItem(new ItemStack[]{this.chatActionsMap.get(player).getStack()});
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void playerChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        if (!this.chatActionsMap.containsKey(player)) {
            return;
        }
        ChatStorage storage = this.chatActionsMap.get(player);
        if (storage.getActions().equals((Object)ChatActions.NONE)) {
            return;
        }
        event.setCancelled(true);
        ItemStack stack = storage.getStack();
        if (storage.getActions().equals((Object)ChatActions.HANDLE_NAME)) {
            ItemMeta im = storage.getStack().getItemMeta();
            String text = PlainTextComponentSerializer.plainText().serialize(event.message());
            im.displayName(MiniMessage.miniMessage().deserialize((Object)text));
            stack.setItemMeta(im);
            player.getInventory().addItem(new ItemStack[]{stack});
            storage.setActions(ChatActions.NONE);
            storage.setStack(null);
            this.chatActionsMap.put(player, storage);
            MessengerUtil.notifyPlayer(player, "<green>Name changed successfully.");
            return;
        }
        if (storage.getActions().equals((Object)ChatActions.HANDLE_LORE)) {
            if (((String)MiniMessage.miniMessage().serialize(event.message())).equalsIgnoreCase("done")) {
                ItemMeta im = storage.getStack().getItemMeta();
                im.lore((List)this.loresCollector.get(player));
                stack.setItemMeta(im);
                player.getInventory().addItem(new ItemStack[]{stack});
                storage.setActions(ChatActions.NONE);
                storage.setStack(null);
                this.chatActionsMap.put(player, storage);
                MessengerUtil.notifyPlayer(player, "<green>Item Lore successfully modified.");
            } else {
                this.loresCollector.putIfAbsent(player, new ArrayList());
                this.loresCollector.get(player).add(MiniMessage.miniMessage().deserialize((Object)PlainTextComponentSerializer.plainText().serialize(event.message())));
            }
        }
    }
}

