/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.Events;

import java.util.ArrayList;
import java.util.HashMap;
import me.marcangeloh.API.Util.ConfigurationUtil.ValueUtil;
import me.marcangeloh.API.Util.GeneralUtil.Tools;
import me.marcangeloh.Config.ConfigManager;
import me.marcangeloh.Events.PlayerChatEvent;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.CheckerUtil;
import me.marcangeloh.Util.InventoryHolders.SettingsGUI;
import me.marcangeloh.Util.InventoryHolders.ToolSelectionInventory;
import me.marcangeloh.Util.InventoryHolders.UpgradeGUI;
import me.marcangeloh.Util.InventoryUtil;
import me.marcangeloh.Util.MessengerUtil;
import me.marcangeloh.Util.PointsUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Events
extends ConfigManager
implements Listener {
    HashMap<Player, Boolean> giveBack = new HashMap();
    InventoryUtil inventoryUtil = new InventoryUtil();
    private final String branding = "<blue>UT: ";
    private final PlayerChatEvent playerChatEvent = new PlayerChatEvent();
    private final HashMap<String, ItemStack> itemList = new HashMap();
    private final ValueUtil valueUtil;
    private final PointsUtil pointsUtil;

    public Events(ValueUtil valueUtil, PointsUtil pointsUtil) {
        this.valueUtil = valueUtil;
        this.pointsUtil = pointsUtil;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void InventoryClickEvent(InventoryClickEvent e) throws NullPointerException {
        String currentItemName;
        if (e.getClickedInventory() == null) {
            return;
        }
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (e.getCurrentItem() == null) {
            return;
        }
        try {
            Component displayName = e.getCurrentItem().getItemMeta().displayName();
            if (displayName == null) {
                return;
            }
            currentItemName = (String)MiniMessage.miniMessage().serialize(displayName);
        }
        catch (NullPointerException exception) {
            return;
        }
        if (!e.getClickedInventory().equals((Object)e.getView().getTopInventory())) {
            return;
        }
        if (currentItemName.isEmpty()) {
            return;
        }
        Inventory inventory = e.getClickedInventory();
        this.handleToolSelectionInventory(inventory, e, currentItemName, player);
        this.handleUpgradeInventory(inventory, e, player, currentItemName);
        this.handleSettingsInventory(inventory, e, player, currentItemName, this.playerChatEvent);
    }

    private void handleSettingsInventory(Inventory inventory, InventoryClickEvent e, Player player, String currentItemName, PlayerChatEvent playerChatEvent) {
        InventoryHolder inventoryHolder;
        if (inventory == null || !((inventoryHolder = inventory.getHolder(false)) instanceof SettingsGUI)) {
            return;
        }
        SettingsGUI settingsGUI = (SettingsGUI)inventoryHolder;
        settingsGUI.handleClickEvent(e, player, currentItemName, this.giveBack, playerChatEvent);
    }

    private void handleToolSelectionInventory(Inventory inventory, InventoryClickEvent event, String currentItemName, Player player) {
        InventoryHolder inventoryHolder;
        if (inventory == null || !((inventoryHolder = inventory.getHolder(false)) instanceof ToolSelectionInventory)) {
            return;
        }
        ToolSelectionInventory toolSelectionInventory = (ToolSelectionInventory)inventoryHolder;
        toolSelectionInventory.clickHandler(currentItemName, event, player, this.giveBack, this.inventoryUtil, "<blue>UT: ", this.pointsUtil, this.itemList);
    }

    private void handleUpgradeInventory(Inventory inventory, InventoryClickEvent event, Player player, String currentItemName) {
        InventoryHolder inventoryHolder;
        if (inventory == null || !((inventoryHolder = inventory.getHolder(false)) instanceof UpgradeGUI)) {
            return;
        }
        UpgradeGUI upgradeGUI = (UpgradeGUI)inventoryHolder;
        upgradeGUI.handleClick(event, player, currentItemName, this.giveBack);
    }

    @EventHandler
    public void InventoryCloseEvent(InventoryCloseEvent e) {
        String title = (String)MiniMessage.miniMessage().serialize(e.getView().title());
        HumanEntity humanEntity = e.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        ItemStack item = new ItemStack(Material.AIR);
        if (this.giveBack.get(p) != null && !this.giveBack.get(p).booleanValue()) {
            return;
        }
        Inventory inventory = e.getInventory();
        if (inventory.getHolder(false) instanceof UpgradeGUI) {
            if (inventory.getItem(22) == null) {
                return;
            }
            item = inventory.getItem(22);
            MessengerUtil.notifyPlayer(p, "<green>Enchantments successfully applied.");
        } else if (inventory.getHolder(false) instanceof ToolSelectionInventory) {
            if (inventory.getItem(13) == null) {
                return;
            }
            item = inventory.getItem(13);
        } else if (inventory.getHolder(false) instanceof SettingsGUI) {
            if (inventory.getItem(4) == null) {
                return;
            }
            item = inventory.getItem(4);
        }
        assert (item != null);
        if (item.getType().equals((Object)Material.AIR)) {
            return;
        }
        if (p.getInventory().firstEmpty() == -1) {
            p.getLocation().getWorld().dropItemNaturally(p.getLocation(), item);
        } else {
            p.getInventory().addItem(new ItemStack[]{item});
        }
    }

    public void onEnable() {
        UpgradeableTools.PLUGIN.getServer().getPluginManager().registerEvents((Listener)this.playerChatEvent, (Plugin)UpgradeableTools.PLUGIN);
        this.handlePlayerHeads();
    }

    public void onDisable() {
        this.playerChatEvent.onDisable();
    }

    private void handlePlayerHeads() {
        ArrayList<Component> lores = new ArrayList<Component>();
        lores.add(MiniMessage.miniMessage().deserialize((Object)"<gray>This will take you to the"));
        lores.add(MiniMessage.miniMessage().deserialize((Object)"<gray>settings page. There you"));
        lores.add(MiniMessage.miniMessage().deserialize((Object)"<gray>can modify the tool name, etc."));
        this.itemList.put("settings", CheckerUtil.getHead("db4898c14428dd2e4011d9be3760ec6bab521ae5651f6e20ad5341a0f5afce28", "<blue>Settings", lores));
        lores.clear();
        lores.add(MiniMessage.miniMessage().deserialize((Object)"<gray>This will take you to the next page."));
        this.itemList.put("next", CheckerUtil.getHead("18660691d1ca029f120a3ff0eabab93a2306b37a7d61119fcd141ff2f6fcd798", "<blue>Next Page", lores));
        lores.clear();
        lores.add(MiniMessage.miniMessage().deserialize((Object)"<gray>This will take you to the last page"));
        this.itemList.put("back", CheckerUtil.getHead("52ba81b47d5ee06b484ea9bdf22934e6abca5e4ced7be3905d6ae6ecd6fcea2a", "<blue>Back", lores));
        lores.clear();
        lores.add(MiniMessage.miniMessage().deserialize((Object)"<gray>Customize the lore of this item."));
        lores.add(MiniMessage.miniMessage().deserialize((Object)"<gray>The lore is this descriptive text."));
        this.itemList.put("loreBook", CheckerUtil.getHead("cdcdee6d06df234b8e603328b96c57f3a312e79aabfc3be72a8b421878ed68cf", "<yellow>Lore", lores));
        lores.clear();
        this.itemList.put("backpack", CheckerUtil.getHead("a45c7bbcee900802da6b3f8ee538aecf5633beea8301d13f247bd63f75907a58", "<blue>Backpack", lores));
        this.itemList.put("spook", CheckerUtil.getHead("cea1b8dd35f356cb66c682eea791df88447281c6d006b82cf853d6945ff6add7", "<blue>Spook", lores));
        this.itemList.put("bleed", CheckerUtil.getHead("93a3960c879474017c0ca3c80f6ee73cf886e00e89c902a3ee893dd2849535c0", "<blue>Bleed", lores));
        this.itemList.put("secondChance", CheckerUtil.getHead("77791ccec16fb68f3c92e0b0264f9680e124c3859d66403524ba5b9576c9818", "Glow", lores));
        MessengerUtil.notifyConsole("<green>Player heads loaded");
    }

    private void openUpgradeGUI(Player p, ItemStack tool) {
        UpgradeGUI upgradeGUI = new UpgradeGUI(UpgradeableTools.PLUGIN, tool, this.inventoryUtil, "<blue>UT: ", this.pointsUtil, p, this.itemList);
        p.openInventory(upgradeGUI.getInventory());
    }

    @EventHandler
    public void blockPlaceEvent(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null) {
            return;
        }
        if (!itemInHand.hasItemMeta()) {
            return;
        }
        ItemMeta itemMeta = itemInHand.getItemMeta();
        if (!itemMeta.getDisplayName().contains("Enchanting Maximizer")) {
            return;
        }
        CheckerUtil.setUpgradeData(event.getBlock());
    }

    @EventHandler
    public void blockBreakEvent(BlockBreakEvent event) {
        if (!CheckerUtil.checkForUpgradeStructure(event.getBlock())) {
            return;
        }
        if (!UpgradeableTools.PLUGIN.getConfig().getBoolean("CanPickupEnchantmentMaximizer", false)) {
            return;
        }
        ItemStack result = new ItemStack(Material.ENCHANTING_TABLE);
        ItemMeta resultMeta = result.getItemMeta();
        resultMeta.displayName(MiniMessage.miniMessage().deserialize((Object)"<green>Enchanting Maximizer"));
        ArrayList<Component> lores = new ArrayList<Component>();
        lores.add(MiniMessage.miniMessage().deserialize((Object)"<gray>Place this block to begin"));
        lores.add(MiniMessage.miniMessage().deserialize((Object)"<gray>your enchanting journey!"));
        resultMeta.lore(lores);
        result.setItemMeta(resultMeta);
        event.getPlayer().getWorld().dropItemNaturally(event.getBlock().getLocation(), result);
        event.setCancelled(true);
        event.getBlock().setType(Material.AIR);
        event.getBlock().getState().update();
    }

    @EventHandler
    public void playerInteractEvent(PlayerInteractEvent event) {
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        if (!event.getClickedBlock().getType().equals((Object)Material.ENCHANTING_TABLE)) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (this.valueUtil.getToolType(itemInHand.getType()) == Tools.NONE) {
            return;
        }
        if (CheckerUtil.checkForUpgradeStructure(event.getClickedBlock())) {
            event.setCancelled(true);
            this.openUpgradeGUI(player, itemInHand);
            player.getInventory().remove(itemInHand);
        }
    }
}

