/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.Events;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Random;
import me.marcangeloh.API.Util.ConfigurationUtil.ValueUtil;
import me.marcangeloh.CustomEnchantments.CustomEnchants;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.CheckerUtil;
import me.marcangeloh.Util.MessengerUtil;
import net.kyori.adventure.key.Key;
import org.apache.commons.text.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.inventory.ItemStack;

public class EnchantEvent
implements Listener {
    private final ValueUtil valueUtil;

    public EnchantEvent(ValueUtil valueUtil) {
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PointsCore")) {
            this.valueUtil = valueUtil;
            return;
        }
        throw new NullPointerException();
    }

    @EventHandler
    public void itemEnchantEvent(EnchantItemEvent event) {
        Player player = event.getEnchanter();
        if (!player.hasPermission("upgradeabletools.enchantcustom") && !player.hasPermission("upgradeabletools.*")) {
            return;
        }
        ArrayList<AbstractCustomEnchantment> enchantmentList = new ArrayList<AbstractCustomEnchantment>();
        ConfigurationSection configSection = UpgradeableTools.PLUGIN.getConfig().getConfigurationSection("MultiplierToLevel");
        if (configSection == null) {
            return;
        }
        for (String path : configSection.getKeys(false)) {
            if (!path.equalsIgnoreCase(this.valueUtil.getToolType(event.getItem().getType()).toString()) || UpgradeableTools.PLUGIN.getConfig().getConfigurationSection("MultiplierToLevel." + WordUtils.capitalizeFully(path)) == null) continue;
            for (AbstractCustomEnchantment enchantment : CustomEnchants.custom_enchants) {
                ConfigurationSection enchantSection = UpgradeableTools.PLUGIN.getConfig().getConfigurationSection("MultiplierToLevel." + WordUtils.capitalizeFully(path));
                if (enchantSection == null) continue;
                for (String enchants : enchantSection.getKeys(false)) {
                    double configVal;
                    String enchName = enchantment.getName().replaceAll("_", "");
                    double random = new Random().nextInt(10000);
                    if (!enchName.equalsIgnoreCase(enchants) || random > (configVal = UpgradeableTools.PLUGIN.getConfig().getDouble("MultiplierToLevel." + path + "." + enchants + ".PercentageEnch", 0.0)) || enchantmentList.size() >= UpgradeableTools.PLUGIN.getConfig().getInt("MaxEnchantsFromTable", 0)) continue;
                    enchantmentList.add(enchantment);
                }
            }
            ItemStack givePlayer = event.getItem();
            for (AbstractCustomEnchantment ench : enchantmentList) {
                Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + ench.getKey())));
                givePlayer = this.handleAll(player, givePlayer, event.getItem().getEnchantmentLevel(yourEnchantment), WordUtils.capitalizeFully(this.valueUtil.getToolType(event.getItem().getType()).toString()) + "." + ench.getName().replaceAll(" ", "").replaceAll("-", ""), yourEnchantment);
            }
            if (givePlayer == null) {
                return;
            }
            event.setExpLevelCost(event.getExpLevelCost() + enchantmentList.size());
            event.setCancelled(true);
            for (Enchantment enchant : event.getEnchantsToAdd().keySet()) {
                givePlayer.addEnchantment(enchant, ((Integer)event.getEnchantsToAdd().get(enchant)).intValue());
            }
            player.getInventory().addItem(new ItemStack[]{givePlayer});
            player.closeInventory();
            MessengerUtil.notifyPlayer(player, "<green>Item enchanted successfully.");
        }
    }

    private ItemStack handleAll(Player player, ItemStack tool, int level, String path, Enchantment enchantment) {
        String name = UpgradeableTools.PLUGIN.getConfig().getString("MultiplierToLevel." + path + ".name", WordUtils.capitalizeFully(enchantment.getKey().getKey().replaceAll("_", " ")));
        if (level <= 0) {
            level = tool.getEnchantmentLevel(enchantment);
        }
        if (level <= 0) {
            level = 0;
        }
        if (!CheckerUtil.checkEnchantmentPermission(player, enchantment, level)) {
            return null;
        }
        int maxLevel = enchantment.getMaxLevel();
        if (level >= maxLevel) {
            return null;
        }
        return this.processAddEnchant(enchantment, tool, level, name);
    }

    private ItemStack processAddEnchant(Enchantment enchantment, ItemStack tool, int level, String enchName) {
        if (tool.containsEnchantment(enchantment)) {
            tool.removeEnchantment(enchantment);
        }
        tool.addUnsafeEnchantment(enchantment, ++level);
        return tool;
    }
}

