/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.CustomEnchantments.Enchantments.Weapons;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.keys.EnchantmentKeys;
import io.papermc.paper.registry.keys.tags.ItemTypeTagKeys;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.tag.TagKey;
import java.util.HashMap;
import java.util.UUID;
import me.marcangeloh.API.Events.PlayerDamageEntityEvent;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.UpgradeableTools;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Spook
extends AbstractCustomEnchantment {
    NamespacedKey key = null;
    HashMap<UUID, Integer> cdtime = new HashMap();
    HashMap<UUID, Integer> spookMap = new HashMap();

    @EventHandler(priority=EventPriority.HIGH)
    public void spookEvent(PlayerDamageEntityEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        Entity entity = event.getEntity();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (itemStack.getItemMeta().getEnchants().isEmpty()) {
            return;
        }
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + this.name)));
        if (!itemStack.containsEnchantment(yourEnchantment)) {
            return;
        }
        int level = itemStack.getEnchantmentLevel(yourEnchantment);
        if (level < 0) {
            return;
        }
        if (this.cdtime.containsKey(player.getUniqueId())) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player damaged = (Player)livingEntity;
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have instilled " + String.valueOf(ChatColor.RED) + "Spook" + String.valueOf(ChatColor.GREEN) + " on your opponent.");
        damaged.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40 * level, 255));
        damaged.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 40 * level, 255));
        damaged.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 40 * level, 255));
        this.cdtime.put(player.getUniqueId(), 800 / (level == 0 ? 1 : level));
        this.spookMap.put(damaged.getUniqueId(), 5);
    }

    public void spookable() {
        new BukkitRunnable(){

            public void run() {
                if (Spook.this.spookMap.isEmpty()) {
                    return;
                }
                for (UUID uuid : Spook.this.spookMap.keySet()) {
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    int timeleft = Spook.this.spookMap.get(uuid);
                    if (player.isDead() && timeleft > 60) {
                        timeleft = 60;
                    }
                    if (timeleft <= 0) {
                        Spook.this.spookMap.remove(player);
                        continue;
                    }
                    player.getWorld().spawnParticle(Particle.SCULK_SOUL, player.getLocation(), 1);
                    Spook.this.spookMap.put(uuid, timeleft - 1);
                }
            }
        }.runTaskTimer((Plugin)UpgradeableTools.PLUGIN, 0L, 20L);
    }

    public void runnablerunner() {
        new BukkitRunnable(){

            public void run() {
                if (Spook.this.cdtime.isEmpty()) {
                    return;
                }
                for (UUID uuid : Spook.this.cdtime.keySet()) {
                    int timeleft = Spook.this.cdtime.get(uuid);
                    if (timeleft <= 0) {
                        Spook.this.cdtime.remove(uuid);
                        continue;
                    }
                    Spook.this.cdtime.put(uuid, timeleft - 1);
                }
            }
        }.runTaskTimer((Plugin)UpgradeableTools.PLUGIN, 0L, 20L);
    }

    public Spook(String path, String name, BootstrapContext context) {
        super(name, path, context);
        if (!this.isEnchantEnabled()) {
            return;
        }
        context.getLifecycleManager().registerEventHandler(RegistryEvents.ENCHANTMENT.freeze().newHandler(event -> event.registry().register(EnchantmentKeys.create((Key)Key.key((String)("utools:" + this.getKey()))), b -> b.description((Component)Component.text((String)name.replace("_", " "))).supportedItems((RegistryKeySet)event.getOrCreateTag(this.getItemTarget())).maxLevel(this.getMaxLevel()).anvilCost(0).weight(1).minimumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).maximumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).activeSlots(new EquipmentSlotGroup[]{this.getEquipmentSlotGroup()}))));
    }

    @Override
    public void registerEvent(JavaPlugin plugin) {
        this.runnablerunner();
        this.spookable();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public String getName() {
        return "Spook";
    }

    @Override
    public EquipmentSlotGroup getEquipmentSlotGroup() {
        return EquipmentSlotGroup.MAINHAND;
    }

    @Override
    public TagKey<ItemType> getItemTarget() {
        return ItemTypeTagKeys.SWORDS;
    }
}

