/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.CustomEnchantments.Enchantments.Tools;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.keys.EnchantmentKeys;
import io.papermc.paper.registry.keys.tags.ItemTypeTagKeys;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.tag.TagKey;
import java.util.ArrayList;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.CheckerUtil;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MassHarvest
extends AbstractCustomEnchantment {
    BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};

    @EventHandler(priority=EventPriority.HIGH)
    public void MassHarvestEvent(BlockBreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        final Player player = event.getPlayer();
        final ItemStack tool = player.getInventory().getItemInMainHand();
        if (tool == null) {
            return;
        }
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + this.getKey())));
        if (!tool.containsEnchantment(yourEnchantment)) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (block.getType() == null) {
            return;
        }
        if (!this.checkForWheat(block)) {
            return;
        }
        final ArrayList<Block> plantsLeft = new ArrayList<Block>();
        plantsLeft.add(block);
        final int level = tool.getEnchantmentLevel(yourEnchantment);
        event.setCancelled(true);
        new BukkitRunnable(){
            int logCounter = 0;
            int secondaryCounter = 0;

            public void run() {
                if (plantsLeft.isEmpty() || this.logCounter > level * 20) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Upgrade your tool more to plant more seeds");
                    this.cancel();
                    return;
                }
                Block log = (Block)plantsLeft.get(0);
                if (CheckerUtil.isPlayerInRegion(player, log.getLocation())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot harvest seeds in protected region");
                    return;
                }
                BlockData bData = log.getBlockData();
                if (!(bData instanceof Ageable)) {
                    this.cancel();
                    return;
                }
                log.breakNaturally(tool);
                for (BlockFace face : MassHarvest.this.faces) {
                    Block block = log.getRelative(face);
                    if (!MassHarvest.this.checkForWheat(block) || plantsLeft.contains(block)) continue;
                    plantsLeft.add(block);
                }
                plantsLeft.remove(log);
                if (this.secondaryCounter == 1) {
                    player.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.WHEAT_SEEDS, 1)});
                    this.secondaryCounter = 0;
                }
                ++this.logCounter;
                ++this.secondaryCounter;
            }
        }.runTaskTimer((Plugin)UpgradeableTools.PLUGIN, 0L, 5L);
    }

    private boolean checkForWheat(Block dirt) {
        if (dirt.getType() == null) {
            return false;
        }
        if (dirt.getType() == Material.WHEAT && dirt.getBlockData() instanceof Ageable) {
            return ((Ageable)dirt.getBlockData()).getAge() == ((Ageable)dirt.getBlockData()).getMaximumAge();
        }
        return false;
    }

    public MassHarvest(String path, String name, BootstrapContext context) {
        super(name, path, context);
        if (!this.isEnchantEnabled()) {
            return;
        }
        context.getLifecycleManager().registerEventHandler(RegistryEvents.ENCHANTMENT.freeze().newHandler(event -> event.registry().register(EnchantmentKeys.create((Key)Key.key((String)("utools:" + this.getKey()))), b -> b.description((Component)Component.text((String)name.replace("_", " "))).supportedItems((RegistryKeySet)event.getOrCreateTag(this.getItemTarget())).maxLevel(this.getMaxLevel()).anvilCost(0).weight(1).minimumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).maximumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).activeSlots(new EquipmentSlotGroup[]{this.getEquipmentSlotGroup()}))));
    }

    @Override
    public String getName() {
        return "Mass Harvest";
    }

    @Override
    public EquipmentSlotGroup getEquipmentSlotGroup() {
        return EquipmentSlotGroup.MAINHAND;
    }

    @Override
    public TagKey<ItemType> getItemTarget() {
        return ItemTypeTagKeys.HOES;
    }
}

