/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.CustomEnchantments.Enchantments.Tools;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.keys.EnchantmentKeys;
import io.papermc.paper.registry.keys.tags.ItemTypeTagKeys;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.tag.TagKey;
import java.util.ArrayList;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.CheckerUtil;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Fell
extends AbstractCustomEnchantment {
    BlockFace[] faces = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};

    @EventHandler(priority=EventPriority.HIGH)
    public void FellEvent(BlockBreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        final Player player = event.getPlayer();
        Block block = event.getBlock();
        if (!this.checkForWood(block)) {
            return;
        }
        final ArrayList<Block> logsLeft = new ArrayList<Block>();
        logsLeft.add(event.getBlock());
        final ItemStack tool = player.getInventory().getItemInMainHand();
        if (tool == null) {
            return;
        }
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + this.getKey())));
        if (!tool.containsEnchantment(yourEnchantment)) {
            return;
        }
        final int level = tool.getEnchantmentLevel(yourEnchantment);
        new BukkitRunnable(){
            int logCounter = 0;

            public void run() {
                if (logsLeft.isEmpty() || this.logCounter > level * 20) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Upgrade your tool more to break more blocks");
                    this.cancel();
                    return;
                }
                Block log = (Block)logsLeft.get(0);
                if (CheckerUtil.isPlayerInRegion(player, log.getLocation())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You're in a protected region! You cannot fell this tree.");
                    return;
                }
                Enchantment magnetic = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)"utools:magnetic"));
                if (tool.containsEnchantment(magnetic)) {
                    log.breakNaturally(player.getInventory().getItemInMainHand());
                } else {
                    for (ItemStack drop : log.getDrops(tool)) {
                        player.getInventory().addItem(new ItemStack[]{drop});
                    }
                    log.setType(Material.AIR);
                }
                for (BlockFace face : Fell.this.faces) {
                    Block block = log.getRelative(face);
                    player.sendMessage(String.valueOf(block.getType()));
                    if (!Fell.this.checkForWood(block) || logsLeft.contains(block)) continue;
                    logsLeft.add(block);
                }
                logsLeft.remove(log);
                ++this.logCounter;
            }
        }.runTaskTimer((Plugin)UpgradeableTools.PLUGIN, 0L, 5L);
    }

    private boolean checkForWood(Block log) {
        if (log.getType() == null) {
            return false;
        }
        Material type = log.getType();
        return type == Material.ACACIA_LOG || type == Material.BIRCH_LOG || type == Material.OAK_LOG || type == Material.DARK_OAK_LOG || type == Material.JUNGLE_LOG || type == Material.MANGROVE_LOG || type == Material.AZALEA || type == Material.SPRUCE_LOG || type == Material.ACACIA_LEAVES || type == Material.AZALEA_LEAVES || type == Material.BIRCH_LEAVES || type == Material.JUNGLE_LEAVES || type == Material.DARK_OAK_LEAVES || type == Material.MANGROVE_LEAVES || type == Material.OAK_LEAVES || type == Material.SPRUCE_LEAVES;
    }

    public Fell(String path, String name, BootstrapContext context) {
        super(name, path, context);
        if (!this.isEnchantEnabled()) {
            return;
        }
        context.getLifecycleManager().registerEventHandler(RegistryEvents.ENCHANTMENT.freeze().newHandler(event -> event.registry().register(EnchantmentKeys.create((Key)Key.key((String)("utools:" + this.getKey()))), b -> b.description((Component)Component.text((String)name.replace("_", " "))).supportedItems((RegistryKeySet)event.getOrCreateTag(this.getItemTarget())).maxLevel(this.getMaxLevel()).anvilCost(0).weight(1).minimumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).maximumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).activeSlots(new EquipmentSlotGroup[]{this.getEquipmentSlotGroup()}))));
    }

    @Override
    public String getName() {
        return "Fell";
    }

    @Override
    public EquipmentSlotGroup getEquipmentSlotGroup() {
        return EquipmentSlotGroup.MAINHAND;
    }

    @Override
    public TagKey<ItemType> getItemTarget() {
        return ItemTypeTagKeys.AXES;
    }
}

