/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.CustomEnchantments.Enchantments;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.registry.tag.TagKey;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class AbstractCustomEnchantment
implements Listener {
    List<String> path;
    protected String name;
    Path dataFolderPath;

    public AbstractCustomEnchantment(String name, String path, BootstrapContext context) {
        this.name = name;
        this.path = new ArrayList<String>();
        this.path.add(path);
        this.dataFolderPath = context.getDataDirectory();
    }

    public AbstractCustomEnchantment(String name, List<String> path, BootstrapContext context) {
        this.name = name;
        this.path = path;
        this.dataFolderPath = context.getDataDirectory();
    }

    public String getName() {
        return this.name;
    }

    public TagKey<ItemType> getItemTarget() {
        return null;
    }

    public String getPath() {
        return this.path.get(0);
    }

    public boolean isEnchantEnabled() {
        return this.getConfig().getBoolean("MultiplierToLevel." + this.path.get(0) + ".enabled", false);
    }

    public int getMaxLevel() {
        return this.getConfig().getInt("MultiplierToLevel." + this.getPath() + ".MaximumLevel");
    }

    public int getStartLevel() {
        return this.getConfig().getInt("MultiplierToLevel." + this.getPath() + ".Start");
    }

    public abstract EquipmentSlotGroup getEquipmentSlotGroup();

    public String getKey() {
        return this.name.toLowerCase();
    }

    public void registerEvent(JavaPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    protected YamlConfiguration getConfig() {
        File file = new File(this.dataFolderPath.toFile().getAbsolutePath(), "config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        return config;
    }
}

