/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.CustomEnchantments;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.lifecycle.event.handler.configuration.LifecycleEventHandlerConfiguration;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.event.type.RegistryEntryAddConfiguration;
import io.papermc.paper.registry.keys.EnchantmentKeys;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.marcangeloh.Config.ConfigManager;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.CustomEnchantments.Enchantments.Armor.Blink;
import me.marcangeloh.CustomEnchantments.Enchantments.Armor.Dupe;
import me.marcangeloh.CustomEnchantments.Enchantments.Armor.ExplosiveTouch;
import me.marcangeloh.CustomEnchantments.Enchantments.Armor.NightVision;
import me.marcangeloh.CustomEnchantments.Enchantments.Armor.PoisonTouch;
import me.marcangeloh.CustomEnchantments.Enchantments.Armor.SecondChance;
import me.marcangeloh.CustomEnchantments.Enchantments.Armor.Speed;
import me.marcangeloh.CustomEnchantments.Enchantments.Multi.Backpack.Backpack;
import me.marcangeloh.CustomEnchantments.Enchantments.Multi.MendWalker;
import me.marcangeloh.CustomEnchantments.Enchantments.Multi.SoulBound;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.AutoEquip;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.BlastExcavating;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.BlastMining;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.Drain;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.Fell;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.Luck;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.Magnetic;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.MassHarvest;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.MassPlanter;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.Smelter;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.Bleed.Bleed;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.Confusion;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.Decapitation;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.Explosive;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.Freeze;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.LifeSteal;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.PoisonShot;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.ShockWave;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.Spook;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.CheckerUtil;
import me.marcangeloh.Util.MessengerUtil;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomEnchants {
    public static Plugin PLUGIN;
    public static ArrayList<AbstractCustomEnchantment> custom_enchants;
    public static Drain drain;
    public static Smelter smelter;
    public static Luck luck;
    public static MendWalker mendWalker;
    public static BlastMining blastMining;
    public static BlastExcavating blastExcavating;
    public static Decapitation decapitation;
    public static Explosive explosive;
    public static LifeSteal lifeSteal;
    public static SoulBound soulBound;
    public static Blink blink;
    public static Speed speed;
    public static PoisonTouch poisonTouch;
    public static ExplosiveTouch explosiveTouch;
    public static Dupe dupe;
    public static NightVision nightVision;
    public static Magnetic magnetic;
    public static Fell fell;
    public static MassPlanter massPlanter;
    public static MassHarvest massHarvester;
    public static ShockWave shockwave;
    public static AutoEquip autoEquip;
    public static Backpack backpack;
    public static SecondChance secondChance;
    public static Bleed bleed;
    public static Freeze freeze;
    public static PoisonShot poisonShot;
    public static Spook spook;
    public static Confusion confusion;

    public void onDisable() {
        try {
            backpack.saveData();
            MessengerUtil.notifyConsole("<green>Backpacks saved");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save backpack data.", e);
        }
    }

    public void onBootstrap(BootstrapContext context, ConfigManager cfgm) {
        CustomEnchants.initializeEnchantments(context, cfgm);
        custom_enchants.addAll(List.of(drain, smelter, luck, blastMining, mendWalker, blastExcavating, decapitation, explosive, lifeSteal, soulBound, blink, speed, poisonTouch, explosiveTouch, dupe, nightVision, magnetic, fell, massPlanter, massHarvester, autoEquip, shockwave, backpack, secondChance, bleed, freeze, poisonShot, spook, confusion));
        this.setEnchantmentLevels(context);
    }

    private static void initializeEnchantments(BootstrapContext context, ConfigManager cfgm) {
        drain = new Drain("Pickaxe.Drain", "Drain", context);
        smelter = new Smelter("Pickaxe.Smelter", "Smelter", context);
        luck = new Luck("Shovel.Luck", "Luck", context);
        blastMining = new BlastMining("Pickaxe.BlastMining", "Blast_Mining", context);
        mendWalker = new MendWalker(Arrays.asList("Pickaxe.MendWalker", "Shovel.MendWalker", "Axe.MendWalker", "FishingRod.MendWalker", "Swords.MendWalker", "Hoe.MendWalker"), "Mend_Walker", context);
        blastExcavating = new BlastExcavating("Shovel.BlastExcavating", "Blast_Excavating", context);
        decapitation = new Decapitation("Swords.Decapitation", "Decapitation", context);
        explosive = new Explosive("Bow.Explosive", "Explosive", context);
        lifeSteal = new LifeSteal("Swords.LifeSteal", "Life_Steal", context);
        soulBound = new SoulBound(Arrays.asList("Swords.SoulBound", "Trident.SoulBound", "Crossbow.SoulBound", "Bow.SoulBound", "Hoe.SoulBound", "Armor.SoulBound", "Pickaxe.SoulBound", "Axe.SoulBound", "FishingRod.SoulBound", "Shovel.SoulBound"), "Soul_Bound", context);
        blink = new Blink("Armor.Blink", "Blink", context);
        speed = new Speed("Armor.Speed", "Speed", context);
        poisonTouch = new PoisonTouch("Armor.PoisonTouch", "Poison_Touch", context);
        explosiveTouch = new ExplosiveTouch("Armor.ExplosiveTouch", "Explosive_Touch", context);
        dupe = new Dupe("Armor.Dupe", "Dupe", context);
        nightVision = new NightVision("Armor.NightVision", "Night_Vision", context);
        magnetic = new Magnetic(Arrays.asList("Pickaxe.Magnetic", "Shovel.Magnetic", "Axe.Magnetic"), "Magnetic", context);
        fell = new Fell("Axe.Fell", "Fell", context);
        massPlanter = new MassPlanter("Hoe.MassPlanter", "Mass_Planter", context);
        massHarvester = new MassHarvest("Hoe.MassHarvester", "Mass_Harvester", context);
        shockwave = new ShockWave("Swords.Shockwave", "Shockwave", context);
        autoEquip = new AutoEquip(Arrays.asList("Pickaxe.AutoEquip", "Shovel.AutoEquip", "Axe.AutoEquip"), "Auto_Equip", context);
        backpack = new Backpack(Arrays.asList("Pickaxe.Backpack", "Shovel.Backpack", "Axe.Backpack", "FishingRod.Backpack", "Swords.Backpack", "Trident.Backpack", "Crossbow.Backpack", "Bow.Backpack", "Hoe.Backpack"), "Backpack", cfgm, context);
        secondChance = new SecondChance("Armor.SecondChance", "Second_Chance", context);
        bleed = new Bleed("Swords.Bleed", "Bleed", context);
        freeze = new Freeze("Swords.Freeze", "Freeze", context);
        poisonShot = new PoisonShot(Arrays.asList("Crossbow.PoisonShot", "Bow.PoisonShot"), "Poison_Shot", context);
        spook = new Spook("Swords.Spook", "Spook", context);
        confusion = new Confusion("Swords.Confusion", "Confusion", context);
    }

    public static String getConfigEnchantmentDisplayName(ItemStack item, String enchantKey) {
        String typeSpecificPath;
        String baseConfigPath = "MultiplierToLevel.";
        if (CheckerUtil.checkForBow(item)) {
            typeSpecificPath = "Bow.";
        } else if (CheckerUtil.checkForCrossbow(item)) {
            typeSpecificPath = "Crossbow.";
        } else if (CheckerUtil.checkForTrident(item)) {
            typeSpecificPath = "Trident.";
        } else if (CheckerUtil.checkForAxe(item)) {
            typeSpecificPath = "Axe.";
        } else if (CheckerUtil.checkForShovel(item)) {
            typeSpecificPath = "Shovel.";
        } else if (CheckerUtil.checkForPickaxe(item)) {
            typeSpecificPath = "Pickaxe.";
        } else if (CheckerUtil.checkForSwords(item)) {
            typeSpecificPath = "Swords.";
        } else if (CheckerUtil.checkForHoe(item)) {
            typeSpecificPath = "Hoe.";
        } else if (CheckerUtil.checkForArmor(item)) {
            typeSpecificPath = "Armor.";
        } else {
            return "";
        }
        return UpgradeableTools.PLUGIN.getConfig().getString(baseConfigPath + typeSpecificPath + enchantKey + ".name", "");
    }

    public void onEnable(JavaPlugin plugin) {
        for (AbstractCustomEnchantment enchant : custom_enchants) {
            enchant.registerEvent(plugin);
        }
    }

    private void setEnchantmentLevels(BootstrapContext context) {
        this.addEnchantmentLevel(context, "MultiplierToLevel.Swords.Sharpness.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.SHARPNESS);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Swords.FireAspect.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.FIRE_ASPECT);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Swords.Looting.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.LOOTING);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Swords.Smite.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.SMITE);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Swords.BaneOfArthropods.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.BANE_OF_ARTHROPODS);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Swords.Knockback.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.KNOCKBACK);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Swords.SweepingEdge.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.SWEEPING_EDGE);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Pickaxe.Fortune.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.FORTUNE);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Pickaxe.SilkTouch.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.SILK_TOUCH);
        this.addEnchantmentLevel(context, "MultiplierToLevel.FishingRod.LuckOfTheSea.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.LUCK_OF_THE_SEA);
        this.addEnchantmentLevel(context, "MultiplierToLevel.FishingRod.Lure.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.LURE);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Trident.Channeling.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.CHANNELING);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Trident.Impaling.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.IMPALING);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Trident.Loyalty.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.LOYALTY);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Trident.Riptide.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.RIPTIDE);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Crossbow.Multishot.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.MULTISHOT);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Crossbow.Piercing.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.PIERCING);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Crossbow.QuickCharge.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.QUICK_CHARGE);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Bow.Power.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.POWER);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Bow.Infinity.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.INFINITY);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Bow.Punch.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.PUNCH);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Bow.Flame.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.FLAME);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Armor.FireProtection.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.FIRE_PROTECTION);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Armor.ProjectileProtection.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.PROJECTILE_PROTECTION);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Armor.BlastProtection.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.BLAST_PROTECTION);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Armor.DepthStrider.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.DEPTH_STRIDER);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Armor.SoulSpeed.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.SOUL_SPEED);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Armor.SwiftSneak.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.SWIFT_SNEAK);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Armor.Protection.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.PROTECTION);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Armor.FeatherFalling.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.FEATHER_FALLING);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Armor.FrostWalker.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.FROST_WALKER);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Armor.Thorns.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.THORNS);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Armor.Respiration.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.RESPIRATION);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Armor.AquaAffinity.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.AQUA_AFFINITY);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Common.Efficiency.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.EFFICIENCY);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Common.Unbreaking.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.UNBREAKING);
        this.addEnchantmentLevel(context, "MultiplierToLevel.Common.Mending.MaximumLevel", (TypedKey<Enchantment>)EnchantmentKeys.MENDING);
    }

    private void addEnchantmentLevel(BootstrapContext context, String maxLevelPath, TypedKey<Enchantment> enchantment) {
        context.getLifecycleManager().registerEventHandler((LifecycleEventHandlerConfiguration)((RegistryEntryAddConfiguration)RegistryEvents.ENCHANTMENT.entryAdd().newHandler(event -> ((EnchantmentRegistryEntry.Builder)event.builder()).maxLevel(this.getConfig(context).getInt(maxLevelPath, 5)))).filter(enchantment));
    }

    protected YamlConfiguration getConfig(BootstrapContext context) {
        File file = new File(context.getDataDirectory().toFile().getAbsolutePath(), "config.yml");
        return YamlConfiguration.loadConfiguration((File)file);
    }

    static {
        custom_enchants = new ArrayList();
    }
}

